Rem drv: <create type="tables"/>
Rem
Rem $Header: common_tables.sql 29-jun-2005.01:47:19 gsbhatia Exp $
Rem
Rem common_tables.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      common_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    gan         08/17/04 - add monitoring 
Rem    dcawley     07/07/04 - Increase user name size 
Rem    skini       06/30/03 - Fixes for reducing db blocksize
Rem    rpinnama    05/14/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/14/02 - Created
Rem


rem
rem  PURPOSE
rem
rem     The MGMT_PARAMETERS table contains general information about the reporting
rem     schema and the parameters required to control it.  Rather than have many small
rem     tables, each with one or two rows for each data item, a common parameter table
rem     is provided to contain all the paramters needed.
rem
rem  COLUMNS
rem
rem     PARAMETER_NAME     - the name of the paramter being defined.
rem
rem     PARAMETER_VALUE    - the value for the parameter specified in parameter_name.
rem
rem     PARAMETER_COMMENT  - Comment with additional information on the purpose of the
rem                          parameter
rem
rem     INTERNAL_FLAG      - When the internal flag is 1, the parameters will not be
rem                          exposed to the user via the view
rem
rem  NOTES
rem
rem     The convention for this table is that parameter names should be specified in
rem     lower case and should not be internationalized.
rem

CREATE TABLE MGMT_PARAMETERS
    (parameter_name     VARCHAR2(32)         NOT NULL,
     parameter_value    VARCHAR2(256)        NOT NULL,
     parameter_comment  VARCHAR2(256)        DEFAULT ' ',
     internal_flag      NUMBER               DEFAULT 0)
  MONITORING;


rem
rem MGMT_OMS_PARAMETERS
rem
rem PURPOSE
rem   The oms_parameters table stores information about each oms that is connecting
rem   to this repository
rem 
rem COLUMNS
rem   host_url The url of the console associated with the middle tier (oms) component
rem      This is in the host:port format
rem   name The parameter name
rem   value The parameter value
rem
rem
CREATE TABLE MGMT_OMS_PARAMETERS
    (host_url VARCHAR2(256),
     name VARCHAR2(256),
     value VARCHAR2(256),
     timestamp DATE DEFAULT SYSDATE) MONITORING;



rem
rem  PURPOSE
rem
rem  The MGMT_CREDENTIALS table is intended to be a common storage
rem  area for all credentials used by enterprise manager and its
rem  integrator modules. A credential is a set of name-value pairs.
rem  A credential could sometimes be associated with a privilege 
rem  (for example, patch credentials are associated with the patch 
rem  privilege, and apply to all users that have the privilege). Such
rem  credentials are called system credentials. Credentials could also
rem  be stored as user preferences (similar to the Preferred Credential
rem  concept that existed in EM 2.x).
rem
rem  COLUMNS
rem
rem   TARGET_GUID The guid of the target that this credential is for
rem   CONTAINER_LOCATION For some targets (particularly apps installations),
rem     the credentials could depend on both the target and the specific
rem     container (appltop or oracle_home). 
rem   CREDENTIAL_COLUMN The name of a column in the credential (for
rem      example, 'node_username' might represent the OS user in a node
rem      credential, and 'node_password' might represent the OS password).
rem   USER_NAME The user that this credential is for. This could be set
rem     to a specific user name, or to '<SYSTEM>' if the credential is 
rem     associated with a privilege
rem  CREDENTIAL_VALUE The value of the credential column
rem  MONITORING_CREDENTIAL True (1) if the credential column is part of
rem   a monitoring credential. (A set of target properties which are used
rem    to monitor a target)      
rem
CREATE TABLE MGMT_CREDENTIALS
    (target_guid RAW(16),
     container_location VARCHAR2(1024) DEFAULT '<0>',
     credential_column VARCHAR2(32),
     user_name VARCHAR2(256),
     credential_value VARCHAR2(256),
     monitoring_credential NUMBER DEFAULT 0,
     monitoring_column_name VARCHAR2(32) DEFAULT NULL)
  MONITORING;
