Rem drv: <create type="pkgdefs" pos="ip/rca/ip_rca_pkgdefs.sql+"/>
Rem $Header: page_custmzn_pkgdef.sql 04-aug-2005.12:31:15 vesriniv Exp $
Rem
Rem page_custmzn_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      page_custmzn_pkgdef.sql - This sql has API declaration to upload customization metadata
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    vesriniv    08/04/05 - vesriniv_custtxn
Rem    vesriniv    07/25/05 - Add type definition 
Rem    vesriniv    06/06/05 - created
Rem    

CREATE OR REPLACE PACKAGE em_page_custmzn AS

-- Package level Type Definition
TYPE cursorType IS REF CURSOR;
--
-- PROCEDURE: add_page_customzn_metadata 
-- PURPOSE: To add the page to customization metadata
--
-- PARAMETERS:
--   p_page_name : Name of the UI page which supports customization
--
--   p_customization_data: A list of name/value pairs containing customization data. 
--                         Example: disallow_perf_metrics, false
--
--   p_condition_names:   A list of condition for the given page
--                         Example: type, target etc
--
-- ERROR CODES:
--       PAGE_NAME_ALREADY_EXISTS - The given page  name alrady exists in the table
--       CONDITION_ALREADY_EXISTS - The given condition metadata already exists in the table
--
PROCEDURE add_page_customzn_metadata (
	p_page_name          IN VARCHAR2,
	p_customization_data IN SMP_EMD_NVPAIR_ARRAY,
	p_condition_names    IN SMP_EMD_STRING_ARRAY
);

---
-- PROCEDURE : get_matching_page_customzns 
-- PURPOSE   : To get the page to customization for the given condition
--
-- PARAMETERS :
--   p_page_name : Name of the UI page which supports customization
--
--   p_context: A list of name/value pairs containing condition data.
--                         Example: type, ocs_email_system
--
-- RETURNS :
--   p_customizations:   A list of customization for the condition and given page
--                         Example: disallow_member_target, true
--
-- ERROR CODES:
--       NO_SUCH_PAGE_EXISTS : The requested page name doesnt exists in the table 
-- 
--
PROCEDURE get_matching_page_customzns (
	p_page_name IN VARCHAR2,
	p_context IN SMP_EMD_NVPAIR_ARRAY,
	p_customizations OUT SMP_EMD_NVPAIR_ARRAY 
);

---
-- PROCEDURE : get_matching_page_customzns
-- PURPOSE   : To get the all page to customization for the given condition
--
-- PARAMETERS :
--
--   p_context: A list of name/value pairs containing condition data.
--                         Example: type, ocs_email_system
--
-- RETURNS :
--   p_customizations:   A cursor with PageName and corresponding customization(name,value)
--                         Example: page1, disallow_member_target, true
--
-- ERROR CODES:
--       NO_SUCH_PAGE_EXISTS : The requested page name doesnt exists in the table
--
--
PROCEDURE get_matching_customzns (
        p_context IN SMP_EMD_NVPAIR_ARRAY,
        p_customizations OUT cursorType 
);


END em_page_custmzn;
/
show errors;

