Rem drv: <create type="tables"/>
Rem
Rem $Header: page_custmzn_tables.sql 04-may-2007.02:20:20 denath Exp $
Rem
Rem page_custmzn_tables.sql
Rem
Rem Copyright (c) 2006, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      page_custmzn_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    denath      05/04/07 - Backport denath_bug-5953382 from main
Rem    denath      04/24/07 - Bug fix 5953382. called drop table and then
Rem                           recreate.
Rem    rpatti      11/10/06 - tables
Rem    rpatti      11/10/06 - Created
Rem

@&EM_SQL_ROOT/core/latest/console/drop_page_custmzn_tables.sql

Rem  Table:
Rem    EM_PAGE_CUST_METADATA 
Rem
Rem  Columns:
Rem    page_name       - Name of the page. Example: groups.edit_group, webapps.edit_webapp etc
Rem    cust_name       - Name of the customization. Example: disallow_member_edit, disallow_perf_metrics etc
Rem    def_cust_value  - Name of the customization. Example: true / false
Rem  

CREATE TABLE EM_PAGE_CUST_METADATA (      
    page_name         VARCHAR2(64) NOT NULL,
    cust_name         VARCHAR2(64) NOT NULL,
    def_cust_value    VARCHAR2(64) DEFAULT 'false' NOT NULL,
    CONSTRAINT em_page_cust_metadata_pk 
    Primary Key(page_name, cust_name)
)
MONITORING;

Rem  Table:
Rem      EM_PAGE_CONDITION_METADATA
Rem
Rem  Columns:
Rem    page_name       - Name of the page. Example: groups.edit_group, webapps.edit_webapp etc
Rem    condition_name  - Name of the condition.
Rem
CREATE TABLE EM_PAGE_CONDITION_METADATA (      
    page_name         VARCHAR2(64)  NOT NULL,
    condition_name    VARCHAR2(64)  NOT NULL,
    CONSTRAINT em_page_condition_metadata_pk 
    Primary Key(page_name, condition_name)
)
MONITORING;

Rem    Table:
Rem        EM_PAGE_CUSTOMIZATIONS
Rem
Rem  Columns:
Rem    page_name        - Name of the page. Example: groups.edit_group
Rem    cust_name        - Name of the customization. Example: disallow_member_edit, disallow_perf_metrics etc
Rem    cust_value       - Value of the customization. Example: true / false
Rem    condition_set_id - GUID of the condition - uniquely identified condition name and condition value
Rem
CREATE TABLE EM_PAGE_CUSTOMIZATIONS (      
    page_name         VARCHAR2(64) NOT NULL,
    cust_name         VARCHAR2(64) NOT NULL,
    cust_value        VARCHAR2(64) NOT NULL,
    condition_set_id  RAW(16)      NOT NULL,
    CONSTRAINT em_page_customizations_pk 
    Primary Key(page_name, cust_name, condition_set_id)
)
MONITORING;

Rem  Table:
Rem    EM_PAGE_CUSTOM_CONDITIONS
Rem
Rem  Columns:
Rem    condition_set_id  - GUID of the condition - uniquely identified condition name and condition value
Rem    condition_name    - Name of the condition. Example: Type, Target etc
Rem    condition_value   - Value of the condition. Example: ocs_email_system, website etc 
Rem
CREATE TABLE EM_PAGE_CUSTOM_CONDITIONS(      
    condition_set_id   RAW(16)       NOT NULL,
    condition_name     VARCHAR2(64)  NOT NULL,
    condition_value    VARCHAR2(1024)  NOT NULL,
    CONSTRAINT em_page_custom_condition_pk 
    Primary Key(condition_set_id, condition_name)
)
MONITORING;
