Rem drv: <create type="pkgdefs" pos="credentials/credentials_ui_pkgdef.sql+"/>
Rem
Rem $Header: credentials_pkgdef.sql 24-oct-2006.08:22:43 sradhakr Exp $
Rem
Rem credential_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      credential_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      This package contains internal routines for the credentials
Rem      subsystem    
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED  
Rem       sradhakr   10/23/06 - Backport sradhakr_bug-5382567 from main
Rem       rpinnama   09/12/05 - Fix 4605552 : Add HostCredsUDM credential set, 
Rem                             if missing 
Rem       rpinnama   08/26/05 - Add target_add, metaver_cp_upd callbacks to 
Rem                             add DBCredsUDM credential 
Rem       gsbhatia   07/01/05 - New repmgr header impl 
Rem       kmanicka   03/04/05 - move to EMDW_LOG from dbms_output
Rem       skini      11/24/04 - Delete credentials when user deleted 
Rem       skini      09/10/04 - skini_3855061_2
Rem

CREATE OR REPLACE PACKAGE EM_CREDENTIAL
AS

MODULE_NAME CONSTANT VARCHAR2(13) := 'EM.credential';

  -- Constant for host credentials type
  HOST_CREDS CONSTANT VARCHAR2(20) := 'HostCreds';

  G_HOST_UDM_CRED_SET CONSTANT VARCHAR2(20) := 'HostUDMCreds';

  -- Constant for database credentials type
  G_DATABASE_CRED_TYPE    CONSTANT VARCHAR2(20) := 'DBCreds';

  G_DATABASE_UDM_CRED_SET CONSTANT VARCHAR2(20) := 'DBCredsUDM';

  -- Log module name
  ADD_CRED_ACTION      CONSTANT VARCHAR2(32) := 'ADD_CREDENTIAL_INFO';


-- Add new host credential information when a new target is added
-- This procedure adds a new credential type and set, called
-- HostCreds, if one does not exist.
PROCEDURE add_host_credential_info(p_target_name VARCHAR2,
                                   p_target_type VARCHAR2,
                                   p_target_guid RAW);

  -- This procedure checks for the existance of HostUDMCreds credential
  --  set for the given target_type, type_meta_ver.
  -- If the credential set is not already present, it is created
  -- for the given target_type, type_meta_ver.
  PROCEDURE add_hostudmcreds_credset(p_target_type VARCHAR2,
                                     p_type_meta_ver VARCHAR2);

  -- Target addition callback 
  -- This callback ensures that the HostUDMCreds credential set
  -- is available for the given type meta ver.
  PROCEDURE handle_host_addition(p_target_name VARCHAR2,
                                 p_target_type VARCHAR2,
                                 p_target_guid RAW);

  -- Type_meta_ver for targets  updated callback Bug#5382567
  -- This callback ensures that the Host credential set
  -- is available for all targtes with the new type meta ver
  PROCEDURE handle_target_metaver_update(
     p_meta_ver_cbk_obj IN MGMT_TARGET_META_VER_CBK_OBJ);

  -- Type_meta_ver, cat_prop updated callback
  -- This callback ensures that the HostUDMCreds credential set
  -- is available for the new type meta ver
  PROCEDURE handle_host_metaver_update(
     p_meta_ver_cbk_obj IN MGMT_TARGET_META_VER_CBK_OBJ);



  -- This procedure checks for the existance of DBCredsUDM credential
  --  set for the given target_type, type_meta_ver.
  -- If the credential set is not already present, it is created
  -- for the given target_type, type_meta_ver.
  PROCEDURE add_dbcredsudm_credset(p_target_type VARCHAR2,
                                   p_type_meta_ver VARCHAR2);

  -- Target addition callback 
  -- This callback ensures that the DBCredsUDM credential set
  -- is available for the given type meta ver.
  PROCEDURE handle_db_addition(p_target_name VARCHAR2,
                               p_target_type VARCHAR2,
                               p_target_guid RAW);

  -- Type_meta_ver, cat_prop updated callback
  -- This callback ensures that the DBCredsUDM credential set
  -- is available for the new type meta ver
  PROCEDURE handle_db_metaver_update(
     p_meta_ver_cbk_obj IN MGMT_TARGET_META_VER_CBK_OBJ);


-- Delete a user's preferred credentials when a user is deleted
PROCEDURE user_deleted(p_user_name VARCHAR2, p_type NUMBER);

-- Delete a user's preferred credentials when a user is deleted and
-- objects are reassigned to someone else
PROCEDURE user_reassigned(p_user_name VARCHAR2, p_new_user VARCHAR2,
                          p_type NUMBER);
END EM_CREDENTIAL;
/

show errors;


