Rem drv: <create type="post_creation" pos="http_session/http_session_post_creation.sql-"/>
Rem
Rem $Header: credentials_post_creation.sql 27-aug-2005.00:01:51 rpinnama Exp $
Rem
Rem credential_post_creation.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      credential_post_creation.sql: Register callbacks for the 
Rem         credentials subsystem, other setup activities
Rem
Rem    DESCRIPTION
Rem      This package contains internal routines for the credentials
Rem      subsystem    
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED  
Rem       rpinnama   08/27/05 - Register callbacks to add DBCredsUDM 
Rem                             credential set 
Rem       gsbhatia   07/14/05 - 
Rem       rzazueta   06/13/05 - Add table to delete exceptions 
Rem       gsbhatia   07/03/05 - New repmgr header impl 
Rem       ktlaw      01/11/05 - add repmgr header 
Rem       skini      11/24/04 - skini_misc_fixes_2
Rem

-- register user model callbacks
BEGIN
    -- for jobs
    MGMT_USER.add_callback('EM_CREDENTIAL.user_deleted',
                           MGMT_USER.USER_DROPPED_CALLBACK);
    MGMT_USER.add_callback('EM_CREDENTIAL.user_reassigned',
                           MGMT_USER.USER_REASSIGN_CALLBACK);
    
END;
/
COMMIT;

-- Add table as a delete exception.
BEGIN
DECLARE del_exceptions SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN
    -- Add deletion exceptions here
    del_exceptions.extend(1);
    del_exceptions(1) := 'MGMT_COLLECTION_TEMPLATE_CREDS';
    MGMT_ADMIN.add_target_deletion_exceptions(del_exceptions);
END;
END;
/

-- Perform the v102020 init actions
@@&&EM_SQL_ROOT/core/v102020/credentials/credentials_common_init.sql

