Rem drv: <create type="tables"/>
REM
REM $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/credentials/credentials_tables.sql /st_emcore_10.2.0.4.2db11.2/1 2009/03/19 08:57:52 aptrived Exp $
REM
REM credentials_tables.sql
REM
REM Copyright (c) 2002, 2009, Oracle and/or its affiliates.
REM All rights reserved. 
REM
REM    NAME
REM      credentials_tables.sql - Credentials subSystem tables
REM
REM    DESCRIPTION
REM      Schema for the credentials subsystem
REM
REM    NOTES
REM
REM    MODIFIED 
REM       aptrived   03/10/09 - Backport aptrived_bug-5499388 from main
REM       aptrived   07/07/08 - Bug#5499388, Modifying
REM                             MGMT_ARU_CREDENTIALS.ARU_USERNAME
REM       nqureshi   04/18/07 - XbranchMerge kmanicka_pdp5 from main
REM       kmanicka   05/09/06 - implement pdp 
REM       kmanicka   05/09/06 - implement pdp 
REM       kmanicka   05/09/06 - implement pdp 
REM       jsadras    04/03/07 - Bug:5934433, suport 2k, added overflow
REM       jsadras    04/23/07 - Backport jsadras_bug-5934433 from main
REM       skini      09/08/05 - Make container_location column 1024 wide 
REM       gsbhatia   06/26/05 - New repmgr header impl 
REM       gsbhatia   02/13/05 - updating repmgr header 
REM       gsbhatia   02/09/05 - updating repmgr header 
REM       gsbhatia   02/07/05 - updating repmgr header 
REM       ktlaw      01/11/05 - add repmgr header 
REM       skini      12/29/04 - Fix column name 
REM       skini      10/27/04 - Versioning support, part 2 
REM       skini      10/08/04 - Cutover to job_type_id 
REM       dsahrawa   10/21/04 - add fk constraint to mgmt_nested_job_cred_info 
REM       dsahrawa   09/17/04 - add nested job creds 
REM       skini      09/28/04 - Add template copy schema 
REM       gan        08/17/04 - monitoring
REM       gan        08/13/04 - add monitoring 
REM       pkantawa   08/09/04 - 
REM       ashugupt   07/12/04 - changes for job system credential page 
REM       skini      07/26/04 - Create MGMT_CREDENTIAL_SET_COL_VALS 
REM       skini      07/23/04 - Add MGMT_CREDENTIAL_SET_COL_VALS 
REM       dcawley    07/07/04 - Increase user name size 
REM       skini      09/18/03 - Add ref_type_meta_ver 
REM       skini      09/02/03 - Remove cluster table 
REM       skini      08/21/03 - Default username to SYSTEM 
REM       skini      08/19/03 - Remove type_meta_ver 
REM       skini      08/18/03 - Fix ref table columns 
REM       skini      08/15/03 - Add context to credential sets table 
REM       skini      08/13/03 - Typo in MGMT_COLLECTION_CREDENTIALS table 
REM       skini      07/09/03 - Add metaver to tables
REM       skini      06/30/03 - Fixes for reducing db blocksize
REM       skini      06/09/03 - Add NLS Ids
REM       skini      05/21/03 - skini_credentials
REM
REM



REM
REM The MGMT_CREDENTIAL_TYPES table stores credential types.
REM 
REM TARGET_TYPE The target type the type is for
REM TARGET_TYPE_META_VER The meta version of the target type
REM TYPE_NAME The name of the type
REM DESCRIPTION The type description
REM TYPE_DISPLAY_NAME The display name for the credential type
REM TYPE_DISPLAY_NLSID The NLS ID for the display name
REM
CREATE TABLE MGMT_CREDENTIAL_TYPES (
    target_type VARCHAR2(64),
    target_type_meta_ver VARCHAR2(8) DEFAULT '1.0',
    type_name VARCHAR2(64),
    type_display_name VARCHAR2(128),
    type_display_nlsid VARCHAR2(64),
    description VARCHAR2(128),
    CONSTRAINT PK_MGMT_CRED_TYPES 
        PRIMARY KEY(target_type, target_type_meta_ver, type_name)
)
  INITRANS 2
  MONITORING;


REM
REM The MGMT_CREDENTIAL_TYPE_REF table stores type reference
REM    information, when one credential type references another
REM 
REM TARGET_TYPE The target type the type is for
REM TARGET_TYPE_META_VER The target type meta version
REM TYPE_NAME The name of the type
REM REF_NAME The name of the ref
REM REF_TYPE_NAME The name of the type that this type refers to
REM REF_TARGET_TYPE The target type of the ref type
REM ASSOCIATION The association that identifies the target
REM
CREATE TABLE MGMT_CREDENTIAL_TYPE_REF (
    target_type VARCHAR2(64),
    target_type_meta_ver VARCHAR2(8) DEFAULT '1.0',
    type_name VARCHAR2(64),
    ref_name VARCHAR2(64),
    ref_type_name VARCHAR2(64),
    ref_target_type VARCHAR2(64),
    ref_type_meta_ver VARCHAR2(8) DEFAULT '2.0',
    association VARCHAR2(64),
    CONSTRAINT PK_CRED_TYPE_REF
        PRIMARY KEY(target_type, target_type_meta_ver, type_name, ref_name, ref_type_name, ref_target_type),
    CONSTRAINT FK_CRED_REF FOREIGN KEY(target_type, 
                                            target_type_meta_ver, 
                                            type_name)
        REFERENCES MGMT_CREDENTIAL_TYPES(target_type, target_type_meta_ver,
                                         type_name)
            ON DELETE CASCADE
) ORGANIZATION INDEX
  INITRANS 2
  MONITORING;


REM
REM The MGMT_CREDENTIAL_TYPE_COLUMNS table stores the credential type
REM columns for a type
REM 
REM TARGET_TYPE The target type the type is for
REM TARGET_TYPE_META_VER The meta version of the type
REM TYPE_NAME The name of the type
REM TYPE_COLUMN_NAME The name of the type column
REM REF_NAME The ref name
REM REF_TYPE_COLUMN_NAME The name of corresponding column in the 
REM    referenced type, if any 
REM KEY 1 if this column is a key, 0 otherwise
REM
CREATE TABLE MGMT_CREDENTIAL_TYPE_COLUMNS (
    target_type VARCHAR2(64),
    target_type_meta_ver VARCHAR2(8) DEFAULT '1.0',
    type_name VARCHAR2(64),
    type_column_name VARCHAR2(64),
    ref_name VARCHAR2(64),
    ref_column_name VARCHAR2(64),
    type_column_display_name VARCHAR2(128),
    type_column_display_nlsid VARCHAR2(64),
    key NUMBER(1),
    CONSTRAINT PK_MGMT_CRED_TYPE_COLS 
        PRIMARY KEY(target_type, target_type_meta_ver, type_name, type_column_name),
    CONSTRAINT FK_CRED_TYPE_COLS FOREIGN KEY (target_type, 
                                              target_type_meta_ver,
                                              type_name)
        REFERENCES MGMT_CREDENTIAL_TYPES(target_type, target_type_meta_ver,
                                         type_name)
            ON DELETE CASCADE
)
  INITRANS 2
  MONITORING;



    
REM
REM Represents the set of possible values a credential type column could have
REM
REM TARGET_TYPE The target type the type is for
REM TARGET_TYPE_META_VER The meta version of the target type
REM TYPE_NAME The name of the type
REM TYPE_COLUMN_NAME The name of the type column
REM DEFAULT_VALUE If true, this is the default value for this type column
REM VALUE The actual value
REM VALUE_NLSID The nls for the actual value
REM
CREATE TABLE MGMT_CREDENTIAL_TYPE_COL_VALS (
    target_type VARCHAR2(64),
    target_type_meta_ver VARCHAR2(8) DEFAULT '1.0',
    type_name VARCHAR2(64),
    type_column_name VARCHAR2(64),
    default_value NUMBER(1), 
    value VARCHAR2(1024),
    value_nlsid VARCHAR2(64),
    CONSTRAINT PK_CRED_TYPE_COL_VALS 
        PRIMARY KEY(target_type, target_type_meta_ver, type_name, 
                    type_column_name, value),    
    CONSTRAINT FK_CRED_TYPE_COL_VALS FOREIGN KEY (target_type, 
                                                  target_type_meta_ver,
                                                  type_name)
        REFERENCES MGMT_CREDENTIAL_TYPES(target_type, target_type_meta_ver, 
                                         type_name)
            ON DELETE CASCADE
)
  INITRANS 2
  MONITORING;


REM
REM TARGET_TYPE The target type that this set is defined for
REM TARGET_TYPE_META_VER The target type meta version
REM SET_NAME The name of the credential set
REM CREDENTIAL_TYPE_NAME The credential type that this set references
REM SET_USAGE The usage of this set (MONITORING/PREFERRED_CRED/SYSTEM)
REM SET_CONTEXT_TYPE The set context type (TARGET/CONTAINER/COLLECTION)
REM SET_CONTEXT This is set to one of (OracleHome/Appltop) when the
REM    SET_CONTEXT_TYPE is set to CONTAINER.
REM
CREATE TABLE MGMT_CREDENTIAL_SETS (
    target_type VARCHAR2(64),
    target_type_meta_ver VARCHAR2(8) DEFAULT '1.0',
    set_name VARCHAR2(64),
    set_display_name VARCHAR2(128),
    set_display_nlsid VARCHAR2(64),
    credential_type_name VARCHAR2(64),
    set_usage VARCHAR2(64),
    set_context_type VARCHAR2 (64),
    set_context VARCHAR2(64),
    CONSTRAINT PK_MGMT_CRED_SETS 
        PRIMARY KEY(target_type, target_type_meta_ver, set_name)
)
  INITRANS 2
  MONITORING;


REM
REM The MGMT_CREDENTIAL_SET_COLUMNS table contains information about the
REM columns of a credential set
REM
REM TARGET_TYPE The target type that this set is defined for
REM TARGET_TYPE_META_VER The target type meta version
REM SET_NAME The name of the credential set
REM SET_COLUMN_NAME The name of the credential set column
REM TYPE_COLUMN_NAME The name of the type column that this column refers to
REM
CREATE TABLE MGMT_CREDENTIAL_SET_COLUMNS (
    target_type VARCHAR2(64),
    target_type_meta_ver VARCHAR2(8) DEFAULT '1.0',
    set_name VARCHAR2(64),
    set_column_name VARCHAR2(64),
    set_column_display_name VARCHAR2(128),
    set_column_display_nlsid VARCHAR2(64),
    type_column_name VARCHAR2(64),
    CONSTRAINT PK_MGMT_CRED_SET_COLS
        PRIMARY KEY(target_type, target_type_meta_ver, set_name, set_column_name),
    CONSTRAINT FK_CRED_SET_COLS FOREIGN KEY (target_type, target_type_meta_ver, set_name)
        REFERENCES MGMT_CREDENTIAL_SETS(target_type, target_type_meta_ver, set_name)
            ON DELETE CASCADE
)
  INITRANS 2
  MONITORING;

REM
REM Represents the set of possible values a credential set column could have
REM
REM TARGET_TYPE The target type the type is for
REM TARGET_TYPE_META_VER The meta version of the target type
REM SET_NAME The name of the set
REM SET_COLUMN_NAME The name of the type column
REM DEFAULT_VALUE If true, this is the default value for this type column
REM VALUE The actual value
REM
CREATE TABLE MGMT_CREDENTIAL_SET_COL_VALS (
    target_type VARCHAR2(64),
    target_type_meta_ver VARCHAR2(8) DEFAULT '1.0',
    set_name VARCHAR2(64),
    set_column_name VARCHAR2(64),
    default_value NUMBER(1), 
    value VARCHAR2(1024),
    value_nlsid	VARCHAR2(64),
    CONSTRAINT PK_CRED_SET_COL_VALS 
        PRIMARY KEY(target_type, target_type_meta_ver, set_name, 
                    set_column_name, value),    
    CONSTRAINT FK_CRED_SET_COL_VALS FOREIGN KEY (target_type, 
                                                  target_type_meta_ver,
                                                  set_name)
        REFERENCES MGMT_CREDENTIAL_SETS(target_type, target_type_meta_ver, 
                                         set_name)
            ON DELETE CASCADE
)
  INITRANS 2
  MONITORING;


REM
REM  CREDENTIAL_GUID The credential guid for this set. 
REM       All set columns have the same guid
REM  CREDENTIAL_SET_COLUMN The name of the credential set column
REM  CREDENTIAL_VALUE The value of the credential column
REM  CREDENTIAL_TYPE_NAME The actual credential type 
REM  CREDENTIAL_TYPE_COLUMN The actual credential type column
REM  KEY_VALUE The value of the "key" for this credential set
REM  ASSOC_TARGET_GUID The target that this credential is actually for
REM
CREATE TABLE MGMT_CREDENTIALS2
    (credential_guid RAW(16),
     credential_set_column VARCHAR2(64),
     credential_value VARCHAR2(256),
     credential_type_name VARCHAR2(32),
     credential_type_column VARCHAR2(32),
     key_value  VARCHAR2(256),
     assoc_target_guid RAW(16),
     CONSTRAINT PK_MGMT_CREDENTIALS 
         PRIMARY KEY(credential_guid, credential_set_column)
) 
  INITRANS 2
  MONITORING;

 

REM
REM The MGMT_TARGET_CREDENTIALS table stores credentials against
REM a target.
REM
REM CREDENTIAL_GUID The credential guid that references the stored
REM   values in the MGMT_CREDENTIALS table
REM TARGET_GUID The target that this credential set is for
REM CREDENTIAL_SET_NAME The credential set name
REM  USER_NAME The EM user on whose behalf this is stored, 
REM        '<SYSTEM>' for system credentials
REM  PDP_DATA   PDP Information associated with the credentials.
REM 
CREATE TABLE MGMT_TARGET_CREDENTIALS
    (target_guid RAW(16),
     credential_set_name VARCHAR2(32),
     user_name VARCHAR2(256) DEFAULT '<SYSTEM>',
     pdp_data VARCHAR(512) DEFAULT NULL,
     credential_guid RAW(16),
     CONSTRAINT PK_MGMT_TARGET_CREDS
         PRIMARY KEY (target_guid, credential_set_name, user_name)
) ORGANIZATION INDEX OVERFLOW
  INITRANS 2
  MONITORING;

REM
REM The MGMT_HOST_CREDENTIALS table stores credentials for all
REM    targets of a specified type on a host
REM
REM CREDENTIAL_GUID The credential guid that references the stored
REM   values in the MGMT_CREDENTIALS table
REM HOST_GUID The host guid
REM TARGET_TYPE The target type that this credential set is for
REM CREDENTIAL_SET_NAME The credential set name
REM  USER_NAME The EM user on whose behalf this is stored, 
REM        '<SYSTEM>' for system credentials
REM  PDP_DATA   PDP Information associated with the credentials.
REM 
CREATE TABLE MGMT_HOST_CREDENTIALS
    (host_guid RAW(16),
     target_type VARCHAR2(64),
     credential_set_name VARCHAR2(32),
     user_name VARCHAR2(256) DEFAULT '<SYSTEM>',
     pdp_data VARCHAR(512) DEFAULT NULL,
     credential_guid RAW(16),
     CONSTRAINT PK_MGMT_HOST_CREDS
         PRIMARY KEY (host_guid, target_type, 
                      credential_set_name, user_name)
) ORGANIZATION INDEX OVERFLOW
  INITRANS 2
  MONITORING;



REM
REM The MGMT_ENTERPRISE_CREDENTIALS table stores credentials for all 
REM     targets of a specified type in the enterprise.
REM
REM CREDENTIAL_GUID The credential guid that references the stored
REM   values in the MGMT_CREDENTIALS table
REM TARGET_TYPE The target type
REM TARGET_TYPE_META_VER The target type meta version
REM CREDENTIAL_SET_NAME The credential set name
REM  USER_NAME The EM user on whose behalf this is stored, 
REM        '<SYSTEM>' for system credentials
REM  PDP_DATA   PDP Information associated with the credentials.
REM 
CREATE TABLE MGMT_ENTERPRISE_CREDENTIALS
    (target_type VARCHAR2(64),
     credential_set_name VARCHAR2(32),
     user_name VARCHAR2(256) DEFAULT '<SYSTEM>',
     pdp_data VARCHAR(512) DEFAULT NULL,
     credential_guid RAW(16),
     CONSTRAINT PK_MGMT_ENTERPRISE_CREDS
         PRIMARY KEY (target_type, 
                      credential_set_name, user_name)
) ORGANIZATION INDEX OVERFLOW
  INITRANS 2
  MONITORING;


REM
REM The MGMT_CONTAINER_CREDENTIALS stores host credentials at the 
REM container level. A "container" is a software install, such as an 
REM Oracle Home or an ApplTop. The container_type column refers to the 
REM type of the container: currently supported values are 
REM "OracleHome" and "Appltop". The container_location is the full path 
REM of the container. Container credentials are always host credentials.
REM
REM CREDENTIAL_GUID The credential guid that references the stored
REM   values in the MGMT_CREDENTIALS table
REM TARGET_GUID The host that this credential set is for
REM CONTAINER_LOCATION The full path of the location
REM CREDENTIAL_SET_NAME The credential set name
REM  USER_NAME The EM user on whose behalf this is stored, 
REM        '<SYSTEM>' for system credentials
REM  PDP_DATA   PDP Information associated with the credentials.
REM 
CREATE TABLE MGMT_CONTAINER_CREDENTIALS
    (target_guid RAW(16),
     container_location VARCHAR2(1024),
     credential_set_name VARCHAR2(32),
     user_name VARCHAR2(256) DEFAULT '<SYSTEM>',
     pdp_data VARCHAR(512) DEFAULT NULL,
     credential_guid RAW(16),
     CONSTRAINT PK_MGMT_CONTAINER_CREDS 
         PRIMARY KEY (target_guid, container_location, 
                      credential_set_name, user_name)
) INITRANS 2
  MONITORING;


REM
REM The MGMT_JOB_CREDENTIALS table stores overridden credentials for jobs. 
REM These may be overridden per target, or for all targets of a specified 
REM type in the job. 
REM 
REM JOB_ID The job ID
REM CREDENTIAL_GUID The credential guid that references the stored
REM   values in the MGMT_CREDENTIALS table
REM TARGET_GUID The target that this credential set is for, null if 
REM    this is an entry for all targets of a specified type
REM TARGET_TYPE If target_guid is null, specifies the target type
REM    that the credentials pertain to
REM CONTAINER_LOCATION The container location
REM CREDENTIAL_SET_NAME The credential set name
REM  PDP_DATA   PDP Information associated with the credentials.
REM
CREATE TABLE MGMT_JOB_CREDENTIALS
    (job_id RAW(16),
     target_guid RAW(16),
     target_type VARCHAR2(64),
     container_location VARCHAR2(256),
     credential_set_name VARCHAR2(32),
     user_name VARCHAR2(256) DEFAULT '<SYSTEM>',
     pdp_data VARCHAR(512) DEFAULT NULL,
     credential_guid RAW(16),
     CONSTRAINT PK_MGMT_JOB_CREDS 
         PRIMARY KEY (job_id, target_guid, 
                      container_location, target_type, credential_set_name,
                      user_name)
    ) ORGANIZATION INDEX  OVERFLOW
  INITRANS 2
  MONITORING;


REM
REM The MGMT_COLLECTION_CREDENTIALS table stores credentials associated
REM with metric collections
REM 
REM METRIC_GUID The guid of the metric
REM CREDENTIAL_GUID The credential guid that references the stored
REM   values in the MGMT_CREDENTIALS table
REM TARGET_GUID The target that this credential set is for, null if 
REM    this is an entry for all targets of a specified type
REM COLL_NAME The name of the metric collection
REM CREDENTIAL_SET_NAME The credential set name
REM  PDP_DATA   PDP Information associated with the credentials.
REM
CREATE TABLE MGMT_COLLECTION_CREDENTIALS
    (target_guid RAW(16),
     metric_guid RAW(16),
     coll_name VARCHAR2(64),
     credential_set_name VARCHAR2(32),
     pdp_data VARCHAR(512) DEFAULT NULL,
     credential_guid RAW(16),
     CONSTRAINT PK_MGMT_COLL_CREDS 
         PRIMARY KEY (target_guid, metric_guid, coll_name, credential_set_name)
) ORGANIZATION INDEX
  INITRANS 2
  MONITORING;

REM
REM The MGMT_COLLECTION_TEMPLATE_CREDENTIALS table stores credentials 
REM associated with metric collections, stored with a template or a
REM template copy.
REM 
REM OBJECT_GUID   The guid of the template copy
REM OBJECT_TYPE   The type of the object (template/copy)
REM      1 - Template
REM      2 - Copy 
REM METRIC_GUID The guid of the metric
REM CREDENTIAL_GUID The credential guid that references the stored
REM   values in the MGMT_CREDENTIALS table
REM TARGET_GUID The target that this credential set is for, null if 
REM    this is an entry for all targets of a specified type
REM COLL_NAME The name of the metric collection
REM CREDENTIAL_SET_NAME The credential set name
REM  PDP_DATA   PDP Information associated with the credentials.
REM
CREATE TABLE MGMT_COLLECTION_TEMPLATE_CREDS
    (object_guid RAW(16),
     object_type NUMBER(1),
     target_guid RAW(16),
     metric_guid RAW(16),
     coll_name VARCHAR2(64),
     credential_set_name VARCHAR2(32),
     pdp_data VARCHAR(512) DEFAULT NULL,
     credential_guid RAW(16),
     CONSTRAINT PK_MGMT_COLL_TMPL_CREDS 
         PRIMARY KEY (object_guid, object_type, target_guid, metric_guid, coll_name, credential_set_name)
) ORGANIZATION INDEX
  INITRANS 2
  MONITORING;

REM
REM Storage of ARU credentials
REM
REM aru_username The ARU username
REM aru_password The ARU password
REM
CREATE TABLE MGMT_ARU_CREDENTIALS (
    aru_username VARCHAR2(255),
    aru_password VARCHAR2(256)
)
MONITORING;

REM
REM Storage of view-user credentials
REM
REM view_username The View username
REM view_password The view password
REM
CREATE TABLE MGMT_VIEW_USER_CREDENTIALS (
    view_username VARCHAR2(64),
    view_password VARCHAR2(256)
)
MONITORING;


REM
REM The MGMT_PDP_METADATA table contains metadata about a PDP (Privilege 
REM Delegation Provider) such as sudo or powerbroker. 
REM
REM pdp_guid                A unique guid to be used as the primary key 
REM pdp_name                The PDP name, for example sudo or powerbroker 
REM credential_type_name    The credential_type that this PDP attaches to, 
REM                         for example HostCreds 
CREATE TABLE MGMT_PDP_METADATA 
( 
    pdp_guid              RAW(16) NOT NULL, 
    pdp_name              VARCHAR2(64) NOT NULL, 
    credential_type_name  VARCHAR2(64) NOT NULL, 
    CONSTRAINT PK_MGMT_PDP_METADATA PRIMARY KEY(pdp_guid) 
) MONITORING;


REM
REM The MGMT_PDP_COLUMN_METADATA table contains additional metadata 
REM about a PDP, in particular the credential columns that this PDP 
REM adds to the Credential Type it is attached to. 
REM
REM pdp_guid         The PDP guid 
REM pdp_column_name  The credential column contributed to the 
REM                  credential type by the PDP,for example RunAs  
REM is_required      Is this column required. 
REM 
CREATE TABLE MGMT_PDP_COLUMN_METADATA 
( 
    pdp_guid        RAW(16) NOT NULL, 
    pdp_column_name VARCHAR2(64) NOT NULL, 
    is_required     NUMBER(1) DEFAULT 0, 
    CONSTRAINT PK_MGMT_PDP_CRED_METADATA PRIMARY KEY(pdp_guid, pdp_column_name), 
    CONSTRAINT FK_MGMT_PDP_CRED_METADATA FOREIGN KEY(pdp_guid) REFERENCES MGMT_PDP_METADATA(pdp_guid) ON DELETE CASCADE 
) MONITORING;


REM
REM The MGMT_PDP_SETTING_METADATA table contains additional metadata 
REM about a PDP, in particular the settings that can be used in named 
REM settings of this PDP. 
REM
REM pdp_guid             	The PDP guid 
REM pdp_setting_name     	The setting name, for example 'command' 
REM is_required                 Is this is a required setting
REM display_name_nlsid   	The NLS id of the display name 
REM display_name         	The default display Name 
REM hint_nlsid           	The NLS id of the Hint 
REM hint                 	The Default Hint 
REM
 
CREATE TABLE MGMT_PDP_SETTING_METADATA 
( 
    pdp_guid              RAW(16) NOT NULL, 
    pdp_setting_name      VARCHAR2(64) NOT NULL, 
    is_required           NUMBER(1) DEFAULT 0,
    display_name_nlsid    VARCHAR2(64) DEFAULT NULL,  
    display_name          VARCHAR2(64) DEFAULT NULL,  
    hint_nlsid            VARCHAR2(64) DEFAULT NULL,  
    hint                  VARCHAR2(256) DEFAULT NULL, 
    CONSTRAINT PK_MGMT_PDP_PROP_METADATA PRIMARY KEY(pdp_guid, pdp_setting_name), 
    CONSTRAINT FK_MGMT_PDP_PROP_METADATA FOREIGN KEY(pdp_guid) REFERENCES MGMT_PDP_METADATA(pdp_guid) ON DELETE CASCADE 
) MONITORING; 

REM
REM The MGMT_PDP_PARAM_METADATA table contains additional metadata 
REM about a PDP, in particular the parameters or 'placeholders' that 
REM this PDP knows about. 
REM
REM pdp_guid        	The PDP guid 
REM pdp_param_name  	The parameter the PDP know about, for example command,runas  
REM description_nlsid   The NLS id of the description 
REM description         Description 
REM 

CREATE TABLE MGMT_PDP_PARAM_METADATA 
( 
    pdp_guid            	RAW(16) NOT NULL, 
    pdp_param_name      	VARCHAR2(64) NOT NULL, 
    description_nlsid   	VARCHAR2(64) DEFAULT NULL,  
    description         	VARCHAR2(256) DEFAULT NULL, 
    CONSTRAINT PK_MGMT_PDP_PARAM_METADATA PRIMARY KEY(pdp_guid, pdp_param_name), 
    CONSTRAINT FK_MGMT_PDP_PARAM_METADATA FOREIGN KEY(pdp_guid) REFERENCES MGMT_PDP_METADATA(pdp_guid) ON DELETE CASCADE 
) MONITORING; 


Rem
Rem PURPOSE
Rem   Stores the pdp settings of a host. This table will not contain an entry if the target does not have any settings.
Rem
Rem COLUMNS
Rem   target_guid       target guid of the host
Rem   pdp_type          The Pdp type
Rem   pdp_setting_name    EMPDP_SUDO_SETTINGS / EMPDP_PBRUN_SETTINGS
Rem   pdp_setting_value   the value of the setting /bin/sudo ?? 
Rem
CREATE TABLE MGMT_PDP_HOST_SETTING
(
     target_guid        RAW(16)     NOT NULL,
     pdp_type             VARCHAR2(256) DEFAULT NULL,
     pdp_setting_name     VARCHAR2(256) DEFAULT NULL,
     pdp_setting_value    VARCHAR2(256) DEFAULT NULL,
     CONSTRAINT PK_MGMT_PDP_HOST_SETTING
                               PRIMARY KEY (target_guid, pdp_type, pdp_setting_name)
) MONITORING;


REM
REM The MGMT_PDP_SETTINGS table contains information about
REM named PDP settings that can be applied to targets.

REM
REM setting_guid        The Setting guid
REM setting_name        The name of this PDP setting, for example 'DefaultSudoTemplate'
REM pdp_type      Type of pdp setting sudo / pbrun

REM created_by    The User who created the PDP Setting

REM last_modified       Time when the Setting was Last Modified
REM

CREATE TABLE MGMT_PDP_SETTINGS
(
    setting_guid               RAW(16) NOT NULL,
    setting_name               VARCHAR2(64) NOT NULL,
    pdp_type                   VARCHAR2(64) NOT NULL,
    created_by                 VARCHAR2(256),
    last_modified              DATE,
    is_enabled		       NUMBER(1),
    CONSTRAINT PK_MGMT_PDP_TEMPLATES PRIMARY KEY(setting_name,pdp_type)
); 


REM
REM The MGMT_PDP_SETTING_VALUES table contains information about
REM named PDP settings that can be applied to targets.
REM setting_guid        The setting guid
REM value_name    The name of this PDP setting, for example 'DefaultSudoTemplate'
REM value   Value of the property, for example 'sudo -u %runas% %command%', 'yes'
REM

CREATE TABLE MGMT_PDP_SETTING_VALUES
(
    setting_guid        RAW(16),
    value_name   VARCHAR2(64),
    value   VARCHAR2(64)
); 

rem
rem MGMT_UPDATE_PDP_DATA_MAP
rem
rem PURPOSE
rem   Stores the mapping of OPERATION_GUID to setting_guid.
rem
rem COLUMNS
rem   OPERATION_GUID - Identifies data for a particular data propagation job
rem   setting_guid - GUID of the setting
rem   applied_by name os the user apllied the setting
rem
CREATE TABLE MGMT_UPDATE_PDP_DATA_MAP
    (
     operation_guid           RAW(16)          NOT NULL,
     setting_guid             RAW(16)          NOT NULL,
     applied_by               VARCHAR2(256)    NOT NULL
    ) MONITORING; 

rem
rem MGMT_UPDATE_PDP_DATA_COPY
rem
rem PURPOSE
rem   Stores update data for the apply PDP operation.
rem
rem COLUMNS
rem   DATA_SET_GUID   - Identifies update data for a particular update 
rem                     job; used to join this table with 
rem                     MGMT_UPDATE_OPERATIONS_DATA
rem  setting_name     - name of the setting (command/prompt_for_password etc)  
rem  setting_value     - actual value of the setting 
CREATE TABLE MGMT_UPDATE_PDP_DATA_COPY 
    (operation_guid           RAW(16)          NOT NULL,
     setting_name            VARCHAR2(64)     NOT NULL,
     setting_value           VARCHAR2(64)
    ) MONITORING;

