Rem drv: <create type="triggers" pos="collections/collections_triggers.sql+"/>
REM
REM $Header: credentials_triggers.sql 03-oct-2007.22:11:51 smalathe Exp $
REM
REM credentials_triggers.sql
REM
REM Copyright (c) 2002, 2007, Oracle. All rights reserved.  
REM
REM    NAME
REM      credentials_triggers.sql - Credentials subSystem triggers
REM
REM    DESCRIPTION
REM
REM    NOTES
REM
REM    MODIFIED 
REM       smalathe   10/03/07 - Bug 6459937: Handle non-key value insert from
REM                             Console
REM       smalathe   09/13/07 - Bug 5988432: Modify trigger on
REM                             mgmt_credentials2
REM       gsbhatia   07/01/05 - New repmgr header impl 
REM       gsbhatia   06/26/05 - New repmgr header impl 
REM       skini      04/15/05 - Add calls to broken ca code in triggers 
REM       gsbhatia   02/13/05 - updating repmgr header 
REM       gsbhatia   02/09/05 - updating repmgr header 
REM       gsbhatia   02/07/05 - updating repmgr header 
REM       ktlaw      01/11/05 - add repmgr header 
REM       skini      09/22/03 - Fix trigger issues 
REM       skini      09/21/03 - Propogation 
REM       skini      09/20/03 - Fix mutating error 
REM       skini      09/18/03 - Compute assoc info 
REM       skini      09/02/03 - Remove mgmt_cluster_credentials 
REM       skini      08/21/03 - unobfuscate credentials data 
REM       skini      08/19/03 - Add trigger for mgmt_cluster_credentials 
REM       skini      05/21/03 - skini_credentials
REM
REM

REM
REM Avoid mutating tables. When updating a key column, we 
REM always delete all non-key columns
REM
CREATE OR REPLACE TRIGGER MGMT_CREDS_UPD AFTER INSERT OR UPDATE ON
    MGMT_CREDENTIALS2
DECLARE
  l_updating BOOLEAN := false;
BEGIN
    IF UPDATING THEN
        l_updating := true;
    END IF;
    MGMT_CREDENTIAL.post_process(l_updating);
END;
/

REM
REM The following trigger encrypts entries into the creds table
REM and computes associated information
REM
CREATE OR REPLACE TRIGGER MGMT_CREDS_INS_UPD BEFORE INSERT OR UPDATE ON
     MGMT_CREDENTIALS2 FOR EACH ROW
DECLARE 
  l_target_guid MGMT_TARGETS.target_guid%TYPE := null;
  l_set_name MGMT_CREDENTIAL_SETS.set_name%TYPE;
  l_cred_value MGMT_CREDENTIALS2.credential_value%TYPE;
BEGIN
    IF :new.credential_value IS NOT NULL THEN
        :new.credential_value := encrypt(:new.credential_value);
    END IF;

    -- For console inserts of credentials, all associated 
    -- info is already computed
    -- If updating mgmt_credentials2 from MGMT_CREDS_UPD trigger, no need
    -- to do any further processing, is_no_recursion will be set
    IF MGMT_CREDENTIAL.is_console_insert OR MGMT_CREDENTIAL.is_no_recursion THEN
        RETURN;
    END IF;

    -- Compute associated info for target credentials
    BEGIN
        SELECT target_guid, credential_set_name 
        INTO   l_target_guid, l_set_name
        FROM   MGMT_TARGET_CREDENTIALS
        WHERE  credential_guid=:new.credential_guid;
    EXCEPTION
        WHEN NO_DATA_FOUND THEN
            l_target_guid := null;
    END;

    IF l_target_guid IS NOT NULL THEN
        IF :new.credential_value IS NOT NULL THEN
            l_cred_value := decrypt(:new.credential_value);
        ELSE
            l_cred_value := null;
        END IF;

        MGMT_CREDENTIAL.compute_associated_info(:new.credential_guid,
                                                l_target_guid,
                                                l_set_name,
                                                :new.credential_set_column,
                                                l_cred_value,
                                                :new.credential_type_name,
                                                :new.credential_type_column,
                                                :new.key_value,
                                                :new.assoc_target_guid);
    END IF;

END;
/
show errors;

REM
REM The following triggers delete corresponding entries from the
REM credentials table when entries are deleted from each of the tables
REM
CREATE OR REPLACE TRIGGER MGMT_TARGET_CREDS_DEL AFTER DELETE ON 
    MGMT_TARGET_CREDENTIALS FOR EACH ROW
DECLARE
l_target_type MGMT_TARGETS.target_type%TYPE;
BEGIN
    BEGIN
        SELECT  target_type
        INTO    l_target_type
        FROM    MGMT_TARGETS
        WHERE   target_guid=:old.target_guid;
    EXCEPTION
        WHEN NO_DATA_FOUND THEN
            -- Could happen when target is being deleted?
            NULL;
    END;

    DELETE FROM MGMT_CREDENTIALS2 WHERE credential_guid=:old.credential_guid;

    IF l_target_type IS NULL THEN RETURN; END IF;

    IF NOT MGMT_CREDENTIAL.is_40_style_set(:old.credential_set_name) THEN
        MGMT_JOB_ENGINE.target_creds_deleted(:old.target_guid, null,
                                           :old.credential_set_name,
                                           l_target_type,
                                           :old.user_name);
        MGMT_JOB_ENGINE.suspend_cred_execs;
    END IF;

END;
/
show errors;

CREATE OR REPLACE TRIGGER MGMT_HOST_CREDS_DEL AFTER DELETE ON 
    MGMT_HOST_CREDENTIALS FOR EACH ROW 
BEGIN
    DELETE FROM MGMT_CREDENTIALS2 WHERE credential_guid=:old.credential_guid;

    IF NOT MGMT_CREDENTIAL.is_40_style_set(:old.credential_set_name) THEN
        MGMT_JOB_ENGINE.target_creds_deleted(null, :old.host_guid,
                                             :old.credential_set_name,
                                             :old.target_type,
                                             :old.user_name);
        MGMT_JOB_ENGINE.suspend_cred_execs;
    END IF;

END;
/


CREATE OR REPLACE TRIGGER MGMT_CONT_CREDS_DEL AFTER DELETE ON 
    MGMT_CONTAINER_CREDENTIALS FOR EACH ROW 
DECLARE
l_target_type MGMT_TARGETS.target_type%TYPE;
BEGIN
    BEGIN
        SELECT  target_type
        INTO    l_target_type
        FROM    MGMT_TARGETS
        WHERE   target_guid=:old.target_guid;
    EXCEPTION
        WHEN NO_DATA_FOUND THEN
            -- Could happen when target is being deleted?
            NULL;
    END;

    DELETE FROM MGMT_CREDENTIALS2 WHERE credential_guid=:old.credential_guid;

    IF l_target_type IS NULL THEN RETURN; END IF;

    IF NOT MGMT_CREDENTIAL.is_40_style_set(:old.credential_set_name) THEN
        MGMT_JOB_ENGINE.container_creds_deleted(:old.target_guid,
                                                :old.container_location,
                                                :old.credential_set_name,
                                                l_target_type,
                                                :old.user_name);
         MGMT_JOB_ENGINE.suspend_cred_execs;
    END IF;
END;
/

CREATE OR REPLACE TRIGGER MGMT_ENT_CREDS_DEL AFTER DELETE ON 
    MGMT_ENTERPRISE_CREDENTIALS FOR EACH ROW
BEGIN
    DELETE FROM MGMT_CREDENTIALS2 WHERE credential_guid=:old.credential_guid;

     IF NOT MGMT_CREDENTIAL.is_40_style_set(:old.credential_set_name) THEN
         MGMT_JOB_ENGINE.target_creds_deleted(null, null,
                                              :old.credential_set_name,
                                              :old.target_type,
                                              :old.user_name);
         MGMT_JOB_ENGINE.suspend_cred_execs;
    END IF;

END;
/


CREATE OR REPLACE TRIGGER MGMT_JOB_CREDS_DEL AFTER DELETE ON 
    MGMT_JOB_CREDENTIALS FOR EACH ROW
BEGIN
    DELETE FROM MGMT_CREDENTIALS2 WHERE credential_guid=:old.credential_guid;
END;
/
