Rem drv: <create type="type_bodys" />
Rem
Rem $Header: credentials_type_bodys.sql 20-apr-2007.23:42:32 nqureshi Exp $
Rem
Rem credentials_type_bodys.sql
Rem
Rem Copyright (c) 2005, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      credentials_type_bodys.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      It defines the bodies of the types used in Credential module
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    nqureshi    04/18/07 - XbranchMerge kmanicka_pdp5 from main
Rem    kmanicka    05/10/06 - implement pdp
Rem    neearora    09/01/05 - neearora_bug-4582517
Rem    neearora    08/30/05 - Created
Rem

CREATE OR REPLACE TYPE BODY MGMT_CRED_SET_COL_RECORD AS
    CONSTRUCTOR FUNCTION MGMT_CRED_SET_COL_RECORD (
       type_column_name VARCHAR2,
       set_column_name VARCHAR2,
       set_column_display_name VARCHAR2,
       set_column_display_nlsid VARCHAR2)
    RETURN SELF AS RESULT
    AS 
    BEGIN
      SELF.type_column_name := type_column_name;
      SELF.set_column_name := set_column_name;
      SELF.set_column_display_name := set_column_display_name;
      SELF.set_column_display_nlsid := set_column_display_nlsid;    
      SELF.set_column_values := NULL;
      RETURN;
    END;
END;
/ 
show errors

CREATE OR REPLACE TYPE BODY MGMT_CRED_RECORD AS

    CONSTRUCTOR FUNCTION MGMT_CRED_RECORD(p_user_name VARCHAR2,
                                          p_credential_set_name VARCHAR2,
                                          p_creds MGMT_CRED_ROW_ARRAY
                                          )
    RETURN SELF AS RESULT  
    AS
    BEGIN
        user_name               := p_user_name;
        credential_set_name     := p_credential_set_name;
        creds                   := p_creds;
        pdp_data                := NULL;
        RETURN;
    END;

    STATIC FUNCTION NEW(p_user_name VARCHAR2,
                        p_credential_set_name VARCHAR2,
                        p_creds MGMT_CRED_ROW_ARRAY,
                        p_pdp_data VARCHAR2 DEFAULT NULL
                        )
    RETURN MGMT_CRED_RECORD    
    AS
    BEGIN
        RETURN(MGMT_CRED_RECORD(p_user_name,
                                p_credential_set_name,
                                p_creds,p_pdp_data)) ;
    END NEW;
END ;
/
show errors

CREATE OR REPLACE TYPE BODY MGMT_TARGET_CRED_RECORD AS
    STATIC FUNCTION NEW(p_target_name VARCHAR2,
                        p_target_type VARCHAR2,
                        p_credential MGMT_CRED_RECORD
                        )
    RETURN MGMT_TARGET_CRED_RECORD
    AS
    BEGIN
        RETURN(MGMT_TARGET_CRED_RECORD(p_target_name,
                                       p_target_type,
                                       p_credential)) ;
    END NEW;
END ;
/
show errors

CREATE OR REPLACE TYPE BODY MGMT_CLUSTER_CRED_RECORD AS
    STATIC FUNCTION NEW(p_cluster_name VARCHAR2,
                        p_cluster_type VARCHAR2,
                        p_target_type VARCHAR2,
                        p_credential MGMT_CRED_RECORD
                        )
    RETURN MGMT_CLUSTER_CRED_RECORD    
    AS
    BEGIN
        RETURN(MGMT_CLUSTER_CRED_RECORD(p_cluster_name,
                                        p_cluster_type,
                                        p_target_type,
                                        p_credential)) ;
    END NEW;
END ;
/
show errors

CREATE OR REPLACE TYPE BODY MGMT_HOST_CRED_RECORD AS
    STATIC FUNCTION NEW(p_host_name VARCHAR2,
                        p_target_type VARCHAR2,
                        p_credential MGMT_CRED_RECORD
                        )
    RETURN MGMT_HOST_CRED_RECORD        
    AS
    BEGIN
        RETURN(MGMT_HOST_CRED_RECORD(p_host_name,
                                     p_target_type,
                                     p_credential)) ;
    END NEW;
END ;
/
show errors

CREATE OR REPLACE TYPE BODY MGMT_ENTERPRISE_CRED_RECORD AS
    STATIC FUNCTION NEW(p_target_type VARCHAR2,
                        p_credential MGMT_CRED_RECORD
                        )
    RETURN MGMT_ENTERPRISE_CRED_RECORD            
    AS
    BEGIN
        RETURN(MGMT_ENTERPRISE_CRED_RECORD(p_target_type,p_credential)) ;
    END NEW;
END ;
/
show errors

CREATE OR REPLACE TYPE BODY MGMT_JOB_CRED_RECORD AS
    STATIC FUNCTION NEW(p_target_name VARCHAR2,
                        p_target_type VARCHAR2,
                        p_container_location VARCHAR2,
                        p_credential MGMT_CRED_RECORD
                        )
    RETURN MGMT_JOB_CRED_RECORD                
    AS
    BEGIN
        RETURN(MGMT_JOB_CRED_RECORD(p_target_name,
                                    p_target_type,
                                    p_container_location,
                                    p_credential)) ;
    END NEW;
END ;
/
show errors

CREATE OR REPLACE TYPE BODY MGMT_CONTAINER_CRED_RECORD AS
    STATIC FUNCTION NEW(p_target_name VARCHAR2,
                        p_target_type VARCHAR2,
                        p_container_location VARCHAR2,
                        p_credential MGMT_CRED_RECORD
                        )
    RETURN MGMT_CONTAINER_CRED_RECORD                    
    AS
    BEGIN
        RETURN(MGMT_CONTAINER_CRED_RECORD(p_target_name,
                                          p_target_type,
                                          p_container_location,
                                          p_credential)) ;
    END NEW;
END ;
/
show errors

CREATE OR REPLACE TYPE BODY MGMT_COLLECTION_CRED_RECORD AS
    STATIC FUNCTION NEW(p_target_name VARCHAR2,
                        p_target_type VARCHAR2,
                        p_metric_name VARCHAR2,
                        p_metric_column VARCHAR2,
                        p_collection_name VARCHAR2,
                        p_credential MGMT_CRED_RECORD
                        )
    RETURN MGMT_COLLECTION_CRED_RECORD                
    AS
    BEGIN
        RETURN(MGMT_COLLECTION_CRED_RECORD( p_target_name,
                                            p_target_type,
                                            p_metric_name,
                                            p_metric_column,
                                            p_collection_name,
                                            p_credential)) ;
    END NEW;
END ;
/
show errors


CREATE OR REPLACE TYPE BODY MGMT_PDP_COLUMN_META AS
    STATIC FUNCTION NEW(p_pdp_column_name VARCHAR2,
                        p_is_required NUMBER
                        )
    RETURN MGMT_PDP_COLUMN_META                
    AS
    BEGIN
        RETURN(MGMT_PDP_COLUMN_META( p_pdp_column_name,p_is_required)) ;
    END NEW;
END ;
/
show errors

CREATE OR REPLACE TYPE BODY MGMT_PDP_SETTING_META AS
    STATIC FUNCTION NEW(p_pdp_setting_name VARCHAR2,
                        p_is_required NUMBER,
                        p_display_name_nlsid VARCHAR2,
                        p_display_name VARCHAR2,
                        p_hint_nlsid VARCHAR2,
                        p_hint VARCHAR2
                        )
    RETURN MGMT_PDP_SETTING_META                
    AS
    BEGIN
        RETURN(MGMT_PDP_SETTING_META( p_pdp_setting_name,
                                      p_is_required,
                                      p_display_name_nlsid,
                                      p_display_name,
                                      p_hint_nlsid,
                                      p_hint)) ;
    END NEW;
END ;
/
show errors


CREATE OR REPLACE TYPE BODY MGMT_PDP_PARAM_META AS
    STATIC FUNCTION NEW(p_pdp_param_name VARCHAR2,
                        p_description_nlsid VARCHAR2,
                        p_description VARCHAR2
                        )
    RETURN MGMT_PDP_PARAM_META    
    AS
    BEGIN
        RETURN(MGMT_PDP_PARAM_META( p_pdp_param_name,
                                    p_description_nlsid,
                                    p_description)) ;
    END NEW;
END ;
/
show errors


CREATE OR REPLACE TYPE BODY MGMT_PDP_META AS
    STATIC FUNCTION NEW(p_pdp_name VARCHAR2,
                        p_credential_type_name VARCHAR2,
                        p_pdp_columns MGMT_PDP_COLUMN_META_ARRAY,
                        pdp_settings MGMT_PDP_SETTING_META_ARRAY,
                        pdp_params MGMT_PDP_PARAM_META_ARRAY
                        )
    RETURN MGMT_PDP_META    
    AS
    BEGIN
        RETURN(MGMT_PDP_META(p_pdp_name,
                             p_credential_type_name,
                             p_pdp_columns,
                             pdp_settings,
                             pdp_params)) ;
    END NEW;
END ;
/
show errors
