Rem drv: <create type="types"/>
REM
REM $Header: credentials_types.sql 20-apr-2007.23:42:32 nqureshi Exp $
REM
REM credentials_types.sql
REM
REM Copyright (c) 2002, 2007, Oracle. All rights reserved.  
REM
REM    NAME
REM      credentials_types.sql - Credentials subSystem pl/sql types
REM
REM    DESCRIPTION
REM
REM    NOTES
REM
REM    MODIFIED 
REM       nqureshi   04/18/07 - XbranchMerge kmanicka_pdp5 from main
REM       kmanicka   05/10/06 - implement pdp
REM       neearora   08/30/05 - Bug 4582517. Moved MGMT_CRED_SET_COL_RECORD 
REM                             body to credentials_type_bodys.sql 
REM       gsbhatia   06/26/05 - New repmgr header impl 
REM       neearora   04/06/05 - Overloaded the type MGMT_CRED_SET_COL_RECORD 
REM       gsbhatia   02/13/05 - updating repmgr header 
REM       gsbhatia   02/09/05 - updating repmgr header 
REM       gsbhatia   02/07/05 - updating repmgr header 
REM       ktlaw      01/11/05 - add repmgr header 
REM       rpinnama   10/10/04 - Add CRED_REC_ARRAY 
REM       rpinnama   10/01/04 - 
REM       skini      09/28/04 - Types fpr UDM credentials 
REM       sjconnol   07/27/04 - Add creds_info types
REM       skini      07/26/04 - Add support credential set column values 
REM       dcawley    07/07/04 - Increase user name size 
REM       skini      12/04/03 - Add ref type meta ver 
REM       skini      08/18/03 - Do not associate container_type with container 
REM       skini      08/16/03 - Add cluster credential types 
REM       skini      08/14/03 - Changes to credential ref definition 
REM       skini      07/09/03 - Changes in schema
REM       skini      06/09/03 - Add NLS Ids
REM       skini      05/21/03 - skini_credentials
REM
REM

REM Represents a credentials type column value
CREATE OR REPLACE TYPE MGMT_CRED_TYPE_COL_VAL AS OBJECT (
    value VARCHAR2(4000),
    default_value NUMBER(1)
);
/

REM Represents an array of credential type column values
CREATE OR REPLACE TYPE MGMT_CRED_TYPE_COL_VAL_ARRAY AS 
     TABLE OF MGMT_CRED_TYPE_COL_VAL;
/

REM Represents a credentials set column value
CREATE OR REPLACE TYPE MGMT_CRED_SET_COL_VAL AS OBJECT (
    value VARCHAR2(4000),
    default_value NUMBER(1)
);
/

REM Represents an array of credential set column values
CREATE OR REPLACE TYPE MGMT_CRED_SET_COL_VAL_ARRAY AS 
     TABLE OF MGMT_CRED_SET_COL_VAL;
/

REM Represents a credentials type ref
CREATE OR REPLACE TYPE MGMT_CRED_TYPE_REF AS OBJECT (
    ref_name VARCHAR2(64),
    type_name VARCHAR2(64),
    target_type VARCHAR2(256),
    ref_type_meta_ver VARCHAR2(8),
    association VARCHAR2(64)   
);
/

CREATE OR REPLACE TYPE MGMT_CRED_TYPE_REF_ARRAY AS TABLE OF MGMT_CRED_TYPE_REF;
/

REM Represents a credentials type column
CREATE OR REPLACE TYPE MGMT_CRED_TYPE_COL_RECORD AS OBJECT (
    type_column_name VARCHAR2(64),
    key NUMBER(1),
    ref_name VARCHAR2(64),
    ref_column_name VARCHAR2(64),
    type_column_display_name VARCHAR2(64),
    type_column_display_nlsid VARCHAR2(64),
    col_values MGMT_CRED_TYPE_COL_VAL_ARRAY
);
/

REM Represents an array of credential type columns
CREATE OR REPLACE TYPE MGMT_CRED_TYPE_COL_ARRAY AS 
    TABLE OF MGMT_CRED_TYPE_COL_RECORD;
/

REM Represents a credentials set column
CREATE OR REPLACE TYPE MGMT_CRED_SET_COL_RECORD AS OBJECT (
    type_column_name VARCHAR2(64),
    set_column_name VARCHAR2(64),
    set_column_display_name VARCHAR2(64),
    set_column_display_nlsid VARCHAR2(64),
    set_column_values MGMT_CRED_SET_COL_VAL_ARRAY,
    CONSTRUCTOR FUNCTION MGMT_CRED_SET_COL_RECORD (
       type_column_name VARCHAR2,
       set_column_name VARCHAR2,
       set_column_display_name VARCHAR2,
       set_column_display_nlsid VARCHAR2)
    RETURN SELF AS RESULT
);
/

CREATE OR REPLACE TYPE MGMT_CRED_SET_COL_ARRAY AS 
    TABLE OF MGMT_CRED_SET_COL_RECORD;
/

REM Represents a row in the credentials table
CREATE OR REPLACE TYPE MGMT_CRED_ROW_RECORD AS OBJECT (
    credential_set_column VARCHAR2(64),
    credential_value VARCHAR2(256)
);
/

CREATE OR REPLACE TYPE MGMT_CRED_ROW_ARRAY AS 
     TABLE OF MGMT_CRED_ROW_RECORD;
/

REM Represents a set of credentials in the credentials table
REM user_name The user for whom these credentials are stored, null if system creds
REM credential_set_name The credential set being used
REM creds The actual credential values
REM
CREATE OR REPLACE TYPE MGMT_CRED_RECORD AS OBJECT (
    user_name VARCHAR2(256),
    credential_set_name VARCHAR2(64),
    creds MGMT_CRED_ROW_ARRAY,
    pdp_data VARCHAR(512),
    CONSTRUCTOR FUNCTION MGMT_CRED_RECORD(p_user_name VARCHAR2,
                                          p_credential_set_name VARCHAR2,
                                          p_creds MGMT_CRED_ROW_ARRAY
                                          )
    RETURN SELF AS RESULT,    
    STATIC FUNCTION NEW(p_user_name VARCHAR2,
                        p_credential_set_name VARCHAR2,
                        p_creds MGMT_CRED_ROW_ARRAY,
                        p_pdp_data VARCHAR2 DEFAULT NULL
                        )
    RETURN MGMT_CRED_RECORD    
);
/

CREATE OR REPLACE TYPE MGMT_CRED_ARRAY AS 
     TABLE OF MGMT_CRED_RECORD;
/

REM Represents a set of target credentials
REM
CREATE OR REPLACE TYPE MGMT_TARGET_CRED_RECORD AS OBJECT (
    target_name VARCHAR2(256),
    target_type VARCHAR2(64),
    credential MGMT_CRED_RECORD,
    STATIC FUNCTION NEW(p_target_name VARCHAR2,
                        p_target_type VARCHAR2,
                        p_credential MGMT_CRED_RECORD
                        )
    RETURN MGMT_TARGET_CRED_RECORD
);
/

CREATE OR REPLACE TYPE MGMT_TARGET_CRED_ARRAY AS 
     TABLE OF MGMT_TARGET_CRED_RECORD;
/

REM Represents a set of cluster credentials
REM
CREATE OR REPLACE TYPE MGMT_CLUSTER_CRED_RECORD AS OBJECT (
    cluster_name VARCHAR2(256),
    cluster_type VARCHAR2(64),
    target_type VARCHAR2(64),
    credential MGMT_CRED_RECORD,
    STATIC FUNCTION NEW(p_cluster_name VARCHAR2,
                        p_cluster_type VARCHAR2,
                        p_target_type VARCHAR2,
                        p_credential MGMT_CRED_RECORD
                        )
    RETURN MGMT_CLUSTER_CRED_RECORD    
);
/

CREATE OR REPLACE TYPE MGMT_CLUSTER_CRED_ARRAY AS 
       TABLE OF MGMT_CLUSTER_CRED_RECORD;
/

REM Represents a set of credentials stored at the host level
REM for all targets of a specified type on the host
REM
CREATE OR REPLACE TYPE MGMT_HOST_CRED_RECORD AS OBJECT (
    host_name VARCHAR2(256),
    target_type VARCHAR2(64),
    credential MGMT_CRED_RECORD,
    STATIC FUNCTION NEW(p_host_name VARCHAR2,
                        p_target_type VARCHAR2,
                        p_credential MGMT_CRED_RECORD
                        )
    RETURN MGMT_HOST_CRED_RECORD        
);
/

CREATE OR REPLACE TYPE MGMT_HOST_CRED_ARRAY AS TABLE OF MGMT_HOST_CRED_RECORD;
/

REM Represents a set of credentials stored at the enterprise
REM level for all targets of a specified type
REM
CREATE OR REPLACE TYPE MGMT_ENTERPRISE_CRED_RECORD AS OBJECT (
    target_type VARCHAR2(64),
    credential MGMT_CRED_RECORD,
    STATIC FUNCTION NEW(p_target_type VARCHAR2,
                        p_credential MGMT_CRED_RECORD
                        )
    RETURN MGMT_ENTERPRISE_CRED_RECORD            
);
/


CREATE OR REPLACE TYPE MGMT_ENTERPRISE_CRED_ARRAY AS 
    TABLE OF MGMT_ENTERPRISE_CRED_RECORD;
/


REM Represents a set of credentials stored at job level
REM (Overridden credentials for the job) The target name
REM  could be null, in which case the credentials represent
REM  overridden credentials for all targets of that type
REM
CREATE OR REPLACE TYPE MGMT_JOB_CRED_RECORD AS OBJECT (
    target_name VARCHAR2(256),
    target_type VARCHAR2(64),
    container_location VARCHAR2(255),
    credential MGMT_CRED_RECORD,
    STATIC FUNCTION NEW(p_target_name VARCHAR2,
                        p_target_type VARCHAR2,
                        p_container_location VARCHAR2,
                        p_credential MGMT_CRED_RECORD
                        )
    RETURN MGMT_JOB_CRED_RECORD                
);
/

CREATE OR REPLACE TYPE MGMT_JOB_CRED_ARRAY AS TABLE OF MGMT_JOB_CRED_RECORD;
/

REM
REM Represents a set of credentials at the container level
REM
CREATE OR REPLACE TYPE MGMT_CONTAINER_CRED_RECORD AS OBJECT (
    target_name VARCHAR2(256),
    target_type VARCHAR2(64),
    container_location VARCHAR2(255),
    credential MGMT_CRED_RECORD,
    STATIC FUNCTION NEW(p_target_name VARCHAR2,
                        p_target_type VARCHAR2,
                        p_container_location VARCHAR2,
                        p_credential MGMT_CRED_RECORD
                        )
    RETURN MGMT_CONTAINER_CRED_RECORD                    
);
/

CREATE OR REPLACE TYPE MGMT_CONTAINER_CRED_ARRAY AS TABLE OF MGMT_CONTAINER_CRED_RECORD;
/

CREATE OR REPLACE TYPE MGMT_COLLECTION_CRED_RECORD AS OBJECT (
    target_name VARCHAR2(256),
    target_type VARCHAR2(64),
    metric_name VARCHAR2(64),
    metric_column VARCHAR2(64),
    collection_name VARCHAR2(64),
    credential MGMT_CRED_RECORD,
    STATIC FUNCTION NEW(p_target_name VARCHAR2,
                        p_target_type VARCHAR2,
                        p_metric_name VARCHAR2,
                        p_metric_column VARCHAR2,
                        p_collection_name VARCHAR2,
                        p_credential MGMT_CRED_RECORD
                        )
    RETURN MGMT_COLLECTION_CRED_RECORD                
);
/

CREATE OR REPLACE TYPE MGMT_COLLECTION_CRED_ARRAY AS TABLE OF MGMT_COLLECTION_CRED_RECORD;
/

CREATE OR REPLACE TYPE MGMT_CREDS_LOUTPUT AS TABLE OF VARCHAR2(128);
/

CREATE OR REPLACE TYPE MGMT_CREDS_SOUTPUT AS TABLE OF VARCHAR2(10);
/


CREATE OR REPLACE TYPE MGMT_PDP_COLUMN_META AS OBJECT (
    pdp_column_name  VARCHAR2(64),
    is_required  NUMBER(1),
    STATIC FUNCTION NEW(p_pdp_column_name VARCHAR2,
                        p_is_required NUMBER
                        )
    RETURN MGMT_PDP_COLUMN_META                
);
/

CREATE OR REPLACE TYPE MGMT_PDP_COLUMN_META_ARRAY AS TABLE OF MGMT_PDP_COLUMN_META;
/

CREATE OR REPLACE TYPE MGMT_PDP_SETTING_META AS OBJECT (
    pdp_setting_name    VARCHAR2(64),
    is_required         NUMBER(1),
    display_name_nlsid  VARCHAR2(64),
    display_name        VARCHAR2(64),
    hint_nlsid          VARCHAR2(64),
    hint                VARCHAR2(264),
    STATIC FUNCTION NEW(p_pdp_setting_name VARCHAR2,
                        p_is_required NUMBER, 
                        p_display_name_nlsid VARCHAR2,
                        p_display_name VARCHAR2,
                        p_hint_nlsid VARCHAR2,
                        p_hint VARCHAR2
                        )
    RETURN MGMT_PDP_SETTING_META                
);
/

CREATE OR REPLACE TYPE MGMT_PDP_SETTING_META_ARRAY AS TABLE OF MGMT_PDP_SETTING_META;
/

CREATE OR REPLACE TYPE MGMT_PDP_PARAM_META AS OBJECT (
    pdp_param_name      VARCHAR2(64),
    description_nlsid   VARCHAR2(64),
    description         VARCHAR2(256),
    STATIC FUNCTION NEW(p_pdp_param_name VARCHAR2,
                        p_description_nlsid VARCHAR2,
                        p_description VARCHAR2
                        )
    RETURN MGMT_PDP_PARAM_META    
);
/

CREATE OR REPLACE TYPE MGMT_PDP_PARAM_META_ARRAY AS TABLE OF MGMT_PDP_PARAM_META;
/


CREATE OR REPLACE TYPE MGMT_PDP_META AS OBJECT (
    pdp_name                VARCHAR2(64),
    credential_type_name    VARCHAR2(64),
    pdp_columns             MGMT_PDP_COLUMN_META_ARRAY,
    pdp_settings            MGMT_PDP_SETTING_META_ARRAY,
    pdp_params              MGMT_PDP_PARAM_META_ARRAY,
    STATIC FUNCTION NEW(p_pdp_name VARCHAR2,
                        p_credential_type_name VARCHAR2,
                        p_pdp_columns MGMT_PDP_COLUMN_META_ARRAY,
                        pdp_settings MGMT_PDP_SETTING_META_ARRAY,
                        pdp_params MGMT_PDP_PARAM_META_ARRAY
                        )
    RETURN MGMT_PDP_META    
);
/

CREATE OR REPLACE TYPE MGMT_PDP_META_ARRAY AS TABLE OF MGMT_PDP_META;
/

CREATE OR REPLACE TYPE MGMT_PDP_ACTUAL_SETTING AS OBJECT (
pdp_value_name           VARCHAR2(256),
pdp_value                VARCHAR2(256)
);
/

CREATE OR REPLACE TYPE MGMT_PDP_ACTUAL_SETTING_ARRAY AS TABLE OF MGMT_PDP_ACTUAL_SETTING;
/

