Rem drv: <create type="pkgdefs" pos="policy/policy_pkgdef.sql+"/>
Rem
Rem $Header: 
Rem
Rem credentials_ui_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      credentials_ui_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Preferred Credentials PL/SQL routines
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    nqureshi    07/04/07 - support for delete pdp setting cli
Rem    nqureshi    05/23/07 - backporting precedures
Rem    nqureshi    04/21/07 - pdp backport 
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    sjconnol    07/27/04 - sjconnol_bug-3785403
Rem    sjconnol    07/27/03 - Creation
Rem

CREATE OR REPLACE PACKAGE MGMT_CREDENTIALS_UI AS

TYPE CURSOR_TYPE IS REF CURSOR;

--
-- Name: get_creds_summary
--
-- Package: MGMT_CREDENTIALS_UI
--
-- Purpose: 
--  Get pref creds summary info for pref creds home page
--
-- OUT parameters:
--   targettype: TABLE
--               Array of target types having pref creds
--   numtargets: TABLE
--               Array of number of targets of each type
--   defset: TABLE
--           Array of booleans indicating whether default creds are
--           set for this type
--   numset: TABLE
--           Array of number of targets of type with creds set
PROCEDURE get_creds_summary (targettype OUT MGMT_CREDS_LOUTPUT, numtargets OUT MGMT_CREDS_SOUTPUT, defset OUT MGMT_CREDS_SOUTPUT, numset OUT MGMT_CREDS_SOUTPUT);

-- deletes the PDP settings 
PROCEDURE delete_pdp_settings(p_setting_guid_in IN MGMT_USER_GUID_ARRAY) ;

-- create the PDP settings 
PROCEDURE create_pdp_settings(p_setting_name_in IN VARCHAR ,
                              p_setting_type_in IN VARCHAR ,
                              p_setting_values_in IN MGMT_PDP_ACTUAL_SETTING_ARRAY,
                              p_setting_status_in IN NUMBER,
                              p_error_code_out OUT VARCHAR);

PROCEDURE apply_pdp(       
                           p_setting_guid_in IN RAW,
                           p_setting_values_in IN MGMT_PDP_ACTUAL_SETTING_ARRAY,
                           p_setting_status_in IN NUMBER,
                           p_pdp_type_in IN VARCHAR2 ,
                           p_destination_list IN MGMT_JOB_TARGET_LIST,
                           p_update_master_agents IN NUMBER DEFAULT 1
                           );



PROCEDURE REMOVE_PDP_SETTING(p_target_name_in IN VARCHAR2,p_target_type_in IN VARCHAR2 ) ;

PROCEDURE INSERT_PDP_SETTING( p_target_name_in IN VARCHAR2,
            p_target_type_in IN VARCHAR2 ,
            p_setting_type_in IN VARCHAR2 ,
            p_setting_values_in IN SMP_EMD_NVPAIR_ARRAY );

PROCEDURE GET_PDP_SETTINGS( p_setting_guid_in IN RAW,
                            p_settings_cur OUT  CURSOR_TYPE );

PROCEDURE VLDTE_PDP_STNG_NMES_AND_SUBMIT( p_setting_names_in IN MGMT_SHORT_STRING_ARRAY,
                                          p_invalid_settings_cur OUT  CURSOR_TYPE,
                                          p_has_error_out OUT NUMBER );

END MGMT_CREDENTIALS_UI;
/

SHOW ERRORS;


