Rem
Rem IMPORTANT:  the corresponding PLB must contain header that looks
Rem Like : type="funcs" condition="EM_REPOS_MODE=CENTRAL"
Rem because this is for GC mode only
Rem
Rem $Header: crypt_funcs.sql 12-aug-2006.11:30:42 bmallipe Exp $
Rem
Rem crypt_funcs.sql
Rem
Rem Copyright (c) 2002, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      crypt_funcs.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    shianand    07/21/06 - Backport shianand_bug-5346292 from main 
Rem    shianand    07/12/06 - fix bug 5346292, fix encrypt, decrypt from 
Rem                           rootkit attacks 
Rem    shianand    07/06/06 - fix bug 5346292, fix encrypt, decrypt from 
Rem                           rootkit attacks 
Rem    bmallipe    08/12/06 - adding disclaimer about headers in PLB files
Rem    kmanicka    08/04/05 - emkey install fix
Rem    kmanicka    07/24/05 - fix getemkey to check if key is in repos
Rem    kmanicka    06/17/05 - oms based encryption key
Rem    dsahrawa    03/04/05 - bug 4176191, check for null inputs 
Rem    gsbhatia    02/08/05 - Removing header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    rpinnama    12/10/03 - Fix 3310479: Support encryptBytes/decryptBytes 
Rem    dsahrawa    12/08/03 - Increase size of key 
Rem    dmshah      11/12/02 - encryption/decryption in raw format
Rem    dmshah      10/28/02 - Allowing more than 2k of encryption/decryption
Rem    rpinnama    10/18/02 - Use non-doc comments
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Created
Rem


create or replace function getEMKey
          return RAW AS
l_emkey RAW(64) := null;           
begin
    EXECUTE IMMEDIATE 'SELECT MGMT_TIME_SYNC.getTimeCoff FROM DUAL'
    INTO l_emkey;

    return l_emkey;
end;
/

show errors;


-- UnPad function unpads whatever pad text has been concatenated to the
-- text by the pad function.
create or replace function unpad( plain_text in varchar2 )
          return varchar2 AS
    raw_text RAW(32767);

    text_length NUMBER := 0;
    pad_length NUMBER;
    
begin
    -- The plan : Convert the plain_text into a stream of bytes, get the last
    -- byte, convert it to a number which gives us the number of pad bytes
    -- appended. Use that to get a substring minus the pad bytes.

    raw_text := SYS.UTL_RAW.cast_to_raw( plain_text );

    text_length := SYS.UTL_RAW.length( raw_text );

    -- Usage of substr : SYS.UTL_RAW.substr( raw, pos, len)
    -- pos:= -1 returns len characters measured from the end of the string.
    pad_length := SYS.UTL_RAW.cast_to_varchar2(
                            SYS.UTL_RAW.substr(raw_text, -1, 1));

    -- get the original string ...
    raw_text := SYS.UTL_RAW.substr( raw_text, 1, (text_length-pad_length));

    return SYS.UTL_RAW.cast_to_varchar2( raw_text );
end;
/

show errors;

create or replace function padBytes(inp_bytes IN RAW)
  RETURN RAW AS
   out_bytes RAW(32767);
   inp_length NUMBER := 8;
   pad_length NUMBER;
   pad_byte   RAW(1);
   pad_lengthc VARCHAR2(1 BYTE);
BEGIN
   -- if the length is >8 then use the formula 8 - (8 mod n), if
   -- the length is <8 then use the formula 8 - (8mod(8+n)) to
   -- arrive at the pad length.
   inp_length := SYS.UTL_RAW.length( inp_bytes );

   if inp_length < 8 then
     inp_length := inp_length + 8;
   end if;

   pad_length := 8-(mod(inp_length, 8));

   -- we need to stuff the pad_length number into a byte. Note that
   -- we do not expect pad_length to be > 8
   pad_lengthc:=to_char(pad_length);

   -- the copies function acts like a concat in a loop.
   out_bytes := SYS.UTL_RAW.concat(inp_bytes,
                               SYS.UTL_RAW.copies(SYS.UTL_RAW.cast_from_number(pad_lengthc), 
			                      pad_length)
                              );

   return out_bytes;

END;
/

show errors;

-- Pad funtion pads the input text to confirm it to 8 byte boundaries
create or replace function pad( plain_text in varchar2 )
          return varchar2 AS
     raw_text RAW(32767);
    
     plain_text_length NUMBER := 8;
     pad_length NUMBER;
     pad_lengthc VARCHAR2(1 BYTE);
begin

    -- first convert varchar2 to raw, then find out the length.
    -- if the length is >8 then use the formula 8 - (8 mod n), if
    -- the length is <8 then use the formula 8 - (8mod(8+n)) to
    -- arrive at the pad length.

    raw_text := SYS.UTL_RAW.cast_to_raw( plain_text );
    plain_text_length := SYS.UTL_RAW.length( raw_text );

    if plain_text_length < 8
    then
        plain_text_length:=8+plain_text_length;
    end if;

    pad_length:=8-(mod(plain_text_length,8));
    
    -- we need to stuff the pad_length number into a byte. Note that
    -- we do not expect pad_length to be > 8
    pad_lengthc:=to_char(pad_length);

    -- the copies function acts like a concat in a loop.
    raw_text := SYS.UTL_RAW.concat(raw_text,
                               SYS.UTL_RAW.copies(SYS.UTL_RAW.cast_to_raw(pad_lengthc),
                                              pad_length)
                              );
    return SYS.UTL_RAW.cast_to_varchar2( raw_text );
end;
/ 

show errors;


-- UnPadBytes function unpads whatever pad bytes have been concatenated to the
-- actual bytes by the pad function.
create or replace function unpadBytes( inp_bytes IN RAW )
          return raw AS
    out_bytes RAW(32767);

    inp_length NUMBER := 0;
    pad_length NUMBER;
    
begin
    -- The plan : Convert the inp_bytes into a stream of bytes, get the last
    -- byte, convert it to a number which gives us the number of pad bytes
    -- appended. Use that to get a substring minus the pad bytes.

    inp_length := SYS.UTL_RAW.length( inp_bytes );

    -- Usage of substr : SYS.UTL_RAW.substr( raw, pos, len)
    -- pos:= -1 returns len characters measured from the end of the string.
    pad_length := SYS.UTL_RAW.cast_to_number(
                            SYS.UTL_RAW.substr(inp_bytes, -1, 1));

    -- get the original string ...
    out_bytes := SYS.UTL_RAW.substr( inp_bytes, 1, (inp_length-pad_length));

    return out_bytes;
end;
/

show errors;


-- The encrypt algorithm. Accesses the session sys_context to see if
-- if the key is already generated or not. If the key is already 
-- generated, then it proceeds with the encryption using the key
-- otherwise it generates the key first, populates the sys_context and
-- then proceeds for encryption.
create or replace function encrypt(plain_text in VARCHAR2)
          return varchar2 AS
      cipher_text RAW(32767);
begin

    if plain_text is null then
        return null;
    end if;

    SYS.DBMS_OBFUSCATION_TOOLKIT.des3encrypt( 
                input=>SYS.UTL_RAW.cast_to_raw(pad(plain_text)),
                key=>getEMKey(),
                encrypted_data=>cipher_text );

    return SYS.UTL_RAW.cast_to_varchar2(cipher_text);
end;
/

show errors;

-- The decrypt algorithm. Accesses the session sys_context to see 
-- if the key is already generated or not. If the key is already 
-- generated, then it proceeds with the decryption using the key
-- otherwise it generates the key first, populates the sys_context and
-- then proceeds for decryption.
create or replace function decrypt(cipher_text in varchar2)
          return varchar2 AS
      plain_text varchar2(32767);
begin
    if cipher_text is null then
        return null;
    end if;

    SYS.DBMS_OBFUSCATION_TOOLKIT.des3decrypt( 
                     input=>SYS.UTL_RAW.cast_to_raw(cipher_text),
                     key=>getEMKey(),
                     decrypted_data=>plain_text);

    return unpad(SYS.UTL_RAW.cast_to_varchar2(plain_text));
end;
/

show errors;

create or replace function encryptBytes(raw_bytes IN RAW)
    return RAW AS
  cipher_bytes RAW(32767);
BEGIN

  cipher_bytes  := SYS.UTL_RAW.cast_to_raw( encrypt(SYS.UTL_RAW.cast_to_varchar2(raw_bytes)) );

  return cipher_bytes;

END;
/

show errors;

CREATE OR REPLACE FUNCTION decryptBytes(cipher_bytes IN RAW)
          RETURN RAW AS
      raw_bytes RAW(32767);
BEGIN

  raw_bytes := SYS.UTL_RAW.cast_to_raw(decrypt(SYS.UTL_RAW.cast_to_varchar2(cipher_bytes)));

  return raw_bytes;

END;
/

show errors;

