Rem
Rem IMPORTANT:  the corresponding PLB must contain header that looks
Rem Like : type="funcs" condition="EM_REPOS_MODE=SYSAUX"
Rem because this is for DBCONTROL mode only
Rem
Rem $Header: crypt_funcs_10g.sql 12-aug-2006.11:30:43 bmallipe Exp $
Rem
Rem crypt_funcs_10g.sql
Rem
Rem Copyright (c) 2003, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      crypt_funcs_10g.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    shianand    07/21/06 - Backport shianand_bug-5346292 from main 
Rem    shianand    07/12/06 - fix bug 5346292, fix encrypt, decrypt from 
Rem                           rootkit attacks 
Rem    shianand    07/06/06 - fix bug 5346292, fix encrypt, decrypt from 
Rem                           rootkit attacks 
Rem    bmallipe    08/12/06 - adding disclaimer about headers in PLB files
Rem    kmanicka    08/04/05 - emkey install fix
Rem    kmanicka    07/24/05 - fix getemkey to check if key is in repos
Rem    kmanicka    06/17/05 - oms based encryption key
Rem    dsahrawa    03/04/05 - bug 4176191, check for null inputs 
Rem    dsahrawa    08/24/04 - fix i18n issues 
Rem    rpinnama    12/10/03 - Fix 3310479: Provide a function to encrypt bytes 
Rem    dsahrawa    12/09/03 - dsahrawa_bug-3105681 
Rem    dsahrawa    12/01/03 - Created
Rem

create or replace function getEMKey
          return RAW AS
l_emkey RAW(64) := null;           
begin
    EXECUTE IMMEDIATE 'SELECT MGMT_TIME_SYNC.getTimeCoff FROM DUAL'
    INTO l_emkey;
    
    return l_emkey;
end;
/

show errors;



create or replace function encryptBytes(raw_bytes IN RAW)
    return RAW AS
  cipher_bytes RAW(32767);
BEGIN

  cipher_bytes := SYS.DBMS_CRYPTO.encrypt( 
		      src=>raw_bytes,
		      typ=>SYS.DBMS_CRYPTO.ENCRYPT_3DES+SYS.DBMS_CRYPTO.CHAIN_CBC+SYS.DBMS_CRYPTO.PAD_PKCS5,
		      key=>getEMKey() );

  return cipher_bytes;
END;
/

show errors;

CREATE OR REPLACE FUNCTION decryptBytes(cipher_bytes IN RAW)
          RETURN RAW AS
      raw_bytes RAW(32767);
BEGIN
    raw_bytes := SYS.DBMS_CRYPTO.decrypt( 
                     src=>cipher_bytes,
                     typ=>SYS.DBMS_CRYPTO.ENCRYPT_3DES+SYS.DBMS_CRYPTO.CHAIN_CBC+SYS.DBMS_CRYPTO.PAD_PKCS5,
                     key=>getEMKey());

    return raw_bytes;
END;
/

show errors;

-- The encrypt algorithm. The src for encryption needs 
-- to be in RAW format. We convert the VARCHAR2 plain_text 
-- to RAW via UTF8 using UTL_18N.STRING_TO_RAW.
create or replace function encrypt(plain_text in VARCHAR2)
          return varchar2 AS
      cipher_text RAW(32767);
begin
    if plain_text is null then
        return null;
    end if;

    cipher_text := SYS.DBMS_CRYPTO.encrypt( 
                src=>SYS.UTL_I18N.STRING_TO_RAW(plain_text, 'AL32UTF8'),
                typ=>SYS.DBMS_CRYPTO.ENCRYPT_3DES+SYS.DBMS_CRYPTO.CHAIN_CBC+SYS.DBMS_CRYPTO.PAD_PKCS5,
                key=>getEMKey());

    return RAWTOHEX(cipher_text);
end;
/

show errors;

-- The decrypt algorithm. See encrypt. DMBS_CRYPTO.decryt
-- returns the result in RAW and this needs to be massaged
-- appropriately.
create or replace function decrypt(cipher_text in varchar2)
          return varchar2 AS
      raw_text RAW(32767);
begin
    if cipher_text is null then
        return null;
    end if;

    raw_text := SYS.DBMS_CRYPTO.decrypt( 
                     src=>HEXTORAW(cipher_text),
                     typ=>SYS.DBMS_CRYPTO.ENCRYPT_3DES+SYS.DBMS_CRYPTO.CHAIN_CBC+SYS.DBMS_CRYPTO.PAD_PKCS5,
                     key=>getEMKey());

    return SYS.UTL_I18N.RAW_TO_CHAR(raw_text, 'AL32UTF8');
end;
/

show errors;
