Rem drv: <create type="pkgdefs" pos="collections/collections_util_pkgdef.sql+"/>
Rem
Rem $Header: data_propagation_pkgdef.sql 21-apr-2007.00:35:05 nqureshi Exp $
Rem
Rem data_propagation_pkgdef.sql
Rem
Rem Copyright (c) 2003, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      data_propagation_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem     This is an internal package that provides low-level services
Rem     to propagate target-related data to one or more targets.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED  (MM/DD/YY)
Rem    nqureshi   04/21/07 - pdp backport
Rem    gan        08/09/05 - add API for job 
Rem    gan        07/29/05 - add save_repo_mntr_setting 
Rem    gsbhatia   07/01/05 - New repmgr header impl 
Rem    rzazueta   06/16/05 - Add purge routine 
Rem    jgwang     01/26/05 - add support for UDM credentials 
Rem    rzazueta   10/11/04 - Add collection credentials to apply_template 
Rem    rpinnama   10/10/04 - Replace template_ with mntr_ 
Rem    rzazueta   10/03/04 - Add CA credentials to apply_template 
Rem    rzazueta   09/01/04 - Add support for templates 
Rem    skini      09/22/03 - Data prop for credentials 
Rem    njuillar   07/23/03 - Remove copy_from flag in update_metric_thresholds
Rem    njuillar   07/07/03 - Fixed Copy From source target name issue
Rem    rzazueta   06/16/03 - Add delete_operation_data method
Rem    rzazueta   06/12/03 - rzazueta_propagate_target_data
Rem    rzazueta   06/09/03 - Creation
Rem

CREATE OR REPLACE PACKAGE MGMT_TARGET_UPDATE AS

TYPE CURSOR_TYPE IS REF CURSOR;

-- Constants for target operation types
TARGET_OP_THRESHOLDS    CONSTANT NUMBER(2) := 1;
TARGET_OP_PROPERTIES    CONSTANT NUMBER(2) := 2;
TARGET_OP_CREDENTIALS   CONSTANT NUMBER(2) := 3;
TARGET_OP_TEMPLATES     CONSTANT NUMBER(2) := 4;
TARGET_OP_MNTR_SETTINGS CONSTANT NUMBER(2) := 5;
TARGET_OP_COLL_CREDENTIALS   CONSTANT NUMBER(2) := 6;
TARGET_OP_APPLY_PDP     CONSTANT NUMBER(2) := 7;

-- Constants for Propagate Target Data job
PROPTGTDATA_JOB_TYPE        CONSTANT VARCHAR2(17) := 'PropagateTarget';
PROPTGTDATA_JOB_DESCRIPTION CONSTANT VARCHAR2(64) := 'This is a Propagate Target Data job';
PROPTGTDATA_JOB_NAME_PREFIX CONSTANT VARCHAR2(17) := 'PROPTGTDATAJOB_';

TYPE p_rowid_list_type IS
  TABLE OF UROWID
  INDEX BY BINARY_INTEGER;

p_purge_batchsize        PLS_INTEGER := 1000; -- rows/bulk delete

PROCEDURE PURGE(pcb_params IN OUT MGMT_PURGE_CALLBACK_PARAMS);

-- This is public for internal use only. 
--
-- PROCEDURE: clean_on_tgt_del
--
-- PURPOSE:
--   Cleanup data propagation entries as needed whenever a target is deleted.
--     The data propagation tables that have target info in them are marked
--     as exceptions and will not be cleaned by the admin routines.
--
--   IN Parameters:
--     target_name_in : target name of the deleted target
--     target_type_in : target type of the deleted target
--     target_guid_in : target guid of the deleted target
--
--
--   OUT Parameters:
--     NONE
PROCEDURE clean_on_tgt_del
   (target_name_in IN VARCHAR2,
    target_type_in IN VARCHAR2,
    target_guid_in IN RAW);


-- PROCEDURE: stop_executions
--
-- PURPOSE:
--   Stop executions of scheduled data propagation jobs.
--
--   IN Parameters:
--     p_execution_ids : array of execution ids to be stopped.
--
--   OUT Parameters:
--     p_target_name_cursor : target names on which the user does not have operator 
--                            privilege.
--     p_execution_id_cursor: execution ids that could not be stopped because they 
--                            were already running
--
PROCEDURE stop_executions(p_execution_ids IN MGMT_JOB_GUID_ARRAY,
                          p_target_name_cursor OUT CURSOR_TYPE,
                          p_execution_id_cursor OUT CURSOR_TYPE);


-- PROCEDURE: delete_executions
--
-- PURPOSE:
--   Delete data propagation entries for executions which are completed, stopped, failed or
--   aborted.
--
--   IN Parameters:
--     p_execution_ids : array of execution ids to be deleted.
--
--   OUT Parameters:
--     p_target_name_cursor : target names on which the user does not have operator 
--                            privilege.
--     p_execution_id_cursor: execution ids that could not be deleted because they 
--                            are scheduled or running.
--
--   Notes: There is no need to delete the execution from the job system. Data propagation
--          jobs are system jobs. They go away when they complete. We only need to remove
--          the entries from the data propagation tables.
--
PROCEDURE delete_executions(p_execution_ids IN MGMT_JOB_GUID_ARRAY,
                            p_target_name_cursor OUT CURSOR_TYPE,
                            p_execution_id_cursor OUT CURSOR_TYPE);


--
-- submit_threshold_data
--
-- Submit a threshold data set
--
-- p_source_target_name The source target name
-- p_source_target_type The source target type
-- p_data The threshold data
-- 
-- RETURNS: A new data set guid obtained by storing the data
--
FUNCTION submit_threshold_data(p_source_target_name VARCHAR2,
                               p_source_target_type VARCHAR2,
                               p_data MGMT_METRIC_THR_OBJ_ARRAY)
    RETURN RAW;


--
-- submit_properties_data
--
-- Submit a properties data set
--
-- p_source_target_name The source target name
-- p_source_target_type The source target type
-- p_data The property data
-- 
-- RETURNS: A new data set guid obtained by storing the data
--
FUNCTION submit_properties_data(p_source_target_name VARCHAR2,
                                p_source_target_type VARCHAR2,
                                p_data MGMT_TARGET_PROPERTY_LIST)
    RETURN RAW;


--
-- submit_credentials_data
--
-- Submit a credentials data set
--
-- p_source_target_name The source target name
-- p_source_target_type The source target type
-- p_credential_set_name The credential set name
-- p_data The credentials data
-- 
-- RETURNS: A new data set guid obtained by storing the data
--
--
FUNCTION submit_credential_data(p_source_target_name VARCHAR2,
                                p_source_target_type VARCHAR2,
                                p_credential_set_name VARCHAR2,
                                p_data MGMT_CRED_ROW_ARRAY)
    RETURN RAW;



--
-- submit_coll_credential_data
--
-- Submit a credentials data set
--
-- p_source_target_name The source target name
-- p_source_target_type The source target type
-- p_credential_set_name The credential set name
-- p_data The credentials data
-- 
-- RETURNS: A new data set guid obtained by storing the data
--
--
FUNCTION submit_coll_credential_data(p_source_target_name VARCHAR2,
                                     p_source_target_type VARCHAR2,
                                     p_metric_name VARCHAR2,   
                                     p_metric_column VARCHAR2,
                                     p_collection_name VARCHAR2,
                                     p_credential_set_name VARCHAR2,
                                     p_data MGMT_CRED_ROW_ARRAY)
    RETURN RAW;




-- 
-- submit_monitoring_settings 
-- 
-- Submit monitoring settings data set 
-- 
-- p_source_target_name The source target name 
-- p_source_target_type The source target type 
-- p_metric_list The metrics data 
-- p_collection_list The collections data 
-- 
-- RETURNS: A new data set guid obtained by storing the data 
-- 
FUNCTION submit_monitoring_settings(p_source_target_name IN VARCHAR2, 
                                    p_source_target_type IN VARCHAR2, 
                                    p_metric_list IN MGMT_MNTR_METRIC_ARRAY, 
                                    p_collection_list IN MGMT_MNTR_COLLECTION_ARRAY) 
    RETURN RAW; 


-- 
-- Submit template data set 
--
-- p_template_name The source template name 
-- p_target_type The target type 
-- p_copy_common_only_flag The copy_copy_only flag. Default is 0 (copy_all)
-- p_target_name The target name when copy_common_only_flag is 1
-- p_ca_creds A list of credentials for corrective actions
-- p_coll_creds A list of collection credentials
-- 
FUNCTION submit_template_data(p_template_name IN VARCHAR2, 
                              p_target_type IN VARCHAR2,
                              p_copy_common_only_flag IN INTEGER DEFAULT 0,
                              p_target_name IN VARCHAR2 DEFAULT NULL,
                              p_ca_creds IN MGMT_MNTR_CA_ARRAY DEFAULT NULL,
                              p_coll_creds IN MGMT_COLLECTION_CRED_ARRAY DEFAULT NULL)
    RETURN RAW;


--
-- Submit an update operation. 
--
-- p_data_guids A list of data set guids
-- p_destination_list A list of destination targets
-- p_update_master_agents This is a flag that indicates how to deal
--   with multi-agent targets in the destination list. If set to 
--   true (1), the master agent as well as all the standby agents
--   monitoring the multi-agent target are updated. If set to false
--   (0, the default), only the standby agents are updated, but
--   not the master. This assumes that the caller of the API
--   has synchronously updated the master.
-- p_schedule An optional schedule, in case the update operation
--   needs to be scheduled at some point in the future, eg.,
--   during a maintenance window. It is null by default, which
--   means that the operation will be scheduled immediately
--   Note that the schedule cannot be a repeating schedule
--
-- RETURNS: An operation guid after saving the operation
--
FUNCTION submit_update_operation(p_data_guids IN MGMT_USER_GUID_ARRAY,
                                 p_destination_list IN MGMT_JOB_TARGET_LIST,
                                 p_update_master_agents IN NUMBER DEFAULT 0,
                                 p_schedule IN MGMT_JOB_SCHEDULE_RECORD 
                                            DEFAULT NULL)
    RETURN RAW;


--
-- update_metric_thresholds
--
-- Convenience function that handles the update of metric thresholds for one 
-- single-agent or multi-agent target. If the specified agent is a multi-agent
-- target, it automatically sets up an asynchronous update for the standby
-- agents by submitting an update operation
-- 
-- p_target_name, p_target_type The target name and type
-- p_data_set The set of thresholds updated
-- p_update_master_agents This is a flag that indicates how to deal
--   with multi-agent targets in the destination list. If set to 
--   true (1), the master agent as well as all the standby agents
--   monitoring the multi-agent target are updated. If set to false
--   (0, the default), only the standby agents are updated, but
--   not the master. This assumes that the caller of the API
--   has synchronously updated the master.
-- p_schedule An optional schedule, in case the update operation
--   needs to be scheduled at some point in the future, eg.,
--   during a maintenance window. It is null by default, which
--   means that the operation will be scheduled immediately
--   Note that the schedule cannot be a repeating schedule
-- 
-- RETURNS: An operation guid after saving the operation
--
PROCEDURE update_metric_thresholds(p_target_name IN VARCHAR2,
                                   p_target_type IN VARCHAR2, 
                                   p_source_target_name IN VARCHAR2,
                                   p_source_target_type IN VARCHAR2,                                    
                                   p_data_set IN MGMT_METRIC_THR_OBJ_ARRAY,
                                   p_update_master_agents IN NUMBER DEFAULT 0,
                                   p_schedule IN MGMT_JOB_SCHEDULE_RECORD 
                                              DEFAULT NULL);
    --RETURN RAW;


--
-- copy_metric_thresholds
-- 
-- Convenience procedure to copy the thresholds of a source target to
-- a specified destination list. copy_flags is an array that specifies,
-- for each target in the destination list, whether ALL thresholds 
-- should be copied, or only common ones. Note that the final data set could
-- be different for each target; this method therefore ends up submitting
-- multiple operations
--
-- p_target_name, p_target_type The target name and type
-- p_data_set The set of thresholds to copy
-- p_destination_list The set of destination targets
-- p_copy_common_only_flags An array that is as large as the number 
--   of destination targets. For each target, it specifies whether to 
--   copy the common thresholds only (1) or all the thresholds (0)
--   from the source.
-- p_update_master_agents This is a flag that indicates how to deal
--   with multi-agent targets in the destination list. If set to 
--   true (1), the master agent as well as all the standby agents
--   monitoring the multi-agent target are updated. If set to false
--   (0, the default), only the standby agents are updated, but
--   not the master. This assumes that the caller of the API
--   has synchronously updated the master.
-- p_schedule An optional schedule
--
PROCEDURE copy_metric_thresholds(p_target_name IN VARCHAR2,
                                 p_target_type IN VARCHAR2,
                                 p_data_set IN MGMT_METRIC_THR_OBJ_ARRAY,
                                 p_destination_list IN MGMT_JOB_TARGET_LIST,
                                 p_copy_common_only_flags IN SMP_EMD_INTEGER_ARRAY,
                                 p_update_master_agents IN NUMBER DEFAULT 0,
                                 p_schedule IN MGMT_JOB_SCHEDULE_RECORD 
                                            DEFAULT NULL);


-- 
-- update_monitoring_settings 
-- 
-- Convenience function that handles the update of monitoring settings for one 
-- single-agent or multi-agent target. If the specified agent is a multi-agent 
-- target, it automatically sets up an asynchronous update for the standby 
-- agents by submitting an update operation. 
-- 
-- p_target_name, p_target_type The target name and type 
-- p_metric_list The metrics data 
-- p_collection_list The collections data 
-- p_update_master_agents This is a flag that indicates how to deal
--   with multi-agent targets in the destination list. If set to 
--   true (1), the master agent as well as all the standby agents
--   monitoring the multi-agent target are updated. If set to false
--   (0, the default), only the standby agents are updated, but
--   not the master. This assumes that the caller of the API
--   has synchronously updated the master.
-- p_schedule An optional schedule, in case the update operation
--   needs to be scheduled at some point in the future, eg.,
--   during a maintenance window. It is null by default, which
--   means that the operation will be scheduled immediately
--   Note that the schedule cannot be a repeating schedule
-- 
-- RETURNS: An operation guid after saving the operation
--
FUNCTION update_monitoring_settings(p_target_name IN VARCHAR2, 
                                    p_target_type IN VARCHAR2, 
                                    p_metric_list IN MGMT_MNTR_METRIC_ARRAY, 
                                    p_collection_list IN MGMT_MNTR_COLLECTION_ARRAY, 
                                    p_update_master_agents IN NUMBER DEFAULT 0, 
                                    p_schedule IN MGMT_JOB_SCHEDULE_RECORD DEFAULT NULL) 
    RETURN RAW; 


--
-- save_repo_mntr_settings
-- Save mntr settings into repository since in 10R2, agent will not upload 
-- monitoring setting change sent from OMS. This function is called from data
-- propagation job command
-- 
PROCEDURE save_repo_mntr_settings(p_target_name IN VARCHAR2,
                                        p_target_type IN VARCHAR2,
                                        p_data_set_guid IN RAW);

-- 
-- apply_template 
-- 
-- Convenience procedure to apply a template to a specified destination list. 
-- 
-- p_template_name The source template name 
-- p_target_type The target type 
-- p_destination_list The set of destination targets 
-- p_copy_common_only_flags An array that is as large as the number of 
--   destination targets. For each target, it specifies whether to  copy the common 
--   thresholds only (1) or all the thresholds (0) from the source. 
-- p_ca_creds A list of credentials for corrective actions.
-- p_coll_creds A list of collection credentials
-- p_update_master_agents This is a flag that indicates how to deal with multi-agent 
--   targets in the destination list. If set to true (1), the master agent as well as all the 
--   standby agents monitoring the multi-agent target are updated. If set to false (0), 
--   only the standby agents are updated, but not the master. 
-- p_schedule An optional schedule 
-- 
PROCEDURE apply_template(p_template_name IN VARCHAR2, 
                         p_target_type IN VARCHAR2, 
                         p_destination_list IN MGMT_JOB_TARGET_LIST, 
                         p_copy_common_only_flags IN SMP_EMD_INTEGER_ARRAY, 
                         p_ca_creds IN MGMT_MNTR_CA_ARRAY DEFAULT NULL,
                         p_coll_creds IN MGMT_COLLECTION_CRED_ARRAY DEFAULT NULL,
                         p_update_master_agents IN NUMBER DEFAULT 1, 
                         p_schedule IN MGMT_JOB_SCHEDULE_RECORD DEFAULT NULL);


--
-- delete_operation_data
--
-- Based on the operation_guid, it deletes the data associated with it 
-- from these tables:
-- MGMT_UPDATE_OPERATIONS
-- MGMT_UPDATE_OPERATIONS_DATA
-- MGMT_UPDATE_OPERATIONS_DETAILS
-- MGMT_UPDATE_THRESHOLDS_DATA
-- MGMT_UPDATE_PROPERTIES_DATA
-- MGMT_UPDATE_CREDENTIALS_DATA
-- 
-- Before deleting any data, it checks that there are no active 
-- executions for the given operation_guid. It generates an error 
-- if the operation_guid has any active executions.
-- 
-- p_operation_guid The operation guid for which data are to be deleted.
-- 
PROCEDURE delete_operation_data(p_operation_guid IN RAW);

--
-- has_running_update_execution
-- Check if the target has any scheduled execution for data propergation.
-- Aborted and Failed execution are counted, since system job in those states
-- will be retried.
-- Parameter: p_dest_target_guid,
--            p_op_type, one of the constant defined in the package
-- Return: 1 for having execution, 0 for none

FUNCTION has_running_update_execution(p_dest_target_guid IN RAW,
                                      p_op_type IN NUMBER)
RETURN NUMBER;

--
-- stop_propagation_execution
-- Abort all existing execution on the target.
-- Parameters: p_dest_target_guid
--             p_op_type
PROCEDURE stop_propagation_execution(p_dest_target_guid IN RAW,
                                      p_op_type IN NUMBER);

--
-- submit_pdp_data
--
-- Submit a pdp data set
--
-- p_source_target_name The source target name
-- p_source_target_type The source target type
-- p_setting_status_in  enable/disable setting
-- p_data The pdp data MGMT_PDP_ACTUAL_SETTING_ARRAY
-- 
-- RETURNS: A new data set guid obtained by storing the data
--
--
FUNCTION submit_pdp_data       (
                                p_setting_guid_in IN RAW,
                                p_source_target_name VARCHAR2,
                                p_source_target_type VARCHAR2,
                                p_setting_status_in IN NUMBER,
                                p_pdp_type_in   IN VARCHAR2,
                                p_data MGMT_PDP_ACTUAL_SETTING_ARRAY)
    RETURN RAW;

END MGMT_TARGET_UPDATE;
/
show errors;

