Rem drv: <create type="tables"/>
Rem
Rem $Header: data_propagation_tables.sql 21-apr-2007.00:38:36 nqureshi Exp $
Rem
Rem data_propagation_tables.sql
Rem
Rem Copyright (c) 2003, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      data_propagation_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    nqureshi    04/21/07 - pdp backport
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    rzazueta    05/03/05 - Add columns to mgmt_update_operations_details 
Rem                           table 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    jgwang      01/26/05 - add UDM credential support 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    rzazueta    09/01/04 - Add support for templates 
Rem    gan         08/17/04 - monitoring
Rem    dcawley     07/07/04 - Increase user name size 
Rem    skini       09/22/03 - Data prop for credentials 
Rem    rzazueta    07/18/03 - Replace emd_url with agent_guid
Rem    skini       06/30/03 - blocksize fixes
Rem    rzazueta    06/18/03 - Move primary key constraints to indexes file
Rem    rzazueta    06/12/03 - rzazueta_propagate_target_data
Rem    rzazueta    06/12/03 - Created
Rem

rem
rem MGMT_UPDATE_OPERATIONS 
rem
rem PURPOSE
rem   Gives a general overview of submitted update jobs
rem
rem COLUMNS
rem   OPERATION_GUID         - The operation GUID
rem   JOB_ID                 - The ID of the job that is servicing this operation
rem   JOB_OWNER              - The user that submitted the job
rem   SUBMISSION_TIMESTAMP   - The time that job was submitted by the user
rem   LAST_UPDATED_TIMESTAMP - The last time the job was modified by any 
rem                            authorized user
rem
CREATE TABLE MGMT_UPDATE_OPERATIONS 
    (operation_guid           RAW(16)    DEFAULT SYS_GUID()   NOT NULL,
     job_id                   RAW(16),
     job_owner                VARCHAR2(256),
     submission_timestamp     DATE       NOT NULL,
     last_updated_timestamp   DATE       DEFAULT NULL
    ) MONITORING;

rem
rem MGMT_UPDATE_OPERATIONS_DATA
rem
rem PURPOSE
rem   Holds details about each individual data set involved in the operation
rem
rem COLUMNS
rem   OPERATION_GUID      - The operation GUID
rem   DATA_SET_GUID       - The unique data set GUID
rem   SOURCE_TARGET_GUID  - The guid of the source target or of the source template
rem   DATA_SET_TYPE       - The type of the data set. Possible values are 
rem                         defined in the MGMT_TARGET_UPDATE package. 
rem                         Depending on the data set type, the actual 
rem                         data is stored in one of: 
rem                            MGMT_UPDATE_THRESHOLDS_DATA, 
rem                            MGMT_UPDATE_PROPERTIES_DATA, 
rem                            MGMT_UPDATE_CREDENTIALS_DATA,
rem                            MGMT_UPDATE_COLL_CREDS_DATA.
rem 
CREATE TABLE MGMT_UPDATE_OPERATIONS_DATA 
    (operation_guid        RAW(16),
     data_set_guid         RAW(16)    NOT NULL,
     source_target_guid    RAW(16),
     data_set_type         NUMBER(2)  NOT NULL
    ) MONITORING;


rem
rem MGMT_UPDATE_OPERATIONS_DETAILS 
rem
rem PURPOSE
rem   Gives details about the status of an operation on each target.
rem   The propagation job will update a row in this table, setting 
rem   the status to COMPLETED or FAILED, as the case may be, when it 
rem   attempts to contact the agent in order to propagate the data.
rem
rem COLUMNS
rem   OPERATION_GUID          - The operation guid .
rem   DESTINATION_TARGET_GUID - The target guid of the target being updated 
rem                             for that particular execution of the job 
rem                             with this JOB_ID.
rem   AGENT_GUID              - Target guid of the emd monitoring the destination 
rem                             target. There could be multiple values in that 
rem                             column for a target since it may be multi-agent. 
rem   EXECUTION_ID            - The id of the execution that is processing
rem                             this target.
rem   EXECUTION_STATUS        - The current status of this particular execution. 
rem                             The following statuses will be supported for 
rem                             the functionalities discussed here: Scheduled, 
rem                             Executing, Failed, Completed.
rem   LAST_UPDATED_TIMESTAMP  - The last time the job ran on a given target. The
rem                             job may get rescheduled if communication with the
rem                             agent gets lost while the job is running.
rem   ERROR_MESSEAGE          - The error message of the last run.
rem
CREATE TABLE MGMT_UPDATE_OPERATIONS_DETAILS 
    (operation_guid             RAW(16)         NOT NULL,
     destination_target_guid    RAW(16)         NOT NULL,
     agent_guid                 RAW(16)         NOT NULL,
     execution_id               RAW(16),
     execution_status           NUMBER,
     last_updated_timestamp     DATE            DEFAULT NULL,
     error_message              VARCHAR2(4000)  DEFAULT ''
    ) MONITORING;


rem
rem MGMT_UPDATE_THRESHOLDS_DATA 
rem
rem PURPOSE
rem   Stores update data for the thresholds data set.
rem
rem COLUMNS
rem   DATA_SET_GUID    - Identifies update data for a particular update 
rem                      job; used to join this table with 
rem                      MGMT_UPDATE_OPERATIONS_DATA
rem
CREATE TABLE MGMT_UPDATE_THRESHOLDS_DATA 
    (data_set_guid         RAW(16)          NOT NULL,
     metric_guid           RAW(16)          NOT NULL,
     coll_name             VARCHAR2(64)     DEFAULT ' '   NOT NULL,
     key_value             VARCHAR2(256)    DEFAULT ' '   NOT NULL,
     eval_order            NUMBER,
     num_occurences        NUMBER,
     fixit_job             VARCHAR2(256),
     warning_threshold     VARCHAR2(256),
     critical_threshold    VARCHAR2(256),
     warning_operator      NUMBER,
     critical_operator     NUMBER,
     key_part1_value       VARCHAR2(256),
     key_part2_value       VARCHAR2(256),
     key_part3_value       VARCHAR2(256),
     key_part4_value       VARCHAR2(256),
     key_part5_value       VARCHAR2(256)
    ) MONITORING;


rem
rem MGMT_UPDATE_PROPERTIES_DATA
rem
rem PURPOSE
rem   Stores update data for the properties data set
rem 
rem COLUMNS
rem   DATA_SET_GUID    - Identifies update data for a particular update 
rem                      job; used to join this table with 
rem                      MGMT_UPDATE_OPERATIONS_DATA
rem
CREATE TABLE MGMT_UPDATE_PROPERTIES_DATA 
    (data_set_guid     RAW(16)          NOT NULL,
     property_name     VARCHAR2(64)     NOT NULL,
     property_type     VARCHAR2(64)     NOT NULL,
     property_value    VARCHAR2(1024)
    ) MONITORING; 


rem
rem MGMT_UPDATE_CREDENTIALS_DATA
rem
rem PURPOSE
rem   Stores update data for the credentials data set.
rem
rem COLUMNS
rem   DATA_SET_GUID   - Identifies update data for a particular update 
rem                     job; used to join this table with 
rem                     MGMT_UPDATE_OPERATIONS_DATA
rem
CREATE TABLE MGMT_UPDATE_CREDENTIALS_DATA 
    (data_set_guid           RAW(16)          NOT NULL,
     credential_set_name     VARCHAR2(64)     NOT NULL,
     credential_column       VARCHAR2(32)     NOT NULL,
     credential_value        VARCHAR2(1024)
    ) MONITORING;



rem
rem MGMT_UPDATE_COLL_CREDS_DATA
rem
rem PURPOSE
rem   Stores update data for the credentials data set.
rem
rem COLUMNS
rem   DATA_SET_GUID   - Identifies update data for a particular update 
rem                     job; used to join this table with 
rem                     MGMT_UPDATE_OPERATIONS_DATA
rem
CREATE TABLE MGMT_UPDATE_COLL_CREDS_DATA
    (data_set_guid           RAW(16)          NOT NULL,
     metric_guid             RAW(16)          NOT NULL,
     collection_name         VARCHAR2(64),
     credential_set_name     VARCHAR2(64)     NOT NULL,
     credential_column       VARCHAR2(32)     NOT NULL,
     credential_value        VARCHAR2(1024)
    ) MONITORING;




rem
rem MGMT_UPDATE_TEMPLATE_DATA_MAP
rem
rem PURPOSE
rem   Stores the mapping of data_set_guid to template_copy_guid.
rem
rem COLUMNS
rem   DATA_SET_GUID - Identifies data for a particular data propagation job
rem   TEMPLATE_COPY_GUID - GUID of the template copy
rem
CREATE TABLE MGMT_UPDATE_TEMPLATE_DATA_MAP
    (data_set_guid           RAW(16)          NOT NULL,
     template_copy_guid      RAW(16)          NOT NULL
    ) MONITORING; 

rem
rem MGMT_UPDATE_PDP_DATA
rem
rem PURPOSE
rem   Stores update data for the apply PDP operation.
rem
rem COLUMNS
rem   DATA_SET_GUID   - Identifies update data for a particular update 
rem                     job; used to join this table with 
rem                     MGMT_UPDATE_OPERATIONS_DATA
rem  setting_name     - name of the setting (command/prompt_for_password etc)  
rem  setting_value     - actual value of the setting 
CREATE TABLE MGMT_UPDATE_PDP_DATA
    (data_set_guid           RAW(16)          NOT NULL,
     setting_name            VARCHAR2(64)     NOT NULL,
     setting_value           VARCHAR2(64)
    ) MONITORING;

