Rem drv: <create type="out_of_box" params="EM_REPOS_USER" pos="notification/default_notification_rules_setup.sql+"/>
Rem
Rem $Header: ecm_add_metalink_creds.sql 06-jul-2005.19:34:51 gsbhatia Exp $
Rem
Rem ecm_add_metalink_creds.sql
Rem
Rem Copyright (c) 2003, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ecm_add_metalink_creds.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Script to add the MetaLink credentials in the repository.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem      gsbhatia  07/06/05 - Adding repmgr header 
Rem      mgoodric  12/15/03 - bug 3312919 
Rem      mgoodric  11/18/03 - mgoodric_bug-3262887 
Rem      mgoodric  11/18/03 - Mask out printing password with '**********'
Rem      mgoodric  11/17/03 - Created
Rem

REM This script will add the MetaLink credentials in the repository.

DECLARE
    metalink_username MGMT_ARU_CREDENTIALS.ARU_USERNAME%TYPE;
    metalink_password MGMT_ARU_CREDENTIALS.ARU_PASSWORD%TYPE;
    metalink_param    MGMT_PARAMETERS.PARAMETER_NAME%TYPE;
    metalink_url      MGMT_PARAMETERS.PARAMETER_VALUE%TYPE;

BEGIN
    -- get the MetaLink credentials (if available)
    metalink_username := '&METALINK_USERNAME';
    dbms_output.put_line('MetaLink user name as obtained from setup: ' || metalink_username);

    metalink_password := '&METALINK_PASSWORD';
    dbms_output.put_line('MetaLink user password as obtained from setup: ' || '**********');

    IF (metalink_username IS NULL OR
            length(trim(metalink_username)) = 0 OR
            UPPER(metalink_username) = '_NOT_AVAILABLE_')
    THEN
        dbms_output.put_line('MetaLink user name is not specified');
    ELSE IF (metalink_password IS NULL OR
            length(trim(metalink_password)) = 0 OR
            UPPER(metalink_password) = '_NOT_AVAILABLE_')
    THEN
        dbms_output.put_line('MetaLink user password is not specified');
    ELSE
        BEGIN
            -- add the MetaLink credentials.
            MGMT_CREDENTIAL.set_aru_credentials(metalink_username, metalink_password);
            COMMIT;
            dbms_output.put_line('MetaLink user name is specified as: ' || metalink_username);
            dbms_output.put_line('MetaLink user password is specified as: ' || '**********');
        EXCEPTION
          WHEN others THEN
            dbms_output.put_line('UNHANDLED EXCEPTION while setting MetaLink credentials' || ', SQLCODE: ' || SQLCODE || ', SQLERRM: ' || SQLERRM);
        END;

        BEGIN
            -- add the MetaLink URL default (if available)
            metalink_param := 'Patch_Search_URL';
            metalink_url := '&METALINK_URL';
            dbms_output.put_line('MetaLink URL as obtained from setup: ' || metalink_url);

            IF (metalink_url IS NULL OR
                length(trim(metalink_url)) = 0 OR
                UPPER(metalink_url) = '_NOT_AVAILABLE_')
            THEN
                dbms_output.put_line('MetaLink URL is not specified');
            ELSE
                INSERT INTO mgmt_parameters
                    (parameter_name, parameter_value)
                VALUES
                    (metalink_param, metalink_url);
                COMMIT;
                dbms_output.put_line(metalink_param || ' is defined as: ' || metalink_url);
            END IF;
        EXCEPTION
          WHEN dup_val_on_index THEN
            UPDATE mgmt_parameters
              SET parameter_value = metalink_url
            WHERE (parameter_name = metalink_param);
            COMMIT;
            dbms_output.put_line(metalink_param || ' is defined as: ' || metalink_url);
          WHEN others THEN
            dbms_output.put_line('UNHANDLED EXCEPTION while setting MetaLink URL' || ', SQLCODE: ' || SQLCODE || ', SQLERRM: ' || SQLERRM);
        END;
    END IF; END IF;
END;
/
commit;
