Rem
Rem $Header: ecm_aru_map.sql 13-oct-2006.11:42:42 rrawat Exp $
Rem
Rem ecm_aru_map.sql
Rem
Rem Copyright (c) 2002, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ecm_aru_map.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Add mappings between ARU ids and ECM internal data types.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem     rrawat     10/13/06 - Backport rrawat_bug-5546644 from main
Rem     rrawat     10/10/06 - Bug-5546644
Rem     abhalla    09/30/05 - Taking care of OCS target types
Rem     apbharga   02/17/05 - updating the out-of-box ARU data 
Rem     rpinnama   06/12/04 - Remove set ECHO 
Rem     mgoodric   02/25/04 - Fix mapping for Microsoft Windows (64-bit)
Rem     shuberma   11/06/03 - Adding map for oms and correcting agent map.
Rem                           Removing Unknown map
Rem     shuberma   10/24/03 - Add a mapping for unknown
Rem     shuberma   10/20/03 - Removing stuff that is taken care of in
Rem     mgoodric   06/30/03 - Fix mapping for Enterprise Manager
Rem     mgoodric   02/25/03 - Fix mapping for Windows
Rem     dmshah     10/29/02 - review comments
Rem     dmshah     10/29/02 - Fixing disable of ECHO
Rem     mgoodric   10/22/02 - Add support for EM_OS_BITLENGTH for platforms
Rem     mgoodric   10/14/02 - Fix ARU maps for HP-UX, IBM AIX
Rem     mgoodric   09/10/02 - Fix Patch wizard selection
Rem     mgoodric   07/16/02 - mgoodric_ecm_aru_auto_update_020716
Rem


Rem ========== Populate MGMT_ECM_ARU_MAP ==========

DELETE MGMT_ECM_ARU_MAP;

-- Integrators: ADD NEW MAPPINGS FOR SUPPORTED FAMILIES HERE

-- Oracle Application Server Products (iAS) (10120)
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, CATEGORY)
  VALUES (10120,'Oracle Application Server Products (iAS)','oracle_ias','family');

-- Oracle Database (9480)
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, CATEGORY)
  VALUES (9480,'Oracle Database','oracle_database','family');

-- Integrators: ADD NEW MAPPINGS FOR SUPPORTED PRODUCTS HERE

-- Oracle Database (9480)
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, CATEGORY)
  VALUES (9481,'RDBMS Server','oracle_database','product');

-- Oracle System Management Products (9800)
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, CATEGORY)
  VALUES (9801,'Intelligent Agent','oracle_emd','product');
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, CATEGORY)
  VALUES (12383,'Enterprise Manager Grid Control','oracle_emrep','product');
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, CATEGORY)
  VALUES (12384,'Enterprise Manager Database Control','oracle_database','product');
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, CATEGORY)
  VALUES (12385,'Enterprise Manager AS Control','oracle_ias','product');

-- Oracle Application Server Products (iAS) (10120)
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, CATEGORY)
  VALUES (10040,'Internet Directory','oracle_ias','product');
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, CATEGORY)
  VALUES (10220,'Workflow Standalone','oracle_ias','product');
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, CATEGORY)
  VALUES (10600,'XML Developers Kit','oracle_ias','product');

-- Integrators: ADD NEW MAPPINGS FOR SUPPORTED PLATFORMS HERE

-- SunOS
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, EM_BITLENGTH, CATEGORY)
  VALUES (453,'Solaris Operating System (SPARC 32-bit)','SunOS','32','platform');
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, EM_BITLENGTH, CATEGORY)
  VALUES (23,'Solaris Operating System (SPARC 64-bit)','SunOS','64','platform');
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, EM_BITLENGTH, CATEGORY)
  VALUES (173,'Solaris Operating System (x86)','Unknown','32','platform');

-- HP-UX
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, EM_BITLENGTH, CATEGORY)
  VALUES (59,'HP-UX PA-RISC (64-bit)','HP-UX','64','platform');
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, EM_BITLENGTH, CATEGORY)
  VALUES (197,'HP-UX Itanium','HP-UX','64','platform');
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, EM_BITLENGTH, CATEGORY)
   VALUES (601, 'HP Alpha Windows NT', 'Windows NT', '64','platform');
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, EM_BITLENGTH, CATEGORY)
  VALUES (89, 'HP OpenVMS Alpha', 'OpenVMS', '64','platform');

-- DG/UX
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, EM_BITLENGTH, CATEGORY)
  VALUES (162, 'Data General AViiON M88K DG', 'DG/UX', '64','platform');

-- Linux x86-64
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, EM_BITLENGTH, CATEGORY)
  VALUES (226, 'Linux x86-64 (AMD64/EM64T)', 'Linux', '64','platform');

-- OSF1
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, EM_BITLENGTH, CATEGORY)
  VALUES (87,'HP Tru64 UNIX','OSF1','64','platform');

-- AIX
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, EM_BITLENGTH, CATEGORY)
  VALUES (212,'AIX5L Based Systems (64-bit)','AIX','64','platform');

INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, EM_BITLENGTH, CATEGORY)
  VALUES (38, 'AIX 4.3 Based Systems (64-bit)', 'Unknown', '64','platform');

-- Linux
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, EM_BITLENGTH, CATEGORY)
  VALUES (46,'Linux x86','Linux','32','platform');
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, EM_BITLENGTH, CATEGORY)
  VALUES (214,'Linux Itanium','Linux','64','platform');
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, EM_BITLENGTH, CATEGORY)
  VALUES (209,'IBM zSeries Based Linux','Unknown','64','platform');

-- Windows
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, EM_BITLENGTH, CATEGORY)
  VALUES (912,'Microsoft Windows (32-bit)','Windows','32','platform');
INSERT into MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, EM_BITLENGTH, CATEGORY)
  VALUES (208,'Microsoft Windows (64-bit)','Windows','64','platform');

-- Generic
INSERT INTO MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, EM_BITLENGTH, CATEGORY)
  VALUES (1234,'NLS Generic Platform','ALL','ALL','platform');
INSERT INTO MGMT_ECM_ARU_MAP
    (ARU_ID, DISPLAY_STRING, EM_NAME, EM_BITLENGTH, CATEGORY)
  VALUES (2000,'Generic Platform','ALL','ALL','platform');

COMMIT;

Rem ========== Populate MGMT_TARGET_TYPE_COMPONENT_MAP ==========

DELETE MGMT_TARGET_TYPE_COMPONENT_MAP;

-- Integrators: ADD NEW MAPPINGS FOR SNAPHOT COMPONENT TYPES THERE

INSERT INTO MGMT_TARGET_TYPE_COMPONENT_MAP
    (TARGET_TYPE, COMPONENT_NAME)
  VALUES ('oracle_database','oracle.rdbms');
INSERT INTO MGMT_TARGET_TYPE_COMPONENT_MAP
    (TARGET_TYPE, COMPONENT_NAME)
  VALUES ('oracle_ias','oracle.iappserver.iappcore');
INSERT INTO MGMT_TARGET_TYPE_COMPONENT_MAP
    (TARGET_TYPE, COMPONENT_NAME)
  VALUES ('oracle_emd','oracle.sysman.agent');
INSERT INTO MGMT_TARGET_TYPE_COMPONENT_MAP
    (TARGET_TYPE, COMPONENT_NAME)
  VALUES ('oracle_emrep','oracle.sysman.console.oms');
INSERT INTO MGMT_TARGET_TYPE_COMPONENT_MAP
    (TARGET_TYPE, COMPONENT_NAME)
  VALUES ('Unknown', 'oracle.ocs.midtier');
COMMIT;

