Rem drv: <create type="post_creation" params="EM_REPOS_USER" pos="website/website_post_creation.sql+"/>
Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/ecm/ecm_auto_aru_job_creation.sql /st_emcore_10.2.0.4.2db11.2/1 2008/10/20 21:16:39 lsatyapr Exp $
Rem
Rem ecm_auto_aru_job_creation.sql
Rem
Rem Copyright (c) 2003, 2008, Oracle and/or its affiliates. All rights reserved.
Rem
Rem    NAME
Rem      ecm_auto_aru_job_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Script to add the 'RefreshFromMetalink' job in the repository.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    lsatyapr    10/12/08 - Backport lsatyapr_bug-7425991 from main
Rem    lsatyapr    10/08/08 - Use MGMT_JOB instead of MJ_ENGINE
Rem    gsbhatia    07/03/05 - New repmgr header impl 
Rem    dsahrawa    06/22/04 - use MGMT_JOBS.get_job_schedule_record 
Rem    awarkar     10/15/03 - Changing Description 
Rem    awarkar     10/08/03 - Created
Rem

REM This script will add the 'RefreshFromMetalink' job in the repository.
set define off

declare
p_job_targets MGMT_JOB_TARGET_LIST := MGMT_JOB_TARGET_LIST();
p_job_params MGMT_JOB_PARAM_LIST := MGMT_JOB_PARAM_LIST();
p_purge_criterion_list MGMT_JOB_PURGE_CRITERION_LIST;
p_mgmt_job_vector MGMT_JOB_VECTOR_PARAMS;
p_schedule MGMT_JOB_SCHEDULE_RECORD;
p_bind_var_index NUMBER;
p_execution raw(16);
p_job raw(16);

begin
-- Create a schedule to run the job daily.
p_schedule := mgmt_jobs.get_job_schedule_record(3, null, null, 0, 0, 1, null, null, 1, 0, 0, null);

-- Submit the job.
mgmt_jobs.submit_job('Refresh_From_Metalink_Job','Out Of The Box Job. Do Not Delete This Job!','RefreshFromMetalink', p_job_targets,p_job_params,p_schedule,p_job,p_execution,null,0,null,null);

-- We are going to purge the job on job type.
p_mgmt_job_vector := MGMT_JOB_VECTOR_PARAMS('RefreshFromMetalink');

-- Create a purge criteria to purge the job on Job_type
p_purge_criterion_list := MGMT_JOB_PURGE_CRITERION_LIST(MGMT_JOB_PURGE_CRITERION(2, 0, p_mgmt_job_vector, null));

-- Register the purge policy to purge the job executions which are more than a week old and which
-- satisfy the purge criteria created above.
MGMT_JOBS.register_purge_policy('RefreshFromMetalinkPurgePolicy', 7, p_purge_criterion_list);
end;
/

set define on

commit;
