Rem
Rem $Header: ecm_csa_pkgdef.sql 20-jul-2005.17:26:51 mgoodric Exp $
Rem
Rem ecm_csa_pkgdef.sql
Rem
Rem Copyright (c) 2003, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ecm_csa_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mgoodric    07/20/05 - add additional parameter to after_load proc 
Rem    vkhizder    02/10/05 - changes to purge 
Rem    asaraswa    11/09/04 - adding procedure to remove failed collections 
Rem    asaraswa    09/21/04 - adding procedure to associate targets with app 
Rem                           ids 
Rem    vkhizder    07/13/04 - adding error code constant for purging csa failures  
Rem    vkhizder    02/17/04 - making csa clients non-targets 
Rem    vkhizder    08/07/03 - vkhizder_trans_jul21_03 
Rem    vkhizder    07/25/03 - Created
Rem

CREATE OR REPLACE PACKAGE MGMT_ECM_CSA_PKG
IS

  -- Module name for logging
  CSA_LOGGING_MODULE_NAME CONSTANT VARCHAR2(3) := 'CSA';

  -- possible internal error codes for logging
  PURGE_CSA_SNAPSHOT_ERR CONSTANT NUMBER(2) := 1;
  PURGE_CSA_SNAPSHOT_HISTORY_ERR CONSTANT NUMBER(2) := 2;
  PURGE_CSA_TARGET_ERR CONSTANT NUMBER(2) := 3;
  PURGE_CSA_FAILURES_ERR CONSTANT NUMBER(2) := 4;

--------------------------------------------------------------------------
-- This is an after-load procedure for the CSA snapshots that will 
-- convert the snapshot to a snapshot for a new (if necessary) client
-- target and set up the target's parameters.
-- 
-- Input: p_snapshot_id ID of the loaded snapshot
-- Input: p_afterLoadInput Additional after-load input parameters

  PROCEDURE AFTER_LOAD 
             (p_snapshot_id IN MGMT_ECM_GEN_SNAPSHOT.SNAPSHOT_GUID%TYPE,
              p_afterLoadInput IN SMP_EMD_NVPAIR_ARRAY);

--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- PURGE
--
-- PURGE
--
-- PURPOSE
--    Cleans up CSA clients / snapshots and their histories.
--    The arguments are used to limit the purged snapshots.
--    IMPORTANT: This call COMMITS its changes as it goes along deleting
--    information.
--
-- PARAMETERS
--
--  p_numberOfDays  Only snapshots that have not been updated within
--                  the last p_numberOfDays days are removed. If the number is
--                  the default 0, all snapshots are removed (perhaps limited
--                  by other parameters). SAVED_TIMESTAMP column is used for
--                  comparison.
--  p_snapshotType  If not null, only snapshots (and their histories) of a given
--                  type are removed. 
--  p_targetName    The exact internal target name of the CSA client.
--  p_removeHistory Should history be removed? 
--
--  RETURNS         The number of deleted snapshots.
--

  FUNCTION PURGE( p_numberOfDays NUMBER := 0,
                  p_snapshotType VARCHAR2 := NULL,
                  p_targetName VARCHAR2 := NULL,
                  p_removeHistory BOOLEAN := TRUE )
                RETURN NUMBER;

--------------------------------------------------------------------------

-- Purge policy for CSA cliects. The procedure will be called by the auto-purging
-- system and will remove all CSA clients / snapshots and their history older
-- than an input timestamp. 
  PROCEDURE AUTO_PURGE(pcb_params IN OUT MGMT_PURGE_CALLBACK_PARAMS);


----------------------------------------------------------------------------
--procedure to create an association between a target and an application id
--target_guids_in: array of target guids
--app_ids_in: array of applicaiton IDs
--both arrays MUST be of the same length. app_ids_in(i) is associated with
--target_guids_in(i)
PROCEDURE CREATE_TARGET_ASSOCIATION(target_guids_in IN VARCHAR2_TABLE,
				    app_ids_in IN VARCHAR2_TABLE);


--------------------------------------------------------------------------
--procedure to remove a list of target associations
--parameters:
--target_guids_in: the target guids, as strings. will be converted to RAW
--in procedure
--app_ids_in: the application IDs
PROCEDURE REMOVE_ASSOC(target_guids_in IN VARCHAR2_TABLE,
                       app_ids_in IN VARCHAR2_TABLE);

----------------------------------------------------------------------------
--procedure to remove a list of failed collections based on their failed collection ids
--parameters:
--ids_in: the list of ids of the failed collections that should be removed.
--        This array should not be NULL
PROCEDURE REMOVE_FAILED(ids_in IN VARCHAR2_TABLE);


END MGMT_ECM_CSA_PKG;
/
show errors;

