Rem
Rem $Header: ecm_ct_pkgdef.sql 23-jul-2007.15:08:53 rrawat Exp $
Rem
Rem ecm_ct_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ecm_ct_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem     rrawat     06/23/07 - Bug-5997153
Rem     rrawat     07/23/07 - Backport rrawat_bug-5977153 from main
Rem     mgoodric   07/20/05 - add additional parameter to after_load proc 
Rem     akskumar   04/07/05 - copy_snapshot to return saved config guid 
Rem     mgoodric   04/06/05 - fix 10.2GC Beta upgrade bug 
Rem     vkhizder   12/03/04 - delete performance improvements 
Rem     akskumar   11/10/04 - saving configurations for composite targets 
Rem     vkhizder   07/27/04 - host config loading changes 
Rem     mgoodric   06/13/03 - added COPY_SNAPSHOT
Rem     vkhizder   06/03/03 - handing target deletion
Rem     vkhizder   05/19/03 - adding oui platform
Rem     vkhizder   03/25/03 - more framework improvements
Rem     mgoodric   03/15/03 - use exceptions to raise errors
Rem     mgoodric   03/14/03 - add PRELOAD_CALLBACK and POSTLOAD_CALLBACK
Rem     agor       01/02/03 - add clonable
Rem     vkhizder   12/18/02 - adding some generic snapshot related procedures
Rem     rpinnama   05/15/02 - rpinnama_reorg_rep_scripts
Rem     rpinnama   05/15/02 - Created
Rem

Rem  PURPOSE
Rem
Rem     The ECM_CT package contains procedures for inserting change tracking
Rem     snapshot information as well as inventory information which is part
Rem     of snapshots.
Rem
Rem  PROCEDURES and FUNCTIONS
Rem
Rem     Procedures in this package populate information into corresponding
Rem     tables and sometime return GUID of the newly created items.
Rem
Rem  NOTES
Rem
Rem     Methods in this package do not make any assumptions about
Rem     transacations.  Essentially, it is up to the call to commit or
Rem     rollback, unless otherwise noted.
Rem

Rem ********************************************************************
Rem ********************************************************************

CREATE OR REPLACE PACKAGE ECM_CT
IS

G_TARGET_GUID              CONSTANT VARCHAR2(11) := 'TARGET_GUID';
G_COLLECTION_NAME          CONSTANT VARCHAR2(15) := 'COLLECTION_NAME';
G_COLLECTION_TIMESTAMP     CONSTANT VARCHAR2(20) := 'COLLECTION_TIMESTAMP';
G_EMD_URL                  CONSTANT VARCHAR2(7)  := 'EMD_URL';
G_VERSION                  CONSTANT VARCHAR2(7)  := 'VERSION';
G_CONFIG_METADATA_VERSION  CONSTANT VARCHAR2(23) := 'CONFIG_METADATA_VERSION';
G_ECM_SNAPSHOT_ID          CONSTANT VARCHAR2(15) := 'ECM_SNAPSHOT_ID';

-- snapshot status (status field in mgmt_ecm_gen_snapshot)
G_COLLECTED_STATUS         CONSTANT VARCHAR2(1)  := 'C';
G_NOT_FOUND_STATUS         CONSTANT VARCHAR2(1)  := 'N';
G_COLLECTION_FAILED_STATUS CONSTANT VARCHAR2(1)  := 'F';

-- is_current field in mgmt_ecm_gen_snapshot
G_IS_CURRENT_TYPE          CONSTANT VARCHAR2(1)  := 'Y'; -- current snapshot
G_IS_NOTCURRENT_TYPE       CONSTANT VARCHAR2(1)  := 'N'; -- saved snapshot
G_IS_TRANSIENT_TYPE        CONSTANT VARCHAR2(1)  := 'T'; -- creation in progress
G_IS_SAVING_TYPE           CONSTANT VARCHAR2(1)  := 'S'; -- saving in progress
G_IS_LOCKED_TYPE           CONSTANT VARCHAR2(1)  := 'L'; -- for snapshot locking
G_IS_DELETED_TYPE          CONSTANT VARCHAR2(1)  := 'D'; -- to be deleted later 
G_IS_BEING_DELETED_TYPE    CONSTANT VARCHAR2(1)  := 'X'; -- deletion in progress
G_IS_ALMOST_DELETED_TYPE   CONSTANT VARCHAR2(1)  := 'Z'; -- no data remains but a 
                                                         -- row in gen_snap table
G_IS_ERROR_TYPE            CONSTANT VARCHAR2(1)  := 'E'; -- error snapshot; will try to delete it 

-- Snapshot metadata kind (kind field in mgmt_ecm_snapshot_metadata)
G_IS_LOADER                CONSTANT VARCHAR2(1)  := 'L';
G_IS_PRESENTATION          CONSTANT VARCHAR2(1)  := 'P';

G_MAX_NAME_LEN             CONSTANT NUMBER       := 256;
G_MAX_VALUE_LEN            CONSTANT NUMBER       := 2000;
G_MAX_MESSAGE_LEN          CONSTANT NUMBER       := 4000;
G_IS_METRIC_ERROR          CONSTANT NUMBER       := 0;
G_IS_DEBUG                 CONSTANT NUMBER       := 0;

TYPE cursorType IS REF CURSOR;

-- Module name for logging host config issues
HOST_CONFIG_LOG_MODULE_NAME CONSTANT VARCHAR2(20) := 'Host Configuration';

-- Possible internal error codes for host config logging
-- Currently not used but can be used for say host config postload operation.
-- Old values used in 10.1+ (strictly before 10.2): 
-- DELETE_HOST_CONFIG_ERR CONSTANT NUMBER(2) := 1;
-- PURGE_HOST_CONFIG_ERR CONSTANT NUMBER(2) := 2;

-- Module name for logging purging issues
ECM_PURGE_LOG_MODULE_NAME CONSTANT VARCHAR2(20) := 'ECM Purging';

-- Possible internal error codes for logging ecm purges
ORPHAN_SNAP_CREATION_ERR_1 CONSTANT NUMBER(2) := 1;
ORPHAN_SNAP_CREATION_ERR_2 CONSTANT NUMBER(2) := 2;
DELETE_SNAP_ERR_3 CONSTANT NUMBER(2) := 3;
DELETE_SNAP_ERR_4 CONSTANT NUMBER(2) := 4;
DELETE_SNAP_ERR_5 CONSTANT NUMBER(2) := 5;
DELETE_SNAP_ERR_6 CONSTANT NUMBER(2) := 6;
DELETE_SNAP_ERR_7 CONSTANT NUMBER(2) := 7;
DELETE_SNAP_ERR_8 CONSTANT NUMBER(2) := 8;
DELETE_SNAP_ERR_9 CONSTANT NUMBER(2) := 9;
ORPHAN_HOST_CONFIG_ERR_10 CONSTANT NUMBER(2) := 10;
ORPHAN_HOST_CONFIG_ERR_11 CONSTANT NUMBER(2) := 11;
DELETE_HOST_CONFIG_ERR_12 CONSTANT NUMBER(2) := 12;
DELETE_HOST_CONFIG_ERR_13 CONSTANT NUMBER(2) := 13;

-- *********************************************************************

PROCEDURE INSERT_SNAPSHOT_INFO (v_type VARCHAR2, v_type_version VARCHAR2,
    v_target_name VARCHAR2, v_target_type VARCHAR2,
    v_display_target_name VARCHAR2, v_display_target_type VARCHAR2,
    v_description VARCHAR2, v_start_timestamp DATE,
    v_elapsed_time NUMBER, v_current VARCHAR2,
    v_collection_error_stream VARCHAR2, v_guid OUT RAW);

-- *********************************************************************

PROCEDURE INSERT_CONTAINER (v_snapshot_guid RAW, v_type VARCHAR2,
    v_name VARCHAR2, v_location VARCHAR2, v_oui_platform NUMBER,
    v_clonable VARCHAR2, v_guid OUT RAW);

-- *********************************************************************

PROCEDURE INSERT_COMPONENT (v_name VARCHAR2, v_version VARCHAR2,
    v_container_guid RAW, v_desription VARCHAR2,
    v_external_name VARCHAR2, v_languages VARCHAR2,
    v_installed_location VARCHAR2, v_installer_version VARCHAR2,
    v_min_deinstaller_version VARCHAR2, v_isTopLevel VARCHAR2,
    v_timestamp STRING, v_guid OUT RAW); 

-- *********************************************************************

PROCEDURE INSERT_PATCH (v_id VARCHAR2, v_container_guid RAW,
    v_timestamp STRING, 
    v_description VARCHAR2, v_isRollbackable VARCHAR2,
    v_guid OUT RAW);

-- *********************************************************************

PROCEDURE INSERT_PATCHSET (v_name VARCHAR2, v_version VARCHAR2,
    v_container_guid RAW, v_description VARCHAR2,
    v_external_name VARCHAR2, v_installer_version VARCHAR2,
    v_min_deinstaller_version VARCHAR2,  v_timestamp STRING,
    v_guid OUT RAW);

-- *********************************************************************

PROCEDURE INSERT_GEN_SNAPSHOT_INFO (v_snapshot_type VARCHAR2,
    v_target_id VARCHAR2, v_target_name VARCHAR2, v_target_type VARCHAR2,
    v_display_target_name VARCHAR2, v_display_target_type VARCHAR2,
    v_description VARCHAR2, v_start_timestamp DATE,
    v_elapsed_time NUMBER, v_current VARCHAR2,
    v_status VARCHAR2, v_message VARCHAR2, v_creator VARCHAR2,
    v_guid OUT VARCHAR2);

-- *********************************************************************

-- use current EM user as snapshot creator
PROCEDURE INSERT_GEN_SNAPSHOT_INFO (v_snapshot_type VARCHAR2,
    v_target_id VARCHAR2, v_target_name VARCHAR2, v_target_type VARCHAR2,
    v_display_target_name VARCHAR2, v_display_target_type VARCHAR2,
    v_description VARCHAR2, v_start_timestamp DATE,
    v_elapsed_time NUMBER, v_current VARCHAR2,
    v_status VARCHAR2, v_message VARCHAR2, v_guid OUT VARCHAR2);

-- *********************************************************************

PROCEDURE PRELOAD_CALLBACK (
    v_input IN SMP_EMD_NVPAIR_ARRAY,
    v_preLoadOutput OUT SMP_EMD_NVPAIR_ARRAY);

-- *********************************************************************

PROCEDURE POSTLOAD_CALLBACK (
    v_input IN SMP_EMD_NVPAIR_ARRAY,
    v_preLoadOutput IN SMP_EMD_NVPAIR_ARRAY);

-- *********************************************************************

FUNCTION COPY_SNAPSHOT_GEN (
    v_target_name IN VARCHAR2,
    v_target_type IN VARCHAR2,
    v_snapshot_type IN VARCHAR2,
    v_description IN VARCHAR2,
    v_snapGuidIn IN VARCHAR2 default null) return VARCHAR2;

-- *********************************************************************

  -- SAVE_COMPOSITE_CONFIG
  -- This is to save all the member snapshots for a given composite snapshot type
  -- Inputs: target name, target type, and snapshot type of the current snapshot
  -- to be copied. v_description is the description of the new saved snapshot,
  -- which will be used same for all the members
   PROCEDURE SAVE_COMPOSITE_CONFIG(v_target_name IN VARCHAR2,
                                   v_target_type IN VARCHAR2,
                                   v_description IN VARCHAR2,
                                   p_save_details out cursorType);

-- *********************************************************************

PROCEDURE DELETE_SNAPSHOT (v_snapshot_guid IN RAW);

-- *********************************************************************

PROCEDURE HANDLE_ORPHAN_SNAPSHOTS (v_number_of_days IN NUMBER DEFAULT 3);

-- *********************************************************************

PROCEDURE HANDLE_ORPHAN_HOST_CONFIGS (v_number_of_days IN NUMBER DEFAULT 3);

-- *********************************************************************

-- Purge generic ECM snapshots
PROCEDURE DELETE_SNAPSHOTS (pcb_params IN OUT MGMT_PURGE_CALLBACK_PARAMS); 

-- *********************************************************************

/*** Uncomment this procedure if CSA is separated into a separate "thread".
PROCEDURE DELETE_CSA_SNAPSHOTS;
***/ 

-- *********************************************************************

-- Purge host config snapshots
PROCEDURE DELETE_HOST_CONFIG_SNAPSHOTS (pcb_params IN OUT 
                                               MGMT_PURGE_CALLBACK_PARAMS);

-- Dummy for 10.1.0.3.0 -> 10.2.0.1.0 upgrade
PROCEDURE PURGE_HOST_CONFIGS (pcb_params IN OUT 
                                               MGMT_PURGE_CALLBACK_PARAMS);
-- *********************************************************************

-- The ecm target deletion callback for the ECM framework
PROCEDURE HANDLE_TARGET_DELETION (
    p_target_name VARCHAR2,
    p_target_type VARCHAR2,
    p_target_guid RAW);

-- *********************************************************************

-- Called by host config loading code to convert temporary snapshot to
-- current one and compute history
--
-- Inputs: v_snapshot_guid - guid of the temporary snapshot to be converted

PROCEDURE HOST_CONFIG_POSTLOAD (v_snapshot_guid RAW);

-- *********************************************************************

-- The ecm target deletion callback for the host configs
PROCEDURE HOST_CONFIG_TARGET_DELETION (
    p_target_name VARCHAR2,
    p_target_type VARCHAR2,
    p_target_guid RAW);

-- *********************************************************************

-- Test post load procedure. Call the procedure assuming there is a (single)
-- temporary snapshot for a given target name / type and snapshot type
/*
PROCEDURE TEST_POST_LOAD (
    p_target_name VARCHAR2,
    p_target_type VARCHAR2,
    p_snapshot_type VARCHAR2);
*/

/*
PROCEDURE AFTER_LOAD_PROC (
    v_snapshot_guid IN RAW,
    v_afterLoadInput SMP_EMD_NVPAIR_ARRAY);

PROCEDURE AFTER_IMPORT_PROC (
    v_snapshot_guid IN RAW,
    v_afterImportInput SMP_EMD_NVPAIR_ARRAY);
*/

-- *********************************************************************

PROCEDURE GET_HOST_CONFIG_INFO (
    v_sguid IN VARCHAR2,
    v_target_name IN VARCHAR2,
    v_target_type IN VARCHAR2,
    p_isStale OUT VARCHAR2,
    p_systemConfig OUT VARCHAR2,
    p_hardwareProvider OUT VARCHAR2,
    p_numberOfCpus OUT INTEGER,
    p_memory OUT INTEGER,
    osName OUT VARCHAR2,
    l_home_list OUT MGMT_ORACLESW_LIST,
    l_vendor_list OUT MGMT_VENDORSW_LIST,
    p_comps OUT sys_refcursor);


PROCEDURE GET_HW_INFO (
    v_sguid IN VARCHAR2,
    p_isStale OUT VARCHAR2,
    l_hwgenlist OUT MGMT_HWGEN_LIST,
    l_cpulist OUT MGMT_CPUDETAILS_LIST,
    l_iocardlist OUT MGMT_IOCARDDETAILS_LIST,
    l_niclist OUT MGMT_NICDETAILS_LIST);

END ECM_CT;
/

show errors;

