Rem
Rem $Header: ecm_db2xml_pkgdef.sql 15-may-2002.18:24:16 rpinnama Exp $
Rem
Rem ecm_db2xml_pkgdef.sql
Rem
Rem Copyright (c) 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      ecm_db2xml_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rmenon      06/26/02 - added nic and fs mount details logic
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Created
Rem

rem The following package defines procedures to return cursors
rem that convert the HC schema entries into XML format and
rem vice versa.

CREATE OR REPLACE package db2XML is
  TYPE hcSystemSummaryRef IS REF CURSOR RETURN mgmt_hc_system_summary%ROWTYPE;
  TYPE hcHardwareInfoRef IS REF CURSOR RETURN mgmt_hc_hardware_master%ROWTYPE;
  TYPE hcCPUDetailsRef IS REF CURSOR RETURN mgmt_hc_cpu_details%ROWTYPE;
  TYPE hcIOCardDetailsRef IS REF CURSOR RETURN mgmt_hc_iocard_details%ROWTYPE;
  TYPE hcNICDetailsRef IS REF CURSOR RETURN mgmt_hc_nic_details%ROWTYPE;
  TYPE hcOSSummaryRef IS REF CURSOR RETURN mgmt_hc_os_summary%ROWTYPE;
  TYPE hcOSPropertiesRef IS REF CURSOR RETURN mgmt_hc_os_properties%ROWTYPE;
  TYPE hcOSComponentsRef IS REF CURSOR RETURN mgmt_hc_os_components%ROWTYPE;
  TYPE hcFSMountRef IS REF CURSOR RETURN mgmt_hc_fs_mount_details%ROWTYPE;
  TYPE hcVendorSoftwareSummaryRef IS REF CURSOR RETURN mgmt_hc_vendor_sw_summary%ROWTYPE;
  TYPE hcVendorSoftwareComponentsRef IS REF CURSOR RETURN mgmt_hc_vendor_sw_components%ROWTYPE;

  procedure getSystemSummary(snapshotID RAW, systemSummary in out hcSystemSummaryRef);
  procedure getHardwareInfo (snapshotID RAW, hardwareInfo in out hcHardwareInfoRef);
  procedure getCPUDetails (snapshotID RAW, cpuDetails in out hcCPUDetailsRef);
  procedure getIOCardDetails (snapshotID RAW, iocardDetails in out hcIOCardDetailsRef);
  procedure getNICDetails (snapshotID RAW, nicDetails in out hcNICDetailsRef);
  procedure getOSSummary (snapshotID RAW, osSummary in out hcOSSummaryRef);
  procedure getOSProperties (snapshotID RAW,-- p_type VARCHAR2,
                             osProperties in out hcOSPropertiesRef);
  procedure getOSComponents (snapshotID RAW, osComponents in out hcOSComponentsRef);
  procedure getFSMountDetails (snapshotID RAW, fsMount in out hcFSMountRef);
  procedure getVendorSoftwareSummary (vendorSoftwareID RAW, vendorSoftwareSummary in out hcVendorSoftwareSummaryRef);
  procedure getVendorSoftwareComponents (vendorSoftwareID RAW, vendorSoftwareComponents in out hcVendorSoftwareComponentsRef);

end db2XML;
/
show errors;
