Rem
Rem $Header: ecm_defines.sql 13-dec-2005.23:41:40 lappanmu Exp $
Rem
Rem ecm_defines.sql
Rem
Rem Copyright (c) 2003, 2005, Oracle. All rights reserved.
Rem
Rem    NAME
Rem      ecm_defines.sql - Defines for ecm sql scripts.
Rem
Rem    DESCRIPTION
Rem      Use this to define script values (constants) for use by the
rem     various .sql scripts.  Reference them in the script with an &.
rem     Import these defines using
rem   @&EM_SQL_ROOT/core/latest/ecm/ecm_defines.sql
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    lappanmu    12/13/05 - XbranchMerge lappanmu_bug-4684929 from main 
Rem    jochen      12/07/05 - Add ecm_gendiff_row_count
Rem    groyal      02/16/05 - Comment out obsolete policy defines
Rem    agor        02/02/05 - add more defines for columns
Rem    shuberma    07/21/03 - Adding some defines for the aru advisory stuff
Rem    vkhizder    07/08/03 -
Rem    vkhizder    06/20/03 - adding more defines
Rem    groyal      06/04/03 - Rework api slightly
Rem    shuberma    05/20/03 - Addin rank values
Rem    shuberma    05/14/03 - Adding author_length
Rem    shuberma    05/06/03 - Adding P_SNAPSHOT_TYPE_LENGTH
Rem    shuberma    04/21/03 - shuberma_policy_fw
Rem    shuberma    04/18/03 - Adding column_name_length
Rem    shuberma    04/18/03 - Adding a few new defines
Rem    shuberma    04/16/03 - Created
Rem

rem  The following constants are common across tables.
DEFINE GUID_RAW_LENGTH = 16
DEFINE MAX_VARCHAR2_LENGTH = 4000
DEFINE TARGET_NAME_LENGTH = 256
DEFINE TARGET_TYPE_LENGTH = 64
DEFINE DISPLAY_TARGET_NAME_LENGTH = 256
DEFINE DISPLAY_TARGET_TYPE_LENGTH = 128
DEFINE SNAPSHOT_TYPE_LENGTH = 64
DEFINE USER_NAME_LENGTH = 256 -- per Ravi and mgmt_user_* tables (LDAP users
                              -- can have these long names over 30 characters)

Rem
Rem  HC related Schema
Rem
rem  Following constants are used to define the column lengths
rem  that are common across tables. This way we only need to
rem  change the constants to reflect length changes across tables.
DEFINE NAME_LENGTH = 128
DEFINE DESCRIPTION_LENGTH = 2000
DEFINE SHORT_DESCRIPTION_LENGTH = 500
DEFINE VERSION_LENGTH = 100
DEFINE TYPE_LENGTH = 100
DEFINE LOCATION_LENGTH = 1024
DEFINE INET_ADDRESS_LENGTH = 20
DEFINE DOMAIN_NAME_LENGTH = 500
DEFINE IP_LENGTH = 20


rem -------------------------------------------------------------------------------
rem   The following defines are obsolete with GC Rel 2.  They had been used to
rem   support the Version 1 policy framework; that is, the framework prior to
rem   the metric/policy unification effort.
rem

/*

rem The following defines are used for column sizes in the policy tables.  The
rem prefix 'P_' keeps them separate from other defines.
DEFINE P_NAME_LENGTH = 128
DEFINE P_DESCRIPTION_LENGTH = 2000
DEFINE P_SHORT_DESCRIPTION_LENGTH = 500
DEFINE P_CAPTION_LENGTH = 100
DEFINE P_VERSION_LENGTH = 50
DEFINE P_TARGET_TYPE_LENGTH = 100
DEFINE P_RULE_TYPE_LENGTH = 100
DEFINE P_CATEGORY_LENGTH = 100
DEFINE P_LARGE_VARCHAR_LENGTH = 4000
DEFINE P_REASONABLE_NUMBER_LENGTH = 10
DEFINE P_SQL_NAME_LENGTH = 31;
DEFINE P_VALUE_LENGTH = 1024;
DEFINE P_FILTER_OP_LENGTH = 10;
DEFINE P_SEVERITY_LENGTH = 10;
DEFINE P_RULE_NAME_LENGTH = 128
DEFINE P_PARAM_NAME_LENGTH = 128
DEFINE P_ATTRIBUTE_NAME_LENGTH = 31
DEFINE P_TARGET_NAME_LENGTH = 100
DEFINE P_PARAM_VALUE_LENGTH = 1024;
DEFINE P_ATTRIBUTE_VALUE_LENGTH = 1024
DEFINE P_COLUMN_NAME_LENGTH = &P_SQL_NAME_LENGTH
DEFINE P_Y_N_LENGTH = 1
DEFINE P_SNAPSHOT_TYPE_LENGTH = 64
DEFINE P_AUTHOR_LENGTH = 128
DEFINE P_URL_LENGTH = 2000
DEFINE P_DISPLAY_ID_LENGTH = 128

DEFINE P_CLEAR = 0
*/

rem Some defines for ARU_ADVISORY TABLES
DEFINE ABSTRACT_LENGTH = 1024
DEFINE DISPLAY_NAME_LENGTH = 128

rem some defines for host config
DEFINE COMPNAME = 128
DEFINE COMPEXTNAME = 128
DEFINE COMPVERSION = 64
DEFINE COMPBASEVERSION = 64
DEFINE COMPHOMELOCATION = 1024
DEFINE COMPHOME = 1024

DEFINE NIC_FLAGS = 1024

rem
rem   This value is used for the generic snapshot viewer starting in 10.2.0.2
rem   We fetch the results of child table comparisons in blocks of rows
rem   the size of this value
rem
rem   NOTE - this must be kept in synch with the corresponding value in
rem          oracle.sysman.eml.ecm.generic.ChildDiffs
rem
DEFINE ecm_gendiff_row_count  = 128;

