Rem
Rem $Header: ecm_depot_pkgbody.sql 15-may-2002.18:24:18 rpinnama Exp $
Rem
Rem ecm_depot_pkgbody.sql
Rem
Rem Copyright (c) 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      ecm_depot_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Created
Rem

CREATE OR REPLACE PACKAGE BODY "ECM_DEPOT"
IS

PROCEDURE REGISTER_PATCH (v_aruId NUMBER,
                          v_bugNo NUMBER,
                          v_patchType VARCHAR2,
                          v_manualEntry VARCHAR2,
                          v_platformId NUMBER,
                          v_languageId NUMBER,
                          v_abstract VARCHAR2,
                          v_productId NUMBER,
                          v_release VARCHAR2,
                          v_patchDate DATE,
                          v_status VARCHAR2,
                          v_readmeUrl VARCHAR2,
                          v_patchUrl VARCHAR2,
                          v_comments VARCHAR2,
                          v_automated VARCHAR2,
                          v_size NUMBER ) IS
BEGIN
  -- First insert an entry into the MGMT_ECM_PATCH_CACHE table.
  INSERT INTO MGMT_ECM_PATCH_CACHE (aru_id,
                                    bug_no,
                                    type,
                                    manually_posted,
                                    platform_id,
                                    language_id,
                                    abstract,
                                    product_id,
                                    release,
                                    patch_date,
                                    status,
                                    readme_url,
                                    patch_url,
                                    comments,
                                    automated,
                                    file_size,
                                    last_referenced )
    VALUES ( v_aruId,
             v_bugNo,
             v_patchType,
             v_manualEntry,
             v_platformId,
             v_languageId,
             v_abstract,
             v_productId,
             v_release,
             v_patchDate,
             v_status,
             v_readmeUrl,
             v_patchUrl,
             v_comments,
             v_automated,
             v_size,
             SYSDATE );
END REGISTER_PATCH;

PROCEDURE INSERT_PATCH_ZIP
            (v_aruId NUMBER,
             v_patchUrl OUT VARCHAR2,
             v_contents OUT BLOB) IS

BEGIN

  UPDATE MGMT_ECM_PATCH_CACHE set file_contents = empty_blob()
    WHERE aru_id = v_aruId
  RETURNING PATCH_URL, FILE_CONTENTS INTO v_patchUrl, v_contents;

END INSERT_PATCH_ZIP;

END ECM_DEPOT;
/
show errors;


