Rem
Rem $Header: ecm_depot_pkgdef.sql 15-may-2002.18:24:19 rpinnama Exp $
Rem
Rem ecm_depot_pkgdef.sql
Rem
Rem Copyright (c) 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      ecm_depot_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Created
Rem

rem
rem  PURPOSE
rem
rem     The ECM_DEPOT package returns contains procedures for registering a
rem     patch.
rem
rem  PROCEDURES and FUNCTIONS
rem
rem   REGISTER_PATCH
rem     ARGUMENTS:  All are IN parameters unless otherwise noted.
rem                 The values are typically returned from ARU.
rem
rem       aruId             -- The aru id of the patch.
rem       bugNo             -- The bug number or patch id of the patch being reg.
rem       patchType         -- The type of the patch being registered,
rem                             Patch or Patchset (returned from aru)
rem       manualEntry       -- 'Y' is this was manually enter and 'N' otherwise.
rem       platformId        -- The aru platform id of the platform.
rem       language          -- The language of the patch e.g. 0 for amer. ENGLISH
rem       abstract          -- A description of the patch
rem       productId         -- The aru id of the base component type.
rem       release           -- The version it patches.  e.g. 8.1.7
rem       patchDate         -- The ARU date of this patch.
rem       status            -- The status of the patch.
rem       readmeUrl         -- The ARU URL for the readme.
rem       patchUrl          -- The ARU url for downloading the zip.
rem       comments          -- Comment fields from ARU.
rem       automated         -- the automation characteristic of the patch.
rem       size              -- The size of the patch file.
rem
rem  NOTES
rem
rem   The methods in this package do not make any assumptions about
rem   transacations.  Essentially, it's up to the call to commit or rollback,
rem   unless otherwise noted.
rem
CREATE OR REPLACE PACKAGE "ECM_DEPOT"
IS

PROCEDURE REGISTER_PATCH (v_aruId NUMBER,
                          v_bugNo NUMBER,
                          v_patchType VARCHAR2,
                          v_manualEntry VARCHAR2,
                          v_platformId NUMBER,
                          v_languageId NUMBER,
                          v_abstract VARCHAR2,
                          v_productId NUMBER,
                          v_release VARCHAR2,
                          v_patchDate DATE,
                          v_status VARCHAR2,
                          v_readmeUrl VARCHAR2,
                          v_patchUrl VARCHAR2,
                          v_comments VARCHAR2,
                          v_automated VARCHAR2,
                          v_size NUMBER );

-- Updates an cache entry with returning the BLOB for the contents column.
PROCEDURE INSERT_PATCH_ZIP
            (v_aruId NUMBER,
             v_patchUrl OUT VARCHAR2,
             v_contents OUT BLOB);

END ECM_DEPOT;
/
show errors;


