Rem
Rem $Header: ecm_hc_delta_pkgdef.sql 02-sep-2004.14:13:45 mgoodric Exp $
Rem
Rem ecm_hc_delta_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ecm_hc_delta_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mgoodric    08/31/04 - configHistory integration 
Rem    shuberma    11/22/02 - 
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Created
Rem

CREATE OR REPLACE PACKAGE MGMT_HC_DELTA
IS
--------------------------------------------------------------------------------
  -- RECORD_HC_DIFFS
  --
  --   This procedure is responsible for collecting history differences for host
  --   host configurations.  It is a special purpose procedure with the details
  --   of the hc tables built into it.  It should be replaced in the future with 
  --   a general purpose procedure that uses register metadata to perform the 
  --   history comparison.
  --
  -- PARAMETERS
  --  
  --   first_target_name      The target name of the first snapshot (current)
  --   first_target_type      The target type of the first snapshot
  --   first_snapshot_type    The type of the first snapshot.  This is 
  --                            always 'host_configuration'
  --   second_target_name     Except when testing, this is always the same as
  --                            the first.  It just isn't current.
  --   second_target_type     Same as first.
  --   second_snapshot_type   Except for testing, this is currently always
  --                            'DELTA'
  --   comparison_type        Doesn't really matter, but is set to 'DELTA'
  --
  PROCEDURE RECORD_HC_DIFFS( first_target_name VARCHAR2,
                             first_target_type VARCHAR2,
                             first_snapshot_type VARCHAR2,
                             second_target_name VARCHAR2,
                             second_target_type VARCHAR2,
                             second_snapshot_type VARCHAR2,
                             comparison_type VARCHAR2 );
                             
END MGMT_HC_DELTA;
/

show errors;

