Rem
Rem $Header: ecm_hostpatch_pkgdef.sql 01-jun-2007.03:35:59 ranmath Exp $
Rem
Rem ecm_hostpatch_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ecm_hostpatch_pkgdef.sql - Declares the MGMT_ECM_HOSTPATCH package.
Rem
Rem    DESCRIPTION
Rem      Declares the MGMT_ECM_HOSTPATCH package.
Rem
Rem    NOTES
Rem      The formatting here follows the "PL/SQL Coding Conventions"
Rem      document and is therefore a bit different from the rest of ECM.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ranmath     06/01/07 - XbranchMerge ranmath_bug-4573095 from main
Rem    ranmath     05/30/07 - bug-4573095: Define HOSTPATCH_CONTAINER_LOCATION.
Rem    ranmath     08/28/05 - bug-4573095: Add defined constants for 
Rem                           specifying credential types. 
Rem    ranmath     08/25/05 - bug-4565977: Create procedure stop_hp_job(). 
Rem    achugh      02/28/05 - bug 4199708: Add procedure 
Rem                           'get_hosts_prefcreds_not_set'. 
Rem    tasingh     02/07/05 - Add get_host_timezones. 
Rem    ranmath     12/08/04 - bug-4053039.
Rem    ranmath     12/07/04 - (bug-4046371) Update for schema changes. 
Rem    ranmath     11/25/04 - Add delete_repos_info. 
Rem    ranmath     10/08/04 - Add functions for getting status of Host 
Rem                           Patching Jobs Executions. 
Rem    ranmath     09/16/04 - Created
Rem

CREATE OR REPLACE PACKAGE mgmt_ecm_hostpatch
AS
  
  -- The EM Target type for Host Patching Groups.
  --
  HOSTPATCH_GROUP_TARGET_TYPE CONSTANT VARCHAR2(10) := 'composite';


  -- The EM Target type for Host Patching Hosts.
  --
  HOSTPATCH_HOST_TARGET_TYPE CONSTANT VARCHAR2(6) := 'host';


  -- BEGIN: bug-4573095

  -- Dummy container location for storing overridden Host Patching
  -- credentials.
  --
  HOSTPATCH_CONTAINER_LOCATION CONSTANT VARCHAR2(64)
    := '/oracle.sysman.eml.ecm.hostpatch/_DUMMY_';


  -- The "HostCredsNormal" credential set.
  --
  HOST_CREDS_NORMAL CONSTANT VARCHAR2(16) := 'HostCredsNormal';


  -- The "OHCreds" credential set.
  --
  OH_CREDS CONSTANT VARCHAR2(8) := 'OHCreds';


  -- Use preferred normal host credentials for patching.
  --
  USE_PREF_NORM_CREDS CONSTANT NUMBER(1) := 0;


  -- Use preferred privileged host credentials for patching.
  --
  USE_PREF_PRIV_CREDS CONSTANT NUMBER(1) := 1;


  -- Use explicitly-specified global host credentials for patching.
  --
  USE_EXPL_GLOBAL_CREDS CONSTANT NUMBER(1) := 2;


  -- Use explicitly-specified individual host credentials for patching.
  --
  USE_EXPL_INDIV_CREDS CONSTANT NUMBER(1) := 3;


  -- END: bug-4573095


  --
  -- NAME: delete_group_info
  --
  -- PACKAGE: mgmt_ecm_hostpatch
  --
  -- PURPOSE: 
  --   Removes Host Patching specific information for a Group, if any.
  --
  -- IN PARAMETERS:
  --   p_group_guid RAW the Target GUID of the Group.
  --   p_group_name VARCHAR2 the name of the Group.
  --
  -- OUT PARAMETERS:
  --   None.
  --
  -- ERROR CODES:
  --   None.
  --
  -- NOTES:
  --   None.
  --
  PROCEDURE delete_group_info(
    p_group_guid IN RAW,
    p_group_name IN VARCHAR2
  );


  --
  -- NAME: delete_repos_info
  --
  -- PACKAGE: mgmt_ecm_hostpatch
  --
  -- PURPOSE: 
  --   Removes Host Patching specific information for a package repository,
  --   if any.
  --
  -- IN PARAMETERS:
  --   p_repos_guid VARCHAR2 the GUID of the package repository.
  --
  -- OUT PARAMETERS:
  --   None.
  --
  -- ERROR CODES:
  --   None.
  --
  -- NOTES:
  --   None.
  --
  PROCEDURE delete_repos_info(
    p_repos_guid IN RAW
  );


  --
  -- NAME: update_group_compl_summary
  --
  -- PACKAGE: mgmt_ecm_hostpatch
  --
  -- PURPOSE: 
  --   Updates the compliance summary information for the given Host
  --   Patching Group.
  --
  -- IN PARAMETERS:
  --   p_group_name VARCHAR2 the name of the Group.
  --   p_total_hosts NUMBER the total number of Hosts in the Group.
  --   p_compl_hosts NUMBER the number of compliant Hosts in the Group.
  --
  -- OUT PARAMETERS:
  --   None.
  --
  -- ERROR CODES:
  --   None.
  --
  -- NOTES:
  --   None.
  --
  PROCEDURE update_group_compl_summary(
    p_group_name IN VARCHAR2,
    p_total_hosts IN NUMBER,
    p_compl_hosts IN NUMBER
  );


  --
  -- NAME: delete_host_info
  --
  -- PACKAGE: mgmt_ecm_hostpatch
  --
  -- PURPOSE: 
  --   Removes Host Patching specific information for a Host, if any.
  --
  -- IN PARAMETERS:
  --   p_host_guid RAW the Target GUID of the Host.
  --   p_host_name VARCHAR2 the name of the Host.
  --
  -- OUT PARAMETERS:
  --   None.
  --
  -- ERROR CODES:
  --   None.
  --
  -- NOTES:
  --   None.
  --
  PROCEDURE delete_host_info(
    p_host_guid IN RAW,
    p_host_name IN VARCHAR2
  );


  --
  -- NAME: group_or_host_deleted
  --
  -- PACKAGE: mgmt_ecm_hostpatch
  --
  -- PURPOSE: 
  --   Get notified of a Group or Host deletion so that we can clean
  --   any information that we store for it.
  --
  -- IN PARAMETERS:
  --   p_target_name VARCHAR2 the name of the Target.
  --   p_target_type VARCHAR2 the type of the Target.
  --   p_target_guid RAW the GUID for the Target
  --
  -- OUT PARAMETERS:
  --   None.
  --
  -- ERROR CODES:
  --   None.
  --
  -- NOTES:
  --   None.
  --
  PROCEDURE group_or_host_deleted(
    p_target_name IN VARCHAR2,
    p_target_type IN VARCHAR2,
    p_target_guid IN RAW
  );


  --
  -- NAME: stop_hp_job
  --
  -- PACKAGE: mgmt_ecm_hostpatch
  --
  -- PURPOSE: 
  --   Stop the given Host Patching job.
  --
  -- IN PARAMETERS:
  --   p_job_id RAW the GUID of the job.
  --
  -- OUT PARAMETERS:
  --   None.
  --
  -- ERROR CODES:
  --   None.
  --
  -- NOTES:
  --   None.
  --
  PROCEDURE stop_hp_job(
    p_job_id IN RAW
  );


  --
  -- NAME: get_num_problematic_executions
  --
  -- PACKAGE: mgmt_ecm_hostpatch
  --
  -- PURPOSE: 
  --   Find the number of problematic executions of a Job within
  --   the given timeframe (in days).
  --
  -- IN PARAMETERS:
  --   p_job_type VARCHAR2 the Job type.
  --   p_timeframe VARCHAR2 the timeframe in days starting from today.
  --
  -- OUT PARAMETERS:
  --   None.
  --
  -- ERROR CODES:
  --   None.
  --
  -- NOTES:
  --   The default timeframe for this information is the last seven days.
  --
  FUNCTION get_num_problematic_executions(
    p_job_type IN VARCHAR2,
    p_timeframe IN NUMBER DEFAULT 7
  ) RETURN NUMBER;


  --
  -- NAME: get_num_suspended_executions
  --
  -- PACKAGE: mgmt_ecm_hostpatch
  --
  -- PURPOSE: 
  --   Find the number of suspended executions of a Job within
  --   the given timeframe (in days).
  --
  -- IN PARAMETERS:
  --   p_job_type VARCHAR2 the Job type.
  --   p_timeframe VARCHAR2 the timeframe in days starting from today.
  --
  -- OUT PARAMETERS:
  --   None.
  --
  -- ERROR CODES:
  --   None.
  --
  -- NOTES:
  --   The default timeframe for this information is the last seven days.
  --
  FUNCTION get_num_suspended_executions(
    p_job_type IN VARCHAR2,
    p_timeframe IN NUMBER DEFAULT 7
  ) RETURN NUMBER;


  --
  -- NAME: get_host_timezones
  --
  -- PACKAGE: mgmt_ecm_hostpatch
  --
  -- PURPOSE: 
  --   Gets a unique set of timezones for all the (viewable by this user)
  --   hosts managed by EM.
  --
  -- IN PARAMETERS:
  --   None.
  --
  -- OUT PARAMETERS:
  --   None.
  --
  -- ERROR CODES:
  --   None.
  --
  -- NOTES:
  --   None.
  --
  FUNCTION get_host_timezones
    RETURN SMP_EMD_STRING_ARRAY;

  -- bug 4199708
  --
  -- NAME: get_hosts_prefcreds_not_set
  --
  -- PACKAGE: mgmt_ecm_hostpatch
  --
  -- PURPOSE: 
  --   Returns an array of host names whose preferred credentials are not set.  
  --
  -- IN PARAMETERS:
  --   p_target_list SMP_EMD_STRING_ARRAY an array of host names.
  --   p_cred_set_name VARCHAR2 the name of the credential.
  --
  -- OUT PARAMETERS:
  --   None.
  --
  -- ERROR CODES:
  --   None.
  --
  -- NOTES:
  --   None.
  --
  FUNCTION get_hosts_prefcreds_not_set(
    p_target_list   IN SMP_EMD_STRING_ARRAY,
    p_cred_set_name IN VARCHAR2 
  )RETURN SMP_EMD_STRING_ARRAY;


END mgmt_ecm_hostpatch;
/

show errors;

