Rem
Rem $Header: ecm_hostpatch_post_creation.sql 03-jul-2005.23:56:24 gsbhatia Exp $
Rem
Rem ecm_hostpatch_post_creation.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ecm_hostpatch_post_creation.sql - Post-creation logic for Host
Rem      Patching.
Rem
Rem    DESCRIPTION
Rem      Post-creation processing logic for Host Patching.
Rem
Rem    NOTES
Rem      Mainly useful for registering Target deletion callbacks.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/03/05 - Removing repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    ranmath     09/22/04 - ranmath_hostpatch_impl
Rem    ranmath     09/21/04 - Removing Host Patching Jobs purge policy. 
Rem    ranmath     09/17/04 - Add purge policies for Host Patching Jobs. 
Rem    ranmath     09/16/04 - Created
Rem

--
-- Post-creation processing logic for Host Patching.
--
BEGIN
  
  -- Register a Target deletion callback with the Core Framework so
  -- that we can clean up our tables if a Group or Host is deleted
  -- from elsewhere.
  mgmt_admin.add_target_deletion_callback(
    'mgmt_ecm_hostpatch.group_or_host_deleted'
  );

  COMMIT;
END;
/
