Rem
Rem $Header: ecm_hostpatch_uln_pkgdef.sql 07-aug-2007.13:44:28 tasingh Exp $
Rem
Rem ecm_hostpatch_uln_pkgdef.sql
Rem
Rem Copyright (c) 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ecm_hostpatch_uln_pkgdef.sql - Declares the MGMT_ECM_HOSTPATCH_ULN pkg
Rem
Rem    DESCRIPTION
Rem      Declares the MGMT_ECM_HOSTPATCH_ULN package
Rem
Rem    NOTES
Rem      None
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    tasingh     08/07/07 - Package definition for linux patching using
Rem                           unbreakable linux network project.
Rem    tasingh     08/07/07 - Created
Rem

CREATE OR REPLACE PACKAGE mgmt_ecm_hostpatch_uln
AS

  --
  -- NAME: delete_channel
  --
  -- PACKAGE: mgmt_ecm_hostpatch_uln
  --
  -- PURPOSE:
  --   Removes the channel associated with a given staging server. If there is
  --   no other staging server that has this channel, then remove it from the
  --   mgmt_ecm_uln_channels table too.
  --
  -- IN PARAMETERS:
  --   p_channel_name VARCHAR2 the name of the channel to be removed
  --   p_stage_server_name VARCHAR2 the name of the staging server
  --
  -- OUT PARAMETERS:
  --   None.
  --
  -- ERROR CODES:
  --   None.
  --
  -- NOTES:
  --   None.
  PROCEDURE delete_channel(
    p_channel_name IN VARCHAR2,
    p_stage_server_name IN VARCHAR2
  );

  --
  -- NAME: add_channel
  --
  -- PACKAGE: mgmt_ecm_hostpatch_uln
  --
  -- PURPOSE:
  --   Adds the channel against the given staging server. If this channel does
  --   exists in the mgmt_ecm_uln_channels table, first make an entry there.
  --
  -- IN PARAMETERS:
  --   p_channel_name VARCHAR2 the name of the channel
  --   p_stage_server_name VARCHAR2 the name of the staging server
  -- 
  -- OUT PARAMETERS:
  --   None.
  --
  -- ERROR CODES:
  --   None.
  -- 
  -- NOTES:
  --   None.
  PROCEDURE add_channel(
    p_channel_name IN VARCHAR2,
    p_stage_server_name IN VARCHAR2
  );

END mgmt_ecm_hostpatch_uln;
/

show errors;
