Rem
Rem $Header: ecm_jobs_pkgdef.sql 15-may-2002.18:24:21 rpinnama Exp $
Rem
Rem ecm_jobs_pkgdef.sql
Rem
Rem Copyright (c) 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      ecm_jobs_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Created
Rem

CREATE OR REPLACE PACKAGE EM_JOBS
IS

TYPE TARGET_RECORD IS RECORD ( TargetName VARCHAR2(64),
                               TargetType VARCHAR2(1024),
                               TargetRole VARCHAR2(32) );
TYPE PARAM_RECORD IS RECORD ( ParamName VARCHAR2(64),
                              ParamValue VARCHAR2(1024) );

TYPE TARGET_LIST IS VARRAY(100) OF TARGET_RECORD;
TYPE PARAM_LIST IS VARRAY(100) OF PARAM_RECORD;

PROCEDURE ADD_JOB( p_jobName IN VARCHAR2,
                   p_creator IN VARCHAR2,
                   p_description IN VARCHAR2,
                   p_jobType IN VARCHAR2,
                   p_jobTargets IN TARGET_LIST,
                   p_jobParams IN PARAM_LIST );

PROCEDURE SCHEDULE_JOB( p_jobName IN VARCHAR2,
                        p_oneTimeRunDate IN DATE );

PROCEDURE SCHEDULE_JOB( p_jobName IN VARCHAR2,
                        p_startDate IN DATE,
                        p_untilDate IN DATE,
                        p_startTime IN DATE,
                        p_intervalType IN VARCHAR2,
                        p_intervalVal NUMBER );

PROCEDURE SCHEDULE_JOB( p_jobName IN VARCHAR2,
                        p_effectiveDate IN DATE,
                        p_untilDate IN DATE,
                        p_startTime IN DATE,
                        p_weeklyDay IN VARCHAR2 );

PROCEDURE SCHEDULE_JOB( p_taskName IN VARCHAR2,
                        p_effectiveDate IN DATE,
                        p_untilDate IN DATE,
                        p_startTime IN DATE,
                        p_mondthlyDay IN NUMBER );

PROCEDURE DELETE_JOB( p_jobName IN VARCHAR2 );

PROCEDURE DELETE_JOB_EXECUTION( p_jobExecutionId IN NUMBER );

END EM_JOBS;
/
show errors;



