Rem drv: <create type="post_creation" pos="esm/esm_core_reports.sql-"/>
Rem
Rem $Header: ecm_post_creation.sql 22-jul-2005.03:17:19 neearora Exp $
Rem
Rem ecm_post_creation.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ecm_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem     neearora   07/22/05 - BUG 4500972. Register valid ECM preLoad and 
Rem                           postLoad callbacks 
Rem     gsbhatia   07/23/05 - Fix repmgr header 
Rem     gsbhatia   07/03/05 - New repmgr header impl 
Rem     aime3      03/25/05 - Remove obsolete callback 
Rem     groyal     03/24/05 - Remove purge policy for obsolete policy table 
Rem     vkhizder   02/10/05 - purging related changes 
Rem     vkhizder   01/13/05 - adding logging module for ECM purging 
Rem     agor       02/16/05 - fix 4189156 
Rem     ktlaw      01/11/05 - add repmgr header 
Rem     asaraswa   10/13/04 - adding row to mgmt_ecm_csa_out_of_box 
Rem     niramach   09/22/04 - Triggering history_groups.sql is removed since 
Rem                           MGMT_ECM_HIST_FOR_GROUPS table is removed . 
Rem     ranmath    09/16/04 - Add ecm_hostpatch_post_creation.sql. 
Rem     mgoodric   07/21/04 - add host_configuration metadata 
Rem     agor       07/30/04 - add history group data 
Rem     agor       07/27/04 - trigger creation of available searches 
Rem     vkhizder   07/27/04 - host config loading changes 
Rem     vkhizder   03/01/04 - adding purge policy for CSA 
Rem     groyal     11/19/03 - Fix network typo 
Rem     shuberma   11/10/03 - Add purge policy and change existing purge 
Rem     shuberma   10/31/03 - Add purge policy for policy errors 
Rem     shuberma   10/28/03 - Add script run of ecm_aru_info_load.sql 
Rem     shuberma   10/20/03 - Remove aru data. Handled elsewhere 
Rem     shuberma   09/18/03 - Add callback for target deletion, for policy 
Rem     shuberma   09/18/03 - Add history purge and policy target deletion 
Rem     vkhizder   07/25/03 - move of ecm_csa.sql
Rem     vkhizder   06/26/03 - adding csa metadata registration
Rem     vkhizder   06/03/03 - handling target deletions in ecm-specific way
Rem     shuberma   04/04/03 - 
Rem     shuberma   04/04/03 - Adding script for loading config fw stuff
Rem     shuberma   08/15/02 - Adding some inserts for sql resources
Rem     mgoodric   07/16/02 - Add automatic update of ARU table data
Rem     mgoodric   05/31/02 - Update ARU mapping scripts for Oracle Agent
Rem     rpinnama   05/16/02 - Initialize ARU.
Rem     rpinnama   05/14/02 - rpinnama_reorg_rep_scripts
Rem     rpinnama   05/14/02 - Created
Rem

-- Load the initial aru data so out of box, tables have values.  Will be refreshed from current
-- data after user sets metalink credentials.
@&EM_SQL_ROOT/core/latest/ecm/ecm_aru_info_load.sql

-- Do all mappings *after* ARU tables are built
@&EM_SQL_ROOT/core/latest/ecm/ecm_aru_map.sql
commit;

insert into mgmt_ecm_resources (resource_type, name, default_text) values ('HOST_CONFIG_HISTORY_TEXT', 'MGMT_HC_FS_MOUNT_DETAILS', 'File System Mount');
insert into mgmt_ecm_resources (resource_type, name, default_text) values ('HOST_CONFIG_HISTORY_TEXT', 'MGMT_HC_NIC_DETAILS', 'Network Information Configuration');
insert into mgmt_ecm_resources (resource_type, name, default_text) values ('HOST_CONFIG_HISTORY_TEXT', 'MGMT_HC_OS_COMPONENTS', 'Operating System Components');
insert into mgmt_ecm_resources (resource_type, name, default_text) values ('HOST_CONFIG_HISTORY_TEXT', 'MGMT_HC_OS_PROPERTIES', 'Operating System Properties');
insert into mgmt_ecm_resources (resource_type, name, default_text) values ('HOST_CONFIG_HISTORY_TEXT', 'MGMT_HC_OS_SUMMARY', 'Operating System');
insert into mgmt_ecm_resources (resource_type, name, default_text) values ('HOST_CONFIG_HISTORY_TEXT', 'MGMT_INV_COMPONENT', 'Oracle Software Component');
insert into mgmt_ecm_resources (resource_type, name, default_text) values ('HOST_CONFIG_HISTORY_TEXT', 'MGMT_INV_PATCHSET', 'Oracle Software Patchset');
insert into mgmt_ecm_resources (resource_type, name, default_text) values ('HOST_CONFIG_HISTORY_TEXT', 'MGMT_INV_PATCH', 'Oracle Software Interim Patch');
insert into mgmt_ecm_resources (resource_type, name, default_text) values ('HOST_CONFIG_HISTORY_TEXT', 'MGMT_HC_CPU_DETAILS', 'CPUs');
insert into mgmt_ecm_resources (resource_type, name, default_text) values ('HOST_CONFIG_HISTORY_TEXT', 'MGMT_HC_IOCARD_DETAILS', 'IO Devices');
insert into mgmt_ecm_resources (resource_type, name, default_text) values ('HOST_CONFIG_HISTORY_TEXT', 'MGMT_HC_VENDOR_SW_SUMMARY', 'Other Software');
insert into mgmt_ecm_resources (resource_type, name, default_text) values ('HOST_CONFIG_HISTORY_TEXT', 'MGMT_HC_VENDOR_SW_COMPONENTS', 'Other Software Components');
insert into mgmt_ecm_resources (resource_type, name, default_text) values ('HOST_CONFIG_HISTORY_TEXT', 'MGMT_HC_HARDWARE_MASTER', 'Hardware');
insert into mgmt_ecm_resources (resource_type, name, default_text) values ('HOST_CONFIG_HISTORY_TEXT', 'MGMT_HC_SYSTEM_SUMMARY', 'System Summary');
insert into mgmt_ecm_csa_out_of_box (status) values(0);
commit;

-- Load config fw metadata views
@&EM_SQL_ROOT/core/latest/ecm/ecm_config_fw_metadata.sql
-- Now the metadata generated from ...eml.ecm.snap.MetadataRegistry
@&EM_SQL_ROOT/core/latest/ecm/ecm_cfw_host_config.sql

-- Register metadata for CSA
@&EM_SQL_ROOT/core/latest/ecm/ecm_csa_metadata.sql

-- Register metadata for host_configuration
@&EM_SQL_ROOT/core/latest/ecm/ecm_hc_host_config.sql
commit;

-- Trigger registration of available searches.
@&EM_SQL_ROOT/core/latest/ecm/available_searches.sql
commit;

-- Post-creation processing specific to Host Patching.
@&EM_SQL_ROOT/core/latest/ecm/ecm_hostpatch_post_creation.sql
commit;

-- Purge Policies registration.
BEGIN
  -- Purge policy for MGMT_ECM_HISTORY
  EM_PURGE.add_purge_policy('MGMT_ECM_HISTORY',
                            EM_PURGE.G_POLICY_TYPE_SYSTEM,
                            'MGMT_DELTA.ECM_HISTORY_PURGE',
                            366*24,
                            NULL, -- No rollup procedure
                            'Purge policy for snapshot history.',
                            EM_PURGE.G_RETENTION_GROUP_CONFIG
                            );

  -- Purge policy for marking for deletion CSA snapshots
  EM_PURGE.add_purge_policy('CSA',
                            EM_PURGE.G_POLICY_TYPE_SYSTEM,
                            'MGMT_ECM_CSA_PKG.AUTO_PURGE',
                            0, -- use number of retention hours used by 
                               -- CONFIG retention group below
                            NULL, -- No rollup procedure
                            'Purge policy for CSA clients.',
                            EM_PURGE.G_RETENTION_GROUP_CONFIG
                            );

  -- Purge policy for host config snapshots
  EM_PURGE.add_purge_policy('HOST_CONFIG',
                            EM_PURGE.G_POLICY_TYPE_SYSTEM,
                            'ECM_CT.DELETE_HOST_CONFIG_SNAPSHOTS',
                            0, -- use number of retention hours used by
                               -- CONFIG retention group below
                            NULL, -- No rollup procedure
                            'Purge policy for host config snapshots.',
                            EM_PURGE.G_RETENTION_GROUP_CONFIG
                            );

  -- Purge policy for generic ECM snapshots
  EM_PURGE.add_purge_policy('ECM_SNAPSHOTS',
                            EM_PURGE.G_POLICY_TYPE_SYSTEM,
                            'ECM_CT.DELETE_SNAPSHOTS',
                            0, -- use number of retention hours used by
                               -- CONFIG retention group below
                            NULL, -- No rollup procedure
                            'Purge policy for generic ECM snapshots.',
                            EM_PURGE.G_RETENTION_GROUP_CONFIG
                            );


  COMMIT;
END;
/


--
-- Target deletion callbacks and exceptions
--

BEGIN
DECLARE del_exceptions SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN
    -- Target deletion callbacks
    MGMT_ADMIN.add_target_deletion_callback('ECM_CT.HANDLE_TARGET_DELETION');
    MGMT_ADMIN.add_target_deletion_callback(
                                       'ECM_CT.HOST_CONFIG_TARGET_DELETION');

    -- Target deletion exceptions 
    del_exceptions.extend(2);
    del_exceptions(1) := 'MGMT_ECM_GEN_SNAPSHOT'; 
    del_exceptions(2) := 'MGMT_ECM_SAVEDHOSTCONFIG'; 

    MGMT_ADMIN.add_target_deletion_exceptions(del_exceptions);

END;

BEGIN

  MGMT_LOG.register_logging_module(MGMT_ECM_CSA_PKG.CSA_LOGGING_MODULE_NAME);
  MGMT_LOG.register_logging_module(ECM_CT.HOST_CONFIG_LOG_MODULE_NAME);
  MGMT_LOG.register_logging_module(ECM_CT.ECM_PURGE_LOG_MODULE_NAME);

  COMMIT;
END;

END;
/

rem
rem Register valid preLoad and postLoad callbacks.
rem
BEGIN
  MGMT_LOADER.register_pre_load_callback('ECM_CT.PRELOAD_CALLBACK');
  MGMT_LOADER.register_post_load_callback('ECM_CT.POSTLOAD_CALLBACK');
 COMMIT;
END;
/

commit;
