Rem $Header: ecm_rc_tables.sql 28-mar-2005.14:31:00 jmansur Exp $
Rem
Rem ecm_rc_tables.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      
Rem
Rem    DESCRIPTION
Rem      ref config tables - tbd move to ecm_tables.sql later
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem     jmansur    03/28/05 - jmansur_ecm-050324-rc-api
Rem     jmansur    03/17/05 - Created
Rem

rem Import defines used for ecm scripts.
rem NOTE: must run from emcore dir - tbd remove when call 
@source/oracle/sysman/emdrep/sql/core/latest/ecm/ecm_defines.sql

rem
rem  PURPOSE
rem     MGMT_ECM_RC
rem
rem     This table holds content and attributes for saved
rem     reference configurataion (rc) xml files
rem
rem  COLUMNS
rem     GUID
rem     NAME
rem     DISPLAY_ID 
rem     VERSION
rem     TARGET_TYPE_GUID
rem     CATEGORY
rem     DESCRIPTION
rem     DOMAIN
rem     AUTHOR
rem     OWNER
rem     CREATION_DATE
rem     UPDATER
rem     LAST_UPDATED
rem     UPDATE_COMMENT
rem     CONTENT_XML
rem
rem tbd dont use ploicy constants????
CREATE TABLE MGMT_ECM_RC
  (
  -- lengths based on old policy constants
  GUID RAW(&GUID_RAW_LENGTH) NOT NULL, 
  NAME VARCHAR2(128), 
  DISPLAY_ID VARCHAR2(128),
  VERSION VARCHAR2(50),
  TARGET_TYPE_GUID RAW(&GUID_RAW_LENGTH), 
  CATEGORY VARCHAR2(100), 
  DESCRIPTION VARCHAR2(2000), 
  DOMAIN VARCHAR2(&SNAPSHOT_TYPE_LENGTH), 
  AUTHOR VARCHAR2(128),
  OWNER VARCHAR2(128),
  CREATION_DATE DATE, 
  UPDATER VARCHAR2(128),
  LAST_UPDATED DATE, 
  UPDATE_COMMENT VARCHAR2(500),
  CONTENT_XML SYS.XMLTYPE NOT NULL,
  CONSTRAINT ECM_RC_PK PRIMARY KEY(GUID),
  CONSTRAINT ECM_RC_UK UNIQUE (AUTHOR, TARGET_TYPE_GUID, DOMAIN, CATEGORY,
                               VERSION, NAME) 
  )
  MONITORING;


rem
rem  PURPOSE
rem     MGMT_ECM_RC_EVAL_RESULT
rem
rem     This table holds content and attributes for saved
rem     reference configurataion evaluation (compliance check) results
rem
rem  COLUMNS
rem     GUID
rem     NAME
rem       -- e.g., "RC1 evaluation"
rem     RC_GUID
rem     VERSION
rem     TARGET_GUID
rem     DESCRIPTION
rem     OWNER
rem     CREATION_DATE
rem     EVAL_COMMENT
rem     CONTENT_XML
rem
rem tbd dont use ploicy constants????
CREATE TABLE MGMT_ECM_RC_EVAL_RESULT
  (
  GUID RAW(&GUID_RAW_LENGTH) NOT NULL, 
  NAME VARCHAR2(128), 
  RC_GUID RAW(&GUID_RAW_LENGTH) NOT NULL, 
  VERSION VARCHAR2(50),
  TARGET_GUID RAW(&GUID_RAW_LENGTH), 
  DESCRIPTION VARCHAR2(2000), 
  OWNER VARCHAR2(128),
  CREATION_DATE DATE, 
  EVAL_COMMENT VARCHAR2(500),
  CONTENT_XML sys.XMLType NOT NULL,
  CONSTRAINT ECM_RC_EVAL_PK PRIMARY KEY(GUID)
  )
  MONITORING;
