Rem drv: <create type="tables" params="EM_ECM_DEPOT_TABLESPACE,EM_ECM_CSA_TABLESPACE_NAME" pos="data_propagation/data_propagation_tables.sql+"/>
Rem
Rem $Header: ecm_tables.sql 06-jul-2007.10:05:58 tasingh Exp $
Rem
Rem ecm_tables.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ecm_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    tasingh     07/06/07 - Adding entry for uln tables
Rem    rrawat      10/09/06 - 
Rem    rrawat      10/13/06 - Backport rrawat_bug-5546644 from main
Rem    abhalla     09/24/05 - 
Rem    akskumar    08/30/05 - bug-4503341
Rem    abhalla     08/24/05 - Adding column IS_VALID to MGMT_CPF_METRIC_SOURCE, and 
Rem                           PATCH_VALID_STATUS to MGMT_BUG_ADV_HOME_PATCH
Rem    asaraswa    07/24/05 - 
Rem    abhalla     07/14/05 - changing table MGMT_BUG_ADV_HOME_PATCH 
Rem    gsbhatia    07/13/05 - 
Rem    abhalla     07/07/05 - Creation of new table MGMT_CPF_METRIC_SOURCE 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    asaraswa    05/04/05 - putting CSA tables in CSA tablespace 
Rem    agor        04/27/05 - snapshotguid cannot be primary key index on mgmt_inv_summary 
Rem                           undoing the change..
Rem    agor        04/27/05 - add primary key index to mgmt_inv_summary 
Rem    asaraswa    04/07/05 - adding a patches column to mgmt_hc_os_summary 
Rem    groyal      02/16/05 - Comment out obsolete policy tables 
Rem    asaraswa    02/25/05 - adding table mgmt_inv_summary to improve perf of 
Rem                           SW rollup table 
Rem    asaraswa    02/16/05 - making appid and overall compliance columns be 
Rem                           non-null and have default values 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    asaraswa    02/08/05 - adding AUTO_CONFIG_URL and BROWSER_PROXY_ENABLED 
Rem                           columns to MGMT_ECM_CSA 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    agor        02/02/05 - subst some def 
Rem    scgrover    01/31/05 - compress index 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    smalathe    11/26/04 - Bug#3903438: Modify table MGMT_DELTA_IDS 
Rem    asaraswa    11/23/04 - adding new CSA columns 
Rem    asaraswa    11/09/04 - changing snapshot_id column in 
Rem                           mgmt_ecm_csa_failed to id 
Rem    vkhizder    10/15/04 - 
Rem    asaraswa    10/12/04 - adding mgmt_ecm_csa_out_of_box table 
Rem    asaraswa    10/11/04 - adding guid column to mgmt_ecm_csa_failed 
Rem    vkhizder    10/04/04 - adding materialized view for ecm metadata 
Rem    niramach    09/22/04 - Removing MGMT_ECM_HIST_FOR_GROUPS table 
Rem                           creation. 
Rem    akskumar    09/16/04  - 
Rem    mningomb    09/15/04  - Adding monitoring for MGMT_ECM_HIST_FOR_GROUPS 
Rem    ranmath     09/10/04  - Invoke Host Patching table creation script 
Rem                            (ecm_hostpatch_tables.sql). 
Rem    apbharga    08/31/04  - New CPF Algoritm requires changes to 
Rem                            MGMT_BUG_ADV_HOME_PATCH 
Rem    mningomb    08/23/04  - 10gr2: CPF Info 
Rem    vkhizder    08/31/04  - adding ui_on flags 
Rem    asaraswa    08/17/04  - add connection_type column to mgmt_ecm_csa 
Rem    akskumar    08/23/04  - modify table mgmt_comp_result_to_job_map, add 
Rem                            column RHS_CONFIG_GUID, required for generic 
Rem                            config comparison(job) results 
Rem    asaraswa    08/06/04  - adding user-agent header column to 
Rem                            mgmt_ecm_csa_failed 
Rem    agor        07/30/04  - history table for group 
Rem    agor        07/27/04  - add available searches table 
Rem    vkhizder    07/27/04  - adding table for orphan host configs 
Rem    vkhizder    07/12/04  - more changes to CSA: rules, app id, failed 
Rem                            collections, etc. 
Rem    agor        04/01/04  - change mgmt_ecm_loaded_files table 
Rem    vkhizder    02/25/04  - various CSA schema changes 
Rem    awarkar     11/14/03  - Bug Fix For Issue#3255739 
Rem    awarkar     11/14/03  - Bug Fix For Issue#3233127 
Rem    vkhizder    11/03/03  - commenting out MGMT_ECM_SEQ 
Rem    shuberma    10/30/03  - Adding a table for storing policy violation 
Rem    groyal      10/09/03  - Remove mgmt_policy_rollups 
Rem    shuberma    09/22/03  - adde a disabled column., 
Rem    shuberma    09/15/03  - Yet another change to aru tables 
Rem    shuberma    09/12/03  - Removing oui versions table 
Rem    shuberma    09/11/03  - Correct bug_adv_bug key 
Rem    shuberma    09/11/03  - Adding temporary column used to indicate if the 
Rem                            patch is already installed 
Rem    shuberma    09/08/03  - AddFactoring out bugs from advisories 
Rem    shuberma    09/04/03  - Add table for cpf rolldown information 
Rem    shuberma    08/19/03  - Making the datatype of the Impact column be 
Rem                            varchar2 (table mgmt_bug_advisories.) 
Rem    vkhizder    08/08/03  - shortening os user name to for csa index to fit 
Rem                            into 2k blocksized db max index size of 1478 
Rem    vkhizder    08/01/03  - adding not null constraints to CSA target identification columns
Rem    rpinnama    07/26/03  - 
Rem    groyal      07/17/03  - Tweak mgmt_policy_rule_def_columns
Rem    shuberma    07/23/03  - Adding a type field to the list of patches
Rem    shuberma    07/21/03  - Adding display name and abstract to the bug_advisory table
Rem    shuberma    07/17/03  - Adding a id column for collection of components for each patch.  Also, rename bug_id to patch_id
Rem    shuberma    07/08/03  - Adding adding tables for ARU downloads of oui mappings
Rem    vkhizder    06/17/03  - adding csa tables
Rem    skini       06/30/03  - Changes for rteducing blocksize
Rem    rmenon      06/14/03  - changed table's name from 
Rem                mgmt_comp_id_to_job_id to mgmt_comp_result_to_job_map.
Rem    rmenon      06/10/03 -  added table MGMT_COMP_ID_TO_JOB_ID_MAP; 
Rem                removed the constraint DELTA_COMP_INFO_PK because
Rem                that combination can be non-unique
Rem    shuberma    06/10/03 - Addin some keys to policy tables
Rem    asaraswa    06/05/03 - adding property name and property value columns to mgmt_target_type_component_map
Rem    groyal      06/06/03 - Rename  mgmt_rule_def_columns
Rem    groyal      06/04/03 - Rework api slightly
Rem    groyal      05/28/03 - Add OUI_PLATFORM
Rem    shuberma    05/20/03 - Changing definition of a rule
Rem    shuberma    05/14/03 - Adding author length
Rem    shuberma    05/06/03 - Change key columns for policy and rule
Rem    shuberma    04/18/03 - Add violation row table and modify violation and violation values table
Rem    shuberma    04/23/03 - Changing index for performance
Rem    shuberma    04/08/03 - Adding policy framework tables
Rem    shuberma    04/02/03 - Removing the not null constraint from some hc tables
Rem    vkhizder    03/25/03 - fixing sizes for procedure names
Rem    vkhizder    03/17/03 - relaxing some null constraints
Rem    vkhizder    03/11/03 - adding SAME_TARGET_COMPARE column to metadata table
Rem    rpinnama    02/27/03 - Parameterize the ECM depot table space
Rem    vkhizder    01/27/03 - various frmw improvements
Rem    shuberma    01/14/03 - Adding target name and target type to delta_snap table
Rem    mgoodric    12/27/02 - Added creator and saved_timestamp date to gen_snapshot
Rem    agor        12/26/02 - add is clonable to container
Rem    shuberma    12/09/02 - Creating new tables for saved compares.
Rem    shuberma    11/25/02 - Updating metadata tables.
Rem    shuberma    11/22/02 - Adding target type to snapshot metadata
Rem    goramamo    10/23/02 - Removed mount time
Rem    mgoodric    10/22/02 - Add support for EM_OS_BITLENGTH for platforms
Rem    shuberma    10/25/02 - specifying different index for unique and pk on some tables
Rem    shuberma    09/12/02 - Adding metadata tables
Rem    agor        09/06/02 - sql stuff
Rem    shuberma    08/23/02 - Adding more information in the delta_snap table
Rem    agor        08/30/02 - adding loaded files tables and modifying snapshots table
Rem    rmenon      08/21/02 - added hostname aliases column (this fixes the refresh host problem)
Rem    shuberma    08/15/02 - Adding english text resource lookup until we have an EM solution
Rem    shuberma    07/16/02 - Making delta time a date instead of a timestamp. history
Rem    skini       07/12/02 - Change target_name column size
Rem    rmenon      06/17/02 - added new columns in mgmt_hc_os_summary and mgmt_hc_vendor_sw_summary
Rem                         - Also added new tables for NIC anf FS mount info collection
Rem    shuberma    05/17/02 - Moving updates lost...byte needs to be removed..
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/14/02 - Created
Rem
  
rem
rem This script requires the following arguments
rem  1. Name of the ecm_depot tablespace where all LOBs are stored
rem  2. Name of the ecm_csa tablespace
rem
DEFINE EM_ECM_DEPOT_TABLESPACE = "&1"
DEFINE EM_ECM_CSA_TABLESPACE_NAME = "&2"

rem Import defines used for ecm scripts.
@&EM_SQL_ROOT/core/latest/ecm/ecm_defines.sql

rem
rem  PURPOSE
rem
rem     The MGMT_ECM_SEQ sequence is used to allocate unique IDs for all
rem     ECM id tables
rem
rem  NOTES
rem
rem CREATE SEQUENCE "MGMT_ECM_SEQ" INCREMENT BY 1 START WITH 1
rem    MAXVALUE 1.0E28 MINVALUE 1 NOCYCLE
rem    CACHE 20 NOORDER;


rem
rem  PURPOSE
rem
rem     The MGMT_ECM_PATCH_CACHE table contains patch cache entries.
rem
rem  COLUMNS
rem
rem     ARU_ID        - The unique id of this patch.  This comes from the ARU
rem                     database and is unique in this repository as well.
rem     STATUS        - The aru status of the patch.  'approved',
rem                     'password protected'
rem     TYPE          - Patch, Patchset
rem     BUG_NO        - The name of the patch in aru is called the bug number.
rem                     it indicates which bug was fixed by the patch.
rem                     For patches that fix multiple bugs, it is generally one
rem                     of the many.
rem     PRODUCT_ID    - the aru id of the aru product to which this
rem                     patch entry applies.
rem     PLATFORM_ID   - ARU platform id. For this patch.
rem     LANGUAGE_ID   - Specifies the ARU language id variant of the entry.
rem     RELEASE       - This is the version number of prodcut to which this
rem                     entry applies.
rem     ABSTRACT      - ARU abstract that describes the patch.
rem     PATCH_DATE    - The date that the patch was last updated in ARU.
rem     README_URL    - The url for pulling down the patch readme file from ARU.
rem     PATCH_URL     - A url for downloading a patch from ARU.
rem     COMMENTS      - Comments from the aru database associated with thie patch.
rem     FILE_SIZE     - The size, in bytes, of the patch zip file.
rem     MANUALLY_POSTED - Was this patch manually entered into the cache?
rem                        'Y' or 'N'.
rem     LAST_REFERENCED - The last time this entry was accessed.  This can
rem                       used to clean up old patch entries.
rem     FILE_CONTENTS - The zip file stored as a blob in the repository.  Null
rem                     if not yet downloaded.
rem     AUTOMATED     - COMPLETELY = 'C', MANUAL = 'M', PARTIAL = 'P'
rem
rem  NOTES
rem
CREATE TABLE MGMT_ECM_PATCH_CACHE
(
  ARU_ID NUMBER NOT NULL,
  STATUS VARCHAR2(31) NOT NULL,
  TYPE VARCHAR2(31) NOT NULL,
  BUG_NO NUMBER NOT NULL,
  PRODUCT_ID NUMBER NOT NULL,
  PLATFORM_ID NUMBER NOT NULL,
  LANGUAGE_ID NUMBER NOT NULL,
  RELEASE VARCHAR2(31) NOT NULL,
  ABSTRACT VARCHAR2(1000),
  PATCH_DATE DATE NOT NULL,
  README_URL VARCHAR2(2000) NOT NULL,
  PATCH_URL VARCHAR2(2000) NOT NULL,
  COMMENTS VARCHAR2(2000),
  FILE_SIZE NUMBER,
  MANUALLY_POSTED VARCHAR2(1) DEFAULT 'N' NOT NULL,
  LAST_REFERENCED DATE DEFAULT SYSDATE NOT NULL,
  FILE_CONTENTS BLOB,
  AUTOMATED VARCHAR2(1) DEFAULT 'M' NOT NULL,
  CONSTRAINT MGMT_ECM_PC_PK PRIMARY KEY(ARU_ID)
) MONITORING
  LOB(FILE_CONTENTS) STORE AS ( TABLESPACE &EM_ECM_DEPOT_TABLESPACE );



rem
rem  PURPOSE
rem
rem     The MGMT_ECM_ARU_MAP table contains a mapping between aru ids, for
rem     platform, product, product family, language and release, and display
rem     strings and em target types.
rem
rem  COLUMNS
rem     ARU_ID          - The ARU id.
rem     DISPLAY_STRING  - Display string (ARU)
rem     EM_NAME         - EM Target type string.
rem     EM_BITLENGTH    - EM OS bit-length
rem     CATEGORY        - "product", "family", "platform", "language", "release"
rem  NOTES
rem
CREATE TABLE MGMT_ECM_ARU_MAP (
  "ARU_ID" NUMBER(10) NOT NULL,
  "DISPLAY_STRING" VARCHAR2(64) NOT NULL,
  "EM_NAME" VARCHAR2(64) NOT NULL,
  "EM_BITLENGTH" VARCHAR2(8) DEFAULT 'ALL' NOT NULL,
  "CATEGORY" VARCHAR2(20) NOT NULL,
  CONSTRAINT "ECM_ARU_MAP_PK" PRIMARY KEY("ARU_ID", "CATEGORY"))
  MONITORING;


rem INVENTORY TABLES
rem============================================================================
rem
rem  PURPOSE
rem     MGMT_ECM_SNAPSHOT
rem       This table holds entries for all snapshots captured in this
rem       repository.  Snapshots include, HOST_CONFIGURATION and
rem       APPS_TECHSTACK(?).
rem  COLUMNS
rem     SNAPSHOT_GUID
rem                         -- A globally unique identifier for this snapshot.
rem     START_TIMESTAMP
rem                         -- This is the timestamp for when the snapshot was
rem                         captured.
rem     IS_CURRENT
rem                         -- This is a flag indicating if this snapshot is
rem                         current. Current snapshots are those that are updated.
rem                         They are not used as "historical snapshots" that are
rem                         never updated.
rem                         In particular, the current inventory is
rem                         special host configuration which is not
rem                         saved historically.  That is, when the current
rem                         inventory is refreshed, the old entries are
rem                         removed/replaced with the newly read
rem                         inventory.
rem                         possible values: Y, N
rem     SNAPSHOT_TYPE
rem                         -- HOST_CONFIGURATION, APPS_TECHSTACK, etc.
rem     ELAPSED_TIME
rem                         -- This records the amount a time it took to
rem                         create/refresh the snapshot.
rem     TARGET_NAME
rem                         -- Internal name of target
rem     TARGET_TYPE
rem                         -- Internal name of target type
rem     DISPLAY_TARGET_NAME
rem                         -- External name for target
rem     DISPLAY_TARGET_TYPE
rem                         -- External name for target type
rem     DESCRIPTION
rem                         -- A text description useful for explaining the
rem                         details of the snapshot.  For current inventory,
rem                         this will be a fixed/generated description
rem                         of the current inventory.
rem     SNAPSHOT_TYPE_VERSION
rem                         -- This column is used to record the version of the
rem                         code that generated the snapshot.  It is used with
rem                         import/export for forward
rem                         compatibility.
rem     COLLECTION_ERROR_STREAM
rem                         -- (Possibly truncated) error stream that was
rem                         generated during snapshot collection
rem  NOTES:
rem     The columns SNAPSHOT_TYPE, START_TIMESTAMP and TARGET_GUID comprise the
rem     primary key.  SNAPSHOT_GUID is an alternate unique key.
CREATE TABLE MGMT_ECM_SNAPSHOT
  (
    SNAPSHOT_GUID RAW(&GUID_RAW_LENGTH) DEFAULT SYS_GUID() NOT NULL,
    SNAPSHOT_TYPE VARCHAR2(&SNAPSHOT_TYPE_LENGTH) NOT NULL,
    START_TIMESTAMP DATE NOT NULL,
    TARGET_NAME VARCHAR2(&TARGET_NAME_LENGTH) NOT NULL,
    TARGET_TYPE VARCHAR2(&TARGET_TYPE_LENGTH) NOT NULL,
    DISPLAY_TARGET_NAME VARCHAR2(&DISPLAY_TARGET_NAME_LENGTH) NOT NULL,
    DISPLAY_TARGET_TYPE VARCHAR2(&DISPLAY_TARGET_TYPE_LENGTH) NOT NULL,
    ELAPSED_TIME NUMBER(16) DEFAULT -1 NOT NULL,
    DESCRIPTION VARCHAR2(1024),
    IS_CURRENT VARCHAR2(1) DEFAULT 'Y' NOT NULL,
    SNAPSHOT_TYPE_VERSION VARCHAR2(16) NOT NULL,
    COLLECTION_ERROR_STREAM VARCHAR2(2048) DEFAULT NULL,
    CONSTRAINT SH_PK PRIMARY KEY (SNAPSHOT_GUID))
    MONITORING;


rem
rem  PURPOSE
rem     MGMT_ECM_SNAP_COMPONENT_INFO
rem
rem     This table holds information about collection status and collection
rem     errors of snapshot components
rem
rem  COLUMNS
rem     SNAPSHOT_GUID
rem                           This is the unique id of the snapshot in which
rem                           component resides.
rem     COMPONENT_NAME
rem                           An internal name of the component uniquely
rem                           identifying it among other components of the
rem                           snapshot
rem     COLLECTION_STATUS
rem                           Collection status of the components:
rem                              COLLECTED, NOT_FOUND, COLLECTION_FAILED
rem
rem     COLLECTION_MESSAGE
rem                           (Error) Message generated during component
rem                           collection.
rem
CREATE TABLE MGMT_ECM_SNAP_COMPONENT_INFO
  (
    SNAPSHOT_GUID RAW(16) NOT NULL,
    COMPONENT_NAME VARCHAR2(64) NOT NULL,
    COLLECTION_STATUS VARCHAR2(32) NOT NULL,
    COLLECTION_MESSAGE VARCHAR2(2048) DEFAULT NULL,
    CONSTRAINT MGMT_ESCI_PK PRIMARY KEY (
              SNAPSHOT_GUID, COMPONENT_NAME) USING INDEX 
      ( CREATE UNIQUE INDEX MGMT_ESCI_PK ON MGMT_ECM_SNAP_COMPONENT_INFO
        (SNAPSHOT_GUID, COMPONENT_NAME) COMPRESS 1),
    CONSTRAINT MGMT_ESCI_FK FOREIGN KEY(SNAPSHOT_GUID)
      REFERENCES MGMT_ECM_SNAPSHOT(SNAPSHOT_GUID)
      ON DELETE CASCADE
  )
  MONITORING;


rem  PURPOSE
rem     MGMT_ECM_GEN_SNAPSHOT
rem       This table holds entries for all generic ECM snapshots captured
rem       in this repository.
rem  COLUMNS
rem     SNAPSHOT_GUID
rem                         -- A globally unique identifier for this snapshot.
rem     SNAPSHOT_TYPE
rem                         -- HOST_CONFIGURATION, dbconfig, etc.
rem     START_TIMESTAMP
rem                         -- The timestamp for when the snapshot was
rem                         captured.
rem     IS_CURRENT
rem                         -- This is a flag indicating if this snapshot is
rem                         current. Current snapshots are those that are updated.
rem                         They are not used as "historical snapshots" that are
rem                         never updated. When the current snapshot is
rem                         refreshed, the old entries are removed/replaced
rem                         with the newly read snapshot information.
rem                         possible values: Y, N, perhaps some other
rem                         temporary values too indicating temporary nature
rem                         of the snapshot.
rem     ELAPSED_TIME
rem                         -- This records the amount a time it took to
rem                         collect information in the snapshot.
rem                         (in milliseconds)
rem     TARGET_GUID
rem                         -- Guid of the target for current snapshots; null
rem                         for saved snapshots; either for temporary
rem                         snapshots. If not null, the guid has to reference
rem                         the targets table (mgmt_targets).
rem     TARGET_NAME
rem                         -- Internal name of target
rem     TARGET_TYPE
rem                         -- Internal name of target type
rem     DISPLAY_TARGET_NAME
rem                         -- External display name for target
rem     DISPLAY_TARGET_TYPE
rem                         -- External display name for target type
rem     DESCRIPTION
rem                         -- A text description useful for explaining the
rem                         details of the snapshot.
rem     MESSAGE
rem                         -- (Possibly truncated) warning / error message
rem                         that was generated during snapshot
rem                         collection / transfer
rem     STATUS
rem                         -- status of the snapshot indicating whether
rem                         snapshot info was not found, there was an error,
rem                         or collection is successful
rem     CREATOR
rem                         -- The name of the user creating the snapshot
rem
rem     SAVED_TIMESTAMP
rem                         -- The timestamp for when the snapshot was
rem                         saved.
rem
CREATE TABLE MGMT_ECM_GEN_SNAPSHOT
  (
    SNAPSHOT_GUID RAW(&GUID_RAW_LENGTH) DEFAULT SYS_GUID() NOT NULL,
    SNAPSHOT_TYPE VARCHAR2(&SNAPSHOT_TYPE_LENGTH) NOT NULL,
    START_TIMESTAMP DATE NOT NULL,
    TARGET_GUID RAW(&GUID_RAW_LENGTH) DEFAULT NULL,
    TARGET_NAME VARCHAR2(&TARGET_NAME_LENGTH) NOT NULL,
    TARGET_TYPE VARCHAR2(&TARGET_TYPE_LENGTH) NOT NULL,
    DISPLAY_TARGET_NAME VARCHAR2(&DISPLAY_TARGET_NAME_LENGTH) NOT NULL,
    DISPLAY_TARGET_TYPE VARCHAR2(&DISPLAY_TARGET_TYPE_LENGTH) NOT NULL,
    ELAPSED_TIME NUMBER(16) DEFAULT -1 NOT NULL,
    DESCRIPTION VARCHAR2(&MAX_VARCHAR2_LENGTH) DEFAULT NULL,
    IS_CURRENT VARCHAR2(1) DEFAULT 'Y' NOT NULL,
    MESSAGE VARCHAR2(&MAX_VARCHAR2_LENGTH) DEFAULT NULL,
    STATUS VARCHAR2(1) NOT NULL,
    CREATOR VARCHAR2(&USER_NAME_LENGTH) DEFAULT NULL,
    SAVED_TIMESTAMP DATE DEFAULT SYSDATE NOT NULL,
    CONSTRAINT GEN_SNAP_PK PRIMARY KEY (SNAPSHOT_GUID)
) MONITORING;

rem  PURPOSE
rem     MGMT_ECM_SNAPSHOT_METADATA
rem       This table holds entries for all configuration snapshot types defined
rem       in the repository.
rem  COLUMNS
rem     SNAPSHOT_TYPE
rem       -- Same as in generic snapshot table. It names the type of
rem          snapshot defined by this table and its children. Snapshot types
rem          are defined in the context of target types.
rem     TARGET_TYPE
rem       -- Target type for the snapshot type above.
rem     KIND
rem       -- For now: 'L' for loader; 'P' for presentation.
rem     METADATA_ID
rem       -- An id to tie all the children rows from the table and column tables
rem         together.  Is unique when combined with the KIND column value.  Would
rem         be unique alone except that we may share the definitions for both the
rem         'L' and 'P'.
rem     UI_NAME
rem       -- User friendly name for the metadata. It is be defaulted to a 
rem          combination of target type and snapshot type, if not supplied.
rem     UI_ON
rem       -- Indicates if the framework is implementing the UI for this
rem          metadata.
rem     COMPARE_ON
rem       -- Indicates if the framework is implementing comparison for this
rem          metadata.
rem     COMPARE_UI_ON
rem       -- Indicates whether generic comparison UI should be turned on for 
rem          this metadata.
rem     HISTORY_ON
rem       -- Indicates if the framework is implementing the history for this
rem          metadata.
rem     HISTORY_UI_ON
rem       -- Indicates whether generic history UI should be turned on for 
rem          this metadata.
rem     LINK_TABLE_NAME
rem       -- Used for populating the top level related links.
rem     AFTER_LOAD_PROC_NAME
rem       -- Name of after-load procedure. The integrator-defined procedure is
rem          called after snapshot load.
rem     AFTER_IMPORT_PROC_NAME
rem       -- Name of after-import procedure. The integrator-defined procedure is
rem          called after snapshot import.
rem     METADATA_VERSION
rem       -- Integrator-defined metadata version. Used for import/export. One
rem          of the parameters to the after-import procedure.
rem     VIEW_URL
rem       -- Custom UI URL that should be followed from the generic UI (e.g.
rem          saved snapshot tables)
rem     COMPARE_URL
rem       -- Custom comparison URL that should be followed from the generic UI
rem          (e.g. comparison job results)
rem     HISTORY_URL
rem       -- Custom history URL that should be followed from the generic UI
rem          (e.g. history button on generic UI)
rem     SAME_TARGET_COMPARE
rem       -- Indicates whether history flags ('H') or compare flags ('C') are 
rem          used for comparison of the same targets.
rem
CREATE TABLE MGMT_ECM_SNAPSHOT_METADATA
(
  SNAPSHOT_TYPE VARCHAR2(&SNAPSHOT_TYPE_LENGTH) NOT NULL,
  TARGET_TYPE VARCHAR2(64) NOT NULL,
  KIND VARCHAR2(1) NOT NULL,
  METADATA_ID RAW(16) DEFAULT SYS_GUID() NOT NULL,
  UI_NAME VARCHAR2(256) NOT NULL,
  UI_ON VARCHAR2(1) NOT NULL,
  COMPARE_ON VARCHAR2(1) NOT NULL,
  COMPARE_UI_ON VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  HISTORY_ON VARCHAR2(1) NOT NULL,
  HISTORY_UI_ON VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  LINK_TABLE_NAME VARCHAR2(30),
  AFTER_LOAD_PROC_NAME VARCHAR2(200),
  AFTER_IMPORT_PROC_NAME VARCHAR2(200),
  METADATA_VERSION VARCHAR2(16),
  VIEW_URL VARCHAR2(&MAX_VARCHAR2_LENGTH) DEFAULT NULL,
  COMPARE_URL VARCHAR2(&MAX_VARCHAR2_LENGTH) DEFAULT NULL,
  HISTORY_URL VARCHAR2(&MAX_VARCHAR2_LENGTH) DEFAULT NULL,
  SAME_TARGET_COMPARE VARCHAR2(1) DEFAULT 'H' NOT NULL,
  CONSTRAINT SM_PK PRIMARY KEY (TARGET_TYPE, SNAPSHOT_TYPE, KIND),
  CONSTRAINT SM_UK UNIQUE (KIND, METADATA_ID)
) MONITORING;


rem  PURPOSE
rem     MGMT_ECM_SNAPSHOT_MD_TABLES
rem       This table holds entries for all tables / views within configuration
rem       snapshot metadatas defined in the repository.
rem  COLUMNS
rem     METADATA_ID
rem       -- An id to tie all the metadata tables/views/columns together.
rem     NAME
rem       -- Name of the table or view in the repository.
rem     UI_NAME
rem       -- User friendly name. It is be defaulted to NAME if not supplied.
rem     UI_ON
rem       -- Indicates if the framework is implementing the UI for this table.
rem     COMPARE_ON
rem       -- Indicates if the framework is implementing comparison for this
rem          table.
rem     COMPARE_UI_ON
rem       -- Indicates whether generic comparison UI should be turned on for 
rem          this table.
rem     HISTORY_ON
rem       -- Indicates if the framework is implementing the history for this
rem          table.
rem     HISTORY_UI_ON
rem       -- Indicates whether generic history UI should be turned on for
rem          this table.
rem     PARENT_TABLE_NAME
rem       -- Name of the parent table if any (parent table has to have the same
rem          metadata_id)
rem     FULL_TABLE_PATH
rem       -- Full path from root table down to this table.
rem     IS_SINGLE_ROW
rem       -- This table has a single row given its parent table's id;  i.e. the
rem          id is that of its parent. In other words, for a given snapshot id
rem          and a set of ancestor table ids (if any), this table will have at
rem          more one row.
rem     TBL_ORDER
rem       -- Order of the table in its tree of tables. Used for:
rem          (a) UI order of this table relative to its siblings: higher-order
rem          tables are displayed after lower-order tables.
rem          (b) Child's ORDER is higher than its parent's order
rem          (c) Export order
rem
CREATE TABLE MGMT_ECM_SNAPSHOT_MD_TABLES
(
  METADATA_ID RAW(16) NOT NULL,
  NAME VARCHAR2(30) NOT NULL,
  UI_NAME VARCHAR2(256) NOT NULL,
  UI_ON VARCHAR2(1) NOT NULL,
  COMPARE_ON VARCHAR2(1) NOT NULL,
  COMPARE_UI_ON VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  HISTORY_ON VARCHAR2(1) NOT NULL,
  HISTORY_UI_ON VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  PARENT_TABLE_NAME VARCHAR2(30),
  FULL_TABLE_PATH VARCHAR2(1000) NOT NULL,
  IS_SINGLE_ROW VARCHAR2(1) NOT NULL,
  TBL_ORDER NUMBER(10) NOT NULL,
  CONSTRAINT SMT_PK PRIMARY KEY(METADATA_ID, NAME),
  CONSTRAINT SMT_SMT_FK FOREIGN KEY(METADATA_ID, PARENT_TABLE_NAME)
      REFERENCES MGMT_ECM_SNAPSHOT_MD_TABLES(METADATA_ID, NAME)
      ON DELETE CASCADE
) MONITORING;


rem  PURPOSE
rem     MGMT_ECM_SNAPSHOT_MD_COLUMNS
rem       This table holds entries for all table / view columns within
rem       configuration snapshot metadatas defined in the repository.
rem  COLUMNS
rem     METADATA_ID
rem       -- An id to tie all the metadata tables/views/columns together
rem     TABLE_NAME
rem       -- Name of the table or view to which this column belongs
rem     NAME
rem       -- Name of the column
rem     UI_NAME
rem       -- User friendly name of the column. It is be defaulted to NAME if 
rem          not supplied.
rem     TYPE
rem       -- For now: 'S' for string, 'N' for real/non-integral number,
rem          'D' for date/time, 'R' for raw
rem     TYPE_FORMAT
rem       -- Used to specify additional info about the type. Examples: length
rem       in case of string type, "precision" or "precision, scale" in case
rem       of numbers, date format in case of date/time.
rem     UI_ON
rem       -- Indicates if the framework is implementing the UI for this column.
rem     COMPARE_ON
rem       -- Indicates if the framework is implementing comparison for this
rem          column.
rem     COMPARE_UI_ON
rem       -- Indicates whether generic comparison UI should be turned on for
rem          this column.
rem     HISTORY_ON
rem       -- Indicates if the framework is implementing the history for this
rem          column.
rem     HISTORY_UI_ON
rem       -- Indicates whether generic history UI should be turned on for
rem          this column.
rem     IS_KEY
rem        -- Is this column part of the table/view key?
rem     IS_CONTEXT
rem        -- Is this a context column? (Used to provide context in UI
rem           instead of / in addition to key columns)
rem     IS_SUMMARY
rem        -- Is this a summary column? (Used to summarize snapshots in UI
rem           by values in this column)
rem     IS_CHILD_LINK
rem        -- Does this column serve as a child link column which drills into
rem           children in generic UI?
rem     LINK_COLUMN_NAME
rem       -- The name of the column in the same table/view which contains the
rem          url for this column. Used to create a link under this column in UI.
rem          Disregarded if IS_CHILD_LINK is set to "Y".
rem     COL_ORDER
rem       -- Order of the columns in the table/view. Used as UI order (and
rem          also during export).
rem
CREATE TABLE MGMT_ECM_SNAPSHOT_MD_COLUMNS
(
  METADATA_ID RAW(16) NOT NULL,
  TABLE_NAME VARCHAR2(30) NOT NULL,
  NAME VARCHAR2(30) NOT NULL,
  UI_NAME VARCHAR2(256) NOT NULL,
  TYPE VARCHAR2(1) NOT NULL,
  TYPE_FORMAT VARCHAR2(100),
  UI_ON VARCHAR2(1) NOT NULL,
  COMPARE_ON VARCHAR2(1) NOT NULL,
  COMPARE_UI_ON VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  HISTORY_ON VARCHAR2(1) NOT NULL,
  HISTORY_UI_ON VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  IS_KEY VARCHAR2(1) NOT NULL,
  IS_CONTEXT VARCHAR2(1) NOT NULL,
  IS_SUMMARY VARCHAR2(1) NOT NULL,
  IS_CHILD_LINK VARCHAR2(1) NOT NULL,
  LINK_COLUMN_NAME VARCHAR2(30),
  COL_ORDER NUMBER(10) NOT NULL,
  CONSTRAINT SMC_PK PRIMARY KEY(METADATA_ID, TABLE_NAME, NAME),
  CONSTRAINT SMC_SM_FK FOREIGN KEY(METADATA_ID, TABLE_NAME)
      REFERENCES MGMT_ECM_SNAPSHOT_MD_TABLES(METADATA_ID, NAME )
      ON DELETE CASCADE,
  CONSTRAINT SMC_SMC_FK FOREIGN KEY(METADATA_ID, TABLE_NAME, LINK_COLUMN_NAME)
      REFERENCES MGMT_ECM_SNAPSHOT_MD_COLUMNS(METADATA_ID, TABLE_NAME, NAME)
      DEFERRABLE INITIALLY IMMEDIATE
) MONITORING;

rem
rem  PURPOSE
rem     MGMT_ECM_MD_ALL_TBL_COLUMNS
rem    
rem     This materialized view contains ECM metadata information
rem     about all table columns for Presentation metadata, 
rem     including those (key columns) "inherited" from the 
rem     ancestor tables in the table hierarchy.
rem
rem  COLUMNS (columns that are not listed have the same meaning as the
rem  same-named columns in the MGMT_ECM_SNAPSHOT_METADATA and
rem  MGMT_ECM_SNAPSHOT_MD_COLUMNS tables).
rem     
rem     TABLE_NAME
rem                       Table name for the column.
rem     SOURCE_TABLE_NAME
rem                       Table name from where the column was inherited.
rem                       Thus, it is either the same as TABLE_NAME or
rem                       its ancestor. In the latter case, the column 
rem                       must be a key column inherited from that ancestor.
rem     COL_ORDER
rem                       Overall column order for all columns in the table,
rem                       including inherited keys.
rem

CREATE MATERIALIZED VIEW MGMT_ECM_MD_ALL_TBL_COLUMNS
BUILD DEFERRED
REFRESH ON DEMAND
AS
SELECT c.METADATA_ID,
       m.TARGET_TYPE,
       m.SNAPSHOT_TYPE, 
       t.name as TABLE_NAME, 
       c.NAME,
       c.UI_NAME,
       c.TYPE, c.TYPE_FORMAT,
       c.UI_ON, c.COMPARE_ON, c.COMPARE_UI_ON, c.HISTORY_ON, c.HISTORY_UI_ON,
       c.IS_KEY, c.IS_CONTEXT, c.IS_SUMMARY, 
       c.IS_CHILD_LINK, c.LINK_COLUMN_NAME,
       rank() over (partition by c.metadata_id, t.name 
           order by anc.tbl_order asc, c.col_order asc) as COL_ORDER,
       c.table_name as SOURCE_TABLE_NAME
FROM
     mgmt_ecm_snapshot_metadata m,
     mgmt_ecm_snapshot_md_tables t,
     mgmt_ecm_snapshot_md_tables anc,
     mgmt_ecm_snapshot_md_columns c
WHERE 
     (anc.name, anc.metadata_id) in
         (SELECT anc_t.name, anc_t.metadata_id 
            FROM mgmt_ecm_snapshot_md_tables anc_t
          START WITH anc_t.name = t.name 
                 AND anc_t.metadata_id = t.metadata_id
          CONNECT BY anc_t.name = PRIOR anc_t.parent_table_name
                 AND anc_t.metadata_id = PRIOR anc_t.metadata_id)
  AND c.metadata_id = anc.metadata_id
  AND c.table_name = anc.name
  AND c.metadata_id = m.metadata_id
  AND m.kind = 'P'
  AND ((c.is_key = 'Y') OR (anc.name = t.name));

ALTER TABLE MGMT_ECM_MD_ALL_TBL_COLUMNS MONITORING;

rem
rem  PURPOSE
rem     MGMT_ECM_MD_HIST_TBLS
rem
rem     This derived table contains ECM metadata information
rem     about all "history-on" tables from presentation metadatas
rem     and their history-related derived columns, including columns
rem     potentially (key columns) "inherited" from the ancestor 
rem     tables in the table hierarchy. The table is derived from
rem     ECM metadata tables and MGMT_ECM_MD_ALL_TBL_COLUMNS view. 
rem
rem     This table is used by generic History code.
rem
rem  COLUMNS (columns that are not listed have the same meaning as the
rem  same-named columns in the MGMT_ECM_SNAPSHOT_METADATA and
rem  MGMT_ECM_SNAPSHOT_MD_TABLES tables).
rem
rem     NAME
rem                       Table name.
rem     NUM_HIST_UI_KEYS
rem                       Total number of key columns for which 
rem                       history_on and history_ui_on flags are on. 
rem                       This includes keys "inherited" from ancestor 
rem                       tables.
rem     HIST_UI_KEY<N>,   where N is between 1 and 6
rem                       First 6 key column names for which history and 
rem                       history UI is turned on. If there are less 
rem                       than 6 keys for the table, the last 
rem                       max(0, 6 - NUM_HIST_UI_KEYS) keys are null.    
rem

CREATE TABLE MGMT_ECM_MD_HIST_TBLS
(
  METADATA_ID RAW(16) NOT NULL,
  TARGET_TYPE VARCHAR2(64) NOT NULL,
  SNAPSHOT_TYPE VARCHAR2(&SNAPSHOT_TYPE_LENGTH) NOT NULL, 
  NAME VARCHAR2(30) NOT NULL,
  NUM_HIST_UI_KEYS NUMBER(7) NOT NULL,
  HIST_UI_KEY1 VARCHAR2(30),
  HIST_UI_KEY2 VARCHAR2(30),
  HIST_UI_KEY3 VARCHAR2(30),
  HIST_UI_KEY4 VARCHAR2(30),
  HIST_UI_KEY5 VARCHAR2(30),
  HIST_UI_KEY6 VARCHAR2(30),
  UI_NAME VARCHAR2(256) NOT NULL,
  UI_ON VARCHAR2(1) NOT NULL,
  COMPARE_ON VARCHAR2(1) NOT NULL,
  COMPARE_UI_ON VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  HISTORY_ON VARCHAR2(1) NOT NULL,
  HISTORY_UI_ON VARCHAR2(1) DEFAULT 'Y' NOT NULL,
  PARENT_TABLE_NAME VARCHAR2(30),
  FULL_TABLE_PATH VARCHAR2(1000) NOT NULL,
  IS_SINGLE_ROW VARCHAR2(1) NOT NULL,
  TBL_ORDER NUMBER(10) NOT NULL,
  CONSTRAINT SMHT_PK PRIMARY KEY(METADATA_ID, NAME),
  CONSTRAINT SMHT_SMHT_FK FOREIGN KEY(METADATA_ID, PARENT_TABLE_NAME)
      REFERENCES MGMT_ECM_MD_HIST_TBLS(METADATA_ID, NAME)
      ON DELETE CASCADE
) MONITORING;

rem
rem  PURPOSE
rem     MGMT_ECM_LOADED_FILES
rem
rem     This table holds information about files loaded during a session.
rem
rem  COLUMNS
rem     FILE_CONTENTS_GUID
rem                           This is the unique id of the contents contained
rem                           in a file. (same as snapshot guid for snapshots.)
rem     SESSION_ID
rem                           Id of the session unique accross all EMLs using
rem                           this repository
rem     FILENAME
rem                           Name of the loaded file
rem     LOAD_TIMESTAMP
rem                           Timestamp of the load
rem
rem
CREATE TABLE MGMT_ECM_LOADED_FILES
  (
    FILE_CONTENTS_GUID RAW(16) NOT NULL,
    FILENAME VARCHAR2(1024) NOT NULL,
    LOAD_TIMESTAMP DATE DEFAULT SYSDATE NOT NULL,
    SESSION_ID RAW(16) DEFAULT SYS_GUID() NOT NULL,
    CONSTRAINT MGMT_ECM_LOAD_FILE_PK PRIMARY KEY (FILE_CONTENTS_GUID),
    CONSTRAINT MGMT_ECM_LOAD_FILE_FK FOREIGN KEY (FILE_CONTENTS_GUID)
      REFERENCES MGMT_ECM_SNAPSHOT(SNAPSHOT_GUID)
      ON DELETE CASCADE
  )
  MONITORING;

rem
rem  PURPOSE
rem     MGMT_ECM_SAVEDHOSTCONFIG
rem
rem     This table holds information about saved hostconfig 
rem     which were manually saved by enduser.
rem
rem  COLUMNS
rem     TARGET_GUID
rem                           Pointer to the actual live target.
rem     CREATOR
rem                           Person who saved this configuration
rem     HOSTCONFIG_CONTENTS_GUID
rem                           This is the unique id of the contents contained
rem                           in a saved host config. (same as snapshot guid for snapshots.)
rem     FILENAME
rem                           Name of the loaded file if imported. It can be null.
rem     LOAD_TIMESTAMP
rem                           Timestamp of the load
rem
rem
CREATE TABLE MGMT_ECM_SAVEDHOSTCONFIG
  (
    TARGET_GUID RAW(16),
    CREATOR VARCHAR2(256) DEFAULT NULL,
    HOSTCONFIG_CONTENTS_GUID RAW(16) NOT NULL,
    FILENAME VARCHAR2(1024) DEFAULT NULL,
    LOAD_TIMESTAMP DATE DEFAULT SYSDATE NOT NULL,
    CONSTRAINT MGMT_ECM_SAVEDHOSTCONFIG_PK PRIMARY KEY (HOSTCONFIG_CONTENTS_GUID),
    CONSTRAINT MGMT_ECM_SAVEDHOSTCONFIG_FK FOREIGN KEY (HOSTCONFIG_CONTENTS_GUID)
      REFERENCES MGMT_ECM_SNAPSHOT(SNAPSHOT_GUID)
      ON DELETE CASCADE
  )
  MONITORING;

rem
rem  PURPOSE
rem    MGMT_INV_SUMMARY
rem
rem    This table holds information identifying all containers in a given
rem    host configuration snapshot
rem
rem  COLUMNS
rem    SNAPSHOT_GUID
rem      The GUID of the host config snapshot
rem      
rem    COMP_EXTERNAL_NAME
rem      The external name of the container
rem 
rem    COMP_VERSION
rem      The version of the component, which is either the component version
rem      or the version of its latest patch
rem      
rem    CONTAINER_LOCATION
rem      The Oracle Home for this component
rem
rem    CONTAINER_GUID
rem      The GUID of the container
rem
rem    
rem    IS_PATCHED
rem       Whether or not this component has been patched
rem
rem    MAP_TARGET_TYPE
rem      The target type corresponding to this component
rem
rem    MAP_PROPERTY_NAME
rem      The target property name corresponding to this component
rem
rem    MAP_PROPERTY_VALUE
rem      The target property value corresponding to this component

CREATE TABLE MGMT_INV_SUMMARY
  (
    SNAPSHOT_GUID RAW(16) NOT NULL,
    COMP_EXTERNAL_NAME VARCHAR2(128) NOT NULL,
    COMP_VERSION VARCHAR2(64) NOT NULL,
    CONTAINER_LOCATION VARCHAR2(128) NOT NULL,
    CONTAINER_GUID RAW(16) NOT NULL,
    IS_PATCHED NUMBER(1) NOT NULL,
    MAP_TARGET_TYPE VARCHAR2(64) NOT NULL,
    MAP_PROPERTY_NAME VARCHAR2(64) DEFAULT NULL,
    MAP_PROPERTY_VALUE VARCHAR2(1024) DEFAULT NULL,
    CONSTRAINT SNAP_GUID_FK FOREIGN KEY(SNAPSHOT_GUID)
      REFERENCES MGMT_ECM_SNAPSHOT(SNAPSHOT_GUID)
      ON DELETE CASCADE
  )
  MONITORING;

rem
rem  PURPOSE
rem     MGMT_INV_CONTAINER
rem
rem     This table holds information indentifying all the containers, or homes,
rem     located on a host node.
rem
rem  COLUMNS
rem     CONTAINER_TYPE
rem                            The type of the container.  (ORACLE_HOME,
rem                           APPL_TOP, INDEPENDENT)
rem     CONTAINER_NAME
rem                            The name of the container ,e.g. the oracle home
rem                           name.
rem     SNAPSHOT_GUID
rem                            This is the unique id of the snapshot in which
rem                           this container resides.
rem     CONTAINER_GUID
rem                            A globally unique identifier for this container.
rem     CONTAINER_LOCATION
rem                            The location, or path of this container on the
rem                           host.
rem     OUI_PLATFORM          OUI platform code (fits into Java int)
rem     IS_CLONABLE          Is the Container clonable?. Y/N
CREATE TABLE MGMT_INV_CONTAINER
  (
    CONTAINER_TYPE VARCHAR2(64) NOT NULL,
    CONTAINER_NAME VARCHAR2(64) NOT NULL,
    SNAPSHOT_GUID RAW(16) NOT NULL,
    CONTAINER_GUID RAW(16) DEFAULT SYS_GUID() NOT NULL,
    CONTAINER_LOCATION VARCHAR2(128) NOT NULL,
    OUI_PLATFORM NUMBER(10) DEFAULT NULL,
    IS_CLONABLE VARCHAR2(1) DEFAULT 'N' NOT NULL,
    CONSTRAINT CON_UK UNIQUE (SNAPSHOT_GUID, CONTAINER_LOCATION) USING INDEX
      (CREATE UNIQUE INDEX CON_UK ON MGMT_INV_CONTAINER 
        (SNAPSHOT_GUID, CONTAINER_LOCATION) COMPRESS 1),
    CONSTRAINT CON_PK PRIMARY KEY (CONTAINER_GUID),
    CONSTRAINT CON_SNP_FK FOREIGN KEY(SNAPSHOT_GUID)
      REFERENCES MGMT_ECM_SNAPSHOT(SNAPSHOT_GUID)
      ON DELETE CASCADE
  )
  MONITORING;

rem
rem  PURPOSE
rem     MGMT_INV_CONTAINER_PROPERTY
rem
rem     Common container properties will be captured in the MGMT_INV_CONTAINER
rem     table as columns.  Some container properties are unique to a particular
rem     container type and will be captured in this table.
rem
rem  COLUMNS
rem     CONTAINER_GUID
rem                      The id of the container to which the property applies.
rem     PROPERTY_NAME
rem                      The name of the property.
rem     PROPERTY_VALUE
rem                      The value of the property.
rem
CREATE TABLE MGMT_INV_CONTAINER_PROPERTY
  (
    CONTAINER_GUID RAW(16) NOT NULL,
    PROPERTY_NAME VARCHAR2(64) NOT NULL,
    PROPERTY_VALUE VARCHAR2(1024) NOT NULL,
    CONSTRAINT CP_SN_FK FOREIGN KEY(CONTAINER_GUID)
      REFERENCES MGMT_INV_CONTAINER(CONTAINER_GUID)
      ON DELETE CASCADE,
    CONSTRAINT CP_PK PRIMARY KEY (CONTAINER_GUID, PROPERTY_NAME)
  )
  MONITORING;

rem
rem  PURPOSE
rem     MGMT_INV_COMPONENT
rem
rem     All component inventory elements will
rem     have an entry in this table.
rem
rem  COLUMNS
rem     NAME
rem                           The name of the inventory element.
rem     VERSION
rem                           The version of the inventory entry.
rem     CONTAINER_GUID
rem                           A FK pointing to the parent container.
rem     COMPONENT_GUID
rem                           A global unique id for this entry.
rem     DESCRIPTION
rem                           A description of the entry, as specified in the
rem                           installation.
rem     EXTERNAL_NAME
rem                           A external name of this component, as specified
rem                           in the installation.
rem     LANGUAGES
rem                           A list of language codes indicating the supported
rem                           languages.
rem     INSTALLED_LOCATION
rem                           Location, or path of this component.
rem     INSTALLER_VERSION
rem     MIN_DEINSTALLER_VERSION
rem     IS_TOP_LEVEL          Is this a top level component in its container
rem                           possible values: Y, N
rem     TIMESTAMP
rem                           When installed.
rem
CREATE TABLE MGMT_INV_COMPONENT
  (
    NAME VARCHAR2(128) NOT NULL,
    VERSION VARCHAR2(64) NOT NULL,
    CONTAINER_GUID RAW(16) NOT NULL,
    COMPONENT_GUID RAW(16) DEFAULT SYS_GUID() NOT NULL,
    DESCRIPTION VARCHAR2(1024),
    EXTERNAL_NAME VARCHAR2(128) NOT NULL,
    LANGUAGES VARCHAR2(1024),
    INSTALLED_LOCATION VARCHAR2(1024),
    INSTALLER_VERSION VARCHAR2(64),
    MIN_DEINSTALLER_VERSION VARCHAR2(64),
    IS_TOP_LEVEL VARCHAR2(1) NOT NULL,
    TIMESTAMP DATE,
    CONSTRAINT ENT_CP_FK FOREIGN KEY(CONTAINER_GUID)
      REFERENCES MGMT_INV_CONTAINER(CONTAINER_GUID)
      ON DELETE CASCADE,
    CONSTRAINT "ENT_UK" UNIQUE("COMPONENT_GUID")
      USING INDEX ( CREATE INDEX MGMT_INV_COMPONENT_IDX
                    ON MGMT_INV_COMPONENT (COMPONENT_GUID,
                                           CONTAINER_GUID,
                                           NAME,
                                           EXTERNAL_NAME,
                                           VERSION )),
    CONSTRAINT "ENT_PK" PRIMARY KEY(NAME, VERSION, CONTAINER_GUID)
      USING INDEX ( CREATE UNIQUE INDEX ENT_PK 
                    ON MGMT_INV_COMPONENT (NAME, VERSION, CONTAINER_GUID)
                    COMPRESS 2 )
  )
  MONITORING;

rem
rem  PURPOSE
rem     MGMT_INV_DEPENDENCY_RULE
rem
rem     This table represents all dependency information between inventory
rem     entries beyond the basic explicit relationships, such as patches
rem     included in a patch set and bugs
rem     fixed by a patch, identified in the inventory model.
rem
rem  COLUMNS
rem     DEPENDEE_GUID
rem                        The id of the depedee of this dependency
rem                       relationship.
rem     REFERENCER_GUID
rem                        The id of the referencer of this dependency
rem                       relationship.
rem     DEPENDENCY_TYPE
rem                        The type of the dependency.  (PRECEDES, REQUIRES...)
rem
CREATE TABLE MGMT_INV_DEPENDENCY_RULE
  (
    DEPENDEE_GUID RAW(16) NOT NULL,
    REFERENCER_GUID RAW(16) NOT NULL,
    DEPENDENCY_TYPE VARCHAR2(64),
    CONSTRAINT DEP_DEP_FK FOREIGN KEY(DEPENDEE_GUID)
      REFERENCES MGMT_INV_COMPONENT(COMPONENT_GUID)
      ON DELETE CASCADE,
    CONSTRAINT DEP_REF_FK FOREIGN KEY(REFERENCER_GUID)
      REFERENCES MGMT_INV_COMPONENT(COMPONENT_GUID)
      ON DELETE CASCADE,
    CONSTRAINT DEP_PK PRIMARY KEY(DEPENDEE_GUID, REFERENCER_GUID)
  )
  MONITORING;

rem
rem  PURPOSE
rem     MGMT_INV_PATCHSET
rem
rem     This table holds entries for all patchsets installed.
rem
rem  COLUMNS
rem     NAME
rem                           The name of the inventory element.
rem     VERSION
rem                           The version of the inventory entry.
rem     CONTAINER_GUID
rem                           A FK pointing to the parent container.
rem     PATCHSET_GUID
rem                           A global unique id for this entry.
rem     DESCRIPTION
rem                           A description of the entry, as specified in the
rem                           installation.
rem     EXTERNAL_NAME
rem                           A external name of this component, as specified
rem                           in the installation.
rem
rem     INSTALLER_VERSION
rem                           Version of the installer that installed this patchset.
rem
rem     MIN_DEINSTALLER_VERSION
rem                           Minimum version of the installer required to deinstall
rem                           this version.
rem     TIMESTAMP
rem                           When installed.
rem
CREATE TABLE MGMT_INV_PATCHSET
  (
    NAME VARCHAR2(128) NOT NULL,
    VERSION VARCHAR2(64) NOT NULL,
    CONTAINER_GUID RAW(16) NOT NULL,
    PATCHSET_GUID RAW(16) DEFAULT SYS_GUID() NOT NULL,
    DESCRIPTION VARCHAR2(1024),
    EXTERNAL_NAME VARCHAR2(128) NOT NULL,
    INSTALLER_VERSION VARCHAR2(64),
    MIN_DEINSTALLER_VERSION VARCHAR2(64),
    TIMESTAMP DATE,
    CONSTRAINT PS_CP_FK FOREIGN KEY(CONTAINER_GUID)
      REFERENCES MGMT_INV_CONTAINER(CONTAINER_GUID)
      ON DELETE CASCADE,
    CONSTRAINT "PS_UK" UNIQUE("PATCHSET_GUID"),
    CONSTRAINT "PS_PK" PRIMARY KEY(NAME, VERSION, CONTAINER_GUID)
  )
  MONITORING;

rem
rem  PURPOSE
rem     MGMT_INV_VERSIONED_PATCH
rem
rem     This table holds entries for OUI patches.
rem
rem  COLUMNS
rem     NAME
rem                           The name of the inventory element.
rem     VERSION
rem                           The version of the inventory entry.
rem     COMPONENT_GUID
rem                           A FK pointing to the parent component.
rem     PATCHSET_GUID
rem                           A FK pointing to the patchset containing this
rem                           patch. (It CAN be null.)
rem     DESCRIPTION
rem                           A description of the entry, as specified in the
rem                           installation.
rem     EXTERNAL_NAME
rem                           A external name of this component, as specified
rem                           in the installation.
rem     LANGUAGES
rem                           A list of language codes indicating the supported
rem                           languages.
rem     INSTALLED_LOCATION
rem                           The relative path within the container for this
rem                           entry.
rem     INSTALLER_VERSION
rem     MIN_DEINSTALLER_VERSION
rem     TIMESTAMP             When installed.
rem
CREATE TABLE MGMT_INV_VERSIONED_PATCH
  (
    NAME VARCHAR2(128) NOT NULL,
    VERSION VARCHAR2(64) NOT NULL,
    COMPONENT_GUID RAW(16) NOT NULL,
    PATCHSET_GUID RAW(16),
    DESCRIPTION VARCHAR2(1024),
    EXTERNAL_NAME VARCHAR2(128) NOT NULL,
    LANGUAGES VARCHAR2(1024),
    INSTALLED_LOCATION VARCHAR2(1024),
    INSTALLER_VERSION VARCHAR2(64),
    MIN_DEINSTALLER_VERSION VARCHAR2(64),
    TIMESTAMP DATE,
    CONSTRAINT VERSIONED_PATCH_CP_FK FOREIGN KEY(COMPONENT_GUID)
      REFERENCES MGMT_INV_COMPONENT(COMPONENT_GUID)
      ON DELETE CASCADE,
    CONSTRAINT VERSIONED_PATCH_PS_FK FOREIGN KEY(PATCHSET_GUID)
      REFERENCES MGMT_INV_PATCHSET(PATCHSET_GUID)
      ON DELETE CASCADE,
    CONSTRAINT "VERSIONED_PATCH_PK" PRIMARY KEY(COMPONENT_GUID)
  )
  MONITORING;

rem
rem  PURPOSE
rem     MGMT_INV_PATCH
rem
rem     This table holds entries for all non-versioned (one-off) patches installed.
rem
rem  COLUMNS
rem     ID
rem                           Id of the patch
rem     CONTAINER_GUID
rem                           A FK pointing to the parent container.
rem     PATCH_GUID
rem                           A global unique id for this entry.
rem     TIMESTAMP
rem                           When installed.
rem     DESCRIPTION
rem                           Patch description
rem     IS_ROLLBACKABLE
rem                           Can this patch be rolled back? (Y or N)
rem
CREATE TABLE MGMT_INV_PATCH
  (
    ID VARCHAR2(128) NOT NULL,
    CONTAINER_GUID RAW(16) NOT NULL,
    PATCH_GUID RAW(16) DEFAULT SYS_GUID() NOT NULL,
    TIMESTAMP DATE,
    DESCRIPTION VARCHAR2(1024),
    IS_ROLLBACKABLE VARCHAR2(1) NOT NULL,
    CONSTRAINT PATCH_CP_FK FOREIGN KEY(CONTAINER_GUID)
      REFERENCES MGMT_INV_CONTAINER(CONTAINER_GUID)
      ON DELETE CASCADE,
    CONSTRAINT "PATCH_UK" UNIQUE("PATCH_GUID"),
    CONSTRAINT "PATCH_PK" PRIMARY KEY(ID, CONTAINER_GUID)
  )
  MONITORING;

rem
rem  PURPOSE
rem     MGMT_INV_COMPONENT_PATCH
rem
rem     This table represents the many to many relationship between non-versioned
rem     (one-off) patches and components.  A patch may patch many different components.
rem     A component may be patched by multiple patches.
rem
rem  COLUMNS
rem     COMPONENT_GUID
rem                     This is the unique id (pointing to the
rem                     MGMT_INV_COMPONENT
rem                     table) of the patchset that contains the patch
rem                     identified in PATCH_GUID
rem     PATCH_GUID
rem                     This is the unique id of a patch that is applied to
rem                     the component.
rem
CREATE TABLE MGMT_INV_COMPONENT_PATCH
  (
    COMPONENT_GUID RAW(16) NOT NULL,
    PATCH_GUID RAW(16) NOT NULL,
    CONSTRAINT CMPT_PK_1 PRIMARY KEY(COMPONENT_GUID, PATCH_GUID),
    CONSTRAINT CMPT_PT_FK FOREIGN KEY(PATCH_GUID)
      REFERENCES MGMT_INV_PATCH(PATCH_GUID)
      ON DELETE CASCADE,
    CONSTRAINT CMPT_COM_FK FOREIGN KEY(COMPONENT_GUID)
      REFERENCES MGMT_INV_COMPONENT(COMPONENT_GUID)
      ON DELETE CASCADE
  )
  MONITORING;

rem
rem  PURPOSE
rem     MGMT_INV_PATCH_FIXED_BUG
rem
rem     This table records the list of bugs fixed by the patch represented by
rem     PATCH_GUID.
rem
rem  COLUMNS
rem     PATCH_GUID
rem                  The patch that fixes the bug identified by BUG_NUMBER.
rem     BUG_NUMBER
rem                  The number of a bug fixed by the patch identified by
rem                  PATCH_GUID.
rem
CREATE TABLE MGMT_INV_PATCH_FIXED_BUG
  (
    PATCH_GUID RAW(16) NOT NULL,
    BUG_NUMBER VARCHAR2(10) NOT NULL,
    COMPONENT_GUID RAW(16) DEFAULT NULL,
    CONSTRAINT PFB_P_FK FOREIGN KEY(PATCH_GUID)
      REFERENCES MGMT_INV_PATCH(PATCH_GUID)
      ON DELETE CASCADE,
    CONSTRAINT PFB_C_FK FOREIGN KEY(COMPONENT_GUID)
      REFERENCES MGMT_INV_COMPONENT(COMPONENT_GUID)
      ON DELETE CASCADE,
    CONSTRAINT PFB_PK PRIMARY KEY(PATCH_GUID, BUG_NUMBER)
  )
  MONITORING;

rem
rem  PURPOSE
rem     MGMT_INV_FILE
rem
rem     Each file replaced/updated by a patch is recorded in this table.
rem     If the file is a container, such as a library file, the files within
rem     the container file are also represented by entries in this table.
rem
rem  COLUMNS
rem     FILE_NAME
rem                        Full name of a patched file.
rem     CONTAINER_GUID
rem                        Guid of the container for the file.
rem     PARENT_FILE_NAME
rem                        If this file is contained in another file, such as
rem                        a libary file, this is the file name of the parent
rem                        file.
rem     LAST_PATCH_GUID
rem                        Patch that modified this file last. Could be null if
rem                        it was impossible to establish the last patch
rem                        applied to the file.
CREATE TABLE MGMT_INV_FILE
  (
    FILE_NAME VARCHAR2(1024) NOT NULL,
    CONTAINER_GUID RAW(16) NOT NULL,
    PARENT_FILE_NAME VARCHAR2(1024),
    LAST_PATCH_GUID RAW(16),
    CONSTRAINT FILE_CONTAINER_FK FOREIGN KEY(CONTAINER_GUID)
      REFERENCES MGMT_INV_CONTAINER(CONTAINER_GUID)
      ON DELETE CASCADE,
    CONSTRAINT FILE_LAST_PATCH_FK FOREIGN KEY(LAST_PATCH_GUID)
      REFERENCES MGMT_INV_PATCH(PATCH_GUID),
    CONSTRAINT FILE_PK PRIMARY KEY(CONTAINER_GUID, FILE_NAME)
  )
  MONITORING;


rem
rem  PURPOSE
rem     MGMT_INV_PATCHED_FILE
rem
rem     Each application of a (one-off) patch to a file is recorded in this
rem     table.
rem
rem  COLUMNS
rem     FILE_NAME
rem                        Full name of the file modified by the patch
rem                        identified by PATCH_GUID. In combination with the
rem                        PATCH_GUID, this filename would be a foreign key into
rem                        the file table.
rem     PATCH_GUID
rem                        Patch that modified the file above.
rem     VERSION
rem                        version of the file after patch application.
rem     CHECKSUM
rem                        Checksum of the file after patch application.
rem                        For now, we represent checksums as strings since it
rem                        makes it easier to process on the Java side:
rem                        (a) changing size of the string is easier then
rem                        switching everything to int, long or something else
rem                        and we do not know the max size for checksums, and
rem                        (b) NULL checksum is easy to represent as NULL string
rem                        but requires an extra variable if we use a numeric
rem                        Java type.
CREATE TABLE MGMT_INV_PATCHED_FILE
  (
    FILE_NAME VARCHAR2(1024) NOT NULL,
    PATCH_GUID RAW(16) NOT NULL,
    VERSION VARCHAR2(64),
    CHECKSUM VARCHAR2(32),
    CONSTRAINT PF_FK FOREIGN KEY(PATCH_GUID)
      REFERENCES MGMT_INV_PATCH(PATCH_GUID)
      ON DELETE CASCADE,
    CONSTRAINT PF_PK PRIMARY KEY(PATCH_GUID, FILE_NAME)
  )
  MONITORING;


rem
rem  PURPOSE
rem     MGMT_INV_PATCHED_FILE_COMP
rem
rem     This table represents the many to many relationship between files
rem     fixed by non-versioned (one-off) patches and components.
rem
rem  COLUMNS
rem     COMPONENT_GUID
rem                     This is the unique id (pointing to the MGMT_INV_COMPONENT
rem                     table) of a component containing the file
rem     FILE_NAME
rem                     This is full filename of the file that is part of
rem                     the component. In combination with component's guid,
rem                     this filename would be a foreign key into the
rem                     file table.
rem
CREATE TABLE MGMT_INV_PATCHED_FILE_COMP
  (
    COMPONENT_GUID RAW(16) NOT NULL,
    FILE_NAME VARCHAR2(1024) NOT NULL,
    CONSTRAINT CMPTF_PK PRIMARY KEY(COMPONENT_GUID, FILE_NAME),
    CONSTRAINT CMPTF_COM_FK FOREIGN KEY(COMPONENT_GUID)
      REFERENCES MGMT_INV_COMPONENT(COMPONENT_GUID)
      ON DELETE CASCADE
  )
  MONITORING;

rem
rem  PURPOSE
rem     MGMT_TARGET_TYPE_COMPONENT_MAP
rem
rem     Mapping between EM target types and inventory component names.
rem
rem  COLUMNS
rem
rem     TARGET_TYPE
rem                           Target type for EMD targets
rem     COMPONENT_NAME
rem                           Name of inventory components
rem
CREATE TABLE MGMT_TARGET_TYPE_COMPONENT_MAP
  (
    TARGET_TYPE VARCHAR2(64) NOT NULL,
    PROPERTY_NAME VARCHAR2(64) DEFAULT NULL,
    PROPERTY_VALUE VARCHAR2(1024) DEFAULT NULL,
    COMPONENT_NAME VARCHAR2(128) NOT NULL,
    PRIMARY KEY (TARGET_TYPE, COMPONENT_NAME)
  )
  MONITORING;

rem
rem  PURPOSE
rem     MGMT_ECM_HOST_CONFIGS_TO_DEL
rem
rem     This table contains snapshots from MGMT_ECM_SNAPSHOT table,
rem     which will potentially be deleted by the purge mechanism.
rem     The purge method will insert rows into this table when finding
rem     snapshots that might need deletion and then check whether
rem     there are any sufficiently old snapshots that still exist,
rem     and thus need to be removed.
rem
rem  COLUMNS
rem
rem     SNAPSHOT_GUID
rem                    Id for the snapshot  
rem     TS
rem                    Timestamp of when the snapshot became suspect 
rem
CREATE TABLE MGMT_ECM_HOST_CONFIGS_TO_DEL
  (
    SNAPSHOT_GUID RAW(16) NOT NULL,
    TS DATE DEFAULT SYSDATE NOT NULL,
    PRIMARY KEY (SNAPSHOT_GUID)
  )
  MONITORING;

rem*******************************************************************
rem   ARU Tables.
rem     These tables are used to store the aru metadata about product families,
rem     products, releases, languages, and platforms, as well as the
rem     relationships between products and product familes, and,
rem     products and releases.  The product and platform tables both contain
rem     the mapping between ARU products/platforms and EM targets and OS's.


rem
rem  PURPOSE
rem
rem     The MGMT_ARU_PRODUCTS
rem
rem  COLUMNS
rem
rem     ARU_PRODUCT_ID    - The ARU product id (PRODUCT_ID) from the
rem                         ARU.ARU_PRODUCTS table.
rem
rem     ARU_PRODUCT_NAME  - The display string from (PRODUCT_NAME) from the
rem                         ARU.ARU_PRODUCTS table.
rem
rem     EM_TARGET_TYPE    - The EM target_type to which to map this product.
rem
rem  NOTES
rem
CREATE TABLE MGMT_ARU_PRODUCTS
(
  PRODUCT_ID NUMBER(10) NOT NULL,
  PRODUCT_NAME VARCHAR2(50) NOT NULL,
  EM_TARGET_TYPE VARCHAR2(64) DEFAULT 'Unknown' NOT NULL,
  CONSTRAINT MGMT_ARU_PRD_PK PRIMARY KEY(PRODUCT_ID)
) MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_OUI_ARU_MAP
rem
rem  COLUMNS
rem
rem     ARU_ID   - The ARU platform id  
rem
rem     OUI_ID   - The OUI platform id  
rem
rem  NOTES
rem
CREATE TABLE MGMT_OUI_ARU_MAP
(
    ARU_ID NUMBER(10) NOT NULL,
    OUI_ID NUMBER(10) NOT NULL
) MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_ARU_PLATFORMS
rem
rem  COLUMNS
rem
rem     ARU_PLATFORM_ID   - The ARU platform id (PLATFORM_ID) from the
rem                         ARU.ARU_PLATFORMS table.
rem
rem     ARU_PLATFORM_NAME - The display string from (PLATFORM_NAME) from the
rem                         ARU.ARU_PLATFORMS table.
rem
rem     EM_OS_NAME        - The EM OS name to which to map this platform.
rem
rem     EM_OS_BITLENGTH   - The EM OS bit-length for this platform.
rem
rem  NOTES
rem
CREATE TABLE MGMT_ARU_PLATFORMS
(
  PLATFORM_ID NUMBER(10) NOT NULL,
  PLATFORM_NAME VARCHAR2(40) NOT NULL,
  EM_OS_NAME VARCHAR2(64) DEFAULT 'Unknown' NOT NULL,
  EM_OS_BITLENGTH VARCHAR2(8) DEFAULT 'Unknown' NOT NULL,
  CONSTRAINT MGMT_ARU_PLT_PK_1 PRIMARY KEY(PLATFORM_ID)
) MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_ARU_RELEASES
rem
rem  COLUMNS
rem
rem     ARU_RELEASE_ID    - The ARU release id (RELEASE_ID) from the
rem                         ARU.ARU_RELEASES table.
rem
rem     ARU_RELEASE_NAME  - The display string from (RELEASE_NAME) from the
rem                         ARU.ARU_RELEASES table.
rem
rem  NOTES
rem
CREATE TABLE MGMT_ARU_RELEASES
(
  RELEASE_ID NUMBER(10) NOT NULL,
  RELEASE_NAME VARCHAR2(30) NOT NULL,
  CONSTRAINT MGMT_ARU_RLS_PK PRIMARY KEY(RELEASE_ID)
) MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_ARU_LANGUAGES
rem
rem  COLUMNS
rem
rem     ARU_LANGUAGE_ID   - The ARU product id (LANGUAGE_ID) from the
rem                         ARU.ARU_LANGUAGES table.
rem
rem     ARU_NLS_LANGUAGE  - The display string from (NLS_LANGUAGE) from the
rem                         ARU.ARU_LANGUAGES table.
rem
rem  NOTES
rem
CREATE TABLE MGMT_ARU_LANGUAGES
(
  LANGUAGE_ID NUMBER(10) NOT NULL,
  NLS_LANGUAGE VARCHAR2(30) NOT NULL,
  CONSTRAINT MGMT_ARU_LGE_PK PRIMARY KEY(LANGUAGE_ID)
) MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_ARU_FAMILY_PRODUCT_MAP
rem
rem  COLUMNS
rem
rem     ARU_PRODUCT_ID  - The ARU product id MGMT_ARU_PRODUCTS table.
rem
rem     ARU_FAMILY_ID   - The ARU family id MGMT_ARU_PRODUCT_FAMILYS table.
rem
rem  NOTES
rem
CREATE TABLE MGMT_ARU_FAMILY_PRODUCT_MAP
(
  FAMILY_ID NUMBER(10) NOT NULL,
  PRODUCT_ID NUMBER(10) NOT NULL,
  CONSTRAINT MGMT_ARU_FAM_PRD_FAM_FK FOREIGN KEY(FAMILY_ID)
      REFERENCES MGMT_ARU_PRODUCTS(PRODUCT_ID)
      ON DELETE CASCADE,
  CONSTRAINT MGMT_ARU_FAM_PRD_PK PRIMARY KEY(FAMILY_ID, PRODUCT_ID),
  CONSTRAINT MGMT_ARU_FAM_PRD_PRD_FK FOREIGN KEY(PRODUCT_ID)
      REFERENCES MGMT_ARU_PRODUCTS(PRODUCT_ID)
      ON DELETE CASCADE
) MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_ARU_PRODUCT_RELEASE_MAP
rem
rem  COLUMNS
rem
rem     ARU_PRODUCT_ID  - The ARU product id  from the MGMT_ARU_PRODUCTS table.
rem
rem     ARU_RELEASE_ID  - The ARU release id from the MGMT_ARU_RELEASES table.
rem
rem  NOTES
rem
CREATE TABLE MGMT_ARU_PRODUCT_RELEASE_MAP
(
  PRODUCT_ID NUMBER(10) NOT NULL,
  RELEASE_ID NUMBER(10) NOT NULL,
  CONSTRAINT MGMT_ARU_PRD_RLS_PRD_FK FOREIGN KEY( PRODUCT_ID )
    REFERENCES MGMT_ARU_PRODUCTS(PRODUCT_ID)
    ON DELETE CASCADE,
  CONSTRAINT MGMT_ARU_PRD_RLS_PK PRIMARY KEY(PRODUCT_ID, RELEASE_ID)
    USING INDEX ( CREATE UNIQUE INDEX MGMT_ARU_PRD_RLS_PK
    ON MGMT_ARU_PRODUCT_RELEASE_MAP (PRODUCT_ID, RELEASE_ID)
    COMPRESS 1 ),
  CONSTRAINT MGMT_ARU_PRD_RLS_RLS_FK FOREIGN KEY(RELEASE_ID)
    REFERENCES MGMT_ARU_RELEASES(RELEASE_ID)
    ON DELETE CASCADE
) MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_ARU_OUI_COMPONENTS table contains the mappings of ARU OUI numbers 
rem   to OUI names used byt the installer.  These represent component that are
rem   installed in oracle homes.
rem
rem  COLUMNS
rem
rem     COMPONENT_ID  - The ARU product id for OUI PRODUCTS from the 
rem   aru_customer_products table.
rem
rem     COMPONENT_NAME  - The string that is used by OUI.
rem
rem     COMPONENT_RELEASE  - The release string that is used by OUI. e.g. 9.2.0.2.0
rem
rem  NOTES
rem
CREATE TABLE MGMT_ARU_OUI_COMPONENTS
(
  COMPONENT_ID NUMBER NOT NULL,
  COMPONENT_NAME VARCHAR2(256),
  COMPONENT_RELEASE VARCHAR2(30),
  CONSTRAINT MGMT_ARU_OP_PK PRIMARY KEY(COMPONENT_ID)
) MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_BUG_ADVISORY table contains the list of bug advisories.  This
rem   is populated by a query to ARU LINK.  It is periodically refreshed with 
rem   new bug advisory info.
rem
rem  COLUMNS
rem
rem     ADVISORY_NAME - Used to identify and display the Advisory.
rem 
rem     IMPACT - an indicator of the type of advisory.  There include security
rem       and others to be added in the future.
rem     SEVERITY - An indicator of the bug's severity.
rem 
rem     URL - Used to link to a page with more information about the advisory.
rem
rem     ABSTRACT - A longer description of the advisory for display to the user
rem  NOTES
rem
CREATE TABLE MGMT_BUG_ADVISORY
(
  ADVISORY_NAME VARCHAR2(&DISPLAY_NAME_LENGTH),
  IMPACT VARCHAR2(&DISPLAY_NAME_LENGTH),
  SEVERITY NUMBER,
  URL VARCHAR2(256),
  ABSTRACT VARCHAR2(&ABSTRACT_LENGTH),
  RELEASE_DATE DATE,
  CONSTRAINT MBA_PK PRIMARY KEY( ADVISORY_NAME )
) MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_BUG_ADVISORY_BUG table contains the list of bugs mapped to an
rem   advisory that it corresponds to. This
rem   is populated by a query to ARU LINK.  It is periodically refreshed with 
rem   new bug advisory info.
rem
rem  COLUMNS
rem
rem     BUG_NUMBER  - The bug number for the advisory bug.
rem
rem     ADVISORY_NAME - Maps to the MGMT_BUG_ADVISORY table.
rem  NOTES
rem
CREATE TABLE MGMT_BUG_ADVISORY_BUG
(
  BUG_NUMBER NUMBER NOT NULL,
  ADVISORY_NAME VARCHAR2(&DISPLAY_NAME_LENGTH),
  CONSTRAINT MBAB_PK PRIMARY KEY( BUG_NUMBER ),
  CONSTRAINT MBAB_MBA_FK FOREIGN KEY (ADVISORY_NAME)
    REFERENCES MGMT_BUG_ADVISORY (ADVISORY_NAME )
    ON DELETE CASCADE
) MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_BUG_AVAILABLE_PATCH contains entries for patches that fix
rem     bugs that have advisories.
rem
rem  COLUMNS
rem
rem     PATCH_GUID  - A unique key for this patch.
rem
rem     PATCH_ID  - The ARU bug_id of the patch.
rem
rem     PRODUCT_ID    - The ARU Product id of the patch.
rem
rem     RELEASE_ID    - The ARU release id of the patch.
rem 
rem     LANGUAGE_ID   - The ARU language id of the patch.
rem 
rem     PATCH_TYPE    - ARU indicates either patch or patchset.
rem
CREATE TABLE MGMT_BUG_AVAILABLE_PATCH
(
  AP_GUID RAW(16) NOT NULL,
  PATCH_ID NUMBER,
  PRODUCT_ID NUMBER,
  RELEASE_ID NUMBER,
  LANGUAGE_ID NUMBER DEFAULT 0,
  PATCH_TYPE VARCHAR2(32),
  CONSTRAINT MBAP_PK PRIMARY KEY( AP_GUID ),
  CONSTRAINT MBAP_UK UNIQUE( PATCH_ID, PRODUCT_ID, RELEASE_ID, LANGUAGE_ID)
) MONITORING;

rem  PURPOSE
rem
rem     The MGMT_BUG_PATCH_PLATFORM contains entries for platforms for each patch.
rem
rem  COLUMNS
rem
rem     PATCH_GUID - A primary key used to identify the patch-platform pair.
rem                 This is more for convenience than anything else.
rem     AP_GUID  - A key of the available patch.
rem
rem     PLATFORM_ID   - The ARU platform of the patch.
rem   
CREATE TABLE MGMT_BUG_PATCH_PLATFORM
(
  PATCH_GUID RAW(16) DEFAULT SYS_GUID() NOT NULL,
  AP_GUID RAW(16) NOT NULL,
  PLATFORM_ID NUMBER NOT NULL,
  CONSTRAINT MBPP_PK PRIMARY KEY (PATCH_GUID),
  CONSTRAINT MBPP_UK UNIQUE (AP_GUID, PLATFORM_ID),
  CONSTRAINT MBPP_MBAP_FK FOREIGN KEY (AP_GUID)
    REFERENCES MGMT_BUG_AVAILABLE_PATCH ( AP_GUID )
    ON DELETE CASCADE
) MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_BUG_PATCH_FIXES_BUG this table maps the bugs advisories to
rem     patches that fix the advisory bug.
rem
rem  COLUMNS
rem
rem     BUG_NUMBER - the number of the bug.  references the bug advisory table.
rem
rem     AP_GUID - a guid that references the available patches that fix
rem       advisory bugs.
rem
rem  NOTES
rem
CREATE TABLE MGMT_BUG_PATCH_FIXES_BUG
(
  AP_GUID RAW(16) NOT NULL,
  BUG_NUMBER NUMBER NOT NULL,
  CONSTRAINT MBPFB_PK PRIMARY KEY( AP_GUID, BUG_NUMBER ),
  CONSTRAINT MBPFB_MBAP_FK FOREIGN KEY (AP_GUID) 
      REFERENCES MGMT_BUG_AVAILABLE_PATCH( AP_GUID )
      ON DELETE CASCADE,
  CONSTRAINT MBPFB_MBA_FK FOREIGN KEY( BUG_NUMBER )
      REFERENCES MGMT_BUG_ADVISORY_BUG( BUG_NUMBER )
      ON DELETE CASCADE
) MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_BUG_FIX_APPLICABLE_COMP_LIST table rows each represent a list of
rem     components.  If any one of the lists for a particular patch matches the
rem     installation, then the patch is applicable to fix that bug.
rem
rem  COLUMNS
rem
rem     AP_GUID - a guid that references the available patches that fix
rem       advisory bugs.
rem     BUG_NUMBER - the number of the bug.  references the bug advisory table.
rem
rem     COMPONENT_LIST_GUID - This uniquely identifies a list of components
rem    
rem
rem  NOTES
rem
CREATE TABLE MGMT_BUG_FIX_APPLIC_COMP_LIST
(
  AP_GUID RAW(16) NOT NULL,
  BUG_NUMBER NUMBER NOT NULL,
  COMPONENT_LIST_GUID RAW(16) NOT NULL,
  CONSTRAINT MBFACL_PK PRIMARY KEY( COMPONENT_LIST_GUID ),
  CONSTRAINT MBFACL_MBPFB_FK FOREIGN KEY (AP_GUID, BUG_NUMBER) 
      REFERENCES MGMT_BUG_PATCH_FIXES_BUG( AP_GUID, BUG_NUMBER )
      ON DELETE CASCADE
) MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_BUG_FIX_APPLICABLE_COMP table's rows represents a component
rem     that is a member of a component list.  When all members of any of a patch's
rem     bug fix component lists is present in an installation, that that patch is applicable.
rem
rem  COLUMNS
rem
rem     COMPONENT_LIST_GUID - Points to the component list of which this row
rem       is a member..
rem     OUI_COMPONENT_ID - the id of a component that the bug fix fixes.  Use the
rem       mapping table to get the actual component name.
rem     OUI_VERSION_ID - The id of the component version that the bug fix fixes.
rem       Use the mapping table to get the actual version string.
rem
rem  NOTES
rem
CREATE TABLE MGMT_BUG_FIX_APPLICABLE_COMP
(
  OUI_COMPONENT_RELEASE_ID NUMBER NOT NULL,
  COMPONENT_LIST_GUID RAW(16) NOT NULL,
  CONSTRAINT MBFAC_PK PRIMARY KEY (COMPONENT_LIST_GUID, OUI_COMPONENT_RELEASE_ID),
  CONSTRAINT MBFAC_MBFACL_FK FOREIGN KEY( COMPONENT_LIST_GUID )
      REFERENCES MGMT_BUG_FIX_APPLIC_COMP_LIST( COMPONENT_LIST_GUID )
      ON DELETE CASCADE
) MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_BUG_ADV_HOME_PATCH stores the actual analysis of critical patch 
rem   advisories.  It contains advisories for each home and the appropriate 
rem   patches for the fix for that home.
rem
rem  COLUMNS
rem
rem     ADVISORY_NAME - Actually the advisory id.  Maps to
rem       the MGMT_BUG_ADVISORIES table.
rem     HOST_NAME - The host of the home that the advisory patch is good for.
rem     HOME_LOCATION - the location on the host of the home that the patch is
rem         applicable.
rem     PATCH_GUID - The guid of the patch that fixes the advisory.  It indexes
rem         into the MGMT_BUG_PATCH_PLAFORM table.
rem     PREREQ_RELEASE - The release id of the prerequisite patchset for this patch.
rem         Null if the home is already up to the appropriate patchset.  Note that 
rem         this release text is in terms of the ARU release string of the patch.
rem         It will always be the same as the release of the patch, but is 
rem         included here as a convenience.
rem     HOME_LOCATION_DISPLAY- The locations with the home name in parens.  Included
rem         for convenience so a join with the underly home container record isn't
rem         necessary.
rem     TARGET_GUID - The target guid of the host that contains the home.  Used
rem         to identify the host (target) that the policy violation is on and is
rem         used when evaluating a single host.  (Used to delete the rows for that
rem         host before reevaluating.  Also, used when we populate this table.  If
rem         the home already has a patch installed, we initially place a null in 
rem         the target guid column.  This enables us to see which other
rem         advisory_name-host_name-home_location rows can be removed since a
rem         patch was already installed that handles that advisory.
rem
rem  NOTES
rem
CREATE TABLE MGMT_BUG_ADV_HOME_PATCH
(
  ADVISORY_NAME VARCHAR2(&DISPLAY_NAME_LENGTH) NOT NULL,
  BUG_NUMBER NUMBER NOT NULL,
  HOST_NAME VARCHAR2(&TARGET_NAME_LENGTH) NOT NULL,
  HOME_LOCATION VARCHAR2( 128 ) NOT NULL,
  PATCH_GUID RAW(16) NOT NULL,
  PREREQ_RELEASE VARCHAR2(256),
  HOME_LOCATION_DISPLAY VARCHAR2(256),
  TARGET_GUID RAW(16),
  PATCH_ID NUMBER NOT NULL,
  PATCH_RELEASE_ID NUMBER NOT NULL,
  PATCH_PLATFORM_ID NUMBER NOT NULL,
  CONTAINER_GUID RAW(16) NOT NULL,
  PATCH_VALID_STATUS VARCHAR2(10) NOT NULL,
  CONSTRAINT MBAHP_PK PRIMARY KEY ( ADVISORY_NAME, HOST_NAME, HOME_LOCATION, BUG_NUMBER, PATCH_GUID )
) MONITORING;




rem
rem CT schema (end)
rem


rem Code for object delta records.
rem ****************************************************************
rem First the objects and tables.  then the package.
rem

rem
rem  PURPOSE
rem     This table stores each unique row key.  Each delta entry has a
rem     FK pointing to its row key.
rem
rem  COLUMNS
rem
rem   COLLECTION_TYPE
rem       - Defined by the application, this describes the scope
rem         of the uniqueness of the row key that each row in this
rem         table represents.  Typically, it would be that table
rem         name of source table.  For table whose data are attributes
rem         to other object, as in a table holding type-name-value
rem         records, the collection_type would be the type value.
rem   ROW_GUID
rem       - A unique id identifying this row (key).
rem   LAST_DELTA_ENTRY_GUID
rem       - Points to the latest (last) delta entry recorded for this key.
rem   LAST_UPDATED_TIME
rem       - Timestamp when the row was inserted or updated.
rem   KEY_STRING
rem       - A materialized text representation of the key.  It is a concatenation
rem         of the fields in the associate nested table rows that are the key.
rem         A function in the package MGMT_DELTA called GET_KEY_DISPLAY_STRING
rem         is used to generate this.  It is used to quickly index to the key
rem         entry given the key information from a source row.
rem   KEY_STRING_REST
rem       - The key string may be longer than the 1024 in the key_string column.
rem         The overflow is placed in this column.
rem
rem  NOTES
rem
CREATE TABLE MGMT_DELTA_IDS
(
  COLLECTION_TYPE VARCHAR2(64) NOT NULL,
  ROW_GUID RAW(16) DEFAULT SYS_GUID() NOT NULL,
  LAST_DELTA_ENTRY_GUID RAW(16),
  LAST_UPDATED_TIME DATE DEFAULT SYSDATE NOT NULL,
  KEY_STRING VARCHAR2(1024) NOT NULL,
  KEY_STRING_REST VARCHAR2(4000),
  CONSTRAINT DI_PK UNIQUE(ROW_GUID)
) MONITORING;


rem
rem  PURPOSE
rem     This table stores deltas, or change records.
rem
rem  COLUMNS
rem
rem   SNAP_GUID
rem       - The id of the timeslice snapshot assigned to this delta.
rem         This is an optional field.  Collections not using snapshoting can
rem         do without and just use the DELTA_TIME column.  The snap_guid
rem         ties together all the deltas common to a particular refresh timeslice.
rem   ROW_GUID
rem       - The id of the key entry corresponding to this row.  It is a FK pointing
rem         to the key entry in the MGMT_DELTA_IDS table.  Delta entries whose
rem         ROW_GUID match represent the various changes made to the same source
rem         record.
rem   OPERATION
rem       - 'INSERT', 'UPDATE', or 'DELETE'
rem   ATTRIBUTES_VALUES
rem       - a nested table holding the name-value-old_value triplets of the
rem         columns (attributes) of the source row that have changed.  Insert
rem         operations contain the inserted value of all attributes (this may not be
rem         necessary) in the value columns of the triplets.  Delete operations
rem         contain the delete values of all attributes.  Update operations
rem         contain only the attributes that have changed, both the old and new
rem         values. (The new values may not be necessary).
rem   DELTA_TIME
rem       - This hold the time that the delta entry was created, and not necessarily
rem         the time that the actual source was updated.
rem   DELTA_ENTRY_GUID
rem       - This is a unique identifier for the delta entry.
rem   PREV_DELTA_ENTRY_GUID
rem       - This is the id of the delta entry that was entered prior to this one.
rem  NOTES
rem
CREATE TABLE MGMT_DELTA_ENTRY
(
  DELTA_GUID RAW(16) NOT NULL,
  ROW_GUID RAW(16) NOT NULL,
  OPERATION VARCHAR2(10) NOT NULL,
  DELTA_TIME DATE DEFAULT SYSDATE NOT NULL,
  DELTA_ENTRY_GUID RAW(16) NOT NULL,
  PREV_DELTA_ENTRY_GUID RAW(16),
--  CONSTRAINT DE_PK PRIMARY KEY(SNAP_GUID, ROW_GUID, DELTA_TIME),
  CONSTRAINT DE_TABLE_ROW FOREIGN KEY(ROW_GUID)
    REFERENCES MGMT_DELTA_IDS(ROW_GUID)
    ON DELETE CASCADE,
  CONSTRAINT DE_PK UNIQUE(DELTA_ENTRY_GUID)
) MONITORING;


CREATE TABLE MGMT_DELTA_ENTRY_VALUES
(
  NAME VARCHAR2(64) NOT NULL,
  VALUE VARCHAR2(&MAX_VARCHAR2_LENGTH),
  OLD_VALUE VARCHAR2(&MAX_VARCHAR2_LENGTH),
  DELTA_ENTRY_GUID RAW(16) NOT NULL,
  TYPE CHAR(1) DEFAULT 'S',
  CONSTRAINT MDV_PK PRIMARY KEY(DELTA_ENTRY_GUID, NAME),
  CONSTRAINT MDV_MDE_FK FOREIGN KEY(DELTA_ENTRY_GUID)
    REFERENCES MGMT_DELTA_ENTRY(DELTA_ENTRY_GUID)
    ON DELETE CASCADE
) MONITORING;


CREATE TABLE MGMT_DELTA_ID_VALUES
(
  NAME VARCHAR2(64) NOT NULL,
  VALUE VARCHAR2(&MAX_VARCHAR2_LENGTH),
  DELTA_IDS_GUID RAW(16) NOT NULL,
  TYPE CHAR(1) DEFAULT 'S',
  CONSTRAINT MDIV_PK PRIMARY KEY(DELTA_IDS_GUID, NAME)
    USING INDEX ( CREATE UNIQUE INDEX MDIV_PK
    ON MGMT_DELTA_ID_VALUES (DELTA_IDS_GUID, NAME)
    COMPRESS 1 ),
  CONSTRAINT MDIV_MDE_FK FOREIGN KEY(DELTA_IDS_GUID)
    REFERENCES MGMT_DELTA_IDS(ROW_GUID)
    ON DELETE CASCADE
) MONITORING;

rem
rem  PURPOSE
rem     This table records snapshot time slices.  It is used to associate
rem     all the deltas that occur in a single refresh or comparison.
rem
rem  COLUMNS
rem
rem   DELTA_GUID
rem       - The unique id of the delta.
rem   TRANSACTION_ID
rem       - This transaction id is used to keep track of which delta id
rem         to associate with a delta as it is being created.  The could be
rem         multiple refreshes/snapshot being captured at any point in time.
rem   DELTA_TIMESTAMP
rem       - This holds the time that the delta was started, and not necessarily
rem         the time that the actual source was updated.
rem   DELTA_TYPE
rem       - By default 'HISTORY'.  'COMPARISON' is other alternative.
rem   TARGET_TYPE
rem   SNAPSHOT_TYPE
rem   NEW_LEFT_SNAPSHOT_GUID
rem       - The guid of the left, in compare, or new in history, snapshot.
rem   NEW_LEFT_TIMESTAMP
rem       - The timestamp of the left, in compare, or new in history, snapshot.
rem   NEW_LEFT_TARGET_NAME
rem   OLD_RIGHT_SNAPSHOT_GUID
rem       - The guid of the right, in compare, or old in history, snapshot.
rem   OLD_RIGHT_TIMESTAMP
rem       - The timestamp of the right, in compare, or old in history, snapshot.
rem   OLD_RIGHT_TARGET_NAME
rem  NOTES
rem
CREATE TABLE MGMT_DELTA_SNAP
(
  DELTA_GUID RAW(16) NOT NULL,
  TRANSACTION_ID VARCHAR(1024) NOT NULL,
  DELTA_TIMESTAMP DATE DEFAULT SYSDATE NOT NULL,
  DELTA_TYPE VARCHAR2(30) DEFAULT 'HISTORY',
  TARGET_TYPE VARCHAR2(&TARGET_TYPE_LENGTH),
  SNAPSHOT_TYPE VARCHAR(&SNAPSHOT_TYPE_LENGTH),
  NEW_LEFT_SNAPSHOT_GUID RAW(&GUID_RAW_LENGTH),
  NEW_LEFT_TARGET_NAME VARCHAR2(&TARGET_NAME_LENGTH),
  NEW_LEFT_TIMESTAMP DATE,
  OLD_RIGHT_SNAPSHOT_GUID RAW(&GUID_RAW_LENGTH),
  OLD_RIGHT_TIMESTAMP DATE,
  OLD_RIGHT_TARGET_NAME VARCHAR2(&TARGET_NAME_LENGTH),
  CONSTRAINT DS_PK PRIMARY KEY(DELTA_GUID)
) MONITORING;


rem
rem PURPOSE
rem
rem     The mgmt_hc_system_summary table holds the system summary
rem     of a host configuration.
rem
rem COLUMNS
rem
rem
rem   snapshot_guid       - ID of the snapshot where this host config.
rem                         information is stored.
rem
rem   host_name           - The name of the host upon the information
rem                         about which is being stored in this snapshot.
rem
rem   domain              - The domain of the host.
rem
rem   cc_name             - If this host is a certified configuraion
rem                         then the name of the CC - otherwise blank.
rem
rem   cc_partner_info     - If this host is a certified configuraion
rem                         then the Info about the partners involved.
rem
rem   cc_software_version - If this host is a certified configuraion
rem                         then the version of the software image.
rem
rem   cc_build_date       - If this host is a certified configuraion
rem                         then the build date of the software image.
rem  NOTES
rem


create table mgmt_hc_system_summary
(
  snapshot_guid raw(16) NOT NULL PRIMARY KEY ,
  hostname varchar2(&NAME_LENGTH) NOT NULL,
  domain varchar2(&DOMAIN_NAME_LENGTH),
  cc_name varchar2(&NAME_LENGTH),
  cc_partner_info varchar2(&DESCRIPTION_LENGTH),
  cc_software_version varchar2(&VERSION_LENGTH),
  cc_software_build_date date,
  constraint sys_snp_fk foreign key(snapshot_guid)
      references mgmt_ecm_snapshot(snapshot_guid)
      on delete cascade
) monitoring;


rem
rem PURPOSE
rem
rem     The mgmt_hc_hardware_master table holds the hardware
rem     master information of a host configuration.
rem
rem COLUMNS
rem
rem   snapshot_guid       - ID of the snapshot under which this hardware
rem                         information is being collected.
rem
rem   vendor_name         - The name of the hardware vendor.
rem
rem   system_config       - information describing the system configuration
rem
rem   machine_architecture - machine architecture of the host.
rem
rem   clock_freq_in_mhz   - Clock frequency (in MHz) of the host
rem                          (+ve number).
rem
rem   memory_size_in_mb   -  Memory Size (in MB) of the host.
rem                          (+ve number)
rem
rem   local_disk_space_in_gb -  Total local disk space (in GB) of the host.
rem                          (+ve number)
rem
rem   cpu_count           - Number of cpus in this host.
rem                          (+ve number).
rem
rem   cpu_board_count     - Number of cpu boards in this host.
rem                          (+ve number).
rem
rem   iocard_count        - Number of iocards in this host.
rem                          (+ve number).
rem
rem   fan_count           - Number of fans in this host.
rem                          (+ve number).
rem
rem   power_supply_count  - Number of power supply units in this host.
rem                          (+ve number).
rem
rem  NOTES
rem

create table mgmt_hc_hardware_master
(
  snapshot_guid raw(16) NOT NULL PRIMARY KEY ,
  vendor_name varchar2(&NAME_LENGTH),
  system_config varchar2(&MAX_VARCHAR2_LENGTH),
  machine_architecture varchar2(&SHORT_DESCRIPTION_LENGTH),
  clock_freq_in_mhz number,
  memory_size_in_mb number,
  local_disk_space_in_gb number,
  cpu_count number,
  cpu_board_count number,
  iocard_count number,
  fan_count number,
  power_supply_count number,
  constraint hwr_snp_fk foreign key(snapshot_guid)
      references mgmt_hc_system_summary(snapshot_guid)
      on delete cascade
) monitoring;

rem
rem PURPOSE
rem
rem     The mgmt_hc_cpu_details table holds the cpu details
rem     of a host configuration.
rem
rem COLUMNS
rem
rem   snapshot_guid     - ID of the snapshot under which this
rem                         information is being collected.
rem
rem   vendor_name       - The name of the vendor of the cpu.
rem
rem   freq_in_mhz       - Clock frequency (in MHz) of the cpu.
rem                          (+ve number).
rem
rem   ecache_in_mb      -  E cache Size (in MB) of the cpu.
rem                          (+ve number).
rem
rem   impl              - The cpu implementation
rem
rem   revision          - Revision details of the cpu
rem
rem   mask              - cpu mask
rem
rem  NOTES
rem

create table mgmt_hc_cpu_details
(
  snapshot_guid raw(16) NOT NULL,
  vendor_name varchar2(&NAME_LENGTH),
  freq_in_mhz number,
  ecache_in_mb number,
  impl varchar2(&SHORT_DESCRIPTION_LENGTH),
  revision varchar2(&DESCRIPTION_LENGTH),
  mask varchar2(&SHORT_DESCRIPTION_LENGTH),
  constraint cpu_snp_fk foreign key(snapshot_guid)
      references mgmt_hc_system_summary(snapshot_guid)
      on delete cascade
) monitoring;

rem
rem PURPOSE
rem
rem     The mgmt_hc_iocard_details table holds the iocard details
rem     of a host configuration.
rem
rem COLUMNS
rem
rem   snapshot_guid     - ID of the snapshot under which this
rem                         information is being collected.
rem
rem   vendor_name       - The name of the vendor of the iocard.
rem
rem   name              - Name of the iocard.
rem
rem   freq_in_mhz       - Frequency in MHz of the iocard.
rem                          (+ve number).
rem
rem   bus               - info about iocard bus.
rem
rem   revision          - Revision info about the iocard.
rem
rem  NOTES
rem

create table mgmt_hc_iocard_details
(
  snapshot_guid raw(16) NOT NULL ,
  vendor_name varchar2(&NAME_LENGTH),
  name varchar2(&NAME_LENGTH) NOT NULL,
  freq_in_mhz number,
  bus varchar2(&SHORT_DESCRIPTION_LENGTH),
  revision varchar2(&DESCRIPTION_LENGTH),
  constraint ioc_snp_fk foreign key(snapshot_guid)
      references mgmt_hc_system_summary(snapshot_guid)
      on delete cascade
) monitoring;

rem
rem PURPOSE
rem
rem     The mgmt_hc_nic_details table holds the network interface
rem     card details of a host configuration.
rem
rem COLUMNS
rem
rem   snapshot_guid     - ID of the snapshot under which this
rem                         information is being collected.
rem
rem   name              - Name of the NIC.
rem
rem   flags             - NIC flags - list of flags that are "on".
rem
rem   max_transfer_unit - maximum transfer unit - the maximum rate of
rem                       data transfer supported by this card.
rem
rem   inet_address      - inet address
rem
rem   mask              - mask - specifies how much of the address to
rem                       reserve for subdividing networks into
rem                       subnetworks.
rem
rem   broadcast_address - address to use to represent broadcasts to the
rem                       network.
rem
rem   mac_address       - MAC address - unique address of this card used by
rem                       ARP (address resolution protocol)
rem
rem   hostname_aliases  - hostname aliases- for the host
rem
rem  NOTES
rem

create table mgmt_hc_nic_details
(
  snapshot_guid raw(16) NOT NULL ,
  name varchar2(&NAME_LENGTH),
  flags varchar2(&NIC_FLAGS),
  max_transfer_unit number,
  inet_address varchar2(&INET_ADDRESS_LENGTH),
  mask varchar2(&INET_ADDRESS_LENGTH),
  broadcast_address varchar2(&INET_ADDRESS_LENGTH),
  mac_address varchar2(&INET_ADDRESS_LENGTH),
  hostname_aliases varchar2(&MAX_VARCHAR2_LENGTH),
  constraint nic_snp_fk foreign key(snapshot_guid)
      references mgmt_hc_system_summary(snapshot_guid)
      on delete cascade
) monitoring;


rem
rem PURPOSE
rem
rem     The mgmt_hc_os_summary table holds the Summary
rem     info of a host configuration.
rem
rem COLUMNS
rem
rem   snapshot_guid     - ID of the snapshot under which this
rem                         information is being collected.
rem
rem   name              - Name of the OS.
rem
rem   vendor_name       - The name of the vendor of the OS.
rem
rem   base_version      - Base OS version - This should typically
rem                       match between two operating systems being
rem                       compared for the comparison to make sense.
rem
rem   update_level      - Kernel Patch update level
rem
rem   distributor_version - Relevant mainly in open source OSs such
rem                       as Linux where there is a separate version
rem                       that tracks the distributor's version
rem                       (e.g. RedHat 7.2 implies 7.2 is the distributor
rem                       version.
rem
rem   max_swap_space_in_mb - Maximum swap space configured on this host.- to
rem                       be deleted when parameters shows up in os properties.
rem
rem   address_length_in_bits -  The bits in address space (e.g. 32 bit OS
rem                             or 64 bit OS)
rem
rem   patches - the number of OS patches in this snapshot
rem
rem  NOTES
rem

create table mgmt_hc_os_summary
(
  snapshot_guid raw(16) NOT NULL PRIMARY KEY ,
  name varchar2(&NAME_LENGTH),
  vendor_name varchar2(&NAME_LENGTH) ,
  base_version varchar2(&VERSION_LENGTH),
  update_level varchar2(&VERSION_LENGTH),
  distributor_version varchar2(&VERSION_LENGTH) ,
  max_swap_space_in_mb number,
  address_length_in_bits varchar2(20),
  patches number DEFAULT 0 NOT NULL,
  constraint oss_snp_fk foreign key(snapshot_guid)
      references mgmt_ecm_snapshot(snapshot_guid)
      on delete cascade
) monitoring;

rem
rem PURPOSE
rem
rem     The mgmt_hc_os_properties table holds various os properties
rem     of a host configuration.
rem
rem COLUMNS
rem
rem   snapshot_guid     - ID of the snapshot under which this
rem                       information is being collected.
rem
rem   type              - type/category of property, e.g., "KERNEL_PARAM"
rem
rem   name              - name of property, e.g., "autoup"
rem
rem   value             - value of property, e.g., "240"
rem
rem  NOTES
rem

create table mgmt_hc_os_properties
(
  snapshot_guid raw(16) NOT NULL,
  type varchar2(&NAME_LENGTH) NOT NULL,
  name varchar2(&NAME_LENGTH) NOT NULL,
  value varchar2(&DESCRIPTION_LENGTH) DEFAULT NULL,
  constraint osp_snp_pk
       primary key(snapshot_guid, type, name) USING INDEX
       ( CREATE UNIQUE INDEX osp_snp_pk ON mgmt_hc_os_properties
         (snapshot_guid, type, name) COMPRESS 2),
  constraint osp_snp_fk foreign key(snapshot_guid)
      references mgmt_hc_os_summary(snapshot_guid)
      on delete cascade
) monitoring;

rem
rem PURPOSE
rem
rem     The mgmt_hc_os_components table holds the details of the
rem     OS components of a host. These components might include
rem     installed packages and patches, for example.
rem
rem COLUMNS
rem
rem   snapshot_guid     - ID of the snapshot under which this
rem                         information is being collected.
rem
rem   name              - Name of the OS component.
rem
rem   type              - Type of the OS component.
rem
rem   version           - The version of the OS component.
rem
rem   description       - description of the OS component.
rem
rem   installation_date - Installation date of the OS component.
rem
rem  NOTES
rem

create table mgmt_hc_os_components
(
  snapshot_guid raw(16) NOT NULL,
  name varchar2(&NAME_LENGTH) NOT NULL,
  type varchar2(&TYPE_LENGTH) NOT NULL,
  version varchar2(&VERSION_LENGTH),
  description varchar2(&DESCRIPTION_LENGTH),
  installation_date date,
  constraint osc_snp_fk foreign key(snapshot_guid)
      references mgmt_hc_os_summary(snapshot_guid)
      on delete cascade
) monitoring;


rem
rem PURPOSE
rem
rem     The mgmt_hc_fs_mount_details table holds the details of the
rem     mounted file systems on an OS.
rem
rem COLUMNS
rem
rem   snapshot_guid     - ID of the snapshot under which this
rem                         information is being collected.
rem
rem   resource_name     - Name of the resource, i.e. the mounted file system
rem                       e.g. in Solaris - /dev/dsk/c2t1d0s7
rem
rem   mount_location    - The directory where the file system is mounted
rem
rem   type              - Type of the file system (e.g. 'nfs' in Solaris)
rem
rem   mount options     - options used while mounting the file system
rem
rem  NOTES
rem

create table mgmt_hc_fs_mount_details
(
  snapshot_guid raw(16) NOT NULL,
  resource_name varchar2(&NAME_LENGTH) NOT NULL,
  mount_location varchar2(&LOCATION_LENGTH) NOT NULL,
  type varchar2(&TYPE_LENGTH),
  mount_options varchar2(1024),
  constraint fmd_snp_fk foreign key(snapshot_guid)
      references mgmt_hc_os_summary(snapshot_guid)
      on delete cascade
) monitoring;

rem
rem PURPOSE
rem
rem     The mgmt_hc_vendor_sw_summary table holds summary info
rem     about 3rd party vendor software of a host configuration.
rem
rem COLUMNS
rem
rem   vendor_software_guid - internally generated id
rem
rem   snapshot_guid        - ID of the snapshot under which this
rem                          information is being collected.
rem
rem   name                 - Name of the vendor software.
rem
rem   vendor_name          - The name of the vendor of the software.
rem
rem   version              - version of the vendor software.
rem
rem   installation_date    - the installation date of the software
rem
rem   installed_location   - the installed location of the software
rem
rem   description          - description of the vendor software.
rem
rem   vendor_software_specific_info - Any info specific to the
rem                       vendor software.
rem
rem  NOTES
rem

create table mgmt_hc_vendor_sw_summary
(
  vendor_software_guid raw(16) PRIMARY KEY NOT NULL,
  snapshot_guid raw(16) NOT NULL,
  name varchar2(&NAME_LENGTH) NOT NULL,
  vendor_name varchar2(&NAME_LENGTH),
  version varchar2(&VERSION_LENGTH),
  installation_date date,
  installed_location varchar2(&LOCATION_LENGTH),
  description varchar2(&DESCRIPTION_LENGTH),
  vendor_software_specific_info varchar2(&MAX_VARCHAR2_LENGTH),
  constraint vnd_snp_fk foreign key(snapshot_guid)
      references mgmt_ecm_snapshot(snapshot_guid)
      on delete cascade
) monitoring;


rem
rem PURPOSE
rem
rem     The mgmt_hc_vendor_sw_components table holds info
rem     about 3rd party vendor software components of a host
rem     configuration.
rem
rem COLUMNS
rem
rem   vendor_software_guid - internally generated id (foreign key
rem                          from mgmt_hc_vendor_sw_summary)
rem
rem   name                 - Name of the vendor software component.
rem
rem   type                 - Type of the vendor software component
rem
rem   version              - version of the vendor software component.
rem
rem   description          - description of the vendor software.
rem
rem   installation_date    - Installation date of the vendor software
rem                          component.
rem
rem  NOTES
rem

create table mgmt_hc_vendor_sw_components
(
  vendor_software_guid raw(16) NOT NULL,
  name varchar2(&NAME_LENGTH) NOT NULL,
  type varchar2(&TYPE_LENGTH) NOT NULL,
  version varchar2(&VERSION_LENGTH),
  description varchar2(&DESCRIPTION_LENGTH),
  installation_date date,
  constraint vnc_vnd_fk foreign key(vendor_software_guid)
      references mgmt_hc_vendor_sw_summary(vendor_software_guid)
      on delete cascade
) monitoring;

rem PURPOSE
rem
rem     The mgmt_ecm_resources table resource text information for
rem   sql queries that are used to populate the GUI.  The current implementation
rem   is english only.  We expect a general solution to this, em wide, so for
rem   now, this will suffice.
rem
rem COLUMNS
rem
rem   resource_type     - used to categorize the resources.
rem
rem   name              - The name of the resource.
rem
rem   default_text      - The english display text.
rem
rem  NOTES
rem

CREATE TABLE MGMT_ECM_RESOURCES
(
  RESOURCE_TYPE VARCHAR2(32) NOT NULL,
  NAME VARCHAR2(32) NOT NULL,
  DEFAULT_TEXT VARCHAR2(128) NOT NULL,
  CONSTRAINT ECM_RESRC_PK PRIMARY KEY(RESOURCE_TYPE, NAME)
) monitoring;



rem PURPOSE
rem
rem     Used to save complete comparison sets.
rem
rem COLUMNS
rem
rem   DELTA_COMP_GUID   - A unique id used to identify each comparison.
rem
rem   COMPARISON_TYPE   - An identifying describing what is compared.  For
rem                       the config fw, this would be the snapshot_type
rem
rem   TARGET_TYPE       - Identifies the target type of the objects being
rem                         compared.  For config fw, this would be the target
rem                         type.  Between this and comparison_type, the snapshot
rem                         is identified.
rem
rem  NOTES
rem
CREATE TABLE MGMT_DELTA_SAVED_COMPARISON
(
  DELTA_COMP_GUID RAW(16) NOT NULL,
  COMPARISON_TYPE VARCHAR2(64),
  TARGET_TYPE VARCHAR2(64),
  SAVED_TIMESTAMP DATE DEFAULT SYSDATE NOT NULL,
  SESSION_ID RAW(16) DEFAULT SYS_GUID() NOT NULL,
  CONSTRAINT COMP_PK PRIMARY KEY( DELTA_COMP_GUID )
) MONITORING;

rem PURPOSE
rem
rem     Used to save the comparison summaries of saved comparisons
rem
rem COLUMNS
rem
rem   DELTA_COMP_GUID   - A unique id used to identify each comparison.  This is
rem                       part of the PK for this table.  Collection type is the
rem                       other part.
rem
rem   COLLECTION_TYPE   - Used with the delta_comp_guid to identify the row.  It
rem                       represents the logical table that this summary row
rem                       describes.
rem
rem   DIFFERENT_COUNT   - The number of row differences found.
rem
rem   LEFT_ONLY_COUNT   - The number of left only rows found
rem
rem   RIGHT_ONLY_COUNT  - The number of right only rows found
rem
rem   ERRORS            - The errors for this collection type, mainly for
rem                     - debugging.
rem
rem  NOTES
rem
CREATE TABLE MGMT_DELTA_COMP_SUMMARIES
(
  DELTA_COMP_GUID RAW(16),
  COLLECTION_TYPE VARCHAR2(64),
  DIFFERENT_COUNT INTEGER,
  LEFT_COUNT INTEGER,
  RIGHT_COUNT INTEGER,
  ERRORS VARCHAR2_TABLE,
  CONSTRAINT COMP_SUMMARY_PK PRIMARY KEY( DELTA_COMP_GUID, COLLECTION_TYPE ),
  CONSTRAINT COMP_DELTA_SUM_FK FOREIGN KEY ( DELTA_COMP_GUID )
    REFERENCES MGMT_DELTA_SAVED_COMPARISON( DELTA_COMP_GUID )
    ON DELETE CASCADE
) NESTED TABLE ERRORS STORE AS MGMT_DELTA_SUMMARY_ERRORS
MONITORING;

rem PURPOSE
rem
rem     Used to save a delta entry, identified by key columns.
rem
rem COLUMNS
rem
rem   DELTA_COMP_GUID   - A unique id used to identify each comparison.
rem
rem   COLLECTION_TYPE   - Used with the delta_comp_guid and name to identify the rows
rem                     - that have deltas within the collection.
rem
rem   KEY_GUID          - A guid representing the entire key.  Used as Primary key.
rem
rem   STATUS            - DIFFERENT, LEFT_ONLY, RIGHT_ONLY, SAME
rem
rem  NOTES
rem

CREATE TABLE MGMT_DELTA_COMPARISON_DELTAS
(
  DELTA_COMP_GUID RAW(16),
  COLLECTION_TYPE VARCHAR2(64),
  STATUS VARCHAR2(10),
  KEY_GUID RAW(16),
  CONSTRAINT COMP_DELTA_PK PRIMARY KEY( KEY_GUID ),
  CONSTRAINT COMP_DELTA_DEL_FK FOREIGN KEY ( DELTA_COMP_GUID )
    REFERENCES MGMT_DELTA_SAVED_COMPARISON( DELTA_COMP_GUID )
    ON DELETE CASCADE
) MONITORING;

rem PURPOSE
rem
rem     Used to save a key column value in saved comparisons
rem
rem COLUMNS
rem
rem   DELTA_COMP_GUID   - A unique id used to identify each comparison.  This is
rem                       part of the UK for this table.  Collection type and name
rem                     - are the other parts.
rem
rem   COLLECTION_TYPE   - Used with the delta_comp_guid and name to identify the row.  It
rem                       represents the logical table that this summary row
rem                       describes.
rem
rem   KEY_GUID          - A guid representing the entire key.  Used with the
rem                       key column name as pk.
rem
rem   NAME              - The inidividual key column's name
rem
rem   VALUE             - The value of the key column
rem
rem  NOTES
rem
CREATE TABLE MGMT_DELTA_COMP_KEY_COLS
(
  DELTA_COMP_GUID RAW(16) NOT NULL,
  COLLECTION_TYPE VARCHAR2(64),
  KEY_GUID RAW(16) NOT NULL,
  NAME VARCHAR2(64),
  VALUE VARCHAR2(4000),
  TYPE CHAR(1),
  CONSTRAINT COMP_KEY_COLS_PK PRIMARY KEY( KEY_GUID, NAME ),
  CONSTRAINT COMP_KEY_FK1 FOREIGN KEY ( KEY_GUID )
    REFERENCES MGMT_DELTA_COMPARISON_DELTAS( KEY_GUID )
    ON DELETE CASCADE
) MONITORING;

rem PURPOSE
rem
rem     Used to save a key column value in saved comparisons
rem
rem COLUMNS
rem
rem   KEY_GUID          - A guid representing the entire key.  Used with the
rem                       name column name as pk.  Also used as Foreign key
rem
rem   NAME              - The inidividual key column's name
rem
rem   LEFT_VALUE        - The left side value of thecolumn
rem   RIGHT_VALUE       - The rigth side value of the column
rem
rem  NOTES
rem
CREATE TABLE MGMT_DELTA_COMP_DELTA_DETAILS
(
  KEY_GUID RAW(16) NOT NULL,
  NAME VARCHAR2(64) NOT NULL,
  LEFT_VALUE VARCHAR2(&MAX_VARCHAR2_LENGTH),
  RIGHT_VALUE VARCHAR2(&MAX_VARCHAR2_LENGTH),
  STATUS VARCHAR2(10),
  TYPE CHAR(1),
  CONSTRAINT COMP_DELTA_DET_PK PRIMARY KEY( KEY_GUID, NAME ),
  CONSTRAINT COMP_DELTA_DET_FK FOREIGN KEY (KEY_GUID )
    REFERENCES MGMT_DELTA_COMPARISON_DELTAS( KEY_GUID )
    ON DELETE CASCADE
) MONITORING;

rem PURPOSE
rem
rem     Used to save properties associated with a comparison.  Typically, the
rem     properties will be things like the name of the left and right
rem     targets and the dates of the data capture for the left and right.
rem     Could even represent general comparison info, where the left value is
rem     the only value, representing the comparison itself and not the right or
rem     left target specifically.
rem
rem COLUMNS
rem
rem   DELTA_COMP_GUID   - A guid pointing to the comparison who owns this
rem                       property pair.
rem
rem   NAME              - The property name.
rem
rem   LEFT_VALUE        - The left side value of the property
rem   RIGHT_VALUE       - The rigth side value of the property
rem
rem  NOTES
rem
CREATE TABLE MGMT_DELTA_COMP_PROPERTIES
(
  DELTA_COMP_GUID RAW(16) NOT NULL,
  NAME VARCHAR2(64) NOT NULL,
  LEFT_VALUE VARCHAR2(&MAX_VARCHAR2_LENGTH),
  RIGHT_VALUE VARCHAR2(&MAX_VARCHAR2_LENGTH),
  CONSTRAINT DELTA_COMP_INFO_FK FOREIGN KEY( DELTA_COMP_GUID )
    REFERENCES MGMT_DELTA_SAVED_COMPARISON( DELTA_COMP_GUID )
    ON DELETE CASCADE
) MONITORING;



rem -------------------------------------------------------------------------------
rem   The following tables are obsolete with GC Rel 2.  They had been used to
rem   support the Version 1 policy framework; that is, the framework prior to
rem   the metric/policy unification effort.
rem


rem
rem PURPOSE
rem   Each row in the MGMT_POLICY_RULE table represents a rule, identified 
rem   by its name, target_type and category.  Each rule can have zero or more 
rem   columns, zero or more default action, and zero or more parameters 
rem   (with default values).   The combination of NAME, TARGET_TYPE and CATEGORY 
rem   must be unique.
rem COLUMNS
rem   RULE_ID   System generated identifier for the rule.
rem   RULE_NAME Creator supplied name of the rule. 
rem   DISPLAY_ID The id used to construct the resource id for obtaining the
rem     appropriate strings
rem   VERSION Rule version
rem   TARGET_TYPE   An EM target type such as oracle_database, host, or oracle_ias.  
rem     Used to associate rules with appropriate targets.
rem   CATEGORY  Indicates the virtual set of rules to which this rule belongs.  
rem     Examples are: Security, Config???
rem   DESCRIPTION   A description of the rule.
rem   RULE_TYPE The rule type describes how to process the rule.  Types include 
rem     SQL, QUERY, PLSQL and CONFIG.  If type QUERY, then the RULE_OBJECT 
rem     attribute is a SQL select statement that defines the data that the rule 
rem     will test.  If SQL, then the rule object holds a view or table name.  
rem     If CONFIG, then the rule object???s metadata is accessible via the EM 
rem     config framework tables.  How can we simplify this?  What are the actual 
rem     requirements?
rem   RULE_OBJECT   A query, table name, view name or qualified procedure name, 
rem     depending on the rule type.
rem   TEST  This is a predicate to attach to a query against the 
rem     RULE_OBJECT.  This predicate describes the condition for rule violation.  
rem     It can contain parameter references.  All parameters must have an entry 
rem     in the MGMT_POLICY_RULE_DEF_PARAMS table.
rem   PRIORITY Rule severity 4,3,2,1,0,-1 (High, medium, low, informational, 
rem      clear, error)
rem   IMPACT_OF_PROBLEM A text message that can be used to describe the impact 
rem     of a rule violation.
rem   RECOMMENDATION A text message indicating recommendation.
rem   AUTHOR Rule's author; for example, 'Oracle'
rem   CREATION_DATE The date that the rule was created (is the entered by the 
rem     creator, or is it actually the date of registration?)
rem   UPDATOR Who last updated this rule?
rem   LAST_UPDATED  This is the when the last change was made to the rule in the 
rem     repository.
rem   UPDATE_COMMENT Comment associated with last update

/*
CREATE TABLE MGMT_POLICY_RULE
(
  RULE_ID RAW(&GUID_RAW_LENGTH) NOT NULL, 
  RULE_NAME VARCHAR2(&P_NAME_LENGTH), 
  DISPLAY_ID VARCHAR2(&P_DISPLAY_ID_LENGTH),
  VERSION VARCHAR2(&P_VERSION_LENGTH),
  TARGET_TYPE VARCHAR2(&P_TARGET_TYPE_LENGTH), 
  CATEGORY VARCHAR2(&P_CATEGORY_LENGTH), 
  DESCRIPTION VARCHAR2(&P_DESCRIPTION_LENGTH), 
  RULE_TYPE VARCHAR2(&P_RULE_TYPE_LENGTH), 
  RULE_OBJECT VARCHAR2(&P_LARGE_VARCHAR_LENGTH), 
  TEST VARCHAR2(&P_LARGE_VARCHAR_LENGTH), 
  PRIORITY NUMBER,
  IMPACT_OF_PROBLEM VARCHAR2(&P_SHORT_DESCRIPTION_LENGTH), 
  RECOMMENDATION VARCHAR2(&P_SHORT_DESCRIPTION_LENGTH),
  AUTHOR VARCHAR2(&P_AUTHOR_LENGTH),
  CREATION_DATE DATE, 
  UPDATOR VARCHAR2(&P_NAME_LENGTH),
  LAST_UPDATED DATE, 
  UPDATE_COMMENT VARCHAR2(&P_SHORT_DESCRIPTION_LENGTH),
  DISABLED_FLAG VARCHAR2(&P_Y_N_LENGTH) DEFAULT 'N',
  DISABLED_BY VARCHAR2(&P_NAME_LENGTH),
  CONSTRAINT MRD_PK PRIMARY KEY(RULE_ID),
  CONSTRAINT MRD_UK UNIQUE (AUTHOR, TARGET_TYPE, CATEGORY, RULE_NAME) 
) MONITORING;


rem PURPOSE
rem   Each row in this table is a child of a row in the MGMT_POLICY_RULE 
rem   table.  The entries in this table describe the columns that should be 
rem   captured when a rule is violated.  Each column referenced in the rule 
rem   test, or predicate, will typically have a corresponding entry in this 
rem   table.
rem COLUMNS
rem   RULE_ID   The ID of the parent row in the MGMT_POLICY_RULE table.
rem   COLUMN_POSITION   The position of the column in the result.
rem   COLUMN_NAME   The name of the column.  Used when displaying the rule 
rem     violations.
rem   IS_KEY  Is this column part of the row key.
rem   IS_VISIBLE  Do I show this column in the generic UI.
rem   URL A url with column references to be used and substituted with row-column
rem       values when displayed in the generic ui.
rem   DISPLAY_ID The id used to construct the resource id for obtaining the
rem     appropriate strings
rem   DISPLAY_FORMAT The display format to use when displaying the row-column
rem       values in the generic ui.  0,1,2 (textFormat, numberFormat, dateFormat)
CREATE TABLE MGMT_POLICY_RULE_DEF_COLUMNS 
(
  RULE_ID RAW(&GUID_RAW_LENGTH) NOT NULL, 
  COLUMN_POSITION NUMBER(&P_REASONABLE_NUMBER_LENGTH), 
  COLUMN_NAME VARCHAR2(&P_SQL_NAME_LENGTH) NOT NULL, 
  IS_KEY VARCHAR2(&P_Y_N_LENGTH),
  IS_VISIBLE VARCHAR2(&P_Y_N_LENGTH),
  URL VARCHAR2(&P_URL_LENGTH),
  DISPLAY_NAME VARCHAR2(&P_SQL_NAME_LENGTH),
  DISPLAY_FORMAT NUMBER(&P_REASONABLE_NUMBER_LENGTH), 
  CONSTRAINT MRDC_MRD_FK FOREIGN KEY(RULE_ID) 
    REFERENCES MGMT_POLICY_RULE(RULE_ID) 
    ON DELETE CASCADE, 
  CONSTRAINT MRDC_UK UNIQUE(RULE_ID, COLUMN_NAME) 
) MONITORING; 


rem PURPOSE
rem   Each parameter referenced in the RULE_TEST of a rule MUST have an entry in 
rem   this table.  This information will drive the Policy Manager when a policy 
rem   is created using that rule.
rem   Each entry specifies the default value of the parameters.  
rem   Rows in this table are used at runtime when an appropriate entry in the 
rem   MGMT_POLICY_PARAMS tables was not found for a particular rule.
rem COLUMNS
rem   RULE_ID   The ID of the parent row in the RULES table.
rem   PARAM_NAME    The name of the parameter used both to drive the GUI to get 
rem     overriding values at policy creation time, and to match those values to 
rem     the parameter placeholders in the rule test.
rem   PARAM_VALUE   The warning threshold value for this parameter.
rem   DISPLAY_ID The id used to construct the resource id for obtaining the
rem     appropriate strings
rem   DISPLAY_FORMAT The display format to use when displaying the values in
rem       the generic ui.  0,1,2 (textFormat, numberFormat, dateFormat)
CREATE TABLE MGMT_POLICY_RULE_DEF_PARAMS 
(
  RULE_ID RAW(&GUID_RAW_LENGTH) NOT NULL, 
  PARAM_NAME VARCHAR2(&P_NAME_LENGTH) NOT NULL, 
  PARAM_VALUE VARCHAR2(&P_VALUE_LENGTH), 
  DISPLAY_NAME VARCHAR2(&P_NAME_LENGTH),
  DISPLAY_FORMAT NUMBER(&P_REASONABLE_NUMBER_LENGTH), 
  CONSTRAINT MRDP_UK UNIQUE(RULE_ID, PARAM_NAME),
  CONSTRAINT MRDP_MRD_FK FOREIGN KEY(RULE_ID) 
    REFERENCES MGMT_POLICY_RULE(RULE_ID) 
    ON DELETE CASCADE 
) MONITORING;


rem PURPOSE
rem   Each row in this table represents a policy set up by the user via the 
rem   policy manager.  Each policy references one or more rule criteria that 
rem   will be used at evaluation time to determine the actual set of rules.  
rem   The actual set of targets to test is also determined at evaluation time.
rem COLUMNS
rem   POLICY_ID The ID of the policy, system generated.
rem   POLICY_NAME Name of the policy
rem   DISPLAY_ID The id used to construct the resource id for obtaining the
rem     appropriate strings
rem   VERSION For upgrades, used to version the policy.
rem   DESCRIPTION   A description of the policy.  Typically what the goal of the policy 
rem     is.
rem   AUTHOR    The creator of the policy.  
rem   CREATION_DATE The date that the policy was created.
rem   UPDATOR   The em user that last modified this policy
rem   UPDATE_DATE   The date that the policy was last updated.
rem   UPDATE_COMMENT - When an update occurs, a comment can be used to annotate 
rem       the policy.
CREATE TABLE MGMT_POLICY_GROUP 
(
  POLICY_ID RAW(&GUID_RAW_LENGTH) NOT NULL,
  POLICY_NAME VARCHAR2( &P_NAME_LENGTH ),
  DISPLAY_ID VARCHAR2(&P_DISPLAY_ID_LENGTH),
  VERSION VARCHAR2( &P_VERSION_LENGTH ),
  DESCRIPTION VARCHAR2(&P_DESCRIPTION_LENGTH),   
  AUTHOR VARCHAR2(&P_AUTHOR_LENGTH), 
  CREATION_DATE DATE, 
  UPDATOR VARCHAR2(&P_NAME_LENGTH), 
  UPDATE_DATE DATE, 
  UPDATE_COMMENT VARCHAR2(&P_SHORT_DESCRIPTION_LENGTH),
  CONSTRAINT MP_PK PRIMARY KEY(POLICY_ID),
  CONSTRAINT MP_UK UNIQUE (AUTHOR, POLICY_NAME) 
) MONITORING;


rem PURPOSE
rem   In order for the policy engine to evaluate rules, it must use the 
rem   rule_test along with the appropriate parameters.  The policy engine will 
rem   first look in this table to find values for each rule???s parameters.  If 
rem   not found here, it will look in the MGMT_POLICY_RULE_DEF_PARAMS table.
rem COLUMNS
rem   POLICY_ID The ID of the policy, system generated.
rem   RULE_NAME A wild-carded name used when matching the parameter values with 
rem     the actual rules at evaluation time.
rem   TARGET_TYPE   A wild-carded target type used when matching the parameter 
rem     values with the actual rules at evaluation time.
rem   CATEGORY  A wild-carded category used when matching the parameter values 
rem     with the actual rules at evaluation time.
rem   PARAM_NAME    The name of the parameter which is used in the rules 
rem     identified by the RULE_NAME, TARGET_TYPE and CATEGORY values.  
rem   PARAM_VALUE   The value to be used to bind in the rulw.  
rem   Typically the parameter will appear in a test that contains a 
rem     threshold test.   E.g. Issue WARNING alert if security patch has been 
rem     available for more than :DAYS days.  
CREATE TABLE MGMT_POLICY_PARAMS 
(
  POLICY_ID RAW(&GUID_RAW_LENGTH) NOT NULL, 
  AUTHOR VARCHAR2(&P_AUTHOR_LENGTH),
  TARGET_TYPE VARCHAR2(&P_TARGET_TYPE_LENGTH), 
  CATEGORY VARCHAR2(&P_CATEGORY_LENGTH), 
  RULE_NAME VARCHAR2(&P_NAME_LENGTH), 
  PARAM_NAME VARCHAR2(&P_NAME_LENGTH) NOT NULL, 
  PARAM_VALUE VARCHAR2(&P_VALUE_LENGTH), 
  CONSTRAINT MPP_MP_FK FOREIGN KEY(POLICY_ID) 
    REFERENCES MGMT_POLICY_GROUP(POLICY_ID) 
    ON DELETE CASCADE,
  CONSTRAINT MPP_UK UNIQUE(POLICY_ID, AUTHOR, 
    TARGET_TYPE, CATEGORY, RULE_NAME, PARAM_NAME) 
) MONITORING;


rem PURPOSE
rem   Entries in this table are used to determine which rules to use in a policy 
rem   evaluation.  The determination is performed at evaluation time so that 
rem   when new rules are added they will be included in the evaluation if they 
rem   meet the existing policy???s rule criteria.
rem COLUMNS
rem   POLICY_ID The ID of the policy, system generated.
rem   RULE_NAME A wild-carded string for  matching with the rules in the 
rem     MGMT_POLICY_RULE table.
rem   TARGET_TYPE   Wild-carded target type for matching with the rules in the 
rem     MGMT_POLICY_RULE table.
rem   CATEGORY  Wild-carder category for matching with the rules in the 
rem     MGMT_POLICY_RULE table.
CREATE TABLE MGMT_POLICY_RULE_CRITERIA
(
  POLICY_ID RAW(&GUID_RAW_LENGTH) NOT NULL, 
  AUTHOR VARCHAR2(&P_AUTHOR_LENGTH),
  TARGET_TYPE VARCHAR2(&P_TARGET_TYPE_LENGTH), 
  CATEGORY VARCHAR2(&P_CATEGORY_LENGTH), 
  RULE_NAME VARCHAR2(&P_NAME_LENGTH), 
  CONSTRAINT MPRC_MP_FK FOREIGN KEY(POLICY_ID) 
    REFERENCES MGMT_POLICY_GROUP(POLICY_ID) 
    ON DELETE CASCADE,
  CONSTRAINT MPRC_UK UNIQUE(POLICY_ID, AUTHOR, 
    TARGET_TYPE, CATEGORY, RULE_NAME) 
)   MONITORING;

rem PURPOSE
rem   This table is used to associate a list of targets with a policy.  The 
rem   criteria specified in this table are used at policy evaluation time to 
rem   determine the actual list of targets whose data should be tested against 
rem   the policy.
rem COLUMNS
rem   POLICY_ID The ID of the policy, system generated.
rem   NAME_IS_GROUP - Indicates if the target name refers to a group or
rem                         individual target.  'Y' for group, 'N' for target.
rem   TARGET_TYPE   Wild-carded target type for matching with targets in the 
rem     MGMT_TARGETS table.
rem   TARGET_NAME   Wild-carded target name for matching with targets in the 
rem     MGMT_TARGETS table
rem   FILTER_OP LIKE or NOT LIKE.  Used when fetching target list..
CREATE TABLE MGMT_POLICY_TARGET_CRITERIA
(
  POLICY_ID RAW(&GUID_RAW_LENGTH) NOT NULL, 
  NAME_IS_GROUP VARCHAR2(&P_Y_N_LENGTH),
  TARGET_TYPE VARCHAR2(&P_TARGET_TYPE_LENGTH), 
  TARGET_NAME VARCHAR2(&P_NAME_LENGTH), 
  FILTER_OP VARCHAR2(&P_FILTER_OP_LENGTH), 
  CONSTRAINT MPTC_MP_FK FOREIGN KEY(POLICY_ID) 
    REFERENCES MGMT_POLICY_GROUP(POLICY_ID) 
    ON DELETE CASCADE,
  CONSTRAINT MPTC_UK UNIQUE(POLICY_ID, TARGET_TYPE, 
    TARGET_NAME, NAME_IS_GROUP)     
) MONITORING;  

rem PURPOSE
rem   Each row that is returned when a rule is violated gets an entry in this 
rem   table.  Each row is actually identified by POLICY_ID, RULE_ID, TARGET_GUID 
rem   and the set of MGMT_POLICY_VIOLATION_VALUES associated with this row.  If 
rem   the a matching row was already in this table, from a previous evaluation, 
rem   then the row is updated to reflect the new information.  If a row existed 
rem   after a previous evaluation, but not in the latest, then the previous 
rem   entry is removed.  If the rule returned no column values, just TRUE or 
rem   FALSE, then an entry will exist in this table with no entries in the 
rem   corresponding MGMT_POLICY_VIOLATION_VALUES table.
rem   If a rule is modified, such that the column list changes, then older 
rem   violation will be removed, because the new violations will not match 
rem   exactly, and the new row will result in a new entry even if it is actually 
rem   the same as one of the old rows.
rem COLUMNS
rem   POLICY_ID The ID of the policy, system generated.
rem   RULE_ID   The id of the rule that was violated.  
rem   TARGET_GUID   The target guid of the target whose data violated the rule. 
rem   VIOLATION_ID  A unique system generated ID for this rule's violation.  
rem     as applied to the rule???s test.
CREATE TABLE MGMT_POLICY_VIOLATIONS
(
  POLICY_ID RAW(&GUID_RAW_LENGTH), 
  RULE_ID RAW(&GUID_RAW_LENGTH), 
  TARGET_GUID RAW(&GUID_RAW_LENGTH), 
  VIOLATION_ID RAW(&GUID_RAW_LENGTH) NOT NULL, 
  CONSTRAINT MPV_PK PRIMARY KEY(VIOLATION_ID) 
) MONITORING;

rem
rem PURPOSE
rem   For any policy-rule-target triplet, there may be zero or more row violations.
rem   This table is used to represent each row violation for that triplet.
rem   A row violation can be marked ignored.
rem COLUMNS
rem   VIOLATION_ID  Id's the POLICY-RULE-TARGET triplet and points to the parent
rem       table, MGMT_POLICY_VIOLATIONS, for them.
rem   KEY This is a concatenation of the key values for the row.  When updating
rem       the status of this policy-rule-target violation, we want to maintain
rem       a record of how long a particular row violation has been so, and whether
rem       or not it was ignored.  We need a key to identify what is ignored etc.
rem   KEY_REST This is the rest of the key, not indexed, that did not fit in 
rem       the indexed part of the key.
rem   ROW_ID  A guid used to identify this row so the row values can use it instead
rem       of the full key as a foreign key referened.
rem   IGNORED_FLAG  A user can mark this particular row violation as ignored.  Being 
rem     ignored, it will be filtered out from the normal violation display.  
rem   IGNORED_BY    The user who marked this row as ignored.
rem   ROW_COMMENT A comment that can be added by a user regarding this violation.
rem   PRIORITY  The highest severity level, based on parameter severity values 
rem     as applied to the rule???s test. (HIGH=4, MEDIUM=3, LOW=2, INFORMATIONAL=1, CLEAR=0
rem   INITIAL_DATE  The date when this rule was first violated by this 
rem     particular target data.
rem   LAST_DATE The last time this row was tested.
CREATE TABLE MGMT_POLICY_VIOLATION_ROWS
(
  VIOLATION_ID RAW( &GUID_RAW_LENGTH ) NOT NULL,
  KEY VARCHAR2(1024),
  ROW_ID RAW( &GUID_RAW_LENGTH ) NOT NULL,
  IGNORED_FLAG VARCHAR2(&P_Y_N_LENGTH),
  IGNORED_BY VARCHAR2(&P_NAME_LENGTH),
  ROW_COMMENT VARCHAR2( &P_SHORT_DESCRIPTION_LENGTH ),
  PRIORITY NUMBER,
  INITIAL_DATE DATE,
  LAST_DATE DATE,
  CONSTRAINT MPVR_PK PRIMARY KEY(ROW_ID),
  CONSTRAINT MPVR_UK UNIQUE (VIOLATION_ID, KEY ) USING INDEX
      (CREATE UNIQUE INDEX MPVR_UK ON MGMT_POLICY_VIOLATION_ROWS
        (VIOLATION_ID, KEY ) COMPRESS 1),
  CONSTRAINT MPVR_MPV_FK FOREIGN KEY (VIOLATION_ID) 
      REFERENCES MGMT_POLICY_VIOLATIONS(VIOLATION_ID)
      ON DELETE CASCADE
) MONITORING;

rem PURPOSE
rem   For rules whose violations return column values, those values are stored 
rem   in this table.  The violation_id attribute associates each value with its 
rem   parent row entry in MGMT_POLICY_VIOLATIONS table.
rem COLUMNS
rem   ROW_ID        Uniquely identifies The row that his column value is part of.
rem           needed because a policy rule target, which is the key of the parent
rem           table (violation_id) can have more than one row, each has more than
rem           one column. This is also a FK pointing to the row record in
rem           MGMT_POLICY_VIOLATION_ROWS table.
rem   COLUMN_NAME   Identifies which column within the rule that this entry 
rem     represents.
rem   COLUMN_VALUE  The value of the column the last time this rule was tested.
CREATE TABLE MGMT_POLICY_VIOLATION_VALUES
(
  VIOLATION_ID RAW(&GUID_RAW_LENGTH) NOT NULL, 
  ROW_ID RAW(&GUID_RAW_LENGTH) NOT NULL,
  COLUMN_NAME VARCHAR2(&P_SQL_NAME_LENGTH) NOT NULL, 
  COLUMN_VALUE VARCHAR2(&P_VALUE_LENGTH), 
  CONSTRAINT MPVV_PK PRIMARY KEY(ROW_ID, COLUMN_NAME) USING INDEX
    (CREATE UNIQUE INDEX MPVV_PK ON MGMT_POLICY_VIOLATION_VALUES
      (ROW_ID, COLUMN_NAME) COMPRESS 1),
  CONSTRAINT MPVV_MPVR_FK FOREIGN KEY(ROW_ID) 
    REFERENCES MGMT_POLICY_VIOLATION_ROWS(ROW_ID) 
    ON DELETE CASCADE
)  MONITORING;


rem PURPOSE
rem   This table is used to associate a policy with snapshot's whose refresh will
rem   trigger policy evaluation for targets in this policy.  Using the LIKE operator,
rem   the paterns specified in the snapshot_type and target type are used to
rem   match with the snapshot being refreshed.
rem COLUMNS
rem   POLICY_ID     The ID of the policy
rem   SNAPSHOT_TYPE The type of the snapshot upon refresh of should trigger
rem                 policy evaluation.  
rem   TARGET_TYPE   The type of the target upon refresh of should trigger
rem                 policy evaluation.
CREATE TABLE MGMT_POLICY_SNAPSHOT_CRITERIA
(
  POLICY_ID RAW(&GUID_RAW_LENGTH) NOT NULL,
  SNAPSHOT_TYPE VARCHAR2(&P_SNAPSHOT_TYPE_LENGTH),
  TARGET_TYPE VARCHAR2(&P_TARGET_TYPE_LENGTH),
  CONSTRAINT MPSC_MP_FK FOREIGN KEY( POLICY_ID )
    REFERENCES MGMT_POLICY_GROUP( POLICY_ID ) ON DELETE CASCADE,
  CONSTRAINT MPSC_UK UNIQUE(POLICY_ID, SNAPSHOT_TYPE, 
    TARGET_TYPE)     
) MONITORING;


CREATE TABLE MGMT_POLICY_ERRORS 
(
  OPERATION VARCHAR2(128), 
  DATA VARCHAR2(2000),
  RULE_ID RAW(16), 
  POLICY_ID RAW(16), 
  ERR_TIME DATE, 
  TARGET_GUID RAW(16), 
  ERROR VARCHAR2(2000)
) MONITORING;

*/

rem PURPOSE
rem   This table is used to associate job data with the comparison results
rem   of all the host comparisons that the job entails. For example, if
rem   you compare host h1 with h2 and h3, the corresponding execution id will
rem   be associated with the comparison guids resulting from <h1, h2> and
rem   <h1, h3> comparisons.
rem COLUMNS
rem   EXECUTION_ID - execution id of the job for one to n comparisons
rem   DELTA_COMP_GUID The comparison guid for a host pair involved in
rem                   the one to n hosts comparison. One job guid can be
rem                   associated with more than one comparison guids. the
rem                   on delete cascade may have to be removed and replaced
rem                   with a purge delete policy according to Sriram but
rem                   that discussion was never complete - so I never
rem                   got conveinced about it.
rem   RHS_HOST_NAME name of the rhs host the result of which is stored 
rem                 in this row. (useful in  joins with job related tables/master target 
rem                 tables)
rem
rem   RHS_SNAPSHOT_GUID guid of the rhs configuration for the comparison
rem
rem   NOTES: The constraint with mgmt_job table could not be added because
rem                     a. jobs team discourages adding foreign keys -
rem                         design decison under discussion at the time of check in
rem                     b. the "cascade delete" is supposed to be implemented
rem                         by a callback (the corresponding jobs code is not
rem                         checked in at the time of this check in) - again
rem                         this is  not be the right way to do it - should allow
rem                         foreign keys and indexes on them.

CREATE TABLE MGMT_COMP_RESULT_TO_JOB_MAP
(
  EXECUTION_ID RAW(&GUID_RAW_LENGTH) NOT NULL,
  DELTA_COMP_GUID RAW(&GUID_RAW_LENGTH) NOT NULL,
  RHS_HOST_NAME  VARCHAR2(256) ,
  RHS_SNAPSHOT_GUID RAW(&GUID_RAW_LENGTH),
--  CONSTRAINT MCIJ_JOB_FK FOREIGN KEY( JOB_GUID )
--    REFERENCES MGMT_JOB( JOB_ID ) ON DELETE CASCADE,
  CONSTRAINT MCIJ_CMP_FK FOREIGN KEY( DELTA_COMP_GUID )
    REFERENCES MGMT_DELTA_SAVED_COMPARISON( DELTA_COMP_GUID ) 
      ON DELETE CASCADE
) MONITORING;

rem PURPOSE
rem This table is used to associate a JOB Step ID for a Configuration comparison Job
rem with the RHS_CONFIG_GUID ( RHS configuration guid in the comparison of two configs,
rem which is 1 step of the 1-N configuration comparison job. For example, if a comparison
rem job is submitted for comparing c0 with c1,c2,...,ck and then the job system
rem performs comparison in 3 steps.. like step_id n1,n2,...,nk
rem this table stores the association (n1,c1) (n2,c2),...,(nk,ck)
rem This table is queried at the innermost query in 
rem mgmt_ecm_snapshot.get_multi_configs_comp_summary()
rem COLUMNS
rem STEP_ID - the job step ID for a given pair of configurations being compared
rem RHS_SNAPSHOT_GUID - GUID of the RHS in the pair of configurations being compared
rem EXECUTION_ID - JOB Execution ID of the job, the comparison steps are part of.

CREATE TABLE MGMT_COMP_SNAPSHOT_TO_STEP_MAP
(
  STEP_ID NUMBER NOT NULL,
  RHS_SNAPSHOT_GUID RAW(&GUID_RAW_LENGTH) NOT NULL,
  EXECUTION_ID RAW(&GUID_RAW_LENGTH) NOT NULL,
  CONSTRAINT MGMT_COMP_SNAPSHOT_STEP_MAP_PK PRIMARY KEY(STEP_ID,EXECUTION_ID)
) MONITORING;

rem ********************** CSA TABLES (BEGIN) **************************
rem Much of the following create-table statements is generated from 
rem ECM framework metadata registry script.. Documentation of these tables
rem is in CSA area of files online.

CREATE TABLE "MGMT_ECM_CSA_SNAPSHOT_INFO" (
  "ECM_SNAPSHOT_ID" RAW(&GUID_RAW_LENGTH) NOT NULL CONSTRAINT "MGMT_ECM_CSA_SNAPSHOT_INFO0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "DISPLAY_TARGET_NAME" VARCHAR2(&DISPLAY_TARGET_NAME_LENGTH),
  "SNAPSHOT_TYPE" VARCHAR2(&SNAPSHOT_TYPE_LENGTH),
  "START_TIMESTAMP" DATE,
  "ELAPSED_TIME" NUMBER(16) DEFAULT -1 NOT NULL,
  "STATUS" VARCHAR2(1),
  "MESSAGE" VARCHAR2(4000),
  CONSTRAINT "MGMT_ECM_CSA_SNAPSHOT_INFO_PK" PRIMARY KEY ("ECM_SNAPSHOT_ID")
) MONITORING TABLESPACE &EM_ECM_CSA_TABLESPACE_NAME;

CREATE TABLE "MGMT_ECM_CSA_GENERAL_INFO" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_ECM_CSA_GENERAL_INFO0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "APPLET_VERSION" VARCHAR2(20),
  "CUSTOM_CLASS" VARCHAR2(1000),
  "CUSTOM_CLASS_VERSION" VARCHAR2(1000),
  "TARGET_ID_METHOD" VARCHAR2(100) NOT NULL,
  "OS_USER_NAME" VARCHAR2(500) NOT NULL,
  "BOOT_DISK_VOLUME_SERIAL_NUM" VARCHAR2(100) NOT NULL,
  "HOSTNAME" VARCHAR2(128) NOT NULL,
  "DOMAIN" VARCHAR2(500) NOT NULL,
  "APPID" VARCHAR2(128) DEFAULT 'Default' NOT NULL,
  "TARGET_KEY1" VARCHAR2(4000),
  "TARGET_KEY2" VARCHAR2(4000),
  "TARGET_KEY3" VARCHAR2(4000),
  "PROXY_TARGET_NAME" VARCHAR2(&TARGET_NAME_LENGTH),
  "PROXY_TARGET_DISPLAY_NAME" VARCHAR2(&DISPLAY_TARGET_NAME_LENGTH),
  "PROXY_TARGET_ID" RAW(16),
  "WORST_RULE_STATUS" NUMBER DEFAULT 15 NOT NULL,
  CONSTRAINT "MGMT_ECM_CSA_GENERAL_INFO_PK" PRIMARY KEY ("ECM_SNAPSHOT_ID")
) MONITORING TABLESPACE &EM_ECM_CSA_TABLESPACE_NAME;

CREATE TABLE "MGMT_ECM_CSA" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_ECM_CSA0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "NET_LATENCY_IN_MS" NUMBER,
  "NET_BANDWIDTH_IN_KBITPS" NUMBER,
  "NET_EFFECTIVE_IP" VARCHAR2(20),
  "NET_IP" VARCHAR2(20),
  "NET_SUBNET" VARCHAR2(20),
  "BROWSER_TYPE" VARCHAR2(100),
  "BROWSER_VERSION" VARCHAR2(20),
  "BROWSER_JVM_VENDOR" VARCHAR2(100),
  "BROWSER_JVM_VERSION" VARCHAR2(20),
  "BROWSER_PROXY_SERVER" VARCHAR2(4000),
  "BROWSER_PROXY_EXCEPTIONS" VARCHAR2(4000),
  "BROWSER_CACHE_SIZE_IN_MB" NUMBER,
  "BROWSER_CACHE_UPDATE_FRQ" VARCHAR2(200),
  "BROWSER_HTTP1_1_SUPPORT" VARCHAR2(1),
  "REFERRING_URL_HEADER" VARCHAR2(4000),
  "REFERRING_URL_PARAMS" VARCHAR2(4000),
  "CSA_URL_HEADER" VARCHAR2(4000),
  "CSA_URL_PARAMS" VARCHAR2(4000),
  "DESTINATION_URL_HEADER" VARCHAR2(4000),
  "DESTINATION_URL_PARAMS" VARCHAR2(4000),
  "CONNECTION_TYPE" NUMBER DEFAULT 3,
  "IS_WINDOWS_ADMIN" VARCHAR2(1),
  "WINDOWS_DOMAIN" VARCHAR2(100),
  "AUTO_CONFIG_URL" VARCHAR2(4000),
  "BROWSER_PROXY_ENABLED" VARCHAR2(1),
  CONSTRAINT "MGMT_ECM_CSA_PK" PRIMARY KEY ("ECM_SNAPSHOT_ID")
) MONITORING TABLESPACE &EM_ECM_CSA_TABLESPACE_NAME;

CREATE TABLE "MGMT_ECM_CSA_COOKIES" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_ECM_CSA_COOKIES0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "NAME" VARCHAR2(4000),
  "VALUE" VARCHAR2(4000)
) MONITORING TABLESPACE &EM_ECM_CSA_TABLESPACE_NAME;

CREATE TABLE "MGMT_ECM_CSA_CUSTOM" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_ECM_CSA_CUSTOM0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "TYPE" VARCHAR2(512),
  "NAME" VARCHAR2(512) NOT NULL,
  "TYPE_UI" VARCHAR2(4000),
  "NAME_UI" VARCHAR2(4000),
  "VALUE" VARCHAR2(4000),
  "DISPLAY_UI" VARCHAR2(1),
  "HISTORY_TRACKING" VARCHAR2(1),
  CONSTRAINT "MGMT_ECM_CSA_CUSTOM_PK" UNIQUE ("ECM_SNAPSHOT_ID", "TYPE", "NAME")
) MONITORING TABLESPACE &EM_ECM_CSA_TABLESPACE_NAME;

CREATE TABLE "MGMT_ECM_HW" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_ECM_HW0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "HOSTNAME" VARCHAR2(128),
  "DOMAIN" VARCHAR2(500),
  "VENDOR_NAME" VARCHAR2(128),
  "SYSTEM_CONFIG" VARCHAR2(4000),
  "MACHINE_ARCHITECTURE" VARCHAR2(500),
  "CLOCK_FREQ_IN_MHZ" NUMBER,
  "MEMORY_SIZE_IN_MB" NUMBER,
  "AVAIL_MEMORY_SIZE_IN_MB" NUMBER,
  "LOCAL_DISK_SPACE_IN_GB" NUMBER,
  "AVAIL_LOCAL_DISK_SPACE_IN_GB" NUMBER,
  "CPU_COUNT" NUMBER(8),
  "CPU_BOARD_COUNT" NUMBER(8),
  "IOCARD_COUNT" NUMBER(8),
  "FAN_COUNT" NUMBER(8),
  "POWER_SUPPLY_COUNT" NUMBER(8),
  "BOOT_DISK_VOLUME_SERIAL_NUM" VARCHAR2(100),
  "SYSTEM_BIOS" VARCHAR2(100),
  "SYSTEM_SERIAL_NUMBER" VARCHAR2(100),
  CONSTRAINT "MGMT_ECM_HW_PK" PRIMARY KEY ("ECM_SNAPSHOT_ID")
) MONITORING TABLESPACE &EM_ECM_CSA_TABLESPACE_NAME;

CREATE TABLE "MGMT_ECM_HW_CPU" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_ECM_HW_CPU0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "VENDOR_NAME" VARCHAR2(128),
  "FREQ_IN_MHZ" NUMBER,
  "ECACHE_IN_MB" NUMBER,
  "IMPL" VARCHAR2(500),
  "REVISION" VARCHAR2(2000),
  "MASK" VARCHAR2(500)
) MONITORING TABLESPACE &EM_ECM_CSA_TABLESPACE_NAME;

CREATE TABLE "MGMT_ECM_HW_IOCARD" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_ECM_HW_IOCARD0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "VENDOR_NAME" VARCHAR2(128),
  "NAME" VARCHAR2(128) NOT NULL,
  "FREQ_IN_MHZ" NUMBER,
  "BUS" VARCHAR2(500),
  "REVISION" VARCHAR2(2000)
) MONITORING TABLESPACE &EM_ECM_CSA_TABLESPACE_NAME;

CREATE TABLE "MGMT_ECM_HW_NIC" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_ECM_HW_NIC0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "NAME" VARCHAR2(128),
  "DESCRIPTION" VARCHAR2(500),
  "FLAGS" VARCHAR2(1024),
  "MAX_TRANSFER_UNIT" NUMBER,
  "INET_ADDRESS" VARCHAR2(20),
  "MASK" VARCHAR2(20),
  "BROADCAST_ADDRESS" VARCHAR2(20),
  "MAC_ADDRESS" VARCHAR2(20),
  "HOSTNAME_ALIASES" VARCHAR2(4000),
  "DEFAULT_GATEWAY" VARCHAR2(20),
  "DHCP_ENABLED" VARCHAR2(1)
) MONITORING TABLESPACE &EM_ECM_CSA_TABLESPACE_NAME;

CREATE TABLE "MGMT_ECM_OS" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_ECM_OS0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "NAME" VARCHAR2(128),
  "VENDOR_NAME" VARCHAR2(128),
  "BASE_VERSION" VARCHAR2(100),
  "UPDATE_LEVEL" VARCHAR2(100),
  "DISTRIBUTOR_VERSION" VARCHAR2(100),
  "MAX_SWAP_SPACE_IN_MB" NUMBER,
  "ADDRESS_LENGTH_IN_BITS" VARCHAR2(20),
  "MAX_PROCESS_VIRTUAL_MEMORY" NUMBER,
  "TIMEZONE" VARCHAR2(64),
  "TIMEZONE_REGION" VARCHAR2(64),
  "TIMEZONE_DELTA" NUMBER,
  CONSTRAINT "MGMT_ECM_OS_PK" PRIMARY KEY ("ECM_SNAPSHOT_ID")
) MONITORING TABLESPACE &EM_ECM_CSA_TABLESPACE_NAME;

CREATE TABLE "MGMT_ECM_OS_PROPERTY" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_ECM_OS_PROPERTY0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "SOURCE" VARCHAR2(128),
  "NAME" VARCHAR2(128),
  "VALUE" VARCHAR2(2000),
  CONSTRAINT "MGMT_ECM_OS_PROPERTY_PK" PRIMARY KEY ("ECM_SNAPSHOT_ID", "SOURCE", "NAME")
) MONITORING TABLESPACE &EM_ECM_CSA_TABLESPACE_NAME;

CREATE TABLE "MGMT_ECM_OS_COMPONENT" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_ECM_OS_COMPONENT0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "NAME" VARCHAR2(128),
  "TYPE" VARCHAR2(100),
  "VERSION" VARCHAR2(100),
  "DESCRIPTION" VARCHAR2(2000),
  "INSTALLATION_DATE" DATE
) MONITORING TABLESPACE &EM_ECM_CSA_TABLESPACE_NAME;

CREATE TABLE "MGMT_ECM_OS_FILESYSTEM" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_ECM_OS_FILESYSTEM0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "RESOURCE_NAME" VARCHAR2(128) NOT NULL,
  "MOUNT_LOCATION" VARCHAR2(1024) NOT NULL,
  "TYPE" VARCHAR2(100),
  "DISK_SPACE_IN_GB" NUMBER,
  "AVAIL_DISK_SPACE_IN_GB" NUMBER,
  "LOCAL_DRIVE" VARCHAR2(1),
  "MOUNT_OPTIONS" VARCHAR2(1024)
) MONITORING TABLESPACE &EM_ECM_CSA_TABLESPACE_NAME;

CREATE TABLE "MGMT_ECM_OS_REGISTERED_SW" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_ECM_OS_REGISTERED_SW0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "ID" VARCHAR2(500),
  "NAME" VARCHAR2(128) NOT NULL,
  "VENDOR_NAME" VARCHAR2(128),
  "VERSION" VARCHAR2(100),
  "INSTALLATION_DATE" DATE,
  "INSTALLED_LOCATION" VARCHAR2(1024),
  "DESCRIPTION" VARCHAR2(2000),
  "VENDOR_SW_SPECIFIC_INFO" VARCHAR2(4000)
) MONITORING TABLESPACE &EM_ECM_CSA_TABLESPACE_NAME;

CREATE TABLE "MGMT_ECM_OS_REGISTERED_SW_COMP" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_ECM_OS_REGISTERED_SW_C0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "ID" VARCHAR2(500),
  "NAME" VARCHAR2(128) NOT NULL,
  "TYPE" VARCHAR2(100) NOT NULL,
  "VERSION" VARCHAR2(100),
  "DESCRIPTION" VARCHAR2(2000),
  "INSTALLATION_DATE" DATE
) MONITORING TABLESPACE &EM_ECM_CSA_TABLESPACE_NAME;

CREATE TABLE "MGMT_ECM_CSA_RULES" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_ECM_CSA_RULES0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "NAME" VARCHAR2(128),
  "DESCRIPTION" VARCHAR2(256),
  "STATUS" NUMBER,
  "MOREINFO" VARCHAR2(1024),
  CONSTRAINT "MGMT_ECM_CSA_RULES_PK" PRIMARY KEY ("ECM_SNAPSHOT_ID", "NAME")
) MONITORING TABLESPACE &EM_ECM_CSA_TABLESPACE_NAME;

CREATE TABLE "MGMT_ECM_CSA_OUT_OF_BOX" (
  "STATUS" NUMBER DEFAULT 0 NOT NULL
) MONITORING;
rem Notes
rem
rem ECM_SNAPSHOT_ID and ID in MGMT_ECM_OS_REGISTERED_SW_COMP table is 
rem essentially a foreign key into MGMT_ECM_OS_REGISTERED_SW table. However,
rem since ID is not always filled in in MGMT_ECM_OS_REGISTERED_SW table 
rem (in particular when MGMT_ECM_OS_REGISTERED_SW_COMP is empty for such 
rem software), we cannot create a uniqueness constraint there on 
rem snapshot id / id pair. Thus, we cannot create foreign key constrain in 
rem MGMT_ECM_OS_REGISTERED_SW_COMP table referencing 
rem MGMT_ECM_OS_REGISTERED_SW table.


CREATE TABLE "MGMT_ECM_CSA_FAILED" (
  "ID" RAW(16) DEFAULT SYS_GUID() NOT NULL,
  "TIMESTAMP" DATE,
  "TIMEZONE_DELTA" NUMBER,
  "SAVED_TIMESTAMP" DATE DEFAULT SYSDATE NOT NULL,
  "EFFECTIVE_IP" VARCHAR2(20),
  "APPID" VARCHAR2(128),
  "REFERRING_URL_HEADER" VARCHAR2(4000),
  "REFERRING_URL_PARAMS" VARCHAR2(4000),
  "CSA_URL_HEADER" VARCHAR2(4000),
  "CSA_URL_PARAMS" VARCHAR2(4000),
  "DESTINATION_URL_HEADER" VARCHAR2(4000),
  "DESTINATION_URL_PARAMS" VARCHAR2(4000),
  "BROWSER_TYPE" VARCHAR2(100),
  "BROWSER_VERSION" VARCHAR2(20),
  "BROWSER_JVM_VENDOR" VARCHAR2(100),
  "BROWSER_JVM_VERSION" VARCHAR2(20),
  "OS_ARCH" VARCHAR2(100),
  "OS_NAME" VARCHAR2(100),
  "HTTP_REQUEST_USER_AGENT" VARCHAR2(100),
  "ERROR_CODE" VARCHAR2(1),
  "ERROR_TEXT" VARCHAR2(1024)
) MONITORING TABLESPACE &EM_ECM_CSA_TABLESPACE_NAME;

rem Per Ravi's email, TARGET_GUID column should NOT have referencial constraint to the mgmt_targets table
rem and the rows from this table will be removed automatically when the target is deleted.

CREATE TABLE "MGMT_ECM_CSA_APPID_TARGET_MAP" (
  "APPID" VARCHAR2(128),
  "TARGET_GUID" RAW(16) NOT NULL,
  CONSTRAINT "MGMT_ECM_CSA_APPID_TARGET_UK" UNIQUE ("APPID", "TARGET_GUID")
) MONITORING;

rem ********************** CSA TABLES (END) **************************

rem
rem  PURPOSE
rem
rem     The MGMT_AVAILABLE_SEARCHES table contains entries as entered by
rem     search integrators. 
rem
rem  COLUMNS
rem     TARGET_TYPE   - Target Type for which the search is applicable.
rem     CLASSNAME     - Java class name where other search details can be found.
rem                     Other search details are search page URL, search pulldown
rem                     Label and so on.
rem     SRCH_TYPE     - Each search has a search type.
rem  NOTES
rem     Example Entry: oracle_database, "oracle.sysman.db.adm.initSearch",INIT_PARAMS_SRCH
rem
CREATE TABLE "MGMT_AVAILABLE_SEARCHES" (
  "TARGET_TYPE" VARCHAR2(64) NOT NULL, 
  "CLASSNAME" VARCHAR2(256) NOT NULL, 
  "SRCH_TYPE" VARCHAR2(64) NOT NULL,
   CONSTRAINT "MGMT_ECM_AS_KEY" PRIMARY KEY ("TARGET_TYPE", "CLASSNAME","SRCH_TYPE")
  )
  MONITORING;
  

rem     PATCH_TYPE   Describes is it is a Patch or PatchSet
rem     CERTIFY_DATE The data on which this Patch was certified.
rem
CREATE TABLE MGMT_BUG_PATCH_CERTIFICATE
(
    PATCH_ID     NUMBER         NOT NULL,
    RELEASE_ID   NUMBER         NOT NULL,
    PLATFORM_ID  NUMBER         NOT NULL,
    PRODUCT      NUMBER         NOT NULL,
    PATCH_TYPE   VARCHAR2(32)   NOT NULL,
    CERTIFY_DATE DATE           NOT NULL,
    CONSTRAINT   MBPC_PK PRIMARY KEY (PATCH_ID, RELEASE_ID, PLATFORM_ID)
  )
  MONITORING;

rem Create Host Patching tables.
@&EM_SQL_ROOT/core/latest/ecm/ecm_hostpatch_tables.sql

rem Create table to store the data for the CPF METRIC source.
rem The table will be populated at the time of RefreshFromMetalink job execution.
rem The procedure CPF_POLICY.SETUP_CPF_METRIC_SOURCE will populate this table.
rem
CREATE TABLE MGMT_CPF_METRIC_SOURCE
(
  ADVISORY_NAME VARCHAR2(128) NOT NULL,
  IMPACT VARCHAR2(128),
  ADVISORY_ABSTRACT VARCHAR2(1024),
  HOME_LOCATION_DISPLAY VARCHAR2(1000),
  HOME_LOCATION VARCHAR2(128)  NOT NULL,
  HOST_NAME VARCHAR2(256)  NOT NULL,
  ADVISORY_URL VARCHAR2(256),
  PATCH_GUIDS VARCHAR2(4000)  NOT NULL,
  TARGET_GUID RAW(16)  NOT NULL,
  PATCHES VARCHAR2(2000),
  CONTAINER_GUID RAW(16) NOT NULL,
  IS_VALID VARCHAR2(10) NOT NULL,
  CPF_VIOLATION_GUID RAW(&GUID_RAW_LENGTH) DEFAULT SYS_GUID() NOT NULL,
  CONSTRAINT MCMS_PK PRIMARY KEY ( CONTAINER_GUID, TARGET_GUID, HOST_NAME, HOME_LOCATION, ADVISORY_NAME)
) MONITORING;

rem Create uln tables
@&EM_SQL_ROOT/core/latest/ecm/ecm_hostpatch_uln_tables.sql

