Rem drv: <create type="triggers" pos="credentials/credentials_triggers.sql+"/>
Rem
Rem $Header: ecm_triggers.sql 01-jul-2005.22:01:40 gsbhatia Exp $
Rem
Rem ecm_triggers.sql
Rem
Rem Copyright (c) 2003, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ecm_triggers.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    asaraswa    10/14/04 - adding trigger for default collector tag on 
Rem                           mgmt_ecm_csa_failed table 
Rem    vkhizder    09/03/04 - extending ecm framework 
Rem    groyal      10/09/03 - Remove triggers on mgmt_policy_rollups 
Rem    shuberma    05/20/03 - Severity now Priority
Rem    shuberma    05/08/03 - Adding count to history calculation
Rem    shuberma    05/06/03 - Adding historical triggers for rules and policies
Rem    shuberma    05/02/03 - shuberma_policy_history
Rem    shuberma    05/02/03 - Fixing compilation problem
Rem    shuberma    05/01/03 - Created
Rem

rem   This trigger will populate FULL_TABLE_PATH column.
CREATE OR REPLACE TRIGGER ecm_md_tables_tr
   BEFORE INSERT OR UPDATE OF ui_name
   ON MGMT_ECM_SNAPSHOT_MD_TABLES FOR EACH ROW
DECLARE
  l_full_parent_path VARCHAR2(1000);
BEGIN
  BEGIN
    SELECT FULL_TABLE_PATH INTO l_full_parent_path
    FROM MGMT_ECM_SNAPSHOT_MD_TABLES t
    WHERE t.METADATA_ID = :new.METADATA_ID
      AND t.NAME = :new.PARENT_TABLE_NAME;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN NULL;
  END;

  IF (l_full_parent_path IS NULL) THEN
    :new.FULL_TABLE_PATH := :new.NAME;
  ELSE
    :new.FULL_TABLE_PATH := l_full_parent_path || '|' || :new.NAME;
  END IF;

  -- If the ui_name is null, then default it to the internal name 
  IF (:new.ui_name IS NULL) THEN
    :new.ui_name := :new.name;
  END IF;

END;
/
show errors;

CREATE OR REPLACE TRIGGER ecm_md_columns_tr
   BEFORE INSERT OR UPDATE OF ui_name 
   ON MGMT_ECM_SNAPSHOT_MD_COLUMNS FOR EACH ROW
BEGIN
  -- If the ui_name is null, then default it to the internal name     
  IF (:new.ui_name IS NULL) THEN
    :new.ui_name := :new.name;
  END IF;

END;
/
show errors;

CREATE OR REPLACE TRIGGER ecm_metadata_tr
   BEFORE INSERT OR UPDATE OF ui_name
   ON MGMT_ECM_SNAPSHOT_METADATA FOR EACH ROW
BEGIN
  IF (:new.ui_name IS NULL) THEN
    :new.ui_name := :new.snapshot_type || ' for ' || :new.target_type;
  END IF;

END;
/
show errors;

