Rem drv: <create type="type_bodys" pos="metric/metric_type_bodys.sql+"/>
Rem
Rem $Header: ecm_type_bodies.sql 01-jul-2005.22:37:42 gsbhatia Exp $
Rem
Rem ecm_types.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ecm_type_bodies.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    groyal      02/16/05 - Comment out obsolete policy types 
Rem    shuberma    10/30/03 - Adding call to logg error in evaluate 
Rem    groyal      10/09/03 - Policy performance work 
Rem    shuberma    10/06/03 - Adding target bindlist to evaluate method 
Rem    groyal      09/04/03 - Fix problem with key string 
Rem    groyal      07/17/03 - Tweak policy column definition
Rem    shuberma    06/18/03 - Removing empty type body
Rem    shuberma    06/12/03 - Removing comment
Rem    shuberma    06/11/03 - Delta entry recorded needs to save to repository
Rem    groyal      06/05/03 - Minor policy api changes
Rem    shuberma    05/20/03 - Changing rule definition
Rem    shuberma    05/14/03 - Author to rule
Rem    groyal      04/30/03 - Fix a couple problems
Rem    aholser     04/19/03 - fix createrep
Rem    shuberma    04/18/03 - Adding ECM to prefix some types
Rem    shuberma    04/11/03 - Adding ecm_rule object
Rem    shuberma    12/02/02 - shuberma_fix_type_dependency
Rem    shuberma    12/02/02 - Must create body in separate file.  This will be the body file

rem Import defines used for ecm scripts.
@&EM_SQL_ROOT/core/latest/ecm/ecm_defines.sql

rem
rem  PURPOSE
rem     This object, derived from MGMT_DELTA_RECORDER is used to record delta 
rem     entries for comparison.  It essentially add a MGMT_DELTA_ENTRY to its
rem     member table, DELTA_ENTRIES.
rem
rem  COLUMNS
rem     SUMMARY           A list of MGMT_DELTA_SUMMARY object, one for each
rem                       collection type.  This makes up a summary of differences
rem                       found for the collection.  Inherited from supertype.
rem     DELTA_ENTRIES     A list of MGMT_DELTA_ENTRY objects recorded by the 
rem                       record_delta method.
rem
rem  METHODS
rem   RECORD_DELTA
rem     This procedure, which must be overridden by subtypes, is used to record
rem     a delta value.  Since where the delta value is recorded depends upon the
rem     user, the subtypes Must override this method.
rem     PARAMETERS
rem       DELTA_ENTRY   This is an object representing a delta.  It contains the 
rem                     following fields.
rem           COLLECTION_TYPE   This is a string that defines the collection type 
rem                             of the summary.  
rem
rem           KEY_COLUMNS       A list of key columns (name and value) that make of 
rem                             the key of the delta entry.
rem
rem           NON_KEY_COLUMNS   A list of the non key columns with values for both the
rem                             first and second comparison object.
rem
rem           OPERATION         This is the number of rows that are in the right set
rem                             but have no match on the left.

CREATE OR REPLACE TYPE BODY MGMT_DELTA_ENTRY_RECORDER AS
  OVERRIDING MEMBER 
    PROCEDURE RECORD_SUMMARY( p_deltaSummary MGMT_DELTA_SUMMARY )
  IS
  BEGIN
    INSERT INTO MGMT_DELTA_COMP_SUMMARIES( DELTA_COMP_GUID,
                                           COLLECTION_TYPE,
                                           DIFFERENT_COUNT,
                                           LEFT_COUNT,
                                           RIGHT_COUNT,
                                           ERRORS )
      VALUES ( COMP_GUID,
               p_deltaSummary.COLLECTION_TYPE,
               p_deltaSummary.DIFFERENT_COUNT,
               p_deltaSummary.LEFT_NEW_COUNT,
               p_deltaSummary.RIGHT_OLD_COUNT,
               p_deltaSummary.ERRORS );

    RETURN;
  END RECORD_SUMMARY;
  
  OVERRIDING MEMBER
    PROCEDURE RECORD_DELTA( p_deltaEntry MGMT_DELTA_ENTRY_OBJ )
  IS
    l_tempKeyGuid RAW(16);    -- For key guid for the id of the row delta.
  BEGIN
    l_tempKeyGuid := sys_guid();
    -- First the entry that represents the row with the delta.
    INSERT INTO MGMT_DELTA_COMPARISON_DELTAS( DELTA_COMP_GUID,
                                              COLLECTION_TYPE,
                                              STATUS,
                                              KEY_GUID )
          VALUES ( COMP_GUID,
                   p_deltaEntry.COLLECTION_TYPE,
                   p_deltaEntry.STATUS,
                   l_tempKeyGuid );

        -- Now the key columns for that row.
    IF p_deltaEntry.KEY_VALUES IS NOT NULL AND
       p_deltaEntry.KEY_VALUES.COUNT > 0
    THEN
          
      FOR k IN p_deltaEntry.KEY_VALUES.FIRST..p_deltaEntry.KEY_VALUES.LAST
      LOOP
        INSERT INTO MGMT_DELTA_COMP_KEY_COLS( DELTA_COMP_GUID,
                                              COLLECTION_TYPE,
                                              KEY_GUID,
                                              NAME,
                                              VALUE,
                                              TYPE )
            VALUES( COMP_GUID,
                    p_deltaEntry.COLLECTION_TYPE,
                    l_tempKeyGuid,
                    p_deltaEntry.KEY_VALUES(k).NAME,
                    p_deltaEntry.KEY_VALUES(k).VALUE,
                    p_deltaEntry.KEY_VALUES(k).TYPE );
      END LOOP;
    END IF;

    -- Now the delta columns for that row.
    IF p_deltaEntry.DELTA_VALUES IS NOT NULL AND
       p_deltaEntry.DELTA_VALUES.COUNT > 0
    THEN
      FOR m IN  p_deltaEntry.DELTA_VALUES.FIRST..p_deltaEntry.DELTA_VALUES.LAST
      LOOP
        INSERT INTO MGMT_DELTA_COMP_DELTA_DETAILS( KEY_GUID,
                                                   NAME,
                                                   LEFT_VALUE,
                                                   RIGHT_VALUE,
                                                   STATUS,
                                                   TYPE )
              VALUES( l_tempKeyGuid,
                      p_deltaEntry.DELTA_VALUES(m).NAME,
                      p_deltaEntry.DELTA_VALUES(m).LEFT_VALUE,
                      p_deltaEntry.DELTA_VALUES(m).RIGHT_VALUE,
                      p_deltaEntry.DELTA_VALUES(m).STATUS,
                      p_deltaEntry.DELTA_VALUES(m).TYPE );
      END LOOP;
    END IF;
    RETURN;
  END RECORD_DELTA;
END;
/

rem
rem  PURPOSE
rem     This object, derived from MGMT_DELTA_RECORDER is used to record delta 
rem     entries for history.  It is used to save history entries using the
rem     MGMT_DELTA.RECORD_OPERATION method.
rem
rem  COLUMNS
rem     SUMMARY           A list of MGMT_DELTA_SUMMARY object, one for each
rem                       collection type.  This makes up a summary of differences
rem                       found for the collection.  Inherited from supertype.
rem
rem  METHODS
rem   RECORD_DELTA
rem     This procedure, which must be overridden by subtypes, is used to record
rem     a delta value.  Since where the delta value is recorded depends upon the
rem     user, the subtypes Must override this method.
rem     PARAMETERS
rem       DELTA_ENTRY   This is an object representing a delta.  It contains the 
rem                     following fields.
rem           COLLECTION_TYPE   This is a string that defines the collection type 
rem                             of the summary.  
rem
rem           KEY_COLUMNS       A list of key columns (name and value) that make of 
rem                             the key of the delta entry.
rem
rem           NON_KEY_COLUMNS   A list of the non key columns with values for both the
rem                             first and second comparison object.
rem
rem           OPERATION         This is the number of rows that are in the right set
rem                             but have no match on the left.

CREATE OR REPLACE TYPE BODY MGMT_HISTORY_ENTRY_RECORDER AS
  OVERRIDING MEMBER 
    PROCEDURE RECORD_SUMMARY( p_deltaSummary MGMT_DELTA_SUMMARY )
  IS
  BEGIN
    -- Don't need summary for history.
    RETURN;
  END RECORD_SUMMARY;

  OVERRIDING MEMBER
  PROCEDURE RECORD_DELTA( p_deltaEntry MGMT_DELTA_ENTRY_OBJ )
  IS
    operation VARCHAR2(10);
  BEGIN
    -- String are hardcoded below because of the way the repository is built.
    -- This file gets created before the plackage where the constants are defined.
    -- Also, one cannot declare object types in a package.
    CASE p_deltaEntry.STATUS
      WHEN 'RIGHT_ONLY' THEN
        operation := 'DELETE';
      WHEN 'LEFT_ONLY' THEN
        operation := 'INSERT';
      WHEN 'DIFFERENT' THEN
        operation := 'UPDATE';
      ELSE
        operation := p_deltaEntry.STATUS;
    END CASE;
    MGMT_DELTA.RECORD_OPERATION( p_deltaEntry.COLLECTION_TYPE,
                                 p_deltaEntry.KEY_VALUES,
                                 p_deltaEntry.DELTA_VALUES,
                                 operation,
                                 HISTORY_TIME );
    RETURN;
  END RECORD_DELTA;
END;
/

rem -------------------------------------------------------------------------------
rem   The following types are obsolete with GC Rel 2.  They had been used to
rem   support the Version 1 policy framework; that is, the framework prior to
rem   the metric/policy unification effort.
rem

/*

-- PURPOSE
--    This object is responsible for evaluating a ECM_RULE.  The EVALUATE
--  method is used to evaluate the rule given an ECM_RULE and target information.
--  It will call the HANDLE_VIOLATION method.  This object is not instantiable.
--  Objects derived from this object must implement the HANDLE_VIOLATIONS method.
-- PURPOSE
--    This object represents an ECM Rule object.  
--  See MGMT_POLICY_RULE,et. al. for more detail.
CREATE OR REPLACE TYPE BODY ECM_RULE AS 
  MEMBER PROCEDURE EVALUATE( p_evalTime DATE, 
                             p_rt_params ECM_RULE_PARAM_LIST, 
                             p_targetClause VARCHAR2,
                             p_targetBindParams VARCHAR2_TABLE )
  IS
    l_query VARCHAR2(32000);
    cur_hdl INTEGER;
    rows_processed INTEGER;
    col_cnt INTEGER;
    rec_tab DBMS_SQL.DESC_TAB;
    col_num NUMBER;
    col_value VARCHAR2(4000);
    l_target_guid RAW(16);
    l_priority VARCHAR2(10);
    l_bindValues ECM_RULE_PARAM_LIST;
    l_violation_values ECM_RULE_VIOLATION_VALUE_LIST;
    l_priority_index NUMBER;
    l_target_guid_index NUMBER;
    l_violation_guid RAW(16);
    l_new_violation BOOLEAN;
    prev_target_guid RAW(16) := NULL;
  BEGIN
    -- First create the rule query ny calling the static utility method
    -- which creates the query given the rule and the target clause.
    l_query := MGMT_ECM_RULES.GET_RULE_QUERY( p_targetClause,
                                              self );

   -- Must use DBMS_SQL package since we do not no what the result will look like
    -- at compile time.
    cur_hdl := DBMS_SQL.OPEN_CURSOR;
    DBMS_SQL.PARSE( cur_hdl, l_query, DBMS_SQL.NATIVE );

    -- Supply the bind variables (parameters) values.
    -- The bind variables are a combination of the default values of the params
    -- that are specified in the rule itself, and the runtime parameters supplied
    -- as a paramater to this method.  The rule defaults are only used if an
    -- override is not supplied in the run-time list.
    
    IF p_rt_params.COUNT > 0
    THEN
        SELECT 
            ECM_RULE_PARAM( rp.param_name, 
                        CASE WHEN pp.param_value IS NOT NULL 
                           THEN pp.param_value ELSE rp.param_value END,
                        rp.display_name,
                        rp.display_format)
        BULK COLLECT INTO l_bindValues
        FROM 
            TABLE(CAST(param_list as ECM_RULE_PARAM_LIST)) rp,
            TABLE(CAST(p_rt_params as ECM_RULE_PARAM_LIST)) pp
        WHERE rp.param_name = pp.param_name(+);    

        -- The l_bindValues is the list of params that will be used to bind with
        -- the sql query.
        FOR i IN l_bindValues.FIRST..l_bindValues.LAST
        LOOP
          DBMS_SQL.BIND_VARIABLE( cur_hdl, l_bindValues(i).param_name, 
                                  l_bindValues(i).param_value );
        END LOOP;
    END IF;

    -- Now bind the target list.
    IF p_targetBindParams.COUNT > 0
    THEN
      FOR i IN p_targetBindParams.FIRST..p_targetBindParams.LAST
      LOOP
        DBMS_SQL.BIND_VARIABLE( cur_hdl, 't' || i, p_targetBindParams(i) );
      END LOOP;
    END IF;

    -- Now execute the query.
    rows_processed := DBMS_SQL.EXECUTE( cur_hdl );

    -- We must call describe columns so we can determine the actual columns 
    -- returned by the  query.  The alternative would have been to have the 
    -- rule explicitly describe all the columns along with their types.  We 
    -- still may make this change if we determine that there is a performance
    -- issue with using DBMS_SQL.
    DBMS_SQL.DESCRIBE_COLUMNS(cur_hdl, col_cnt, rec_tab);

    -- Priority and target_guid are always the last two columns returned
    -- so remember their column index
    l_priority_index := col_cnt-1;
    l_target_guid_index := col_cnt;

    FOR i IN 1..l_priority_index
    LOOP
      DBMS_SQL.DEFINE_COLUMN(cur_hdl, i, col_value, rec_tab(i).col_max_len );
    END LOOP;

    -- Define_column is used to associate a local variable with the output
    -- values.  All queries have a severitiy and target_guid columns as the last
    -- two.
    DBMS_SQL.DEFINE_COLUMN( cur_hdl, l_priority_index, l_priority, rec_tab(l_priority_index).col_max_len );
    DBMS_SQL.DEFINE_COLUMN_RAW( cur_hdl, l_target_guid_index, l_target_guid, 16 );
    
    -- Now we will loop through all the other columns and associate them with
    -- a varchar output column.  Even though we are representing them all as
    -- varchars, we could find our the type from the rec_tab structure.  We do
    -- a similar thing with history and record the types along with the column
    -- differences.  We may wish to to that here as well.

    -- Now fetch each row and write result out to violations table.
    LOOP
      -- Create an empty violation column list.
      l_violation_values := ECM_RULE_VIOLATION_VALUE_LIST();

      -- Fetch a row
      IF DBMS_SQL.FETCH_ROWS( cur_hdl) > 0
      THEN
        -- Now grab each column and add it to the column list for this row.
        FOR i IN 1..l_priority_index
        LOOP
          DBMS_SQL.COLUMN_VALUE( cur_hdl, i, col_value );

          l_violation_values.EXTEND;
          l_violation_values(l_violation_values.LAST) := 
              ECM_RULE_VIOLATION_VALUE( rec_tab(i).col_name, col_value );
        END LOOP;
        -- Grab the rows severity and target guid.
        DBMS_SQL.COLUMN_VALUE( cur_hdl, l_priority_index, l_priority );
        DBMS_SQL.COLUMN_VALUE_RAW( cur_hdl, l_target_guid_index, l_target_guid );
         
        -- Done with a row... pass the resulting row structure to the handle_violation
        -- method.         
        IF (prev_target_guid IS NULL OR l_target_guid <> prev_target_guid)
        THEN
            GET_VIOLATION_GUID( l_target_guid, l_violation_guid, l_new_violation );
            prev_target_guid := l_target_guid;
        END IF;
        
        HANDLE_VIOLATION( p_evalTime, l_target_guid, l_violation_guid, l_new_violation, l_priority, l_violation_values );
      ELSE
        EXIT;
      END IF;
    END LOOP;
    DBMS_SQL.CLOSE_CURSOR( cur_hdl );
    RETURN;
  EXCEPTION
    WHEN OTHERS THEN
      DBMS_SQL.CLOSE_CURSOR( cur_hdl );
      MGMT_ECM_POLICY.RAISE_EVALUATE_EXCEPTION( l_query );                                   
  END EVALUATE;

  MEMBER PROCEDURE GET_ROWS_KEY_STRING( p_values ECM_RULE_VIOLATION_VALUE_LIST,
                                        p_key OUT VARCHAR2,
                                        p_allKeyColumns OUT BOOLEAN)
  IS
    l_comma VARCHAR2(3) := '';
  BEGIN
    p_key := NULL;
    p_allKeyColumns := TRUE;
    IF p_values IS NULL OR p_values.COUNT = 0 THEN
      RETURN;
    END IF;
    
    p_key := '';    
    FOR i IN self.column_list.FIRST..self.column_list.LAST 
    LOOP
      IF self.column_list(i).IS_KEY = 'Y' THEN
        p_key := p_key || l_comma || p_values(i).attribute_value;
        l_comma := ',';
      ELSE
        p_allKeyColumns := FALSE;
      END IF;
    END LOOP;
    
  END GET_ROWS_KEY_STRING;
 
END;
/

------------------------------------------------------------------------------------------
-- The ecm_policy_rule body is used to implement the GET_VIOLATION_GUID and
-- HANDLE_VIOLATION method defined in the base class.
CREATE OR REPLACE TYPE BODY ECM_POLICY_RULE AS
  OVERRIDING MEMBER PROCEDURE GET_VIOLATION_GUID( p_targetGuid RAW,
                                                  p_violationGuid OUT RAW,
                                                  p_newViolation OUT BOOLEAN )
  IS
  BEGIN
    p_violationGuid := NULL;
    p_newViolation := FALSE;
    -- First see of there is already a violation entry for this policy-rule-target.
    BEGIN
      SELECT VIOLATION_ID INTO p_violationGuid FROM MGMT_POLICY_VIOLATIONS
        WHERE POLICY_ID = self.policy_id
          AND RULE_ID = self.rule_id
          AND TARGET_GUID = p_targetGuid;
    EXCEPTION
      WHEN NO_DATA_FOUND THEN 
        p_violationGuid := SYS_GUID();
        p_newViolation := TRUE;
        INSERT INTO MGMT_POLICY_VIOLATIONS (POLICY_ID, RULE_ID, TARGET_GUID, VIOLATION_ID)
          VALUES (self.policy_id, self.rule_id, p_targetGuid, p_violationGuid );
    END;    
  END GET_VIOLATION_GUID;

  OVERRIDING MEMBER PROCEDURE HANDLE_VIOLATION( p_evalTime DATE,
                                                p_targetGuid RAW,
                                                p_violationGuid RAW,
                                                p_newViolation BOOLEAN,
                                                p_priority NUMBER,
                                                p_values ECM_RULE_VIOLATION_VALUE_LIST )
  IS
    -- A new row, get a row id.
    l_row_id RAW(16);
    l_key MGMT_POLICY_VIOLATION_ROWS.KEY%TYPE;
    l_allKeyColumns BOOLEAN;
    l_newViolationRow BOOLEAN;
  BEGIN  
    -- Now we need to update the policy_violation_row table.  If there was an
    -- entry in that table that has the same key as this row, then we need to update that row.
    -- Otherwise, we need to create a new row.
    -- First get the key string for this violation:

    self.GET_ROWS_KEY_STRING( p_values, l_key, l_allKeyColumns );

    IF p_newViolation
    THEN
        l_newViolationRow := TRUE;
    ELSE   
        -- Update the entry with the severity
        UPDATE MGMT_POLICY_VIOLATION_ROWS SET PRIORITY = p_priority, LAST_DATE = p_evalTime
          WHERE KEY = l_key and VIOLATION_ID = p_violationGuid
          RETURNING ROW_ID INTO l_row_id;
        
        -- If an update occurred, then we know to delete all the previous row values
        -- for this row and insert the new ones.
        IF SQL%ROWCOUNT <> 0
        THEN
            l_newViolationRow := FALSE;
        ELSE
            l_newViolationRow := TRUE;
        END IF;
    END IF;

    -- If we've seen this violation before and all columns are key
    -- columns then no need to update any of the values in MGMT_POLICY_VIOLATION_VALUES
    IF (NOT l_newViolationRow) AND l_allKeyColumns 
    THEN
        RETURN;
    END IF;
        
    IF l_newViolationRow
    THEN
      -- Insert a new entry
      l_row_id := SYS_GUID();
      INSERT INTO MGMT_POLICY_VIOLATION_ROWS( VIOLATION_ID,
                                              ROW_ID,
                                              KEY,
                                              LAST_DATE,
                                              INITIAL_DATE,
                                              PRIORITY )
        VALUES ( p_violationGuid, l_row_id, l_key, p_evalTime, p_evalTime, p_priority);
    ELSE
      -- Delete old violation column values.
      DELETE FROM MGMT_POLICY_VIOLATION_VALUES
          WHERE ROW_ID = l_row_id;
    END IF;

    -- Now we have a row_id...
    IF p_values IS NOT NULL AND p_values.COUNT > 0
    THEN
      -- Now insert the column values using the violation id, which corresponds
      -- to a policy-row-target triplet, and the row_id which distinguishes between
      -- the possilby multiple rows for a particular violation id.
      FOR i IN p_values.FIRST..p_values.LAST
      LOOP
        INSERT INTO MGMT_POLICY_VIOLATION_VALUES( VIOLATION_ID, 
                                                  ROW_ID, 
                                                  COLUMN_NAME, 
                                                  COLUMN_VALUE )
          VALUES( p_violationGuid, l_row_id,  p_values(i).ATTRIBUTE_NAME, p_values(i).ATTRIBUTE_VALUE );
      END LOOP;
    END IF;
    RETURN;
  END HANDLE_VIOLATION;
END;
/

*/
