Rem drv: <create type="types"/>
Rem
Rem $Header: ecm_types.sql 13-dec-2005.23:41:45 lappanmu Exp $
Rem
Rem ecm_types.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ecm_types.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    lappanmu    12/13/05 - XbranchMerge lappanmu_bug-4684929 from main 
Rem    jochen      12/08/05 - Add gendiff types 
Rem    abhalla     09/17/05 - Changes for the CPF related code
Rem    pdasika     09/22/05 - Adding new types for get_homes_all pkg. 
Rem    pdasika     09/11/05 - Adding new types for CPF packages 
Rem    abhalla     08/24/05 - adding PATCH_VALID_STATUS to 
Rem                           MGMT_BUG_ADVISORY_VIOLATION 
Rem    abhalla     07/14/05 - Addition of container_guid to 
Rem                           MGMT_BUG_ADVISORY_VIOLATION 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    pdasika     05/26/05 - Adding home_details record 
Rem    groyal      02/16/05 - Comment out obsolete policy types 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    agor        02/02/05 - fix mem length 
Rem    mnosseir    01/25/05 - add PRODUCT_NAMES to CLONE_SOURCE_RECORD
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    agor        11/05/04 - add types 
Rem    akskumar    10/25/04 - add save composite config result type 
Rem    mningomb    10/21/04 - Inclusion of group cpf data types 
Rem    rpinnama    06/25/04 - Add ecm_inv_types.sql 
Rem    jmansur     10/30/03 - bug 3199957 - to be safe, increase
Rem                           CLONE_SOURCE_RECORD.PRODUCT_VERSIONS length
Rem    groyal      10/30/03 - Add patch type to MGMT_BUG_PATCH_ADVISORIES  
Rem    groyal      10/09/03 - Policy performance work 
Rem    shuberma    10/06/03 - Adding bind param arg to evaluate 
Rem    shuberma    09/09/03 - Adding a temporary type for holding the results 
Rem                           of the patchsql query 
Rem    shuberma    09/08/03 - Factor out bugs and advisories. Get rid of bug 
Rem    shuberma    09/04/03 - Add object and table type for results of cpf 
Rem    jmansur     08/21/03 - add IS_AD_HOC_CLONABLE, PRODUCT_VERSIONS to
Rem                           CLONE_SOURCE_RECORD
Rem    groyal      07/17/03 - Tweak policy column definition
Rem    jmansur     07/14/03 - add oui_platform,home_kind to CLONE_SOURCE_RECORD
Rem    shuberma    06/11/03 - DELTA_ENTRY_RECORDER needs to save to repository
Rem    groyal      06/04/03 - Rework api slightly
Rem    shuberma    05/20/03 - Changing rule definition
Rem    shuberma    05/14/03 - Adding author to rule
Rem    shuberma    04/18/03 - Adding an IS_KEY value to columns
Rem    shuberma    04/10/03 - Adding some types supporting the policy api
Rem    shuberma    02/12/03 - Add emd_url to clone_source_record
Rem    shuberma    01/13/03 - Adding a type to support get_clone_source procedure
Rem    shuberma    12/12/02 - Adding datatype to name_value and delta_value
Rem    shuberma    12/02/02 - Must create body in separate file.  Moving to ecm_type_bodies.sql
Rem    shuberma    11/20/02 - Adding type for recording deltas
Rem    rpinnama    09/18/02 - Make types create or replace
Rem    shuberma    09/20/02 - Add another query to mgmt_delta_query object
Rem    shuberma    09/12/02 - Only pass the one query, so we no longer need both in object
Rem    shuberma    09/05/02 - Updating delta_value and delta_entry_obj
Rem    shuberma    08/22/02 - Adding return types for summary and errors
Rem    shuberma    06/05/02 - Deltaqueries should use deltaValues instead of nameValues for diff attributes..
Rem    shuberma    05/22/02 - Adding MGMT_DELTA_QUERIES type..
Rem    shuberma    05/17/02 - Adding delta entry types..
Rem    rpinnama    05/14/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/14/02 - Created
Rem


rem Import defines used for ecm scripts.
@&EM_SQL_ROOT/core/latest/ecm/ecm_defines.sql


rem
rem PURPOSE
rem   Hold column differences for comparisons and history.
rem
rem COLUMNS
rem   NAME
rem     The name of the column that this delta represents.
rem   LEFT_VALUE
rem     The value of the left side of the comparison, or the new value in history.
rem   RIGHT_VALUE
rem     The value of the right side of the comparison, or the old value in history.
rem   STATUS
rem     The status of the delta.  'SAME', 'DIFFERENT', 'LEFT_ONLY', 'RIGHT_ONLY'.  
rem     For history, left_only can be interpreted has an INSERT and right_only
rem     as a DELETE. 
rem
CREATE OR REPLACE TYPE MGMT_DELTA_VALUE AS OBJECT 
( 
  NAME VARCHAR2(64), 
  LEFT_VALUE VARCHAR2(4000), 
  RIGHT_VALUE VARCHAR2(4000),
  STATUS VARCHAR2(10),
  TYPE CHAR(1)
);
/

CREATE OR REPLACE TYPE MGMT_DELTA_VALUES AS
    TABLE OF MGMT_DELTA_VALUE;
/

CREATE OR REPLACE TYPE MGMT_NAME_VALUE AS
  OBJECT ( NAME VARCHAR2(64), VALUE VARCHAR2(4000), TYPE CHAR(1) );
/

CREATE OR REPLACE TYPE MGMT_NAME_VALUES AS
    TABLE OF MGMT_NAME_VALUE;
/
rem
rem  PURPOSE
rem     This object is use to host/represent a delta entry, or the details
rem     for a row comparison.
rem
rem  COLUMNS
rem
rem     STATUS            This is the status of the rows comparison.  'SAME'
rem                       'DIFFERENT', 'LEFT_ONLY', 'RIGHT_ONLY'.  For history
rem                       LEFT_ONLY means INSERT and RIGHT_ONLY means DELETE.
rem     COLLECTION_TYPE   This is a string that defines the collection type 
rem                       of the delta entry.  
rem
rem     KEY_VALUES        This is a collection of name value pairs that are the
rem                       list of attributes and values that make this delta
rem                       entry unique given the collection type.
rem
rem     DELTA_VALUES      This is a collection of name-old_value-new_value triplets
rem                       that capture the attribute differences.
CREATE OR REPLACE TYPE MGMT_DELTA_ENTRY_OBJ AS OBJECT 
( 
  STATUS VARCHAR2(10),
  COLLECTION_TYPE VARCHAR2(64), 
  KEY_VALUES MGMT_NAME_VALUES, 
  DELTA_VALUES MGMT_DELTA_VALUES 
);
/

rem
rem   PURPOSE   - A collection of mgmt_delta entry objects.
rem
CREATE OR REPLACE TYPE MGMT_DELTA_ENTRIES AS 
    TABLE OF MGMT_DELTA_ENTRY_OBJ;
/

CREATE OR REPLACE TYPE VARCHAR2_TABLE AS TABLE OF VARCHAR2(256);
/
CREATE OR REPLACE TYPE VARCHAR_TABLE AS TABLE OF VARCHAR2(2500);
/


rem
rem  PURPOSE
rem     This object is use to describe a comparison operation and is passed to
rem     the comparison function (DO_DIFF_QUERIES).
rem
rem  COLUMNS
rem
rem     FIRST_QUERY_TEXT   This is the first (left, new) .
rem
rem     SECOND_QUERY_TEXT  This is the second (right, old) .
rem
rem     COLLECTION_TYPE   The name of the collection that these queries are
rem                       running against.
rem
rem     KEY_LIST          This is a list of the key columns used to match left (old)
rem                       and right (new) rows.
rem
rem     ATTRIBUTE_LIST    This is the list of columns whose differences are checked.
rem
rem     ID_LIST           This is a list of columns used to identify the rows as
rem                       being part of a row set (left or right).
rem
CREATE OR REPLACE TYPE MGMT_DELTA_QUERY AS OBJECT
(
  FIRST_QUERY_TEXT VARCHAR2(8000),
  SECOND_QUERY_TEXT VARCHAR2(8000),
  COLLECTION_TYPE VARCHAR2(64),
  KEY_LIST VARCHAR2_TABLE,
  ATTRIBUTE_LIST MGMT_DELTA_VALUES,
  ID_LIST MGMT_DELTA_VALUES,
  FLAGS SMALLINT
);
/

CREATE OR REPLACE TYPE MGMT_DELTA_QUERIES AS 
      TABLE OF MGMT_DELTA_QUERY;
/

rem
rem  PURPOSE
rem     This object is use to return summary information about a comparison. 
rem
rem  COLUMNS
rem
rem     COLLECTION_TYPE   This is a string that defines the collection type 
rem                       of the summary.  
rem
rem     DIFFERENT_COUNT   This is the number of rows whose matching rows were
rem                       different.  i.e. at least one of the attribute column
rem                       were different.
rem
rem     LEFT_NEW_COUNT    This is the number of rows that are in the left set
rem                       but have no match on the right.
rem
rem     RIGHT_OLD_COUNT   This is the number of rows that are in the right set
rem                       but have no match on the left.
rem
rem     ERRORS            This is an table of errors encounter.
CREATE OR REPLACE TYPE MGMT_DELTA_SUMMARY AS OBJECT 
( 
  COLLECTION_TYPE VARCHAR2(64),
  DIFFERENT_COUNT INTEGER, 
  LEFT_NEW_COUNT INTEGER, 
  RIGHT_OLD_COUNT INTEGER,
  ERRORS VARCHAR2_TABLE
);
/

CREATE OR REPLACE TYPE MGMT_DELTA_SUMMARIES AS 
    TABLE OF MGMT_DELTA_SUMMARY;
/



rem
rem  PURPOSE
rem     This non instantiable object is a root object used to record delta 
rem     entries.  History and comparison each use a subtype of this.
rem
rem  COLUMNS
rem
rem  METHODS
rem   RECORD_SUMMARY
rem     This procedure places the new summary object into the collection SUMMARY.
rem   RECORD_DELTA
rem     This procedure, which must be overridden by subtypes, is used to record
rem     a delta value.  Since where the delta value is recorded depends upon the
rem     user, the subtypes Must override this method.
rem     PARAMETERS 
rem       DELTA_ENTRY   This is an object representing a delta.  It contains the 
rem                     following fields.
rem           COLLECTION_TYPE   This is a string that defines the collection type 
rem                             of the summary.  
rem
rem           KEY_COLUMNS       A list of key columns (name and value) that make of 
rem                             the key of the delta entry.
rem
rem           NON_KEY_COLUMNS   A list of the non key columns with values for both the
rem                             first and second comparison object.
rem
rem           OPERATION         This is the number of rows that are in the right set
rem                             but have no match on the left.

CREATE OR REPLACE TYPE MGMT_DELTA_RECORDER AS OBJECT 
(
  HISTORY_TIME DATE,
  NOT INSTANTIABLE MEMBER PROCEDURE RECORD_SUMMARY( p_deltaSummary MGMT_DELTA_SUMMARY ),
  NOT INSTANTIABLE MEMBER PROCEDURE RECORD_DELTA ( p_deltaEntry MGMT_DELTA_ENTRY_OBJ )   
) NOT INSTANTIABLE NOT FINAL;
/


rem
rem  PURPOSE
rem     This object, derived from MGMT_DELTA_RECORDER is used to record delta 
rem     entries for comparison.  It essentially add a MGMT_DELTA_ENTRY to its
rem     member table, DELTA_ENTRIES.
rem
rem  COLUMNS
rem     COMP_GUID         ID of comparison in repository..
rem
rem  METHODS
rem   RECORD_DELTA
rem     This procedure, which must be overridden by subtypes, is used to record
rem     a delta value.  Since where the delta value is recorded depends upon the
rem     user, the subtypes Must override this method.
rem     PARAMETERS
rem       DELTA_ENTRY   This is an object representing a delta.  It contains the 
rem                     following fields.
rem           COLLECTION_TYPE   This is a string that defines the collection type 
rem                             of the summary.  
rem
rem           KEY_COLUMNS       A list of key columns (name and value) that make of 
rem                             the key of the delta entry.
rem
rem           NON_KEY_COLUMNS   A list of the non key columns with values for both the
rem                             first and second comparison object.
rem
rem           OPERATION         This is the number of rows that are in the right set
rem                             but have no match on the left.

CREATE OR REPLACE TYPE MGMT_DELTA_ENTRY_RECORDER UNDER MGMT_DELTA_RECORDER
(
  COMP_GUID RAW(16),
  OVERRIDING MEMBER PROCEDURE RECORD_SUMMARY( p_deltaSummary MGMT_DELTA_SUMMARY ),
  OVERRIDING MEMBER 
    PROCEDURE RECORD_DELTA( p_deltaEntry MGMT_DELTA_ENTRY_OBJ ) 
);
/

rem
rem  PURPOSE
rem     This object, derived from MGMT_DELTA_RECORDER is used to record delta 
rem     entries for history.  It is used to save history entries using the
rem     MGMT_DELTA.RECORD_OPERATION method.
rem
rem  COLUMNS
rem     SUMMARY           A list of MGMT_DELTA_SUMMARY object, one for each
rem                       collection type.  This makes up a summary of differences
rem                       found for the collection.  Inherited from supertype.
rem
rem  METHODS
rem   RECORD_DELTA
rem     This procedure, which must be overridden by subtypes, is used to record
rem     a delta value.  Since where the delta value is recorded depends upon the
rem     user, the subtypes Must override this method.
rem     PARAMETERS
rem       DELTA_ENTRY   This is an object representing a delta.  It contains the 
rem                     following fields.
rem           COLLECTION_TYPE   This is a string that defines the collection type 
rem                             of the summary.  
rem
rem           KEY_COLUMNS       A list of key columns (name and value) that make of 
rem                             the key of the delta entry.
rem
rem           NON_KEY_COLUMNS   A list of the non key columns with values for both the
rem                             first and second comparison object.
rem
rem           OPERATION         This is the number of rows that are in the right set
rem                             but have no match on the left.

CREATE OR REPLACE TYPE MGMT_HISTORY_ENTRY_RECORDER UNDER MGMT_DELTA_RECORDER
(
  OVERRIDING MEMBER PROCEDURE RECORD_SUMMARY( p_deltaSummary MGMT_DELTA_SUMMARY ),
  OVERRIDING MEMBER 
    PROCEDURE RECORD_DELTA( p_deltaEntry MGMT_DELTA_ENTRY_OBJ ) 
);
/

rem
rem  PURPOSE
rem     This object is used to store the results from the get_clone_source function
rem     call.  It is primarily used internally within that function since
rem     the function returns a ref cursor where each fetch row is one of these
rem     objects.  
rem
rem  COLUMNS
rem     HOME_LOCATION
rem         This is the path of the oracle home
rem     HOME_NAME
rem         This is the name of the oracle home
rem     HOST_NAME
rem         This is the host name of on which the oracle home resides.
rem     PLATFORM
rem         This is the platform (e.g. SunOS) of the host on which this oracle
rem         home resides.
rem     ADDRESS_SIZE
rem         This is the address_size (e.g. 32, 64...) of the host on which this
rem         home resides.
rem     TARGETS
rem         This is a comma separated list of target name whose oracle home
rem         property indicates this oracle home.  The list is a string.
rem     PRODUCTS
rem         This is a comma separated list of top level products that are installed 
rem         in this home.  The list is a string.

CREATE OR REPLACE TYPE CLONE_SOURCE_RECORD AS OBJECT 
(
  HOME_LOCATION VARCHAR2(128),
  HOME_NAME VARCHAR2(64),
  HOST_NAME VARCHAR2(256),
  PLATFORM VARCHAR2(150),
  ADDRESS_SIZE VARCHAR2(10),
  TARGETS VARCHAR2(4000),
  PRODUCTS VARCHAR2(4000),
  EMD_URL VARCHAR2(2000),
  OUI_PLATFORM VARCHAR2(16), -- oui platform id, e.g., '453' for solaris
  HOME_TYPE VARCHAR2(16), -- 'db' or 'ias', NULL if home is built-in-clonable
  IS_AD_HOC_CLONABLE VARCHAR2(16), -- 'true' if home is ad-hoc-clonable
  PRODUCT_VERSIONS VARCHAR2(256), -- e.g., '9.2.0.4.0, 9.2.0.3.0'
  PRODUCT_INTERNAL_NAMES VARCHAR2(2000) -- 'oracle.rdbms', 'oracle.iappserver.iapptop' ...
);
/
CREATE OR REPLACE TYPE CLONE_SOURCE_TABLE AS TABLE OF CLONE_SOURCE_RECORD;
/


rem -------------------------------------------------------------------------------
rem   The following types are obsolete with GC Rel 2.  They had been used to
rem   support the Version 1 policy framework; that is, the framework prior to
rem   the metric/policy unification effort.
rem

/*
--------------------------------------------------------------------------------
--  POLICY API
-- The following types are for use by the POLICY API.
-- The API requires that the user pass lists of objects such as rule columns, 
-- rule parameters, policy criteria....

rem           RULE_COLUMN
rem  PURPOSE
rem     The object is used to represent individual rule columns.  A list (table)
rem   of these is passed along with its parent rule in CREATE_POLICY_RULE().
rem
rem  COLUMNS
rem     COLUMN_NAME     The name of the column.
rem     IS_KEY          Is the column a key, 'Y' or 'N'?
rem     IS_VISIBLE      Should this column be visible in UI, , 'Y' or 'N'?
rem     URL             URL template with column names for substitution.
rem     DISPLAY_NAME    Name to display if resource (using COLUMN_NAME) can't be
rem                     found
rem     DISPLAY_FORMAT  Display format to use when displaying the row-column
rem                       values in the UI.  0,1,2 (textFormat, numberFormat,
rem                       dateFormat)
rem
CREATE OR REPLACE TYPE ECM_RULE_COLUMN AS OBJECT
(
  COLUMN_NAME VARCHAR2( &P_COLUMN_NAME_LENGTH ),
  IS_KEY VARCHAR2( &P_Y_N_LENGTH ),
  IS_VISIBLE VARCHAR2( &P_Y_N_LENGTH ),
  URL VARCHAR2( &P_URL_LENGTH ),
  DISPLAY_NAME VARCHAR2( &P_COLUMN_NAME_LENGTH ),
  DISPLAY_FORMAT NUMBER (&P_REASONABLE_NUMBER_LENGTH )
);
/

CREATE OR REPLACE TYPE ECM_RULE_COLUMN_LIST AS TABLE OF ECM_RULE_COLUMN;
/


rem           RULE_PARAM
rem  PURPOSE
rem     The object is used to represent individual rule paramaters.  A list (table)
rem   of these is passed along with it's parent rule in CREATE_POLICY_RULE().
rem
rem  COLUMNS
rem     PARAM_NAME      The name of the parameter.  Used for binding the 
rem                       parameter value to the placeholders in the rule predicates.
rem     PARAM_VALUE     The value of the parameter, used as a default if the 
rem                       policy using the rule doesn't override it.
rem     DISPLAY_NAME    Name to display if resource (using COLUMN_NAME) can't be
rem                     found
rem     DISPLAY_FORMAT  Display format to use when displaying the parameter
rem                       values in the UI.  0,1,2 (textFormat, numberFormat,
rem                       dateFormat)
rem
CREATE OR REPLACE TYPE ECM_RULE_PARAM AS OBJECT
(
  PARAM_NAME VARCHAR2( &P_PARAM_NAME_LENGTH ),
  PARAM_VALUE VARCHAR2( &P_PARAM_VALUE_LENGTH ),
  DISPLAY_NAME VARCHAR2( &P_PARAM_NAME_LENGTH ),
  DISPLAY_FORMAT NUMBER (&P_REASONABLE_NUMBER_LENGTH )
);
/

CREATE OR REPLACE TYPE ECM_RULE_PARAM_LIST AS TABLE OF ECM_RULE_PARAM;
/

rem           ECM_RULE_VIOLATION_VALUE
rem
rem PURPOSE
rem   Rule violation rows can be represented as a list of name value pairs for
rem   each column/attribute in the result set of the rule object.  The 
rem   RULE_VIOLATION_VALUE object is used to represent each attribute/column
rem   name-value pair.
CREATE OR REPLACE TYPE ECM_RULE_VIOLATION_VALUE AS OBJECT
(
  ATTRIBUTE_NAME VARCHAR2( &P_ATTRIBUTE_NAME_LENGTH ),
  ATTRIBUTE_VALUE VARCHAR2( &P_ATTRIBUTE_VALUE_LENGTH )
);
/

CREATE OR REPLACE TYPE ECM_RULE_VIOLATION_VALUE_LIST AS TABLE OF ECM_RULE_VIOLATION_VALUE;
/


rem           POLICY_PARAM
rem  PURPOSE
rem     The object is used to represent individual policy paramaters.  A list 
rem   (table) of these is passed along with its parent rule in 
rem   CREATE_POLICY_GROUP().  The values of these are used to override rule 
rem   parameters with the same name.  The authore target_type, category and
rem   rule name are used to determine which rules the parameter applies to.  
rem   This can be more than one since they can be wildcarded strings.
rem
rem  COLUMNS
rem     AUTHOR            The rule author....Used to determin which rules in the
rem                   policy this parameter can be applied to.
rem     TARGET_TYPE       A string used to determine which rules in the policy
rem                   this parameter can be applied to.  Rules are identified by
rem                   their name, target_type and category.
rem     CATEGORY          A string used to determine which rules in the policy
rem                   this parameter can be applied to.  Rules are identified by
rem                   their name, target_type and category.
rem     RULE_NAME         A string used to determine which rule in the policy 
rem                   that this parameter can be applied to.  It can be a wildcarded
rem                   string.
rem     PARAM_NAME        The name of the parameter.  Used for binding the 
rem                   parameter value to the placeholders in the rule predicates.
rem     PARAM_VALUE       The value of the parameter, used as a default if the 
rem                   policy using the rule doesn't override it.
rem
CREATE OR REPLACE TYPE ECM_POLICY_PARAM AS OBJECT
(
  AUTHOR VARCHAR2( &P_AUTHOR_LENGTH ),
  TARGET_TYPE VARCHAR2( &P_TARGET_TYPE_LENGTH ), 
  CATEGORY VARCHAR2( &P_CATEGORY_LENGTH ), 
  RULE_NAME VARCHAR2( &P_RULE_NAME_LENGTH ), 
  PARAM_NAME VARCHAR2( &P_PARAM_NAME_LENGTH ), 
  PARAM_VALUE VARCHAR2( &P_PARAM_VALUE_LENGTH ) 
);
/

CREATE OR REPLACE TYPE ECM_POLICY_PARAM_LIST AS TABLE OF ECM_POLICY_PARAM;
/

rem           POLICY_RULE_CRITERION
rem  PURPOSE
rem     A policy must specify criteria that is used at run-time to determine 
rem     which rules are to be evaluated.  Rules are identified by their author,  
rem     target_type, category and rule name.  The values in this object can be 
rem     wild-carded allowing a single criterion to refer to multiple rules, the 
rem     set of which is determined each time a policy is evaluated.
rem
rem  COLUMNS
rem     AUTHOR            The rule author.
rem     TARGET_TYPE       A string used to determine which rules should be
rem                   evaluated when the policy is checked.  Rules are identified by
rem                   their name, target_type and category.
rem     CATEGORY          A string used to determine which rules should be
rem                   evaluated when the policy is checked.   Rules are identified by
rem                   their name, target_type and category.
rem     RULE_NAME         A string used to determine which rules should be
rem                   evaluated when the policy is checked.  It can be a wildcarded
rem                   string.
rem
CREATE OR REPLACE TYPE ECM_POLICY_RULE_CRITERION AS OBJECT
(
  AUTHOR VARCHAR2( &P_AUTHOR_LENGTH ),
  TARGET_TYPE VARCHAR2( &P_TARGET_TYPE_LENGTH ), 
  CATEGORY VARCHAR2( &P_CATEGORY_LENGTH ),
  RULE_NAME VARCHAR2( &P_RULE_NAME_LENGTH )
);
/

CREATE OR REPLACE TYPE ECM_POLICY_RULE_CRITERIA AS TABLE OF ECM_POLICY_RULE_CRITERION;
/

rem           POLICY_TARGET_CRITERION
rem  PURPOSE
rem     A policy must specify criteria that is used at run-time to determine 
rem     which targets the rules are to be evaluated against.  Targets are 
rem     identified by their name and target_type.  The filter op is used to 
rem     indicate "LIKE", or "NOT LIKE". The values in this object can be 
rem     wild-carded allowing a single criterion to refer to multiple targets, 
rem     the set of which is determined each time a policy is evaluated.
rem
rem  COLUMNS
rem     NAME_IS_GROUP     'Y' if the name is a group name to which the criterion says
rem                       any matching target in the group with a matching target
rem                       type is included.
rem     TARGET_TYPE       A string used to determine which targets on which to 
rem                   evaluate the rules.  This can be wildcarded.
rem     TARGET_NAME          A string used to determine which targets on which to 
rem                   evaluate the rules.  This can be wildcarded.
rem     FILTER_OP          A string indicating how to match the targets.
rem
CREATE OR REPLACE TYPE ECM_POLICY_TARGET_CRITERION AS OBJECT
(
  NAME_IS_GROUP VARCHAR2(&P_Y_N_LENGTH),
  TARGET_TYPE VARCHAR2( &P_TARGET_TYPE_LENGTH ), 
  TARGET_NAME VARCHAR2( &P_TARGET_NAME_LENGTH ), 
  FILTER_OP VARCHAR2( &P_FILTER_OP_LENGTH ) 
);
/

CREATE OR REPLACE TYPE ECM_POLICY_TARGET_CRITERIA IS TABLE OF ECM_POLICY_TARGET_CRITERION;
/

rem           ECM_RULE
rem  PURPOSE
rem    This object represents an ECM Rule object.  It is a non-instantiable, 
rem    meaning one must create a subtype that implements the HANDLE_VIOLATION
rem    method.  See MGMT_POLICY_RULE, et. al. for more detail of the attributes. 
rem    In general, this object should have all columns in that table 
rem    represented as members.
rem  METHODS:
rem    EVALUATE:
rem    The method EVALUATE is used to evaluate the rule, Parameters to EVALUATE 
rem    are:
rem      p_evalTime - evaluation time which is used to ensure that all rule 
rem        violations detected can use the same timestamp is so desired.
rem      p_rt_params - A list of parameter name value pairs used to override the
rem        default parameters of this rule.  For policies, these are the policy
rem        params.
rem      p_targetClause - a select statement that defines the set of targets 
rem        againsts which the rules are evaluated.
rem    GET_VIOLATION_GUID:
rem    This method is to be overrided and is meant to return a unique id 
rem    for the violation  
rem    HANDLE_VIOLATION:
rem    This method is to be overrided and is meant to handle each row violation 
rem    found.  For Policies, the method would write the results to a database
rem    table.  
CREATE OR REPLACE TYPE ECM_RULE AS OBJECT
(
  AUTHOR VARCHAR(&P_AUTHOR_LENGTH),
  TARGET_TYPE VARCHAR2(&P_TARGET_TYPE_LENGTH),
  CATEGORY VARCHAR2(&P_CATEGORY_LENGTH),
  RULE_NAME VARCHAR2(&P_RULE_NAME_LENGTH),
  DISPLAY_ID VARCHAR2(&P_DISPLAY_ID_LENGTH),
  DESCRIPTION VARCHAR2(&P_DESCRIPTION_LENGTH),
  RULE_TYPE VARCHAR2(&P_RULE_TYPE_LENGTH),
  RULE_OBJECT VARCHAR2(&P_LARGE_VARCHAR_LENGTH),
  TEST VARCHAR2(&P_LARGE_VARCHAR_LENGTH),
  PRIORITY NUMBER,
  IMPACT_OF_PROBLEM VARCHAR2(&P_SHORT_DESCRIPTION_LENGTH),
  RECOMMENDATION VARCHAR2(&P_SHORT_DESCRIPTION_LENGTH),
  COLUMN_LIST ECM_RULE_COLUMN_LIST,
  PARAM_LIST ECM_RULE_PARAM_LIST,
  MEMBER PROCEDURE EVALUATE( p_evalTime DATE, 
                             p_rt_params ECM_RULE_PARAM_LIST, 
                             p_targetClause VARCHAR2,
                             p_targetBindParams VARCHAR2_TABLE ),                            
  NOT INSTANTIABLE MEMBER 
         PROCEDURE GET_VIOLATION_GUID( p_targetGuid RAW,
                                       p_violationGuid OUT RAW,
                                       p_newViolation OUT BOOLEAN ),
  NOT INSTANTIABLE MEMBER 
         PROCEDURE HANDLE_VIOLATION( p_evalTime DATE,
                                     p_targetGuid RAW,
                                     p_violationGuid RAW,
                                     p_newViolation BOOLEAN,
                                     p_priority NUMBER,
                                     p_values ECM_RULE_VIOLATION_VALUE_LIST ),
  MEMBER PROCEDURE GET_ROWS_KEY_STRING( p_values ECM_RULE_VIOLATION_VALUE_LIST,
                                        p_key OUT VARCHAR2,
                                        p_allKeyColumns OUT BOOLEAN )
) NOT INSTANTIABLE NOT FINAL;
/

rem           ECM_POLICY_RULE
rem  PURPOSE
rem    This object represents an ECM Rule object for ECM policies.  It includes
rem    a policy id and rule_id members identifying the ids used in the 
rem    repository for this rule.  See MGMT_POLICY_RULE, et. al. for more detail.
rem    This method implements
rem    1.  The GET_VIOLATION_GUID method which returns a unique id for
rem        the violation.
rem    2.  The HANDLE_VIOLATION method such as to write the 
rem    resulting violation rows to the repository MGMT_RULE_VIOLATIONS table.
CREATE OR REPLACE TYPE ECM_POLICY_RULE UNDER ECM_RULE
(
  RULE_ID RAW(16),
  POLICY_ID RAW(16),
  OVERRIDING MEMBER PROCEDURE GET_VIOLATION_GUID( p_targetGuid RAW,
                                                  p_violationGuid OUT RAW,
                                                  p_newViolation OUT BOOLEAN ),
  OVERRIDING MEMBER PROCEDURE HANDLE_VIOLATION( p_evalTime DATE,
                                                p_targetGuid RAW,
                                                p_violationGuid RAW,
                                                p_newViolation BOOLEAN,
                                                p_priority NUMBER,
                                                p_values ECM_RULE_VIOLATION_VALUE_LIST )   
);
/

*/

rem
rem   This object is used to hold the policy violation values temporarily while
rem   being passed back from a function used to calculate the violations.
rem
CREATE OR REPLACE TYPE MGMT_BUG_ADVISORY_VIOLATION AS OBJECT
(
  ADVISORY_NAME VARCHAR2(128), 
  IMPACT VARCHAR2(128), 
  PATCHES VARCHAR2(2000), 
  ADVISORY_ABSTRACT VARCHAR2(1024), 
  HOME_LOCATION_DISPLAY VARCHAR2(1000), 
  HOME_LOCATION VARCHAR2(128), 
  HOST_NAME VARCHAR2(256), 
  ADVISORY_URL VARCHAR2(256), 
  PATCH_GUIDS VARCHAR2(4000),
  REF_PATCH_GUID RAW(16), 
  TARGET_GUID RAW(16) ,
  CONTAINER_GUID RAW(16),
  PATCH_VALID_STATUS VARCHAR2(10)
);
/

CREATE OR REPLACE TYPE MGMT_BUG_ADVISORY_VIOLATIONS AS 
  TABLE OF MGMT_BUG_ADVISORY_VIOLATION;
/

rem
rem   This object is used to hold the policy violation values temporarily while
rem   being passed back from a function used to calculate the violations.
rem
CREATE OR REPLACE TYPE MGMT_BUG_PATCH_ADVISORIES AS OBJECT
(
  PATCH_ID NUMBER,
  PATCH_GUID RAW(16), 
  PATCH_TYPE VARCHAR2(32),
  PRODUCT_NAME VARCHAR2(50), 
  RELEASE_NAME VARCHAR2(30), 
  PLATFORM_NAME VARCHAR2(40), 
  ALERTS VARCHAR2(2000), 
  URLS VARCHAR2(4000), 
  HOME_COUNT NUMBER 
);
/

CREATE OR REPLACE TYPE MGMT_BUG_PATCH_ADVISORIES_LIST AS 
  TABLE OF MGMT_BUG_PATCH_ADVISORIES;
/
CREATE OR REPLACE TYPE save_composite_rec IS OBJECT
    (
    target_name             VARCHAR2(256),
    target_type             VARCHAR2(64),
    display_target_name     VARCHAR2(256),
    display_target_type     VARCHAR2(128),
    snapshot_type           VARCHAR2(64),
    collection_time         DATE,
    error_message           VARCHAR2(1024),
    save_success            SMALLINT
    );
/
    --Next a table type is defined using the previous object type as a rowtype:
    
CREATE OR REPLACE  TYPE save_composite_tab IS TABLE OF save_composite_rec;
/


CREATE OR REPLACE  TYPE PATCH_ADV_TYPE AS OBJECT
(
ADV_NAME         VARCHAR2(128),
ADV_URL          VARCHAR2(128),
ADV_IMPACT       VARCHAR2(256),
ADV_ABSTRACT     VARCHAR2(1024),
HOST_COUNT       INTEGER,
HOME_COUNT       INTEGER
);

/

CREATE OR REPLACE TYPE PATCH_ADVISORIES_TYPE IS TABLE OF PATCH_ADV_TYPE;

/


CREATE OR REPLACE TYPE MGMT_ORACLESW_RECORD AS OBJECT (
    compName VARCHAR2 (&COMPNAME),
    compExternalName VARCHAR2(&COMPEXTNAME),
    compVersion VARCHAR2(&COMPVERSION),
    compBaseVersion VARCHAR2(&COMPBASEVERSION),
    compHomeLocation VARCHAR2(&COMPHOMELOCATION),
    compHome VARCHAR2(&COMPHOME),
    compTime DATE,
    hasAdvisory NUMBER
);
/

CREATE OR REPLACE TYPE MGMT_ORACLESW_LIST AS TABLE 
       OF MGMT_ORACLESW_RECORD;
/

CREATE OR REPLACE TYPE MGMT_VENDORSW_RECORD AS OBJECT (
    compName VARCHAR2(&NAME_LENGTH),
    vendorName VARCHAR2(&NAME_LENGTH),
    compVersion VARCHAR2(&VERSION_LENGTH),
    compLocation VARCHAR2(&LOCATION_LENGTH),
    numberOfComps NUMBER,
    compTime DATE
);
/

CREATE OR REPLACE TYPE MGMT_VENDORSW_LIST AS TABLE 
       OF MGMT_VENDORSW_RECORD;
/

CREATE OR REPLACE TYPE MGMT_HWGEN_RECORD AS OBJECT (
  system_config VARCHAR2(&MAX_VARCHAR2_LENGTH), 
  machine_architecture  VARCHAR2(&SHORT_DESCRIPTION_LENGTH), 
  vendor_name  VARCHAR2(&NAME_LENGTH), 
  memory_size_in_mb   VARCHAR2(1024) , 
  local_disk_space_in_gb  VARCHAR2(1024) , 
  clock_freq_in_mhz  VARCHAR2(1024), 
  cpu_count  VARCHAR2(1024), 
  cpu_board_count  VARCHAR2(1024), 
  iocard_count   VARCHAR2(1024), 
  fan_count  VARCHAR2(1024) , 
  power_supply_count   VARCHAR2(1024) 
);
/

CREATE OR REPLACE TYPE MGMT_HWGEN_LIST AS TABLE 
       OF MGMT_HWGEN_RECORD;
/

CREATE OR REPLACE TYPE MGMT_CPUDETAILS_RECORD AS OBJECT (
  freq_in_mhz    VARCHAR2(1024), 
  vendor_name   VARCHAR2(&NAME_LENGTH), 
  revision   VARCHAR2(&DESCRIPTION_LENGTH), 
  ecache_in_mb    VARCHAR2(1024), 
  impl   VARCHAR2(&SHORT_DESCRIPTION_LENGTH), 
  mask   VARCHAR2(&SHORT_DESCRIPTION_LENGTH) 
);
/

CREATE OR REPLACE TYPE MGMT_CPUDETAILS_LIST AS TABLE 
       OF MGMT_CPUDETAILS_RECORD;
/

CREATE OR REPLACE TYPE MGMT_IOCARDDETAILS_RECORD AS OBJECT (
  name VARCHAR2(&NAME_LENGTH),  
  vendor_name VARCHAR2(&NAME_LENGTH), 
  bus VARCHAR2(&SHORT_DESCRIPTION_LENGTH), 
  freq_in_mhz  VARCHAR2(1024) , 
  revision VARCHAR2(&DESCRIPTION_LENGTH)
);
/

CREATE OR REPLACE TYPE MGMT_IOCARDDETAILS_LIST AS TABLE 
       OF MGMT_IOCARDDETAILS_RECORD;
/


CREATE OR REPLACE TYPE MGMT_NICDETAILS_RECORD AS OBJECT (
  name  VARCHAR2(&NAME_LENGTH), 
  inet_address  VARCHAR2(&INET_ADDRESS_LENGTH), 
  max_transfer_unit  VARCHAR2(1024), 
  broadcast_address VARCHAR2(&INET_ADDRESS_LENGTH), 
  mask VARCHAR2(&INET_ADDRESS_LENGTH), 
  flags VARCHAR2(&NIC_FLAGS), 
  mac_address VARCHAR2(&INET_ADDRESS_LENGTH), 
  hostname_aliases VARCHAR2(&MAX_VARCHAR2_LENGTH)
);
/

CREATE OR REPLACE TYPE MGMT_NICDETAILS_LIST AS TABLE 
       OF MGMT_NICDETAILS_RECORD;
/

--DROP TYPE HOME_CRED_ARRAY;
--/
--DROP TYPE HOME_CREDS_REC_TYPE;
--/

CREATE OR REPLACE TYPE HOME_REC_TYPE AS OBJECT (
  host_name     varchar2(256),
  home_location varchar2(256),
  home_index    number
  );
/
CREATE OR REPLACE TYPE HOME_REC_ARRAY AS TABLE OF HOME_REC_TYPE;
/


CREATE OR REPLACE TYPE DEST_PLATFORM_REC_TYPE AS OBJECT (
  platform_id varchar2(20),
  id_type varchar2(100)
  );
/

CREATE OR REPLACE TYPE DEST_PLATFORM_ARRAY AS TABLE OF DEST_PLATFORM_REC_TYPE;
/

CREATE OR REPLACE TYPE CPF_HOME_RECORD AS OBJECT (
HOME_HOST               VARCHAR2(256),   
HOME_DIRECTORY          VARCHAR2(256),   
HOME_NAME               VARCHAR2(320),   
HOME_VERSION            VARCHAR2(64),
HOST_TARGET_GUID        RAW(16),
HOME_ID                 RAW(16),
HOME_PLATFORM_TYPE      VARCHAR2(3),   
HOME_HOST_BIT_LENGTH    VARCHAR2(20),
HOME_TARGET_TYPE        VARCHAR2(64),    
HOME_ARU_PLATFORM       NUMBER      
);
/

CREATE OR REPLACE TYPE CPF_HOME_ARRAY AS TABLE OF CPF_HOME_RECORD;
/
rem ================================================================
rem   The following types are for use in the generic UI for viewing
rem   and comparing snapshots.  They were added in 10.2.0.2.
rem ================================================================
rem
rem   DROP TYPE ecm_gendiff_compkeys_table
rem   DROP TYPE ecm_gendiff_compkeys_rec
rem   DROP TYPE ecm_eendiff_res_array;
rem   DROP TYPE ecm_gendiff_keys_table;
rem   DROP TYPE ecm_gendiff_keyvalues_rec;
rem   DROP TYPE ecm_gendiff_rowcounts_table;
rem   DROP TYPE ecm_gendiff_rowcount_rec
rem
rem
rem ecm_gendiff_compkeys_rec
rem PURPOSE
rem   This object represents a list of key values for a specific key
rem
CREATE OR REPLACE TYPE ecm_gendiff_compkeys_rec AS OBJECT(
  keyname VARCHAR2(64),
  keyval  VARCHAR2(4000)
  );
/
rem
rem ecm_gendiff_compkeys_table
rem PURPOSE
rem   Nested table of keyname/value objects
rem
CREATE OR REPLACE TYPE ecm_gendiff_compkeys_table
  AS TABLE OF ecm_gendiff_compkeys_rec;
/
rem
rem PURPOSE
rem   This object represents a list of key values for a specific key
rem
CREATE OR REPLACE TYPE ecm_gendiff_keyvalue_array
  AS VARRAY(&ecm_gendiff_row_count) OF VARCHAR2(4000);
/
rem
rem PURPOSE
rem   This object represents a key and a list of values for this key.
rem
rem  COLUMNS
rem   keyname The name of the key column
rem   vals    An array of key values in the order that they appear in
rem           the UI
rem
CREATE OR REPLACE TYPE ecm_gendiff_keyvalues_rec AS
OBJECT (keyname VARCHAR2(64),
        vals    ecm_gendiff_keyvalue_array);
/
rem
rem PURPOSE
rem   This object is a list of keys and their associated values
rem
CREATE OR REPLACE TYPE ecm_gendiff_keys_table
  AS TABLE OF ecm_gendiff_keyvalues_rec;
/
rem
rem PURPOSE
rem   This object represents a list of table names
rem
CREATE OR REPLACE TYPE ecm_gendiff_tablename_table AS
    TABLE OF VARCHAR2(30);
/
rem
rem PURPOSE
rem   This object is a list of comparison results
rem   Each value is either 0 for unknown, 1 for different, 2 for same
rem
CREATE OR REPLACE TYPE ecm_gendiff_res_array
  AS VARRAY(&ecm_gendiff_row_count) OF CHAR(1);
/
rem
rem PURPOSE
rem   This object is the rowcount for a child table
rem COLUMNS
rem   table_name  Name of the child table
rem   count       The number of rows
rem
CREATE OR REPLACE TYPE ecm_gendiff_rowcount_rec AS OBJECT
(
  table_name  VARCHAR2(30),
  count       INTEGER
);
/
rem
rem PURPOSE
rem   This object is a bag of rowcounts for a set of child tables
rem
CREATE OR REPLACE TYPE ecm_gendiff_rowcounts_table
  AS TABLE OF ecm_gendiff_rowcount_rec;
/
rem ================================================================
rem   End of generic UI types
rem ================================================================


@&EM_SQL_ROOT/core/latest/ecm/inv/ecm_inv_types.sql
