CREATE OR REPLACE PACKAGE ecm_drill AS


   TYPE cursorType IS REF CURSOR;


--PROCEDURE sw_targets_drill
--PURPOSE: creates the targets drill-down table
--IN parameters:
--   target_name_in: the name of the target that defines the context in which we are searching
--   target_type_in: the type of the target that defines the context in which we are searching
--   these two must either both be null or both be non-null
--   external_name_in: the name of the component to search for
--   version_in: the version of the component to search for
--OUT parameters:
-- inventory_cur_out: the results of the query
PROCEDURE sw_targets_drill  (inventory_cur_out OUT cursorType,
                              external_name_in IN varchar2,
                              version_in IN varchar2,
                              target_name_in IN varchar2,
                              target_type_in IN varchar2,
			      targetList_in IN MGMT_INV_TARGET_LIST_OBJ_ARRAY);



--PROCEDURE sw_installs_drill
--PURPOSE: creates the installs drill-down table
--IN parameters:
--   target_name_in: the name of the target that defines the context in which we are searching
--   target_type_in: the type of the target that defines the context in which we are searching
--   these two must either both be null or both be non-null
--   product_name_in: the name of the component to search for
--   version_in: the version of the component to search for
--OUT parameters:
-- inventory_cur_out: the results of the query
PROCEDURE sw_installs_drill (inventory_cur_out OUT cursorType,
                             product_version_in IN varchar2,
                             product_name_in IN varchar2,
                             target_name_in IN varchar2,
                             target_type_in IN varchar2,
			     targetList_in IN MGMT_INV_TARGET_LIST_OBJ_ARRAY);

--PROCEDURE sw_patches_drill
--PURPOSE: creates the patches drill-down table
--IN parameters:
--   target_name_in: the name of the target that defines the context in which we are searching
--   target_type_in: the type of the target that defines the context in which we are searching
--   these two must either both be null or both be non-null
--   product_name_in: the name of the component to search for
--   version_in: the version of the component to search for
--OUT parameters:
-- inventory_cur_out: the results of the query
PROCEDURE sw_patches_drill(inventory_cur_out OUT cursorType,
			   total_homes_out OUT number,
                           product_version_in IN varchar2,
                           product_name_in IN varchar2,
                           target_name_in IN varchar2,
                           target_type_in IN varchar2,
			   targetList_in IN MGMT_INV_TARGET_LIST_OBJ_ARRAY);

--PROCEDURE hw_hosts_drill
--PURPOSE: creates the HW hosts drill-down table
--IN parameters:
--   target_name_in: the name of the target that defines the context in which we are searching
--   target_type_in: the type of the target that defines the context in which we are searching
--   these two must either both be null or both be non-null

--OUT parameters:
--   inventory_cur_out: the results of the query

PROCEDURE hw_hosts_drill(inventory_cur_out OUT cursorType,
                         system_config_in IN varchar2,
                         machine_arch_in IN varchar2, 
                         target_name_in IN varchar2,
                         target_type_in IN varchar2);


PROCEDURE os_patches_drill(inventory_cur_out OUT cursorType,
			   total_count_out OUT NUMBER,
                           osName_in IN varchar2,
                           osVersion_in IN varchar2,
                           patchLevel_in IN varchar2,
                           target_name_in IN varchar2,
                           target_type_in IN varchar);
/*PROCEDURE os_patches_drill(inventory_cur_out OUT cursorType,
                           osName_in IN varchar2,
                           osVersion_in IN varchar2,
                           patchLevel_in IN varchar2,
                           target_name_in IN varchar2,
                           target_type_in IN varchar);*/

PROCEDURE os_hosts_drill(inventory_cur_out OUT cursorType,
                         osName_in IN varchar2,
                         osVersion_in IN varchar2,
                         patchLevel_in IN varchar2,
                         target_name_in IN varchar2,
                         target_type_in IN varchar2);

PROCEDURE os_with_patch_drill(inventory_cur_out OUT cursorType,
			      osName_in IN varchar2,
                              osVersion_in IN varchar2,
                              patchLevel_in IN varchar2,
                              patchName_in IN varchar2,
                              target_name_in IN varchar2,
                              target_type_in IN varchar);

PROCEDURE os_no_patch_drill(inventory_cur_out OUT cursorType,
			      osName_in IN varchar2,
                              osVersion_in IN varchar2,
                              patchLevel_in IN varchar2,
                              patchName_in IN varchar2,
                              target_name_in IN varchar2,
                              target_type_in IN varchar);

PROCEDURE sw_with_patch_drill (inventory_cur_out OUT cursorType,
                             product_version_in IN varchar2,
                             product_name_in IN varchar2,
			     patch_name_in IN varchar2,
                             target_name_in IN varchar2,
                             target_type_in IN varchar2,
			     targetList_in IN MGMT_INV_TARGET_LIST_OBJ_ARRAY);

PROCEDURE sw_no_patch_drill (inventory_cur_out OUT cursorType,
                             product_version_in IN varchar2,
                             product_name_in IN varchar2,
			     patch_name_in IN varchar2,
                             target_name_in IN varchar2,
                             target_type_in IN varchar2,
			     targetList_in IN MGMT_INV_TARGET_LIST_OBJ_ARRAY);

end ecm_drill;

/
show errors;





