Rem
Rem $Header: ecm_inv_types.sql 25-jun-2004.03:31:33 rpinnama Exp $
Rem
Rem ecm_inv_types.sql
Rem
Rem Copyright (c) 2004, Oracle.  All rights reserved.  
Rem
Rem    NAME
Rem      ecm_inv_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rpinnama    06/25/04 - Created
Rem


CREATE OR REPLACE PACKAGE ecm_inv AS

-- Package level Type Definition 
   TYPE cursorType IS REF CURSOR;

-- PROCEDURE: get_inv_hw_info
--
-- PURPOSE:
--   This procedure returns HW inventory info for a given context
--
-- IN Parameters:
--   target_name_in: the name of the target that defines the context in which we are searching
--   target_type_in: the type of the target that defines the context in which we are searching
--   these two must either both be null or both be non-null
--
-- OUT Parameters:
--    inventory_cur_out: the cursor containing the inventory information
--                      the format is system config, architecture, num hosts
--    number_of_hosts_out: The total number of host targets found
--    refreshed_hosts_out: the number of updated hosts 
PROCEDURE get_inv_hw_info( inventory_cur_out OUT cursorType,
                           target_name_in IN VARCHAR2,
                           target_type_in IN VARCHAR2,
                           number_of_hosts_out OUT NUMBER,
                           refreshed_hosts_out OUT NUMBER,
                           collection_errors_out OUT NUMBER);



-- PROCEDURE: get_inv_os_info
--
-- PURPOSE:
--   This procedure returns OS inventory info for a given context
--
-- IN Parameters:
--   target_name_in: the name of the target that defines the context in which we are searching
--   target_type_in: the type of the target that defines the context in which we are searching
--   these two must either both be null or both be non-null
--
-- OUT Parameters:
--    inventory_cur_out: the cursor containing the inventory information
--                   the format is name, version, patch level, num hosts, patched
--    number_of_hosts_out: The total number of host targets found
--    refreshed_hosts_out: the number of updated hosts 
PROCEDURE get_inv_os_info( inventory_cur_out OUT cursorType,
                           target_name_in IN VARCHAR2,
                           target_type_in IN VARCHAR2,
                           number_of_hosts_out OUT NUMBER,
                           refreshed_hosts_out OUT NUMBER,
                           collection_errors_out OUT NUMBER);


--
-- PROCEDURE: get_inv_sw_info
--
-- PURPOSE:
-- This procedure returns information about various kinds of software, depending on the 
-- types listed in the targetList_in argument
-- IN Parameters:
--   target_name_in: the name of the target that defines the context in which we are searching
--   target_type_in: the type of the target that defines the context in which we are searching
--   these two must either both be null or both be non-null
--    
-- OUT parameters:
--    inventory_cur_out: the cursor containing the inventory information. 
--                     the format is name, version, instances, installs, patched
--    number_of_hosts_out: The total number of host targets found
--    refreshed_hosts_out: the number of updated hosts 
PROCEDURE get_inv_sw_info(
                           inventory_cur_out OUT cursorType,
                           target_name_in IN VARCHAR2,
                           target_type_in IN VARCHAR2,
                           targetList_in IN MGMT_INV_TARGET_LIST_OBJ_ARRAY,
			   number_of_targets_out OUT NUMBER,
			   collection_errors_out OUT NUMBER);

end ecm_inv;
/

show errors;
