Rem
Rem $Header: cpf_policy_pkgdefs.sql 16-sep-2005.01:29:27 pdasika Exp $
Rem
Rem cpf_policy_pkgdefs.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      cpf_policy_pkgdefs.sql
Rem
Rem    DESCRIPTION
Rem      PL/SQL for checking status of critical job
Rem
Rem    NOTES
Rem    
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       pdasika  09/11/05 - Changing the signature of 
Rem                           SETUP_CPF_ADV_HOME_PATCH 
Rem       abhalla  08/27/05 - Adding new functions
Rem                           get_exclusive_lock and release_lock 
Rem       abhalla  07/07/05 - Added code for SETUP_CPF_METRIC_SOURCE, 
Rem                           to populate MGMT_CPF_METRIC_SOURCE table
Rem                           and added the procedure GET_ADV_HOME_COUNT
Rem       gsbhatia 06/26/05 - New repmgr header impl 
Rem       mningomb 02/23/05 - Change meta type ver to 2.0 
Rem       gsbhatia 02/13/05 - updating repmgr header 
Rem       gsbhatia 02/09/05 - updating repmgr header 
Rem       gsbhatia 02/07/05 - updating repmgr header 
Rem       ktlaw    01/11/05 - add repmgr header 
Rem       mningomb 12/15/04 - mningomb_cpf_policy
Rem    mningomb   12/07/04    Created
Rem

CREATE OR REPLACE PACKAGE CPF_POLICY AS

--------------------------------------------------------------------------------
-- Constant denoting the value of the mgmt_targets.type_meta_ver used in CPF metric
--
HOST_TYPE_META_VERSION CONSTANT         VARCHAR2(3)   := '2.0';

--------------------------------------------------------------------------------
-- Does critical patch policy evaluation for all hosts
--
PROCEDURE RUN_CPF_POLICY_EVALUATION;


------------------------------------------------------------------------------------------
-- This method is used to do a preanalysis of the critical patches for homes.
-- It stores the information in a table called MGMT_BUG_ADV_HOME_PATCH.  It should
-- be called prior to doing the policy evaluation for critical patches.  The
-- critical patch policy actually queries the MGMT_BUG_ADV_HOME_PATCH table.
--
PROCEDURE SETUP_CPF_ADV_HOME_PATCH( p_homeRecords in CPF_HOME_ARRAY, p_deleteFlag in NUMBER);
PROCEDURE SETUP_CPF_FOR_NAMED_HOST( p_targetName VARCHAR2);
PROCEDURE RUN_SETUP_CPF_ADV_HOME_PATCH;
--------------------------------------------------------------------------------
-- This method is specific to the critical patch advisory functionality
-- policy.  It is the function that is called by that policy to get rollup information
-- for display on the critical patch page.
--
-- Returns a MGMT_BUG_PATCH_ADVISORIES_LIST table.
FUNCTION CPF_PAGE_INFO
      RETURN MGMT_BUG_PATCH_ADVISORIES_LIST;

--------------------------------------------------------------------------------
-- This method is specific to the critical patch advisory functionality
-- policy.  It is the function that is called by critical patch advisories
-- bean to get rollup information for a specified group.
--
-- Returns a MGMT_BUG_ADVISORY_VIOLATIONS table.
--
FUNCTION CPF_PAGE_INFO_FILTER_BY_GROUP(
          p_compositeTargetName VARCHAR2,
          p_compositeTargetType VARCHAR2)
      RETURN MGMT_BUG_PATCH_ADVISORIES_LIST; 

--------------------------------------------------------------------------------
-- This method is specific to the critical patch advisory functionality
-- policy.  It is the function that is called by that policy to get violations.
--
-- Returns a MGMT_BUG_ADVISORY_VIOLATIONS table.
--
  FUNCTION CPF_QUERY(p_targetGuid in RAW := NULL)
      RETURN MGMT_BUG_ADVISORY_VIOLATIONS;

---------------------------------------------------------------------------------------
--Purpose
--Get a exclusive lock on the handle
--
   FUNCTION get_exclusive_lock RETURN NUMBER;

-----------------------------------------------------------------------------------------
-- Release the lock
   FUNCTION  release_lock RETURN NUMBER ;

------------------------------------------------------------------------------------------
-- This procedure populates the table MGMT_CPF_METRIC_SOURCE with data from
-- CPF_QUERY.
--
  PROCEDURE SETUP_CPF_METRIC_SOURCE( p_targetGuid RAW := NULL );

------------------------------------------------------------------------------------------
-- This procedure evaluates Advisory and Affected Homes count for CPF
--
PROCEDURE GET_ADV_HOME_COUNT(p_adv_count OUT number, p_homes_count OUT number,
                             p_host_name IN varchar2,p_home_location IN varchar2,
                             p_composite_name IN varchar2, p_composite_type IN varchar2,
                             p_type IN number);

END CPF_POLICY;
/
show errors


