Rem
Rem $Header: critical_jobstatus_pkgbody.sql 21-feb-2005.07:14:23 dcawley Exp $
Rem
Rem critical_jobstatus_pkgbody.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      critical_jobstatus_pkgbody.sql
Rem
Rem    DESCRIPTION
Rem      PL/SQL for checking status of critical job
Rem
Rem    NOTES
Rem    
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       dcawley  02/21/05 - Replace enter super user mode 
Rem       mningomb 07/21/04 - mningomb_bug-3454471
Rem    mningomb   05/27/04    Created
Rem

----------------------------------------------------
CREATE OR REPLACE PACKAGE BODY MGMT_CRITICALPATCH_JOB AS
----------------------------------------------------

-----------------------------------
--Refresh from metalink job checks
-----------------------------------
-- Get the count of refresh_metalink_jobs that has run
-- in last 3 days

PROCEDURE get_refreshfrommetalink_count
          ( job_count OUT INTEGER,
           tmp_current_user IN VARCHAR2)

 IS
    l_current_user VARCHAR2(256) := MGMT_USER.GET_CURRENT_EM_USER;
 BEGIN

   SETEMUSERCONTEXT(MGMT_USER.GET_REPOSITORY_OWNER, 
                    MGMT_USER.OP_SET_IDENTIFIER);

   BEGIN 
     select count(*) into job_count from (
        select 
          j.job_name 
        from 
          mgmt_job j, mgmt_job_exec_summary s
        where 
          s.job_id=j.job_id and 
          j.job_type = 'RefreshFromMetalink' and
          s.status = MGMT_JOBS.COMPLETED_STATUS and 
          s.scheduled_time IS not null and 
          s.scheduled_time > = (sysdate - 3)
    );

   EXCEPTION
     WHEN NO_DATA_FOUND THEN
       job_count := 0;
   END;

   SETEMUSERCONTEXT(l_current_user, MGMT_USER.OP_SET_IDENTIFIER);

 EXCEPTION WHEN OTHERS
 THEN
   -- Make sure to catch all possible errors and reset user context
   SETEMUSERCONTEXT(l_current_user, MGMT_USER.OP_SET_IDENTIFIER);
   RAISE;

 END;

-- Check if any job of type 'RefreshFromMetalink' exist

PROCEDURE get_refreshfrommetalink_exist (
                     job_count OUT INTEGER,
                     tmp_current_user IN VARCHAR2)
 IS
   l_current_user VARCHAR2(256) := MGMT_USER.GET_CURRENT_EM_USER;
 BEGIN

   SETEMUSERCONTEXT(MGMT_USER.GET_REPOSITORY_OWNER, 
                    MGMT_USER.OP_SET_IDENTIFIER);

   BEGIN
     select count(*) into job_count from (
          select 
            /*+ INDEX(MGMT_JOB MGMT_JOB_IDX02) */ j.job_name 
          from 
            mgmt_job j
          where j.job_type = 'RefreshFromMetalink'
     );
   EXCEPTION
     WHEN NO_DATA_FOUND THEN
       job_count := 0;
   END;

   SETEMUSERCONTEXT(l_current_user, MGMT_USER.OP_SET_IDENTIFIER);

 EXCEPTION WHEN OTHERS
 THEN
   -- Make sure to catch all possible errors and reset user context
   SETEMUSERCONTEXT(l_current_user, MGMT_USER.OP_SET_IDENTIFIER);
   RAISE;

 END;

----------------------------------------
-- End Refresh from metalink job checks
----------------------------------------

--  End package
--
END MGMT_CRITICALPATCH_JOB;

/
show errors;

