Rem
Rem $Header: aru_platform_util_body.sql 10-sep-2004.02:18:08 mningomb Exp $
Rem
Rem aru_platform_util_body.sql
Rem
Rem Copyright (c) 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      aru_platform_util_body.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mningomb    08/25/04 - 10gr2: changes due to aru platform id 
Rem    mningomb    08/18/04 - mningomb_impl
Rem    mningomb    07/13/04 - Created
Rem

CREATE OR REPLACE PACKAGE BODY ARU_PLATFORM_UTIL
IS
--
-- Purpose: The package contains utility routines for ARU PLATFORM related logic
--
-- ---------   ------  ------------------------------------------
   FUNCTION get_home_aru_platform( p_container_guid IN RAW)  RETURN  NUMBER  IS
     aru_platform_id NUMBER := 0;
   BEGIN

      begin
            select
                to_number(property_value) into aru_platform_id
            from
                mgmt_inv_container_property
            where
                container_guid = p_container_guid and
                property_name = G_ARU_ID_PROP_NAME;
        EXCEPTION
            WHEN OTHERS THEN
                aru_platform_id := 0;
      end;
      
     if (aru_platform_id = 0) then
      select
       decode(oui_platform,
              610, 212, 87, 87, 197, 197, 2, 59, 211, 209,
              110, 214, 46, 46, 912, 912, 208, 208, 453, 453,
              23, 23, 173, 173)
      into aru_platform_id
      from
        mgmt_inv_container
      where
        container_guid = p_container_guid;

     end if;
     
        return aru_platform_id;
   EXCEPTION
      WHEN OTHERS THEN
          aru_platform_id := 0;
    return aru_platform_id;
   END;

END;

/
show errors
