Rem
Rem $Header: get_homes_all_def.sql 12-jun-2005.04:25:23 pdasika Exp $
Rem
Rem get_homes_all_def.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      get_homes_all_def.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pdasika     05/22/05 - 
Rem    mningomb    08/25/04 - 10gr2: changes due to aru platform id 
Rem    mningomb    08/18/04 - mningomb_impl
Rem    mningomb    07/13/04 - Created
Rem



CREATE OR REPLACE PACKAGE GET_HOMES_ALL
  IS
--
-- Purpose: The package contains util functions/procedures for getting oracle homes list
--
-- ---------   ------  ------------------------------------------
TYPE HOMEDETAILS_REF_CUR IS REF CURSOR;

PLATFORM_SUNOS64 number  := 23;
PLATFORM_SUNOS32 number  := 453;
MODULE_NAME VARCHAR2(20) := 'DEBUG_GET_HOMES_ALL';

procedure check_home_platform(
    p_host_name in varchar2,
    p_dir_name in varchar2,
    p_platform_id in varchar2,
    home_count OUT integer,
    platform_match_count out integer);

procedure sunos_aru_id_exists_for_home(
    p_host_name in varchar2,
    p_dir_name in varchar2,
    p_patch_bit_len in varchar2,
    p_exist OUT varchar2);

FUNCTION get_home_platform_id(
    p_host_name in varchar2,
    p_dir_name in varchar2)
    RETURN  number;

FUNCTION get_target_credentials(
        p_host_names in VARCHAR2_TABLE,
        p_home_dirs  in VARCHAR2_TABLE,
        p_curr_em_user in varchar2)
RETURN HOMEDETAILS_REF_CUR;

FUNCTION get_targets_in_oracle_home(
        p_host_names in VARCHAR2_TABLE,
        p_home_names in VARCHAR2_TABLE,
	p_target_type in VARCHAR2)
   RETURN HOMEDETAILS_REF_CUR;

FUNCTION get_destination_platform(
        p_host_names in VARCHAR2_TABLE,
        p_home_dirs  in VARCHAR2_TABLE)
   RETURN HOMEDETAILS_REF_CUR;

FUNCTION get_job_status(
        p_host_names in VARCHAR2_TABLE,
        p_home_names  in VARCHAR2_TABLE,
		p_execution_id in VARCHAR2)
RETURN HOMEDETAILS_REF_CUR;

END;
/

show errors

