Rem
Rem $Header: emx_tables_10_2_0_1_0.sql 18-jul-2005.14:23:02 caroy Exp $
Rem
Rem emx_tables.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      emx_tables.sql - Tables to store EM Management Plug-in information
Rem
Rem    DESCRIPTION
Rem      Tables to store EM Management Plug-in information
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       caroy    07/18/05 - prepare beta migration 
Rem       gsbhatia 06/28/05 - Removing repmgr header 
Rem       caroy    05/11/05 - change from te to mp 
Rem       itarashc 03/07/05 - add NLS support 
Rem       caroy    03/03/05 - caroy_repos_upgrade
Rem       gsbhatia 02/13/05 - updating repmgr header 
Rem       gsbhatia 02/09/05 - updating repmgr header 
Rem       gsbhatia 02/07/05 - updating repmgr header 
Rem       itarashc 02/08/05 - add HWM status 
Rem       ktlaw    01/11/05 - add repmgr header 
Rem       itarashc 11/18/04 - add mechanism support 
Rem       caroy    10/01/04 - add errors tables 
Rem       caroy    09/03/04 - caroy_create_emx
Rem

 DEFINE EM_ECM_DEPOT_TABLESPACE = "&1"

rem
rem PURPOSE
rem
rem The MGMT_TE_SEQ sequence is used to generate unique guids for MGMT_TE_DEPLOYMENT_ERRORS
rem (and possibly for other purposes)
rem
CREATE SEQUENCE mgmt_te_seq;

rem
rem PURPOSE
rem
rem The MGMT_TARGET_EXTENSIONS table stores target extension information
rem
rem COLUMNS
rem
rem    TARGET_TYPE (KEY)         The TE name 
rem    TE_VERSION  (KEY)         The TE version
rem    TE_GUID                   The TE guid
rem    IMPORT_DATE               Import date of the TE
rem    HWM_STATUS                High Water Mark status
rem                              0 - not HWM, 1 - HWM, 2 - HWM & DELETED
rem    FUNCTIONAL_DESCRIPTION    Functional Description
rem    REQUIREMENTS_DESCRIPTION  Requirements Description
rem
CREATE TABLE MGMT_TARGET_EXTENSIONS
(
     TARGET_TYPE               VARCHAR2(64)  NOT NULL,
     TE_VERSION                VARCHAR2(64)  NOT NULL,
     TE_GUID                   RAW(16)       NOT NULL,
     IMPORT_DATE               DATE,
     HWM_STATUS                INTEGER       DEFAULT 0,
     FUNCTIONAL_DESCRIPTION    VARCHAR2(4000),
     REQUIREMENTS_DESCRIPTION  VARCHAR2(4000),
  CONSTRAINT "MGMT_TE_PK" PRIMARY KEY ("TARGET_TYPE", "TE_VERSION")
)
INITRANS 2
MONITORING;

rem
rem PURPOSE
rem
rem The MGMT_TE_PROPS table stores properties (name-value pairs) of
rem the target extension
rem
rem COLUMNS
rem
rem    TE_GUID     (KEY)         The TE GUID
rem    PROP_NAME   (KEY)         Name  of the TE property (OS, ...)
rem    PROP_VALUE                Value of TE property (SunOS, ...)
rem
CREATE TABLE MGMT_TE_PROPS
(
     TE_GUID                   RAW(16)       NOT NULL,
     PROP_NAME                 VARCHAR2(128) NOT NULL,
     PROP_VALUE                VARCHAR2(128),
  CONSTRAINT "MGMT_TE_PROPS_PK" PRIMARY KEY ("TE_GUID", "PROP_NAME")
)
INITRANS 2
MONITORING;


rem
rem PURPOSE
rem
rem The MGMT_TE_MECHANISMS table stores properties (name-value pairs) of
rem the target extension mechanisms (e.g. custom implementations of TE functionality)
rem
rem COLUMNS
rem
rem    TE_GUID              The TE GUID
rem    MECHANISM_ID         The ID used to group the properties belonging to the same mechanism instance
rem    MECHANISM_TYPE       The type of the mechanism (DeploymentPlan, ...)
rem    PROP_NAME            Name  of the property (class, ...)
rem    PROP_VALUE           Value of property (oracle.sysman.emx.DepPlanner, ...)
rem
CREATE TABLE MGMT_TE_MECHANISMS
(
     TE_GUID                   RAW(16)       NOT NULL,
     MECHANISM_ID              NUMBER        NOT NULL,
     MECHANISM_TYPE            VARCHAR2(128) NOT NULL,
     PROP_NAME                 VARCHAR2(128) NOT NULL,
     PROP_VALUE                VARCHAR2(128)
)
INITRANS 2
MONITORING;

rem
rem PURPOSE
rem
rem The MGMT_TE_FILES table stores target extension files information
rem
rem COLUMNS
rem
rem    TE_GUID     (KEY)         The TE GUID
rem    FILE_ID     (KEY)         File ID
rem    FILE_NAME                 Name of the TE file
rem    FILE_TYPE                 Type of TE file (TARGET_TYPE_DEFINITION,
rem                                               DEFAULT_COLLECTION, etc.)
rem    FILE_CONTENTS             Contents of the TE file (BLOB)
rem
CREATE TABLE MGMT_TE_FILES
(
     TE_GUID                   RAW(16)       NOT NULL,
     FILE_ID                   NUMBER        NOT NULL,
     FILE_NAME                 VARCHAR2(256),
     FILE_TYPE                 VARCHAR2(64),
     FILE_CONTENTS             BLOB,
  CONSTRAINT "MGMT_TE_FILES_PK" PRIMARY KEY ("TE_GUID", "FILE_ID")
) LOB(FILE_CONTENTS) STORE AS ( TABLESPACE &EM_ECM_DEPOT_TABLESPACE )
INITRANS 2
MONITORING;

rem
rem PURPOSE
rem
rem The MGMT_TE_FILE_PROPS table stores properties (name-value pairs) of
rem the target extension files 
rem
rem COLUMNS
rem
rem    TE_GUID     (KEY)         The TE GUID
rem    FILE_ID     (KEY)         File ID
rem    PROP_NAME   (KEY)         Name  of the TE file property (OS, ...)
rem    PROP_VALUE                Value of TE file property (SunOS, ...)
rem
CREATE TABLE MGMT_TE_FILE_PROPS
(
     TE_GUID                   RAW(16)       NOT NULL,
     FILE_ID                   NUMBER        NOT NULL,
     PROP_NAME                 VARCHAR2(128) NOT NULL,
     PROP_VALUE                VARCHAR2(128),
  CONSTRAINT "MGMT_TE_FILE_PROPS_PK" PRIMARY KEY ("TE_GUID", "FILE_ID", "PROP_NAME")
)
INITRANS 2
MONITORING;

rem
rem PURPOSE
rem
rem The MGMT_TE_DEPLOYMENTS table stores target extension deployment information
rem
rem COLUMNS
rem
rem    TE_GUID     (KEY)  The TE GUID
rem    AGENT       (KEY)  Agent name
rem    DEPLOY_DATE        Date of deployment
rem    STATUS             Status of deployment(2-scheduled, 1-success, 0-error)
rem
CREATE TABLE MGMT_TE_DEPLOYMENTS
(
     TE_GUID                   RAW(16)       NOT NULL,
     AGENT                     VARCHAR2(128) NOT NULL,
     DEPLOY_DATE               DATE          NOT NULL,
     STATUS                    INTEGER,
  CONSTRAINT "MGMT_TE_DEPLOYMENTS_PK" PRIMARY KEY ("TE_GUID", "AGENT")
)
INITRANS 2
MONITORING;

rem
rem PURPOSE
rem
rem The MGMT_TE_DEPLOYMENT_ERRORS table stores target extension deployment 
rem errors
rem
rem COLUMNS
rem
rem    TE_GUID              The TE GUID
rem    AGENT                Agent name
rem    SEVERITY             Severity of deployment error (0: error, 1: warning)
rem    MSG_BUNDLE           The name of the message bundle (e.g. java class name)
rem    MSG_ID               The message ID within a bundle
rem    MSG_GUID     (KEY)   The message GUID
rem
CREATE TABLE MGMT_TE_DEPLOYMENT_ERRORS
(
     TE_GUID                   RAW(16)       NOT NULL,
     AGENT                     VARCHAR2(128) NOT NULL,
     SEVERITY                  INTEGER,
     MSG_BUNDLE             VARCHAR2(128) NOT NULL,
     MSG_ID                 VARCHAR2(128) NOT NULL,
     MSG_GUID               INTEGER,
 CONSTRAINT "MGMT_TE_DEPLOYMENT_ERRORS_PK" PRIMARY KEY ("MSG_GUID")
)
INITRANS 2
MONITORING;

rem -------------------------------------------------------------------
rem
rem PURPOSE
rem
rem The MGMT_TE_NLS_SUBSTITUTIONS table stores substitutions for translatable
rem messages stored in MGMT_TE_DEPLOYMENT_ERRORS
rem and in MGMT_TE_VALIDATION_ERRORS
rem
rem COLUMNS
rem
rem    MSG_GUID      (KEY)   The message GUID
rem    SUB_INDEX     (KEY)   Index of the substitution
rem    SUBSTITUTION          Substitution string
rem
CREATE TABLE MGMT_TE_NLS_SUBSTITUTIONS
(
     MSG_GUID               INTEGER,
     SUB_INDEX              INTEGER,
     SUBSTITUTION           VARCHAR2(1024) NOT NULL,
 CONSTRAINT "MGMT_TE_NLS_SUBSTITUTIONS_PK" PRIMARY KEY ("MSG_GUID", "SUB_INDEX")
)
INITRANS 2
MONITORING;

rem
rem PURPOSE
rem
rem The MGMT_TE_VALIDATIONS table stores target extension validation information
rem
rem COLUMNS
rem
rem    TE_GUID         (KEY)   The TE GUID
rem    AGENT           (KEY)   Agent name
rem    VALIDATION_DATE         Validation date
rem    STATUS                  Status of validation (2 - scheduled, 
rem                            1 - success, 0 - error)
rem
CREATE TABLE MGMT_TE_VALIDATIONS
(
     TE_GUID                   RAW(16)       NOT NULL,
     AGENT                     VARCHAR2(128) NOT NULL,
     VALIDATION_DATE           DATE,
     STATUS                    INTEGER,
  CONSTRAINT "MGMT_TE_VALIDATIONS_PK" PRIMARY KEY ("TE_GUID", "AGENT")
)
INITRANS 2
MONITORING;

rem
rem PURPOSE
rem
rem The MGMT_TE_VALIDATION_ERRORS table stores target extension validation 
rem errors
rem
rem COLUMNS
rem
rem    TE_GUID              The TE GUID
rem    AGENT                Agent name
rem    SEVERITY             Severity of validation error (0: error, 1: warning)
rem    MSG_BUNDLE           The name of the message bundle (e.g. java class name)
rem    MSG_ID               The message ID within a bundle
rem    MSG_GUID     (KEY)   The message GUID
rem
CREATE TABLE MGMT_TE_VALIDATION_ERRORS
(
     TE_GUID                   RAW(16)       NOT NULL,
     AGENT                     VARCHAR2(128) NOT NULL,
     SEVERITY                  INTEGER,
     MSG_BUNDLE               VARCHAR2(128) NOT NULL,
     MSG_ID                   VARCHAR2(128) NOT NULL,
     MSG_GUID                 INTEGER,
 CONSTRAINT "MGMT_TE_VALIDATION_ERRORS_PK" PRIMARY KEY ("MSG_GUID")
)
INITRANS 2
MONITORING;

rem
rem PURPOSE
rem
rem The MGMT_TE_CONTRIBUTORS table stores target extension contributor information
rem
rem COLUMNS
rem
rem    TE_GUID             (KEY) The TE GUID
rem    CONTRIBUTOR_FILE_ID (KEY) Contributor file id
rem    CONTRIBUTOR_ROLE    (KEY) Contributor role(CREATOR, SUPPORTER, APPROVER)
rem    CONTRIBUTOR_NAME          Contributor name
rem
CREATE TABLE MGMT_TE_CONTRIBUTORS
(
     TE_GUID                   RAW(16)       NOT NULL,
     CONTRIBUTOR_FILE_ID       VARCHAR2(128) NOT NULL,
     CONTRIBUTOR_NAME          VARCHAR2(128),
     CONTRIBUTOR_ROLE          VARCHAR2(64)  NOT NULL, 
  CONSTRAINT "MGMT_TE_CONTRIBUTORS_PK" PRIMARY KEY ("TE_GUID",
                                                    "CONTRIBUTOR_FILE_ID",
                                                    "CONTRIBUTOR_ROLE")
)
INITRANS 2
MONITORING;

rem
rem PURPOSE
rem
rem The MGMT_TE_CONTRIBUTOR_FILE table stores target extension contributor information
rem
rem COLUMNS
rem
rem    TE_GUID             (KEY)    The TE GUID
rem    CONTRIBUTOR_FILE_ID (KEY)    Contributor file id
rem    FILE_CONTENTS                Contributor file contents (BLOB)
rem
CREATE TABLE MGMT_TE_CONTRIBUTOR_FILE
(
     TE_GUID                   RAW(16)       NOT NULL,
     CONTRIBUTOR_FILE_ID       VARCHAR2(128) NOT NULL,
     FILE_CONTENTS             BLOB,
  CONSTRAINT "MGMT_TE_CONTRIB_FILE_PK" PRIMARY KEY ("TE_GUID",
                                                    "CONTRIBUTOR_FILE_ID")
) LOB(FILE_CONTENTS) STORE AS ( TABLESPACE &EM_ECM_DEPOT_TABLESPACE )
INITRANS 2
MONITORING;


