Rem
Rem $Header: emx_tables_10_2_0_2_0.sql 03-aug-2005.00:08:18 caroy Exp $
Rem
Rem emx_tables_10_2_0_2_0.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      emx_tables_10_2_0_2_0.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    caroy       08/03/05 - caroy_bug-4496322
Rem    caroy       07/18/05 - Created
Rem

 DEFINE EM_ECM_DEPOT_TABLESPACE = "&1"

rem
rem PURPOSE
rem
rem The MGMT_MP_SEQ sequence is used to generate unique guids for 
rem MGMT_MP_DEPLOYMENT_ERRORS (and possibly for other purposes)
rem
CREATE SEQUENCE mgmt_mp_seq;

rem
rem PURPOSE
rem
rem The MGMT_MANAGEMENT_PLUGINS table stores Management Plug-in information
rem
rem COLUMNS
rem
rem    TARGET_TYPE (KEY)         The MP name 
rem    MP_VERSION  (KEY)         The MP version
rem    MP_GUID                   The MP guid
rem    IMPORT_DATE               Import date of the MP
rem    HWM_STATUS                High Water Mark status
rem                              0 - not HWM, 1 - HWM, 2 - HWM & DELETED
rem    FUNCTIONAL_DESCRIPTION    Functional Description
rem    REQUIREMENTS_DESCRIPTION  Requirements Description
rem
CREATE TABLE MGMT_MANAGEMENT_PLUGINS
(
     TARGET_TYPE               VARCHAR2(64)  NOT NULL,
     MP_VERSION                VARCHAR2(64)  NOT NULL,
     MP_GUID                   RAW(16)       NOT NULL,
     IMPORT_DATE               DATE,
     HWM_STATUS                INTEGER       DEFAULT 0,
     FUNCTIONAL_DESCRIPTION    VARCHAR2(4000),
     REQUIREMENTS_DESCRIPTION  VARCHAR2(4000),
  CONSTRAINT "MGMT_MP_PK" PRIMARY KEY ("TARGET_TYPE", "MP_VERSION")
)
INITRANS 2
MONITORING;

rem
rem PURPOSE
rem
rem The MGMT_MP_PROPS table stores properties (name-value pairs) of
rem the Management Plug-in
rem
rem COLUMNS
rem
rem    MP_GUID     (KEY)         The MP GUID
rem    PROP_NAME   (KEY)         Name  of the MP property (OS, ...)
rem    PROP_VALUE                Value of MP property (SunOS, ...)
rem
CREATE TABLE MGMT_MP_PROPS
(
     MP_GUID                   RAW(16)       NOT NULL,
     PROP_NAME                 VARCHAR2(128) NOT NULL,
     PROP_VALUE                VARCHAR2(128),
  CONSTRAINT "MGMT_MP_PROPS_PK" PRIMARY KEY ("MP_GUID", "PROP_NAME")
)
INITRANS 2
MONITORING;


rem
rem PURPOSE
rem
rem The MGMT_MP_MECHANISMS table stores properties (name-value pairs) of
rem the Management Plug-in mechanisms (e.g. custom implementations of MP
rem functionality)
rem
rem COLUMNS
rem
rem    MP_GUID              The MP GUID
rem    MECHANISM_ID         The ID used to group the properties belonging to
rem                         the same mechanism instance
rem    MECHANISM_TYPE       The type of the mechanism (DeploymentPlan, ...)
rem    PROP_NAME            Name  of the property (class, ...)
rem    PROP_VALUE           Value of property(oracle.sysman.emx.DepPlanner,...)
rem
CREATE TABLE MGMT_MP_MECHANISMS
(
     MP_GUID                   RAW(16)       NOT NULL,
     MECHANISM_ID              NUMBER        NOT NULL,
     MECHANISM_TYPE            VARCHAR2(128) NOT NULL,
     PROP_NAME                 VARCHAR2(128) NOT NULL,
     PROP_VALUE                VARCHAR2(128)
)
INITRANS 2
MONITORING;

rem
rem PURPOSE
rem
rem The MGMT_MP_FILES table stores Management Plug-in files information
rem
rem COLUMNS
rem
rem    MP_GUID     (KEY)         The MP GUID
rem    FILE_ID     (KEY)         File ID
rem    FILE_NAME                 Name of the MP file
rem    FILE_TYPE                 Type of MP file (TARGET_TYPE_DEFINITION,
rem                                               DEFAULT_COLLECTION, etc.)
rem    FILE_CONTENTS             Contents of the MP file (BLOB)
rem
CREATE TABLE MGMT_MP_FILES
(
     MP_GUID                   RAW(16)       NOT NULL,
     FILE_ID                   NUMBER        NOT NULL,
     FILE_NAME                 VARCHAR2(256),
     FILE_TYPE                 VARCHAR2(64),
     FILE_CONTENTS             BLOB,
  CONSTRAINT "MGMT_MP_FILES_PK" PRIMARY KEY ("MP_GUID", "FILE_ID")
) LOB(FILE_CONTENTS) STORE AS ( TABLESPACE &EM_ECM_DEPOT_TABLESPACE )
INITRANS 2
MONITORING;

rem
rem PURPOSE
rem
rem The MGMT_MP_FILE_PROPS table stores properties (name-value pairs) of
rem the Management Plug-in files 
rem
rem COLUMNS
rem
rem    MP_GUID     (KEY)         The MP GUID
rem    FILE_ID     (KEY)         File ID
rem    PROP_NAME   (KEY)         Name  of the MP file property (OS, ...)
rem    PROP_VALUE                Value of MP file property (SunOS, ...)
rem
CREATE TABLE MGMT_MP_FILE_PROPS
(
     MP_GUID                   RAW(16)       NOT NULL,
     FILE_ID                   NUMBER        NOT NULL,
     PROP_NAME                 VARCHAR2(128) NOT NULL,
     PROP_VALUE                VARCHAR2(128),
  CONSTRAINT "MGMT_MP_FILE_PROPS_PK" PRIMARY KEY ("MP_GUID", "FILE_ID", "PROP_NAME")
)
INITRANS 2
MONITORING;

rem
rem PURPOSE
rem
rem The MGMT_MP_DEPLOYMENTS table stores Management Plug-in deployment info
rem
rem COLUMNS
rem
rem    MP_GUID     (KEY)  The MP GUID
rem    AGENT       (KEY)  Agent name
rem    DEPLOY_DATE        Date of deployment
rem    STATUS             Status of deployment(2-scheduled, 1-success, 0-error)
rem
CREATE TABLE MGMT_MP_DEPLOYMENTS
(
     MP_GUID                   RAW(16)       NOT NULL,
     AGENT                     VARCHAR2(128) NOT NULL,
     DEPLOY_DATE               DATE          NOT NULL,
     STATUS                    INTEGER,
  CONSTRAINT "MGMT_MP_DEPLOYMENTS_PK" PRIMARY KEY ("MP_GUID", "AGENT")
)
INITRANS 2
MONITORING;

rem
rem PURPOSE
rem
rem The MGMT_MP_DEPLOYMENT_ERRORS table stores Management Plug-in deployment 
rem errors
rem
rem COLUMNS
rem
rem    MP_GUID              The MP GUID
rem    AGENT                Agent name
rem    SEVERITY             Severity of deployment error (0: error, 1: warning)
rem    MSG_BUNDLE           The name of the message bundle (eg java class name)
rem    MSG_ID               The message ID within a bundle
rem    MSG_GUID     (KEY)   The message GUID
rem
CREATE TABLE MGMT_MP_DEPLOYMENT_ERRORS
(
     MP_GUID                   RAW(16)       NOT NULL,
     AGENT                     VARCHAR2(128) NOT NULL,
     SEVERITY                  INTEGER,
     MSG_BUNDLE             VARCHAR2(128) NOT NULL,
     MSG_ID                 VARCHAR2(128) NOT NULL,
     MSG_GUID               INTEGER,
 CONSTRAINT "MGMT_MP_DEPLOYMENT_ERRORS_PK" PRIMARY KEY ("MSG_GUID")
)
INITRANS 2
MONITORING;

rem -------------------------------------------------------------------
rem
rem PURPOSE
rem
rem The MGMT_MP_NLS_SUBSTITUTIONS table stores substitutions for translatable
rem messages stored in MGMT_MP_DEPLOYMENT_ERRORS
rem and in MGMT_MP_VALIDATION_ERRORS
rem
rem COLUMNS
rem
rem    MSG_GUID      (KEY)   The message GUID
rem    SUB_INDEX     (KEY)   Index of the substitution
rem    SUBSTITUTION          Substitution string
rem
CREATE TABLE MGMT_MP_NLS_SUBSTITUTIONS
(
     MSG_GUID               INTEGER,
     SUB_INDEX              INTEGER,
     SUBSTITUTION           VARCHAR2(1024) NOT NULL,
 CONSTRAINT "MGMT_MP_NLS_SUBSTITUTIONS_PK" PRIMARY KEY ("MSG_GUID", "SUB_INDEX")
)
INITRANS 2
MONITORING;

rem
rem PURPOSE
rem
rem The MGMT_MP_CONTRIBUTORS table stores Management Plug-in contributor info
rem
rem COLUMNS
rem
rem    MP_GUID             (KEY) The MP GUID
rem    CONTRIBUTOR_FILE_ID (KEY) Contributor file id
rem    CONTRIBUTOR_ROLE    (KEY) Contributor role(CREATOR, SUPPORTER, APPROVER)
rem    CONTRIBUTOR_NAME          Contributor name
rem
CREATE TABLE MGMT_MP_CONTRIBUTORS
(
     MP_GUID                   RAW(16)       NOT NULL,
     CONTRIBUTOR_FILE_ID       VARCHAR2(128) NOT NULL,
     CONTRIBUTOR_NAME          VARCHAR2(128),
     CONTRIBUTOR_ROLE          VARCHAR2(64)  NOT NULL, 
  CONSTRAINT "MGMT_MP_CONTRIBUTORS_PK" PRIMARY KEY ("MP_GUID",
                                                    "CONTRIBUTOR_FILE_ID",
                                                    "CONTRIBUTOR_ROLE")
)
INITRANS 2
MONITORING;

rem
rem PURPOSE
rem
rem The MGMT_MP_CONTRIBUTOR_FILE table stores Management Plug-in contributor
rem information
rem
rem COLUMNS
rem
rem    MP_GUID             (KEY)    The MP GUID
rem    CONTRIBUTOR_FILE_ID (KEY)    Contributor file id
rem    FILE_CONTENTS                Contributor file contents (BLOB)
rem
CREATE TABLE MGMT_MP_CONTRIBUTOR_FILE
(
     MP_GUID                   RAW(16)       NOT NULL,
     CONTRIBUTOR_FILE_ID       VARCHAR2(128) NOT NULL,
     FILE_CONTENTS             BLOB,
  CONSTRAINT "MGMT_MP_CONTRIB_FILE_PK" PRIMARY KEY ("MP_GUID",
                                                    "CONTRIBUTOR_FILE_ID")
) LOB(FILE_CONTENTS) STORE AS ( TABLESPACE &EM_ECM_DEPOT_TABLESPACE )
INITRANS 2
MONITORING;


