Rem
Rem $Header: emx_tables_10_2_0_4_0.sql 09-may-2007.01:56:20 rstobbe Exp $
Rem
Rem emx_tables_10_2_0_4_0.sql
Rem
Rem Copyright (c) 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      emx_tables_10_2_0_4_0.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rstobbe     05/09/07 - group support
Rem    rstobbe     05/09/07 - Created
Rem

rem
rem  PURPOSE
rem
rem  The MGMT_MP_GROUPS table stores Managemnt Plug-in group information
rem
rem  COLUMNS
rem
rem  GROUP_NAME       The name of the group
rem
rem  DESCRIPTION      The description of the group


CREATE TABLE MGMT_MP_GROUPS (
    group_name       VARCHAR2(64) NOT NULL,
    description      VARCHAR2(4000),
    CONSTRAINT MGMT_MP_GROUPS_PK PRIMARY KEY (group_name)
) INITRANS 2 MONITORING;
rem
rem  PURPOSE
rem
rem  The MGMT_MP_GROUP_MEMBERS table stores Managemnt Plug-in group membership
rem  and deployment order.
rem
rem  COLUMNS
rem
rem  GROUP_NAME       The name of the group
rem
rem  TARGET_TYPE      The name of the Management Plug-in (target type)
rem
rem  MP_VERSION       The version of the Management Plug-in (could be "newest"
rem                   or NULL)
rem
rem  DEPLOYMENT_ORDER The deployment order for this group. Undeployment happens
rem                   in reverse order.


CREATE TABLE MGMT_MP_GROUP_MEMBERS (
    group_name       VARCHAR2(64)  NOT NULL,
    target_type      VARCHAR2(64)  NOT NULL,
    mp_version       VARCHAR2(64),
    deployment_order NUMBER        NOT NULL,
    CONSTRAINT MGMT_MP_GROUP_MEMBERS_PK PRIMARY KEY (group_name, target_type, deployment_order)
) INITRANS 2 MONITORING;


