Rem
Rem $Header: emx_target_pkgbody_10_2_0_4_0.sql 26-jul-2007.11:09:32 caroy    Exp $
Rem
Rem emx_target_pkgbody_10_2_0_4_0.sql
Rem
Rem Copyright (c) 2007, Oracle.  All rights reserved.  
Rem
Rem    NAME
Rem      emx_target_pkgbody_10_2_0_4_0.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    caroy       07/26/07 - Created
Rem

CREATE OR REPLACE PACKAGE BODY mgmt_mp AS


-- Generate the mp guid for the specified target extension
FUNCTION generate_mp_guid(p_target_type IN VARCHAR2,
                          p_mp_version IN VARCHAR2)
    RETURN RAW IS
BEGIN
    RETURN DBMS_OBFUSCATION_TOOLKIT.md5(
             input => UTL_RAW.cast_to_raw(p_target_type ||
                            ';'|| p_mp_version));
END;


PROCEDURE agent_deleted(
    p_target_name IN VARCHAR2,
    p_target_type IN VARCHAR2,
    p_target_guid IN RAW)
IS
BEGIN
    IF p_target_type = 'oracle_emd'
    THEN
      delete_agent_records(p_target_name);
    END IF;
END;

PROCEDURE delete_agent_records(
    p_target_name IN VARCHAR2)
IS
BEGIN
    DELETE FROM MGMT_MP_NLS_SUBSTITUTIONS WHERE msg_guid IN 
       (select msg_guid
        from MGMT_MP_DEPLOYMENT_ERRORS 
        where agent = p_target_name);

    DELETE FROM MGMT_MP_DEPLOYMENT_ERRORS WHERE agent = p_target_name;

    DELETE FROM MGMT_MP_DEPLOYMENTS WHERE agent = p_target_name;
END;

PROCEDURE handle_agent_port_change(
    p_old_agent_guid   IN mgmt_targets.target_guid%TYPE,
    p_new_agent_guid   IN mgmt_targets.target_guid%TYPE
  )
IS
    l_old_agent_name VARCHAR2(256);
    l_new_agent_name VARCHAR2(256);
BEGIN
    SELECT target_name
      INTO l_old_agent_name
    FROM mgmt_targets
    WHERE target_guid = p_old_agent_guid;

    SELECT target_name
      INTO l_new_agent_name
    FROM mgmt_targets
    WHERE target_guid = p_new_agent_guid;

    UPDATE MGMT_MP_DEPLOYMENT_ERRORS 
       SET agent = l_new_agent_name
     WHERE agent = l_old_agent_name;

    UPDATE MGMT_MP_DEPLOYMENTS
       SET agent = l_new_agent_name
     WHERE agent = l_old_agent_name;

END;

END mgmt_mp;
/
show errors;


