Rem
Rem $Header: emx_target_pkgdef_10_2_0_4_0.sql 26-jul-2007.11:09:59 caroy    Exp $
Rem
Rem emx_target_pkgdef_10_2_0_4_0.sql
Rem
Rem Copyright (c) 2007, Oracle.  All rights reserved.  
Rem
Rem    NAME
Rem      emx_target_pkgdef_10_2_0_4_0.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    caroy       07/26/07 - Created
Rem


-- 
-- Package: mgmt_mp
--
-- PURPOSE: 
--   This package provides access to the Management Plug-in utilities
--
-- NOTES: 
--   A Management Plug-in is uniquely identified by its target type and MP
--   version.  
--
CREATE OR REPLACE PACKAGE mgmt_mp
AS

--
-- FUNCTION: generate_mp_guid
--
-- PURPOSE:
--   Given a target type (mp name) and mp version, this function computes the
--   mp guid for the Management Plug-in. The guid is an MD5 hash of the target
--   type and mp version.
--
-- IN Parameters:
--   p_target_type: The type of the target (aka the mp name)
--   p_mp_version : The version of the mp
--
-- RETURN:
--   The generated mp guid
--
FUNCTION generate_mp_guid(p_target_type IN VARCHAR2,
                          p_mp_version IN VARCHAR2) 
         RETURN RAW;


--
-- FUNCTION: agent_deleted
--
-- PURPOSE:
--   Callback during agent target deletion for us to clean up any 
--   deployment records.
--
-- IN Parameters:
--   p_target_name: The name of the target 
--   p_target_type: The type of the target 
--   p_target_guid: The target guid
--
--
PROCEDURE agent_deleted(
    p_target_name IN VARCHAR2,
    p_target_type IN VARCHAR2,
    p_target_guid IN RAW);

--
-- FUNCTION: delete_agent_records
--
-- PURPOSE:
--   Delete all deployment records associated with a particular agent.
--
-- IN Parameters:
--   p_target_name: The name of the target 
--
--
PROCEDURE delete_agent_records(
    p_target_name IN VARCHAR2);

--
-- FUNCTION: handle_agent_port_change
--
-- PURPOSE:
--   Change deployment records to reflect an agent port change
--
-- IN Parameters:
--   p_old_agent_guid:  Guid of the old agent
--   p_new_agent_guid:  Guid of the new agent
--
--
PROCEDURE handle_agent_port_change(
    p_old_agent_guid   IN mgmt_targets.target_guid%TYPE,
    p_new_agent_guid   IN mgmt_targets.target_guid%TYPE
  );

END mgmt_mp;

/
show errors;

