Rem drv: <create type="pkgdefs" pos="ecm/ecm_pkgdefs.sql+"/>
Rem
Rem $Header: esm_pkgdefs.sql 15-sep-2005.20:09:42 dsukhwal Exp $
Rem
Rem esm_pkgdefs.sql
Rem
Rem Copyright (c) 2003, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      esm_pkgdefs.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dsukhwal    09/07/05 - proc for console home page 
Rem    dkjain      07/28/05 - Adding modify_policy 
Rem    dkjain      08/15/05 - Adding policy_eval for unlimited login policy 
Rem    dsukhwal    08/05/05 - add get_repository_databases 
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    dkjain      01/31/05 - Added clear param 
Rem    dkjain      01/19/05 - Fixed Bug-4128312(added support to old agent 
Rem                           version) 
Rem    dkjain      01/05/05 - Adding author constant 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    dkjain      11/07/04 - p_auto_enable param added 
Rem    dkjain      10/08/04 - ESA 10gR2 Impl 
Rem    eujang      09/04/03 - eujang_esm_init_no_intgr 
Rem    anajmi      08/26/03 - Created
Rem


   

CREATE OR REPLACE PACKAGE ESM AS
  
  TYPE cursorType IS REF CURSOR;
  HOST_TARGET_TYPE CONSTANT		  VARCHAR2(4)   :='host';
  LSNR_TARGET_TYPE	CONSTANT	  VARCHAR2(15)  :='oracle_listener';
  DB_TARGET_TYPE CONSTANT		  VARCHAR2(15)  :='oracle_database';
  HOST_TYPE_META_VERSION CONSTANT         VARCHAR2(3)   := '3.0';
  LSNR_TYPE_META_VERSION CONSTANT 	  VARCHAR2(3)   := '2.0';
  DB_TYPE_META_VERSION CONSTANT 	  VARCHAR2(3)   := '4.0';
  METRIC_AUTHOR	       CONSTANT	          VARCHAR2(6)	:= 'ORACLE';
  SECURITY_SNAPSHOT_TYPE CONSTANT MGMT_ECM_SNAPSHOT_METADATA.SNAPSHOT_TYPE%TYPE := 'oracle_security';

  PROCEDURE CREATE_POLICY(
  p_target_type VARCHAR2,
  p_policy_name VARCHAR2,
  p_metric_name VARCHAR2,
  p_policy_label_nlsid VARCHAR2 := NULL,
  p_description VARCHAR2 := ' ',
  p_description_nlsid VARCHAR2 := NULL,
  p_impact VARCHAR2 := ' ',
  p_impact_nlsid VARCHAR2 := NULL,
  p_recommendation  VARCHAR2 := ' ',
  p_recommendation_nlsid VARCHAR2 := NULL,
  p_violation_level NUMBER := NULL,
  p_condition_type NUMBER := 1,
  p_condition  VARCHAR2 := NULL,
  p_condition_operator NUMBER := 0,
  p_message VARCHAR2 := NULL,
  p_message_nlsid VARCHAR2 := NULL,
  p_clear_message VARCHAR2 := NULL,
  p_clear_message_nlsid VARCHAR2 := NULL,
  p_auto_enable NUMBER := 1 , 
  p_cs_consider_percentage NUMBER := 0,
  p_start_type_meta_ver  VARCHAR2 := '1.0',
  p_end_type_meta_ver    VARCHAR2 := NULL,
  p_policy_param_list  MGMT_POLICY_PARAM_DEF_ARRAY := NULL,
  p_dflt_param_val_list MGMT_POLICY_KEY_VAL_ARRAY := NULL,
  p_viol_ctxt_list MGMT_VIOL_CTXT_DEF_ARRAY := NULL
 );
  
 PROCEDURE MODIFY_POLICY(
  p_target_type VARCHAR2,
  p_policy_name VARCHAR2,
  p_metric_name VARCHAR2,
  p_policy_label_nlsid VARCHAR2 := NULL,
  p_description VARCHAR2 := ' ',
  p_description_nlsid VARCHAR2 := NULL,
  p_impact VARCHAR2 := ' ',
  p_impact_nlsid VARCHAR2 := NULL,
  p_recommendation  VARCHAR2 := ' ',
  p_recommendation_nlsid VARCHAR2 := NULL,
  p_violation_level NUMBER := NULL,
  p_condition_type NUMBER := 1,
  p_condition  VARCHAR2 := NULL,
  p_condition_operator NUMBER := 0,
  p_message VARCHAR2 := NULL,
  p_message_nlsid VARCHAR2 := NULL,
  p_clear_message VARCHAR2 := NULL,
  p_clear_message_nlsid VARCHAR2 := NULL,
  p_auto_enable NUMBER := 1 , 
  p_cs_consider_percentage NUMBER := 0,
  p_start_type_meta_ver  VARCHAR2 := '1.0',
  p_end_type_meta_ver    VARCHAR2 := NULL,
  p_policy_param_list  MGMT_POLICY_PARAM_DEF_ARRAY := NULL,
  p_dflt_param_val_list MGMT_POLICY_KEY_VAL_ARRAY := NULL,
  p_viol_ctxt_list MGMT_VIOL_CTXT_DEF_ARRAY := NULL
 );

 PROCEDURE DELETE_POLICY(
  p_target_type VARCHAR2,
  p_policy_name VARCHAR2
 ) ;

 PROCEDURE DELETE_POLICY_METADATA(
  p_target_type VARCHAR2,
  p_policy_name VARCHAR2
 ) ;

 
 FUNCTION GET_REPOSITORY_TARGETS RETURN MGMT_USER_GUID_ARRAY;

  PROCEDURE EVAL_POLICY10GR1(
    p_target_guid IN RAW,
    p_metric_guid IN RAW,
    p_coll_name IN VARCHAR2,
    p_metric_values OUT mgmt_metric_Value_array
  );
  
  PROCEDURE EVAL_POLICY10GR2(
    p_target_guid IN RAW,
    p_metric_guid IN RAW,
    p_coll_name IN VARCHAR2,
    p_metric_values OUT mgmt_metric_Value_array
  );

    PROCEDURE get_console_homepage_info(
       p_time_period IN VARCHAR2,
       p_ext_viol_cur_out OUT cursorType,          --existing violations by severity
       p_new_viol_cur_out OUT cursorType --new violations in last p_time_period days
  );

    
 END ESM;
/
COMMIT;
show errors;




/*
create or replace package ESM as

-- This procedure creates a single policy for security called CONS_SECURITY_POLICY_NAME.
-- This policy covers all rules from CONS_SECURITY_POLICY_AUTHOR of category CONS_SECURITY_POLICY_CATEGORY.
-- It further registers this policy to execute automatically for a target of any type.
-- This procedure must be invoked AFTER adding a new target type, if the user
-- wishes to define Security policies on this new target.
-- NOTE: Commit is not called automatically.

  procedure CREATE_POLICY;

-- This procedure provides a simplified API for adding security rules to the policy framework
-- NOTE: Commit is not called automatically.

  procedure CREATE_RULE(
    test_name VARCHAR2,				-- Name of test
    test_description VARCHAR2,			-- Text description of test
    severity VARCHAR2,				-- Severity: 'C' | 'W' | 'I'
    impact VARCHAR2,				-- Text description of impact of violation
    recommendation VARCHAR2,			-- Text description of recommendation
    target_type VARCHAR2,			-- EM Target Type from MGMT_TARGETS
    esm_metric_name VARCHAR2,			-- Name of metric which collects property below (for future use)
    property_name VARCHAR2,			-- Name of property used by the rule
    value_expression VARCHAR2 := 'VALUE',	-- Expression for the column value shown in UI
    value_expression_type VARCHAR2 := 'T',	-- Type: 'T' for text, 'N' for numeric, 'D' for date
    property_display_name VARCHAR2 := null,	-- Default display name for the property (used if no i18n)
    value_selection_expression VARCHAR2 := null,-- Further filter using VALUE
    URL VARCHAR2 := null,			-- Not sure what to do with this yet
    rule_display_Id VARCHAR2 := null,   	-- for i18n support
    property_display_Id VARCHAR2 := null	-- for i18n support
  );

end ESM;
/

show errors;
*/

