Rem drv: <create type="tables"/>
Rem
Rem $Header: esm_tables.sql 23-apr-2007.23:28:41 jsadras Exp $
Rem
Rem esm_tables.sql
Rem
Rem Copyright (c) 2003, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      esm_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem     This is the SQL script to (re)create the ESM_COLLECTION table and associated registeration of metadata
Rem     for the ECM Security snapshot.
Rem     This file was largely BUT NOT COMPLETELY generated by the ECM Snapshot registry, invoking the command
Rem     >> java -classpath $ORACLE_HOME/emdw/sysman/jlib/emCORE.jar:$ORACLE_HOME/xdk/lib/xmlparserv2.jar:$ORACLE_HOME/emdw/sysman/jlib/log4j-core.jar oracle.sysman.eml.ecm.snap.MetadataRegistry esm.xml esm.sql Y
Rem     where the contents of the file esm.xml are as follows:
Rem     <METADATAS>
Rem             <METADATA SNAP_TYPE="security" TARGET_TYPE="host" 
Rem              UI_IGNORE="Y" HISTORY_IGNORE="Y" COMPARE_IGNORE="Y">
Rem                     <METADATA_UI_NAME>Security best practices</METADATA_UI_NAME>
Rem                             <TABLE NAME="ESM_COLLECTION">
Rem                                     <UI_NAME>ESM Collection</UI_NAME>
Rem                                     <COLUMN NAME="PROPERTY" TYPE="STRING" 
Rem                                             TYPE_FORMAT="64" IS_KEY="Y">Property</COLUMN>
Rem                                     <COLUMN NAME="VALUE" TYPE="STRING"
Rem                                             TYPE_FORMAT="64" IS_KEY="Y">Value</COLUMN>
Rem                             </TABLE>
Rem                     </METADATA>
Rem     </METADATAS>
Rem
Rem
Rem     The resulting SQL has been modified in the following ways:
Rem     1. The ESM_COLLECTION table is to be used for security snapshots of ALL existing target types, not just "host".
Rem     2. The length for the PROPERTY and VALUE columns has been extracted out as variables in the DECLARE statement.
Rem
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsadras     04/03/07 - Bug:5964364, move esm_collection/report to gc/db
Rem    jsadras     04/03/07 - Bug:5964364, move esm_collection/report to gc/db
Rem    jsadras     04/23/07 - Backport jsadras_bug-5934433 from main
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    scgrover    01/31/05 - compress esm_collection_pk with 2 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    dkjain      12/30/04 - Size of column of MGMT_ESA_REPORT table increased  
Rem    dkjain      12/30/04 - Size of the value and value2 column increases 
Rem    dkjain      10/13/04 - Column value1 name changed 
Rem    dkjain      10/08/04 - ESA 10gR2 Impl 
Rem    smalathe    08/19/04 - Bug#3803536: Add Compress in Create table stmt 
Rem    rpinnama    06/12/04 - Remove SET ECHO . 
Rem    eujang      09/04/03 - eujang_esm_init_no_intgr 
Rem    anajmi      08/26/03 - Created
Rem


Rem Do not use substitution variables in this script so that there is no
Rem additional restrictions on the string values that are being inserted (such as ampersand 
Rem being interpreted specially by SQLPlus).
SET DEFINE OFF 

Rem------------------------------------------
Rem Table (re)creation statements based on metadata Security best practices for target type host and snapshot type security
Rem Please REVIEW the table (re)creation statements below and modify them if necessary. Examples: 
Rem   (1) You meant for a TABLE tag in the metadata to represent a view. Then, remove the corresponding drop-table / create-table statements.
Rem   (2) Generated PRIMARY KEY constraints are supposed to be uniqueness constraints instead.
Rem   (3) You want to impose additional constraints on the tables.
Rem------------------------------------------

Rem Create tables

Rem Moved tables esm_collection.sql/mgmt_esa_report to esm_tables_gc.sql/esm_tables_db.sql

Rem End of table (re)creation for metadata Security best practices

SET DEFINE ON 
