Rem
Rem $Header: host_policies.sql 14-jul-2005.16:10:17 dsukhwal Exp $
Rem
Rem host_policies.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      host_policies.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dsukhwal    07/14/05 - open ports condition : bug 4440237 
Rem    dkjain      06/17/05 - Hide the rep metrics 
Rem    dkjain      03/17/05 - Fixed bug-4221757 
Rem    dkjain      02/18/05 - Fixed bug-4128312 
Rem    kashukla    02/24/05 - fixing bug 4203687 
Rem    dkjain      01/30/05 - UI text modified. 
Rem    dsukhwal    12/08/04 - correct phrases and polish 
Rem    dkjain      10/18/04 - Fix for evaluation error 
Rem    dkjain      10/13/04 - Thresholded param removed
Rem    dkjain      10/08/04 - dkjain_esa_impl_init
Rem    dkjain      10/08/04 - Created
Rem

DECLARE
 -- Metrics Variable
 l_metric_column_list        	   	             MGMT_METRIC_COLUMN_ARRAY;
 l_metric_type					     NUMBER ;
 l_snapshot_list				     MGMT_SNAPSHOT_ARRAY; 
 -- Policies Variable
 l_ctxList  		  			     MGMT_VIOL_CTXT_DEF_ARRAY; 
 l_paramDefList      		   		     MGMT_POLICY_PARAM_DEF_ARRAY;
 l_defaultParamValList   			     MGMT_POLICY_PARAM_VAL_ARRAY;
 l_defaultSettingsList   			     MGMT_POLICY_KEY_VAL_ARRAY;
 l_10gR1_host_meta_ver                   VARCHAR2(3) ; 
 l_valid_if_list                       MGMT_VALIDIF_ARRAY ;
BEGIN
   l_10gR1_host_meta_ver := '2.0'; 
   l_metric_type := MGMT_GLOBAL.G_METRIC_TYPE_TABLE ;
   l_snapshot_list := MGMT_SNAPSHOT_ARRAY(
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type => ESM.HOST_TARGET_TYPE,
                p_snapshot_name =>ESM.SECURITY_SNAPSHOT_TYPE));

   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'status',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Status',
                p_column_label_nlsid =>'STATUS_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.HOST_TARGET_TYPE,
      p_metric_name => 'executeStackRep',	
      p_type_meta_ver => l_10gR1_host_meta_ver,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,   			
      p_metric_label => 'Execute Stack',
      p_metric_label_nlsid => 'EXE_STACK_METRIC_LABEL',
      p_description  => 'Collect the information of whether the execution on the stack is allowed',
      p_description_nlsid => 'EXE_STACK_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid AS TARGET_GUID, value as status '
                  ||'FROM esm_collection_latest '
                  ||'WHERE property=''execute_stack''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT;

 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'status'));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
 p_target_type => ESM.HOST_TARGET_TYPE,
 p_policy_name => 'Execute_Stack',   --Policy name
 p_metric_name => 'executeStackRep',      --Metric name
 p_policy_label_nlsid => 'EXE_STACK_NAME',    
 p_description => 'Ensure that the OS configuration parameter, which enables '||
              'execution of code on the user stack, is not enabled',
 p_description_nlsid => 'EXE_STACK_DESC',
 p_impact => 'Enabling code execution on the user stack may allow a malicious user '||
             'to exploit stack buffer overflows. Overflows can cause portions of a '||
             'system to fail, or even execute arbitrary code.',
 p_impact_nlsid => 'EXE_STACK_IMPACT',
 p_recommendation => 'Disable code execution on the user stack.',
 p_recommendation_nlsid => 'EXE_STACK_RECOMM',
 p_violation_level => MGMT_GLOBAL.G_SEVERITY_WARNING,
 p_condition_type => MGMT_GLOBAL.G_CONDITION_SQL,
 p_condition => ':status = ''enabled''',
 p_message => 'The host is in an insecure state. Executable code on the user stack is enabled.',
 p_message_nlsid => 'EXE_STACK_MESG',
 p_start_type_meta_ver => l_10gR1_host_meta_ver,
 p_cs_consider_percentage => MGMT_GLOBAL.G_TRUE,
 p_dflt_param_val_list => l_defaultSettingsList,
 p_viol_ctxt_list => l_ctxList	
);
COMMIT ;

   l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'port',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Port Number',
                p_column_label_nlsid =>'PORT_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.HOST_TARGET_TYPE,
      p_metric_name => 'openPortsRep',	
      p_type_meta_ver => l_10gR1_host_meta_ver,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    			
      p_metric_label => 'Open Ports',
      p_metric_label_nlsid => 'OPEN_PORT_METRIC_LABEL',
      p_description  => 'Collect the information of TCP/UDP open ports',
      p_description_nlsid => 'OPEN_PORT_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE,     
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, TO_NUMBER(value) as port,value as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''port''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list =>l_metric_column_list  
 );
COMMIT ;

    l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
      	MGMT_VIOL_CTXT_DEF.NEW(
		p_metric_column => 'port'));
    l_paramDefList := MGMT_POLICY_PARAM_DEF_ARRAY(
        MGMT_POLICY_PARAM_DEF(
                param_name => 'DFLT_PORT',
                param_name_nlsid => 'DFLT_PORT_PNAME',
                param_type => MGMT_POLICY.G_PARAM_TYPE_NUMBER));
    l_defaultParamValList := MGMT_POLICY_PARAM_VAL_ARRAY(
        MGMT_POLICY_PARAM_VAL.NEW(
                p_param_name => 'DFLT_PORT',
                p_crit_threshold => '32768'));
    l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL,
                p_param_values => l_defaultParamValList));
 ESM.CREATE_POLICY(
  p_target_type => ESM.HOST_TARGET_TYPE,
  p_policy_name =>'Open_ports',   --Policy name
  p_metric_name =>'openPortsRep',      --Metric name
  p_policy_label_nlsid =>'OPEN_PORTS_NAME',   
  p_description =>'Ensure that no unintended ports are left open', -- Text description of test  
  p_description_nlsid =>'OPEN_PORTS_DESC',
  p_impact =>'Open ports may allow a malicious user to take over the host.',-- Text description of impact of violation          
  p_impact_nlsid =>'OPEN_PORTS_IMPACT',
  p_recommendation =>'Do not open insecure ports.',
  p_recommendation_nlsid =>'OPEN_PORTS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type => MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition => 'to_number(:port) < :DFLT_PORT',	-- Further filter using port
  p_message =>'The host is in an insecure state. Port %port% is open.',
  p_message_nlsid => 'OPEN_PORTS_MESG',
  p_start_type_meta_ver => l_10gR1_host_meta_ver,
  p_cs_consider_percentage => MGMT_GLOBAL.G_TRUE,
  p_policy_param_list => l_paramDefList,
  p_dflt_param_val_list => l_defaultSettingsList,
  p_viol_ctxt_list => l_ctxList	
);
COMMIT ;

 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'service',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Service Name',
                p_column_label_nlsid =>'SERVICE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.HOST_TARGET_TYPE,
      p_metric_name => 'insecureServicesRep',	
      p_type_meta_ver =>l_10gR1_host_meta_ver,
      p_valid_if_list => NULL,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    			
      p_metric_label => 'Insecure Services',
      p_metric_label_nlsid => 'INSEC_SERV_METRIC_LABEL',
      p_description  => 'Collect the information of those services which are running from the hard coded list of service names',
      p_description_nlsid => 'INSEC_SERV_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , value as service, value as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''service''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list =>l_metric_column_list  
 );
COMMIT ;

 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'service'));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.HOST_TARGET_TYPE ,
  p_policy_name =>'Insecure_Services',   --Policy name
  p_metric_name =>'insecureServicesRep',      --Metric name
  p_policy_label_nlsid =>'INSEC_SERV_NAME',   
  p_description =>'Ensure that there are no insecure services (for example, telnet and ftp) running on the server',
  p_description_nlsid =>'INSEC_SERV_DESC',
  p_impact =>'Insecure services may allow a malicious user to take over the host.',
  p_impact_nlsid =>'INSEC_SERV_DESC',
  p_recommendation =>'Do not run insecure services.',
  p_recommendation_nlsid =>'INSEC_SERV_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',--check for existence of a row
  p_message =>'The host is in an insecure state. The insecure service %service% is running on the host.',
  p_message_nlsid =>'INSEC_SERV_MESG',
  p_start_type_meta_ver =>l_10gR1_host_meta_ver,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;

   l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Windows'))
  );
  l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filesystem',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'File System',
                p_column_label_nlsid =>'FILE_SYS_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.HOST_TARGET_TYPE,
      p_metric_name => 'fileSystemTypeRep',	
      p_type_meta_ver => ESM.HOST_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,   			
      p_metric_label => 'File System Type',
      p_metric_label_nlsid => 'FILE_SYS_TYPE_METRIC_LABEL',
      p_description  => 'Collect the information file system type on windows',
      p_description_nlsid => 'FILE_SYS_TYPE_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE,     
      p_author => 'ORACLE',
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid , value as filesystem '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''file_system_type''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list =>l_metric_column_list  
 );
COMMIT ;

 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filesystem'));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.HOST_TARGET_TYPE,
  p_policy_name =>'NTFS_File_System',   --Policy name
  p_metric_name =>'fileSystemTypeRep',      --Metric name
  p_policy_label_nlsid =>'FILE_SYS_TYPE_NAME',    
  p_description =>'Ensure that the file system on a Windows operating system uses NTFS',
  p_description_nlsid =>'FILE_SYS_TYPE_DESC',
  p_impact =>'Other than NTFS, file systems on Windows platforms may have serious security risks.',
  p_impact_nlsid =>'FILE_SYS_TYPE_IMPACT',
  p_recommendation =>'On Windows operating systems, it is strongly recommended to use NTFS as the file system.',
  p_recommendation_nlsid =>'FILE_SYS_TYPE_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'The host is in an insecure state. NTFS is not configured on the Windows operating system.',
  p_message_nlsid =>'FILE_SYS_TYPE_MESG',
  p_start_type_meta_ver => ESM.HOST_TYPE_META_VERSION,
  p_cs_consider_percentage => MGMT_GLOBAL.G_TRUE,
  p_dflt_param_val_list => l_defaultSettingsList,
  p_viol_ctxt_list => l_ctxList	
);
COMMIT ;
END;
/
show errors ;

