Rem drv: <create type="pkgdefs" pos="esm/esm_pkgdefs.sql+"/>
Rem
Rem $Header: failover_pkgdefs.sql 25-aug-2005.03:13:05 neearora Exp $
Rem
Rem failover_pkgdefs.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      failover_pkgdefs.sql - Manages failover of middle-tier components
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    neearora    08/25/05 - Constants for heartbeat_interval_factor 
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    skini       06/23/05 - Add logging module 
Rem    aholser     06/09/05 - add host name to register proc 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    gan         08/19/04 - add get_active_mt_count 
Rem    skini       04/23/03 - Add column for hb interval
Rem    mbhoopat    07/30/02 - 
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Restructured
Rem    aholser     03/28/02 - monitoring the monitor.
Rem    skini       01/30/02 - Increase failover interval
Rem    rpinnama    01/21/02 - Lock during inserting.
Rem    rpinnama    01/18/02 - Add a method to get the count of entries..
Rem    skini       11/21/01 - Merged skini_js_stability
Rem    skini       11/19/01 - fix typo
Rem    skini       11/18/01 - Created
Rem

CREATE OR REPLACE PACKAGE MGMT_FAILOVER AS

G_MODULE_NAME CONSTANT VARCHAR2(32) := 'EM.FAILOVER';

G_ACTIVE_OMS_GRACE_PROP CONSTANT VARCHAR2(50) := 'ACTIVE_OMS_GRACE_TIME';
G_DEFAULT_OMS_GRACE CONSTANT INTEGER := 60;
G_MIN_OMS_GRACE CONSTANT INTEGER := 30;

G_DEFAULT_HB_INTERVAL_FACTOR CONSTANT INTEGER := 4;
G_HEARTBEAT_INTERVAL_FACTOR CONSTANT VARCHAR2(50) := 'HEARTBEAT_INTERVAL_FACTOR';

-- Register a new middle-tier with the failvoer package.
-- Returns a new id for the failover
FUNCTION register(p_host_url IN VARCHAR2, 
                  p_oms_url IN VARCHAR2,
                  p_host_name IN VARCHAR2,
                  p_heartbeat_interval IN NUMBER) RETURN INTEGER;

-- Gets the count of middle-tiers registerd with the failover package
FUNCTION get_middle_tier_count RETURN INTEGER;

-- Register a callback
PROCEDURE register_callback(p_callback_name VARCHAR2);

-- Heartbeat. Returns 1 on success, 0 on failure
FUNCTION heartbeat(p_id IN NUMBER) RETURN INTEGER;

-- Check whether any components have died
PROCEDURE check_failure;

-- Gets the count of active middle-tiers registerd with the failover package
-- Active middle tiers are the ones pinged repository recently. The threshold
-- is defined by parameter ACTIVE_OMS_GRACE_TIME in mgmt_parameters.
FUNCTION get_active_mt_count RETURN INTEGER;


END MGMT_FAILOVER;
/
show errors;

