Rem drv: <create type="tables"/>
Rem
Rem $Header: failover_tables.sql 19-may-2007.11:10:18 sradhakr Exp $
Rem
Rem failover_tables.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      failover_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sradhakr    05/19/07 - Backport sradhakr_rfi_backport_5873907_10.2.4.0.0
Rem                           from st_emcore_10.2.0.1.0
Rem    sradhakr    03/09/07 - Bug#5873907 - Review comments incorporated.
Rem    sradhakr    03/07/07 - Bug#5873907 - OMS FAILOVER CODE DOES NOT HANDLE
Rem                           DST CHANGES.
Rem    sradhakr    04/05/07 - Backport sradhakr_dummy2 from main
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    rmaggarw    03/10/05 - bug 4225651: add nocache order failover sequence 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    gan         08/20/04 - add minitoring 
Rem    skini       04/23/03 - Add column for hb interval
Rem    rpinnama    05/14/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/14/02 - Created
Rem

rem
rem MGMT_FAILOVER
rem
rem PURPOSE
rem   The failover table allows multiple middle-tier components to
rem   use the repository and detect when one or more of them
rem   dies unexpectedly. Specifically, the work done by the middle-tier
rem   that dies can then be redivided among the surviving middle-tiers.
rem 
rem COLUMNS
rem   id The id of the middle tier component
rem   time_stamp The last "heartbeat" from the component
rem   host_url The url of the console for the machine the oms is running on
rem       this is used to identify the particular job dispatcher for 
rem       monitoring purposes.
rem       It maps to the host_url in the MGMT_OMS_PARAMETERS table
rem   heartbeat_interval The hearbeat interval for this oms, in seconds
rem
CREATE TABLE MGMT_FAILOVER_TABLE
    (failover_id NUMBER,
     last_time_stamp DATE,
     host_url VARCHAR2(256),
     heartbeat_interval NUMBER(3),
     last_time_stamp_utc TIMESTAMP DEFAULT SYSTIMESTAMP) MONITORING;

rem
rem MGMT_FAILOVER_CALLBACKS
rem
rem PURPOSE
rem   The callbacks table lists a set of callbacks used with the
rem   failover system. Each callback must be a method with the
rem   signature "PROCEDURE callback(id IN INTEGER)"
rem 
rem COLUMNS
rem    callback_name The callback name
rem 
CREATE TABLE MGMT_FAILOVER_CALLBACKS
    (callback_name VARCHAR2(256)) MONITORING;

CREATE SEQUENCE MGMT_FAILOVER_SEQUENCE INCREMENT BY 1 START WITH 1 NOCYCLE NOCACHE ORDER;


